<?php
return [
    'plugin' => [
        'name' => 'Шоп',
        'description' => 'E-commerce решение для October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Создание товара',
            'update' => 'Изменить товар',
            'preview' => 'Просмотр товара',
        ],
        'categories' => [
            'create' => 'Создать категорию',
            'update' => 'Редактирование категории',
            'preview' => 'Просмотр категории',
        ],
        'orders' => [
            'show' => 'Детали заказа',
            'export' => 'Экспорт заказов',
        ],
        'discounts' => [
            'create' => 'Создать скидку',
            'update' => 'Редактировать скидку',
            'preview' => 'Просмотр скидки',
        ],
        'services' => [
            'create' => 'Создать услугу',
            'update' => 'Редактировать услугу',
        ],
        'shipping_methods' => [
            'create' => 'Создайте метод доставки',
            'update' => 'Изменить способ доставки',
            'preview' => 'Просмотр доставки',
        ],
        'payment_methods' => [
            'create' => 'Создать метод оплаты',
            'edit' => 'Изменить способ оплаты',
            'reorder' => 'Изменение порядка',
        ],
        'custom_field_options' => [
            'edit' => 'Редактировать параметры поля',
        ],
        'properties' => [
            'create' => 'Создание свойства',
            'edit' => 'Изменить свойства',
        ],
        'order_states' => [
            'create' => 'Создание статус',
            'edit' => 'Изменить статус',
            'reorder' => 'Изменить порядок',
        ],
        'brands' => [
            'create' => 'Создание бренда',
            'edit' => 'Редактировать бренд',
        ],
        'property_groups' => [
            'create' => 'Создать группу',
            'edit' => 'Редактирование группы',
        ],
        'customer_groups' => [
            'create' => 'Создать группу',
            'update' => 'Редактирование группы',
        ],
        'notifications' => [
            'update' => 'Уведомление об обновлении',
        ],
        'taxes' => [
            'create' => 'Создание налоговых ставок',
            'update' => 'Редактировать налог',
        ],
        'reviews' => [
            'create' => 'Создать отзыв',
            'update' => 'Редактировать отзыв',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Все категории магазина',
        'single_category' => 'Категория одного магазина',
        'all_products' => 'Все товары магазин',
        'all_variants' => 'Все варианты магазина',
    ],
    'currency_settings' => [
        'label' => 'Валюты',
        'description' => 'Настройка вашей валюты',
        'currencies' => 'Введите только официальные 3-х символа валюты.',
        'currency_code' => 'Код валюты',
        'currency_decimals' => 'Количество знаков после запятой',
        'currency_rounding' => 'Округлять итог',
        'currency_rounding_comment' => 'Итог, включая налоги, будет округлен до этого значения, если валюта активна',
        'currency_format' => 'Формат',
        'currency_symbol' => 'Символ',
        'currency_rate' => 'Курс',
        'is_default' => 'По умолчанию',
        'unknown' => 'Неизвестная валюта',
    ],
    'payment_gateway_settings' => [
        'label' => 'Платежные шлюзы',
        'description' => 'Настроить ваши платежные шлюзы',
        'stripe' => [
            'api_key' => 'Stripe API ключ',
            'api_key_comment' => 'Вы можете найти этот ключ в панели инструментов Stripe.',
            'publishable_key' => 'Stripe публичный ключ',
            'publishable_key_comment' => 'Вы можете найти этот ключ в панели инструментов Stripe.',
        ],
        'paypal' => [
            'client_id' => 'PayPal клиент |',
            'secret' => 'PayPal секрет',
            'test_mode' => 'Тестовый режим',
            'test_mode_comment' => 'Запустите все выплаты в PayPal песочнице',
        ],
        'postfinance' => [
            'test_mode' => 'Тестирование',
            'test_mode_comment' => 'Запустить все платежи в тестовой среде',
            'pspid' => 'PSPID (Имя пользователя)',
            'hashing_method' => 'Алгоритм хеша',
            'hashing_method_comment' => 'Конфигурация -> Техническая информация -> Глобальные параметры безопасности',
            'sha_in' => 'SHA-IN подпись',
            'sha_in_comment' => 'Конфигурация -> Техническая информация -> Проверка данных и происхождения товара',
            'sha_out' => 'SHA-OUT Подпись',
            'sha_out_comment' => 'Конфигурация -> Техническая информация -> Обратная связь по сделке',
        ],
    ],
    'notification_settings' => [
        'label' => 'Уведомления',
        'description' => 'Настройка уведомлений магазина',
    ],
    'price_category_settings' => [
        'label' => 'Ценовые категории',
        'description' => 'Настройка дополнительных ценовых категорий',
    ],
    'order_state_settings' => [
        'description' => 'Настройка порядка стран',
    ],
    'payment_method_settings' => [
        'description' => 'Управление методами оплаты',
    ],
    'shipping_method_settings' => [
        'description' => 'Управление методами доставки',
    ],
    'tax_settings' => [
        'description' => 'Управление налогами',
    ],
    'general_settings' => [
        'category' => 'Торговый центр: общие',
        'category_payments' => 'Торговый центр: платежи',
        'category_orders' => 'Торговый центр: заказы',
        'label' => 'Конфигурация',
        'description' => 'Общие параметры',
        'product_page' => 'Страница сведений о товаре',
        'product_page_comment' => 'Это то, где отображаются сведения о товаре',
        'address_page' => 'Страница адреса',
        'address_page_comment' => 'AddressForm компонент должен присутствовать на этой странице.',
        'checkout_page' => 'Страница оформления заказа',
        'checkout_page_comment' => 'Компонент проверки должен присутствовать на этой странице',
        'account_page' => 'Страница Учетная запись',
        'account_page_comment' => 'MyAccount компонент должен присутствовать на этой странице.',
        'cart_page' => 'Страница корзины',
        'cart_page_comment' => 'Компонент проверки должен присутствовать на этой странице',
        'category_page' => 'Страница категорий для списка товаров',
        'redirect_to_cart' => 'Перенаправление в корзину',
        'redirect_to_cart_comment' => 'Перенаправление в корзину после того, как пользователь добавил товар',
        'use_state' => 'Использовать поле Штат/Округ/Провинция',
        'use_state_comment' => 'Покупатели должны выбрать Штат/Округ/Провинцию во время регистрации',
        'group_search_results_by_product' => 'Сгруппировать поисковые результаты по товару',
        'group_search_results_by_product_comment' => 'Включить товар только один раз в результаты поиска, не показывать все совпадающие варианты',
        'shipping_selection_before_payment' => 'Выбрать способ доставки перед оплатой во время оформления заказа',
        'shipping_selection_before_payment_comment' => 'По умолчанию во время оформления заказа пользователю сначала предлагается выбрать способ оплаты, а затем способ доставки; используйте этот параметр, чтобы отменить эту логику',
        'admin_email' => 'Почта администратора',
        'admin_email_comment' => 'Уведомления для администратора будут высланы на этот адрес',
        'base' => 'Основные настройки',
        'links' => 'CMS страницы',
        'links_comment' => 'Выберите, какие страницы будут использоваться для отображения ваших товаров',
        'customizations' => 'Настройки',
        'customizations_comment' => 'Настройка функций вашего магазина',
        'category_page_comment' => 'Добавьте компонент "товары" на эту страницу.',
        'order_number_start' => 'Номер первого заказа',
        'order_number_start_comment' => 'Начальный id первого заказа',
        'index_driver' => 'Драйвер индексации',
        'index_driver_comment' => 'Если ваша база данных поддерживает JSON, используйте драйвер базы данных.',
        'index_driver_filesystem' => 'Файловая система',
        'index_driver_database' => 'База данных (только для MySQL 5.7+ или MariaDB 10.2+)',
        'index_driver_hint' => 'Если вы измените этот параметр, обязательно запустите "php artisan mall:reindex" в командной строке, чтобы переиндексировать ваши товары!',
    ],
    'feed_settings' => [
        'description' => 'Настроить ленты',
        'google_merchant_enabled' => 'Включить Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'Лента товара будет сгенерирована',
        'google_merchant_url' => 'Ваш Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Добавить ?locale=xy для локализации ленты.',
    ],
    'review_settings' => [
        'description' => 'Настроить отзывы',
        'enabled' => 'Отзывы включены',
        'enabled_comment' => 'Покупатели могут создавать отзывы',
        'moderated' => 'Модерирование отзывов',
        'moderated_comment' => 'Новые отзывы должны быть опубликованы админом',
        'allow_anonymous' => 'Разрешить анонимные отзывы',
        'allow_anonymous_comment' => 'Незарегистрированные пользователи могут комментировать отзывы',
    ],
    'common' => [
        'shop' => 'Магазин',
        'products' => 'Товары',
        'product' => 'Товар',
        'orders' => 'Заказы',
        'cart' => 'Корзина',
        'shipping' => 'Доставка',
        'taxes' => 'Налоги',
        'rates' => 'Курсы',
        'inventory' => 'Инвентаризация',
        'accessories' => 'Аксессуары',
        'shipping_methods' => 'Методы доставки',
        'accessory' => 'Аксессуар',
        'custom_fields' => 'Кастомные поля',
        'variants' => 'Варианты',
        'variant' => 'Вариант',
        'discounts' => 'Скидки',
        'discount' => 'Скидка',
        'discount_percentage' => 'Скидка (%)',
        'select_placeholder' => '-- Пожалуйста, выберите',
        'main_image' => 'Основное изображение',
        'images' => 'Изображения',
        'image_set' => 'Набор изображений',
        'attachments' => 'Изображения/Загрузки/Вставки',
        'downloads' => 'Загрузки',
        'select_image' => 'Выберите изображение',
        'select_file' => 'Выберите файл',
        'allowed' => 'Разрешено',
        'not_allowed' => 'Не разрешено',
        'yes' => 'Да',
        'no' => 'Нет',
        'seo' => 'SEO',
        'properties_links' => 'Свойства/ссылки',
        'categories' => 'Категории',
        'category' => 'Категория',
        'meta_title' => 'Мета-заголовок',
        'meta_description' => 'Мета-описание',
        'meta_keywords' => 'Мета ключевые слова',
        'reorder' => 'Порядок записей',
        'id' => 'ID',
        'created_at' => 'Создан',
        'updated_at' => 'Обновлен',
        'approved_at' => 'Утверждено',
        'hide_published' => 'Скрыть',
        'slug' => 'URL',
        'name' => 'Имя',
        'display_name' => 'Отображаемое имя',
        'group_name' => 'Имя группы',
        'add_value' => 'Добавить значение',
        'export_orders' => 'Экспорт заказов',
        'use_backend_defaults' => 'Использовать значения по умолчанию из параметров бэкэнда',
        'api_error' => 'Не удалось сохранить скидку. Ошибка при отправке изменений в торговом центре API.',
        'includes_tax' => 'Включая налоги',
        'conditions' => 'Условия',
        'general' => 'Общие',
        'logo' => 'Логотип',
        'payment_gateway' => 'Платежный шлюз',
        'payment_provider' => 'Провайдера платежей',
        'payment_methods' => 'Способы оплаты',
        'payment' => 'Оплата',
        'payments' => 'Платежи',
        'image' => 'Изображение',
        'color' => 'Цвет',
        'unit' => 'Единица',
        'dont_group' => '--Нет группы',
        'properties' => 'Свойства',
        'old_price' => 'Старая цена',
        'property' => 'Свойства',
        'property_groups' => 'Группы свойств',
        'property_group' => 'Свойства группы',
        'options' => 'Параметры',
        'option' => 'Параметр',
        'catalogue' => 'Каталог',
        'out_of_stock' => 'Этот товар закончился.',
        'out_of_stock_short' => 'Нет в наличии',
        'stock_limit_reached' => 'Вы не можете добавить больше товаров этого товара в вашу корзину, так как был достигнут предел запаса.',
        'deleted_at' => 'Удален',
        'sort_order' => 'Сортировка',
        'order_states' => 'Состояние заказа',
        'website' => 'Веб-сайт',
        'brands' => 'Бренды',
        'brand' => 'Бренд',
        'sorting_updated' => 'Порядок сортировки был обновлен',
        'not_in_use' => 'Параметр не используется',
        'saved_changes' => 'Изменения успешно сохранены',
        'none' => '-- Нет',
        'customers' => 'Клиенты',
        'customer_groups' => 'Группы клиентов',
        'customer_group' => 'Группы клиентов',
        'product_or_variant' => 'Тоавр / Вариант',
        'code' => 'Код',
        'code_comment' => 'Этот код может быть использован для идентификации этой записи программно',
        'checked' => 'Отмечен',
        'unchecked' => 'Не отмечен',
        'notifications' => 'Уведомления',
        'notification' => 'Уведомление',
        'price_missing' => 'Введите хотя бы цену для валюты по умолчанию',
        'slug_unique' => 'URL должен быть уникальным',
        'fees' => 'Сборы',
        'value' => 'Значение',
        'action_required' => 'Требуется действие!',
        'invalid_quantity' => 'Указанное количество не является действительным',
        'addresses' => 'Адреса',
        'address' => 'Адрес',
        'reference' => 'Ссылка',
        'session_id' => 'id Сессии',
        'message' => 'Сообщение',
        'payment_method' => 'Метод оплаты',
        'data' => 'Данные',
        'successful' => 'Успешно',
        'failed' => 'Отклонено',
        'caution' => 'Предупреждение',
        'since_begin' => 'С самого начала',
        'weekly' => 'Еженедельно',
        'feeds' => 'Ленты',
        'services' => 'Услуги',
        'service' => 'Услуга',
        'review' => 'Отзыв',
        'reviews' => 'Отзывы',
        'review_categories' => 'Категории отзыва',
        'review_category' => 'Категория отзыва',
        'title' => 'Заголовок',
        'version' => 'Версия',
    ],
    'variant' => [
        'method' => [
            'single' => 'Артикул',
            'variant' => 'Артикул вариантов',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Использовать для вариантов',
        'use_for_variants_comment' => 'Это свойство отличается для различных вариантов товара',
        'filter_type' => 'Тип фильтра',
        'filter_types' => [
            'none' => 'Без фильтра',
            'set' => 'Набор',
            'range' => 'Диапазон',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Текстовое поле',
        'integer' => 'Целое число',
        'float' => 'Число с плавающей точкой',
        'textarea' => 'Многострочное текстовое поле',
        'richeditor' => 'Rich-редактор',
        'dropdown' => 'Выпадающий список',
        'checkbox' => 'Флажок',
        'color' => 'Цвет',
        'image' => 'Изображение',
        'switch' => 'Переключатель',
        'add' => 'Добавить параметр',
        'name' => 'Имя',
        'price' => 'Цена',
        'attributes' => 'Атрибут',
        'option' => 'Параметр',
        'date' => 'Дата',
        'datetime' => 'Дата и время',
    ],
    'product' => [
        'user_defined_id' => 'ID товара',
        'name' => 'Название  товара',
        'published' => 'Опубликован',
        'published_short' => 'Опубл.',
        'is_virtual' => 'Виртуальный',
        'is_virtual_comment' => 'Этот товар виртуальный (файл, без доставки)',
        'product_file' => 'Файл товара',
        'product_files' => 'Файлы товара',
        'product_files_section_comment' => 'Это виртуальный товар. Вы можете загрузить новые версии файлов ниже. Клиентам будет видна последняя версия.',
        'product_file_version' => 'версия файла',
        'not_published' => 'Не опубликовано',
        'published_comment' => 'Этот товар видимый на веб-сайте',
        'stock' => 'Запас',
        'price' => 'Цена',
        'description_short' => 'Краткое описание',
        'description' => 'Описание',
        'weight' => 'Вес (г)',
        'length' => 'Длина (мм)',
        'height' => 'Высота (мм)',
        'width' => 'Ширина (мм)',
        'quantity_default' => 'Количество по умолчанию',
        'quantity_min' => 'Минимальное количество',
        'quantity_max' => 'Минимальное количество',
        'inventory_management_method' => 'Метод управления инвентаризации',
        'allow_out_of_stock_purchases' => 'Разрешить покупки, если нет на складе',
        'allow_out_of_stock_purchases_comment' => 'Этот товар можно заказать, даже если нет на складе',
        'stackable' => 'В корзину',
        'stackable_comment' => 'Если товар добавлен в корзину несколько раз показывать только одну запись (увеличение количества)',
        'shippable' => 'Транспортируемый',
        'shippable_comment' => 'Этот товар может быть доставлен',
        'taxable' => 'С налогом',
        'taxable_comment' => 'Рассчитать налоги на этот товар',
        'add_currency' => 'Добавить валюту',
        'is_taxable' => 'Использование налога',
        'is_not_taxable' => 'Нет налога',
        'currency' => 'Валюта',
        'general' => 'Общие',
        'duplicate_currency' => 'Вы ввели несколько цен для одной валюты',
        'property_title' => 'Название',
        'property_value' => 'Значение',
        'link_title' => 'Название',
        'link_target' => 'Целевой URL-адрес',
        'embed_title' => 'Заголовок',
        'embed_code' => 'Код',
        'properties' => 'Свойства',
        'links' => 'Ссылки',
        'embeds' => 'Вставки',
        'details' => 'Детали',
        'price_includes_tax' => 'Цена включает в себя налоги',
        'price_includes_tax_comment' => 'В указанную цену включены все налоги',
        'group_by_property' => 'Атрибут для варианта группировки',
        'additional_descriptions' => 'Дополнительные описания',
        'additional_properties' => 'Дополнительные свойства',
        'gtin' => 'Номер Позиции Глобальной Торговли (GTIN)',
        'mpn' => 'Номер Детали Производителя (MPN)',
        'price_table_modal' => [
            'trigger' => 'Редактировать значения запасов и цен',
            'label' => 'Цена и запасы',
            'title' => 'Обзор цены и запасов',
            'currency_dropdown' => 'Валюта: ',
        ],
        'missing_category' => 'Товар не имеет категории, связанной с ним. Пожалуйста, выберите категорию ниже, чтобы отредактировать этот товар.',
        'variant_support_header' => 'Варианты не поддерживаются',
        'variant_support_text' => 'Выбранная категория не имеет определенных свойств варианта. Пожалуйста, переключите метод управления запасами на "артикул" или выберите другую категорию.',
        'filter_virtual' => 'Показывать только виртуальные товары',
    ],
    'product_file' => [
        'display_name_comment' => 'Это имя будет видно покупателям',
        'version_comment' => 'Уникальная версия помогает клиенту распознавать обновленные файлы.',
        'expires_after_days' => 'Загрузка действительна в течение нескольких дней',
        'expires_after_days_comment' => 'Файл может быть загружен только в течение этого количества дней после покупки. Оставьте пустым без ограничений.',
        'max_download_count' => 'Максимальное количество загрузок',
        'max_download_count_comment' => 'Файл может быть загружен только это количество раз. Оставьте пустым без ограничений.',
        'session_required' => 'Требуется войти в систему',
        'session_required_comment' => 'Файл может быть загружен только тогда, когда клиент вошел в систему (ссылка для скачивания недоступна).',
        'file' => 'Файл',
        'download_count' => 'Количество загрузок',
        'errors' => [
            'invalid' => 'Неверная ссылка для скачивания',
            'expired' => 'Срок действия ссылки для скачивания истек',
            'too_many_attempts' => 'Слишком много попыток загрузки',
            'not_found' => 'Не удается найти запрошенный файл, пожалуйста, свяжитесь с нами для получения поддержки.',
        ],
        'hint' => [
            'intro' => 'Этот товар не имеет прикрепленного файла. Пожалуйста, не забудьте добавить один или программно сгенерировать его во время оформления заказа.',
            'info_text' => 'Вы можете найти информацию о том, как это сделать',
            'info_link' => 'в документации',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Основной набор',
        'is_main_set_comment' => 'Используйте этот набор для этого товара',
        'create_new' => 'Создать новый набор',
    ],
    'category' => [
        'name' => 'Имя',
        'code' => 'Код',
        'code_comment' => 'Этот код может быть использован для идентификации этой категории в части внешнего интерфейса',
        'parent' => 'Родительская категория',
        'no_parent' => 'Нет родительской категории',
        'inherit_property_groups' => 'Наследовать свойства родительской категории',
        'inherit_property_groups_comment' => 'Используйте группы свойства родительской категории в этой категории',
        'inherit_review_categories' => 'Наследовать отзывы категории от родительской',
        'inherit_review_categories_comment' => 'Использовать отзывы категории от этой родительской категории',
        'google_product_category_id' => 'Google Product Category ID',
        'google_product_category_id_comment' => 'Использовать Google Merchant integration, смотрите https://support.google.com/merchants/answer/6324436',
    ],
    'custom_fields' => [
        'name' => 'Имя поля',
        'type' => 'Тип поля',
        'options' => 'Параметры',
        'required' => 'Обязательно',
        'required_comment' => 'Это поле является обязательным для размещения заказа',
        'is_required' => 'Обязательно',
        'is_not_required' => 'Не требуется',
    ],
    'tax' => [
        'percentage' => 'Процент',
        'countries' => 'Применяются налог при транспортировке в этих странах',
        'countries_comment' => 'Если выбрана ни одна страна, налог применяется во всем мире.',
        'is_default' => 'По умолчанию',
        'is_default_comment' => 'Этот налог используется, если страна назначения доставки еще не известна',
    ],
    'discounts' => [
        'name' => 'Имя',
        'code' => 'Код скидки',
        'code_comment' => 'Оставьте пустым, чтобы сгенерировать случайный код',
        'total_to_reach' => 'Минимальная сумма заказа, чтобы применить скидку',
        'type' => 'Тип скидки',
        'trigger' => 'Действительный если',
        'rate' => 'Ставка (%)',
        'amount' => 'Фиксированная сумма',
        'max_number_of_usages' => 'Максимальное количество использований',
        'valid_from' => 'Действительно с',
        'expires' => 'Срок действия',
        'number_of_usages' => 'Количество использований',
        'shipping_description' => 'Наименование альтернативного способа доставки',
        'shipping_price' => 'Цена альтернативного способа доставки',
        'shipping_guaranteed_days_to_delivery' => 'Гарантированный срок доставки',
        'section_type' => 'Что делает эта скидка?',
        'section_trigger' => 'Когда применяется скидка?',
        'types' => [
            'fixed_amount' => 'Фиксированная сумма',
            'rate' => 'Процент',
            'shipping' => 'Альтернативная доставка',
        ],
        'triggers' => [
            'total' => 'Общая сумма заказа достигнута',
            'code' => 'Код скидки введен',
            'product' => 'Этот товар присутствует в корзине',
            'customer_group' => 'Пользователь принадлежит к определенной группе клиентов',
        ],
        'validation' => [
            'empty' => 'Введите промо-код.',
            'shipping' => 'Вы можете применить только один промо-код, который снижает стоимость доставки.',
            'duplicate' => 'Можно использовать код только один раз.',
            'expired' => 'Этот промо-код истек.',
            'not_found' => 'Этот промо-код не действителен.',
            'usage_limit_reached' => 'Этот промо-код был применен к много раз и больше не является допустимым.',
        ],
    ],
    'payment_method' => [
        'price' => 'Фиксированная плата',
        'price_comment' => 'Сумма, добавляемая к сумме заказа',
        'fee_percentage' => 'Процентная ставка',
        'fee_percentage_comment' => 'Процент от суммы, добавляемой к сумме заказа',
        'fee_label' => 'Ярлык для сбора',
        'fee_label_comment' => 'Этот текст будет отображаться клиенту при оформлении заказа.',
        'instructions' => 'Инструкции по оплате',
        'instructions_comment' => 'Поддерживается синтаксис Twig. Используйте {{ order }} или {{ cart }} для доступа к соответствующей информации, если она доступна',
        'pdf_partial' => 'Теплейт PDF прикрепления',
        'pdf_partial_comment' => 'Для всех заказов с этим способом оплаты визуализированный PDF-файл выбранной части будет прикреплен к уведомлению по почте',
        'pdf_partial_none' => 'Прикреплений PDF нет',
    ],
    'order' => [
        'order_number' => 'Номер заказа',
        'invoice_number' => 'Номер счета',
        'payment_hash' => 'Хеш оплаты',
        'customer' => 'Клиент',
        'creation_date' => 'Создан',
        'modification_date' => 'Изменен',
        'completion_date' => 'Завершен',
        'credit_card' => 'Кредитная карта',
        'payment_status' => 'Статус платежа',
        'grand_total' => 'Общая сумма',
        'billing_address' => 'Адрес оплаты',
        'shipping_address' => 'Адрес доставки',
        'currency' => 'Валюта',
        'status' => 'Статус',
        'email' => 'Email',
        'will_be_paid_later' => 'Будет оплачен позже',
        'shipping_address_same_as_billing' => 'Адрес доставки совпадает с адресом оплаты',
        'credit_card_last4_digits' => 'Последние 4 цифры',
        'tracking_number' => 'Номер для отслеживания',
        'tracking_url' => 'URL-адрес отслеживания',
        'tracking_shipped' => 'Пометить заказ как отправленный',
        'tracking_shipped_comment' => 'Заказ будет отмечен как отправленный',
        'tracking_completed' => 'Пометить заказ как завершенный',
        'tracking_completed_comment' => 'Заказ будет помечен как выполненный',
        'tracking_notification' => 'Отправить уведомление',
        'tracking_notification_comment' => 'Уведомление, содержащее информацию об отслеживании будет отправлен заказчику',
        'shipping_fees' => 'Стоимость доставки',
        'shipping_provider' => 'Транспортная компания',
        'shipping_method' => 'Метод доставки',
        'card_holder_name' => 'Владелец карты',
        'card_type' => 'Тип карты',
        'payment_method' => 'Метод оплаты',
        'payment_gateway_used' => 'Платежный шлюз',
        'tax_provider' => 'Налоговый поставщик',
        'lang' => 'Язык',
        'refunds_amount' => 'Сумма возмещения',
        'adjusted_amount' => 'Скорректированная сумма',
        'rebate_amount' => 'Сумма бонуса',
        'total' => 'Итого',
        'taxes_total' => 'Сумма налогов',
        'items_total' => 'Всего товаров',
        'subtotal' => 'Итого',
        'taxable_total' => 'Всего НДС',
        'total_weight' => 'Общий вес',
        'total_rebate_rate' => 'Общая скидка',
        'notes' => 'Примечания',
        'custom_fields' => 'Настраиваемые поля',
        'shipping_enabled' => 'Доставка включена',
        'payment_transaction_id' => 'Идентификатор транзакции оплаты',
        'change_order_status' => 'Изменить статус заказа',
        'change_payment_status' => 'Изменить статус платежа',
        'items' => 'Товары',
        'quantity' => 'Количество',
        'shipping_address_is_same_as_billing' => 'Адрес доставки совпадает с адресом оплаты',
        'update_shipping_state' => 'Обновить состояние доставки',
        'invalid_status' => 'Выбранный статус не существует.',
        'updated' => 'Обновление заказа прошло успешно',
        'deleted' => 'Удаление заказа прошло успешно',
        'deleting' => 'Удаление заказа ...',
        'delete_confirm' => 'Вы действительно хотите удалить этот заказ?',
        'update_invoice_number' => 'Установить номер счета',
        'shipped' => 'Отправлен',
        'shipping_pending' => 'Ожидает отправки',
        'not_shipped' => 'В ожидании',
        'data' => 'Данные заказа',
        'total_revenue' => 'Общий доход',
        'download_invoice' => 'Скачать счет-фактуру',
        'order_file_name' => 'Заказ-:order',
        'modal' => [
            'cancel' => 'Отменен',
            'update' => 'Обновить информацию',
        ],
        'payment_states' => [
            'pending_state' => 'Ожидает оплаты',
            'failed_state' => 'Платеж не прошел',
            'refunded_state' => 'Платеж возвращен',
            'paid_state' => 'Оплачен',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Гарантированная доставка в днях',
        'available_above_total' => 'Доступно, если общее число больше или равно',
        'available_below_total' => 'Доступно, если общее количество меньше, чем',
        'countries' => 'Доступно для доставки в страны',
        'countries_comment' => 'Если ни одна страна не выбрана, этот метод доступен во всем мире.',
        'not_required_name' => 'Доставка не требуется',
        'not_required_description' => 'Текущая корзина не требует никакой доставки.',
    ],
    'payment_status' => [
        'paid' => 'Оплачен',
        'deferred' => 'Отложенный',
        'paid_deferred' => 'Платеж отложен',
        'paiddeferred' => 'Платеж отложен',
        'charged_back' => 'Отправлен обратно',
        'refunded' => 'Платеж возмещен',
        'paidout' => 'Выплачен',
        'failed' => 'Неудачный',
        'pending' => 'В ожидании',
        'expired' => 'Просрочен',
        'cancelled' => 'Отменен',
        'open' => 'Открыт',
    ],
    'permissions' => [
        'manage_products' => 'Может управлять товарами',
        'manage_categories' => 'Может управлять категориями',
        'manage_orders' => 'Может управлять заказами',
        'manage_discounts' => 'Может управлять скидками',
        'settings' => [
            'manage_general' => 'Может управлять общими настройка магазина',
            'manage_payment_gateways' => 'Может изменить настройки платежного шлюза',
            'manage_currency' => 'Может управлять валютами магазина',
            'manage_payment_methods' => 'Может управлять способами оплаты магазина',
        ],
        'manage_properties' => 'Может редактировать свойства товара',
        'manage_customer_groups' => ' Может управлять группами покупателей',
        'manage_customer_addresses' => 'Может изменить адрес покупателей',
        'manage_notifications' => 'Можно управлять уведомлениями',
        'manage_price_categories' => 'Можно управлять ценой категорий',
        'manage_order_states' => 'Можно управлять статусом заказа',
        'manage_shipping_methods' => 'Можно управлять методами доставки',
        'manage_taxes' => 'Можно управлять налогами',
        'manage_payment_log' => 'Can manage payment log',
        'manage_feeds' => 'Может изменять ленты',
        'manage_wishlists' => 'Может изменять списки желаемого',
        'manage_services' => 'Может изменять услуги',
        'manage_reviews' => 'Может изменять отзывы',
        'manage_brands' => 'Может изменять бренды',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Товары',
                'description' => 'Список товаров',
            ],
            'properties' => [
                'no_category_filter' => 'Не фильтровать по категориям',
                'use_url' => 'Использовать Slug-категории из URL-адреса',
                'filter_component' => [
                    'title' => 'Псевдоним компонента фильтра',
                    'description' => 'Псевдоним компонента ProductsFilter, который фильтрует этот компонент Товары',
                ],
                'filter' => [
                    'title' => 'Строка фильтра',
                    'description' => 'Принудительный фильтр для этого компонента',
                ],
                'include_variants' => [
                    'title' => 'Показать Артикул вариантов',
                    'description' => 'Не показывать отдельные товары, но все доступные варианты товаров',
                ],
                'include_children' => [
                    'title' => 'Включить дочерние',
                    'description' => 'Показать все товары дочерних категорий',
                ],
                'per_page' => [
                    'title' => 'На страницу',
                    'description' => 'Сколько товаров, отображать на странице',
                ],
                'paginate' => [
                    'title' => 'Пагинация',
                    'description' => 'Разбивать результат (более чем одной страницы)',
                ],
                'sort' => [
                    'title' => 'Сортировка',
                    'description' => 'Это отменяет предпочтения пользователя по сортировке',
                ],
                'set_page_title' => [
                    'title' => 'Название страницы',
                    'description' => 'Использовать имя категории как заголовок страницы',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Фильтр товаров',
                'description' => 'Фильтры товаров из категории',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Показать ценовой фильтр',
                ],
                'showBrandFilter' => [
                    'title' => 'Показать фильтр бренда',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Показать фильтр распродажи',
                ],
                'includeChildren' => [
                    'title' => 'Включить дочерние',
                    'description' => 'Включать свойства и фильтры из дочерних категории',
                ],
                'includeVariants' => [
                    'title' => 'Включить варианты',
                    'description' => 'Показать фильтры для вариантов свойств',
                ],
                'includeSliderAssets' => [
                    'title' => 'Включать noUI слайдер',
                    'description' => 'Включить все зависимости noUI слайдера через cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Сортировка',
                    'description' => 'Начальный порядок сортировки',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Бестселлер',
                'priceLow' => 'Низкая цена',
                'priceHigh' => 'Высокая цена',
                'latest' => 'Новейшие',
                'oldest' => 'Старые',
                'random' => 'Случайно',
                'manual' => 'Вручную',
                'name' => 'Имя',
                'ratings' => 'Рейтинг',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Ваш кабинет',
                'description' => 'Отображает различные формы, где пользователь может просматривать и редактировать свой профиль',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Активные подстраницы',
                ],
            ],
            'pages' => [
                'orders' => 'Заказы',
                'profile' => 'Профиль',
                'addresses' => 'Адреса',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Профиль клиента',
                'description' => 'Отображает форму редактирования профиля клиента.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Выбор валюты',
                'description' => 'Показывает переключатель для выбора текущей валюты магазина',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Frontend зависимости',
                'description' => 'Включает в себя все необходимые frontend зависимости',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Список адресов',
                'description' => 'Отображает список всех адресов зарегистрированных пользователей',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'Не удалось найти запрошенный адрес',
                'cannot_delete_last_address' => 'Нельзя удалить последний адрес',
            ],
            'messages' => [
                'address_deleted' => 'Адрес удален',
                'default_billing_address_changed' => 'Изменен платежный адрес по умолчанию',
                'default_shipping_address_changed' => 'Изменен адрес доставки по умолчанию',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Список заказов',
                'description' => 'Отображает список всех заказов клиента',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Сведения о товаре',
                'description' => 'Отображает подробности товара',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Перенаправление после изменение свойства',
                    'description' => 'Перенаправление пользователя на новую страницу сведений, если свойство было изменено',
                ],
            ],
            'added_to_cart' => 'Товар успешно добавлен',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Отзывы о товаре',
                'description' => 'Показать все отзывы о товаре',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Количество отзывов на странице',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Показывать только рейтинги этого варианта',
                    'description' => "Не показывать отзывы о других вариантах этого товара",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Корзина',
                'description' => 'Отображает корзину',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Показать скидку',
                ],
                'showShipping' => [
                    'title' => 'Показать стоимость доставки',
                ],
                'showTaxes' => [
                    'title' => 'Показать налоги',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Показать кнопку Перейти к оформлению заказа',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Оформить заказ',
                'description' => 'Обрабатывает процесс покупки',
            ],
            'errors' => [
                'missing_settings' => 'Пожалуйста, выберите способ оплаты и доставки.',
            ],
        ],
        'quickCheckout' => [
            'details' => [
                'name' => 'Быстрая оплата',
                'description' => 'Одностраничный процесс оформления заказа',
            ],
            'errors' => [
                'signup_failed' => 'Не удалось создать учетную запись пользователя.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Ввод промо-кода',
                'description' => 'Отображает поле промо-кода',
            ],
            'discount_applied' => 'Скидка успешно применена!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Переключатель доставки',
                'description' => 'Отображает список всех доступных методов доставки',
            ],
            'errors' => [
                'unavailable' => 'Выбранный способ доставки не доступен для заказа.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Переключатель метода оплаты',
                'description' => 'Отображает список всех доступных способов оплаты',
            ],
            'errors' => [
                'unavailable' => 'Выбранный способ оплаты не доступен для заказа.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Переключатель адресов',
                'description' => 'Отображает список всех существующих адресов пользователей',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Форма адреса',
                'description' => 'Отображает форму для редактирования адреса пользователя',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Адрес',
                ],
                'redirect' => [
                    'title' => 'Перенаправление (после сохранения)',
                ],
                'set' => [
                    'title' => 'Использовать этот адрес как',
                ],
            ],
            'redirects' => [
                'checkout' => 'Страница оформления заказа',
            ],
            'set' => [
                'billing' => 'Адрес для оплаты',
                'shipping' => 'Адрес доставки',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Зарегистрироваться',
                'description' => 'Отображает форму регистрации и входа',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Перенаправление после входа',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Вы пытаетесь войти в учетную запись гостя.',
                'unknown_user' => 'Недопустимые учетные данные, которые вы ввели.',
                'not_activated' => 'Ваша учетная запись должна быть активирована, прежде чем вы сможете войти в систему.',
                'login' => [
                    'required' => 'Пожалуйста, введите адрес электронной почты.',
                    'email' => 'Пожалуйста, введите действительный адрес электронной почты.',
                    'between' => 'Пожалуйста, введите действительный адрес электронной почты.',
                ],
                'password' => [
                    'required' => 'Пожалуйста, введите ваш пароль.',
                    'max' => 'Пароль слишком длинный.',
                    'min' => 'Пароль короткий. Пожалуйста, введите по крайней мере 8 символов.',
                ],
                'password_repeat' => [
                    'required' => 'Пожалуйста, повторите пароль.',
                    'same' => 'Подтверждение пароля не совпадает.',
                ],
                'email' => [
                    'required' => 'Пожалуйста, введите адрес электронной почты.',
                    'email' => 'Адрес электронной почты недействительный.',
                    'unique' => 'Пользователь с таким адресом электронной почты уже зарегистрирован.',
                    'non_existing_user' => 'Пользователь с таким адресом электронной почты уже зарегистрирован. Используйте сброс пароля.',
                ],
                'firstname' => [
                    'required' => 'Пожалуйста, введите вашу фамилию.',
                ],
                'lastname' => [
                    'required' => 'Пожалуйста, введите ваше имя.',
                ],
                'lines' => [
                    'required' => 'Пожалуйста, введите ваш адрес.',
                ],
                'zip' => [
                    'required' => 'Пожалуйста, введите ваш почтовый индекс.',
                ],
                'city' => [
                    'required' => 'Пожалуйста, введите город.',
                ],
                'country_id' => [
                    'required' => 'Выберите страну.',
                    'exists' => 'Страна не допуступна.',
                ],
                'state_id' => [
                    'required' => 'Выберите область',
                    'exists' => 'Выбранное значение не доступно.',
                ],
                'terms_accepted' => [
                    'required' => 'Пожалуйста, примите наши условия и положения.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Категории',
                'description' => 'Список доступных категорий',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Начать с категории',
                    'description' => 'Показывать только дочерние категории в этой категории',
                ],
                'categorySlug' => [
                    'title' => 'Категория Slug-параметр',
                    'description' => 'Используйте этот параметр, чтобы загрузить родительскую категорию из Url',
                ],
                'categoryPage' => [
                    'title' => 'Страница категории',
                    'description' => 'Ссылки будут указывать на эту страницу. Если ничего не введено, будут использованы настройки по умолчанию из настроек бэкэнда.',
                ],
            ],
            'no_parent' => 'Показать все категории',
            'by_slug' => 'Использовать категорию в URL как родитель',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Итоги корзины',
                'description' => 'Отображать количество товаров и общую стоимость корзины',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Показать количество товаров',
                    'description' => 'Показать количество товаров в корзине',
                ],
                'showTotalPrice' => [
                    'title' => 'Показать общую стоимость',
                    'description' => 'Отображать общую стоимость всех товаров в корзине',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Панель управления для клиентов',
                'description' => 'Отображает ссылку для входа в систему клиента и изменения настроек его учетной записи.',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Ярлык для Панели управления клиентов',
                    'description' => 'Текст ссылки для страницы панели управления клиента',
                ],
                'logoutLabel' => [
                    'title' => 'Logout метка',
                    'description' => 'Текст для ссылки выхода',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Расширенный компонент электронной коммерции (UA)',
                'description' => 'Внедряет Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Кнопка добавления в желаемое',
                'description' => 'Показывает кнопку добавления в желаемое',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Товар',
                    'description' => 'ID товара',
                ],
                'variant' => [
                    'name' => 'Variant',
                    'description' => 'ID варианта',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Список желаемого',
                'description' => 'Показывает управление списком желаемого',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Показать доставку',
                    'description' => 'Показать стоимость доставки и выбор',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'От (вес в граммах)',
        'to_weight' => 'До (вес в граммах)',
    ],
    'products' => [
        'variants_comment' => 'Создавать различные варианты этого товара',
    ],
    'order_states' => [
        'name' => 'Имя',
        'description' => 'Описание',
        'color' => 'Цвет',
        'flag' => 'Специальная пометка',
        'flags' => [
            'new' => 'Установить состояние заказа как «новый»',
            'complete' => 'Установить состояние заказа как «выполнен»',
            'cancelled' => 'Установить состояние заказа как "отменено"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Этот код может быть использован для идентификации этой группы программно',
        'discount_comment' => 'Предоставить этой группе клиентов определенную скидку в % на весь ваш каталог',
    ],
    'order_status' => [
        'processed' => 'Обработан',
        'disputed' => 'Обсуждаемый',
        'shipped' => 'Отправлен',
        'delivered' => 'Доставлен',
        'pending' => 'В ожидании',
        'cancelled' => 'Отменен',
    ],
    'notifications' => [
        'enabled' => 'Включены',
        'enabled_comment' => 'Это уведомление активно',
        'template' => 'Шаблон почты',
    ],
    'payment_log' => [
        'payment_data' => 'Платежные данные',
        'data_comment' => 'Эти данные были возвращены поставщиком платежей',
        'order_data_comment' => 'Это все данные заказа для данного платежа',
        'message_comment' => 'Это сообщение было возвращено поставщиком платежей',
        'code_comment' => 'Этот код был возвращен платежным провайдером',
        'failed_only' => 'Провалено только',
    ],
    'services' => [
        'options' => 'Настройки',
        'option' => 'Настройка',
        'required' => 'Услуга обязательна',
        'required_comment' => 'Один из вариантов этой услуги должен быть выбран при добавлении товара в корзину.',
    ],
    'reviews' => [
        'rating' => 'Рейтинг',
        'review' => 'Детали отзыва',
        'title' => 'Заголовок вашего отзыва',
        'pros' => 'Позитивные стороны',
        'cons' => 'Негативные отзывы',
        'anonymous' => 'Аноним',
        'only_unapproved' => 'Показывать только неутвержденные',
        'no_more' => 'Больше никаких неутвержденных отзывов',
        'approved' => 'Комментарий одобрен',
        'approve' => 'Одобрить комментарий',
        'approve_next' => 'Одобрить и перейдите к следующему',
    ],
];
