<?php
return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'E-commerce solution for October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Create product',
            'update' => 'Edit product',
            'preview' => 'Preview product',
        ],
        'categories' => [
            'create' => 'Create category',
            'update' => 'Edit category',
            'preview' => 'Category preview',
        ],
        'orders' => [
            'show' => 'Order details',
            'export' => 'Export orders',
        ],
        'discounts' => [
            'create' => 'Create discount',
            'update' => 'Edit discount',
            'preview' => 'Preview discount',
        ],
        'services' => [
            'create' => 'Create service',
            'update' => 'Edit service',
        ],
        'shipping_methods' => [
            'create' => 'Create shipping method',
            'update' => 'Edit shipping method',
            'preview' => 'Preview shipping method',
        ],
        'payment_methods' => [
            'create' => 'Create payment method',
            'edit' => 'Edit payment method',
            'reorder' => 'Reorder',
        ],
        'custom_field_options' => [
            'edit' => 'Edit field options',
        ],
        'properties' => [
            'create' => 'Create properites',
            'edit' => 'Edit properties',
        ],
        'order_states' => [
            'create' => 'Create status',
            'edit' => 'Edit status',
            'reorder' => 'Reorder status',
        ],
        'brands' => [
            'create' => 'Create brand',
            'edit' => 'Edit brand',
        ],
        'property_groups' => [
            'create' => 'Create group',
            'edit' => 'Edit group',
        ],
        'customer_groups' => [
            'create' => 'Create group',
            'update' => 'Edit group',
        ],
        'notifications' => [
            'update' => 'Update notification',
        ],
        'taxes' => [
            'create' => 'Create tax',
            'update' => 'Edit tax',
        ],
        'reviews' => [
            'create' => 'Create review',
            'update' => 'Edit review',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'All shop categories',
        'single_category' => 'Single shop category',
        'all_products' => 'All shop products',
        'all_variants' => 'All shop variants',
    ],
    'currency_settings' => [
        'label' => 'Currencies',
        'description' => 'Setup your currencies',
        'currencies' => 'Only enter official 3-char currency codes.',
        'currency_code' => 'Currency code',
        'currency_decimals' => 'Decimal places',
        'currency_rounding' => 'Rounding the total',
        'currency_rounding_comment' => 'The total, including taxes, is rounded to this value if this currency is active.',
        'currency_format' => 'Format',
        'currency_symbol' => 'Symbol',
        'currency_rate' => 'Rate',
        'is_default' => 'Is default',
        'unknown' => 'Unknown Currency',
    ],
    'payment_gateway_settings' => [
        'label' => 'Payment gateways',
        'description' => 'Configure your payment gateways',
        'stripe' => [
            'api_key' => 'Stripe API Key',
            'api_key_comment' => 'You can find this key in your Stripe Dashboard',
            'publishable_key' => 'Stripe Publishable Key',
            'publishable_key_comment' => 'You can find this key in your Stripe Dashboard',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Test mode',
            'test_mode_comment' => 'Run all payments in the PayPal Sandbox.',
        ],
        'postfinance' => [
            'test_mode' => 'Test mode',
            'test_mode_comment' => 'Run all payments against the test environment',
            'pspid' => 'PSPID (Username)',
            'hashing_method' => 'Hash algorithm',
            'hashing_method_comment' => 'Configuration -> Technical information -> Global security parameters',
            'sha_in' => 'SHA-IN Signature',
            'sha_in_comment' => 'Configuration -> Technical information -> Data and origin verification',
            'sha_out' => 'SHA-OUT Signature',
            'sha_out_comment' => 'Configuration -> Technical information -> Transaction feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'Notifications',
        'description' => 'Configure store notifications',
    ],
    'price_category_settings' => [
        'label' => 'Price categories',
        'description' => 'Configure additional price categories',
    ],
    'order_state_settings' => [
        'description' => 'Configure order states',
    ],
    'payment_method_settings' => [
        'description' => 'Manage payment methods',
    ],
    'shipping_method_settings' => [
        'description' => 'Manage shipping methods',
    ],
    'tax_settings' => [
        'description' => 'Manage taxes',
    ],
    'general_settings' => [
        'category' => 'Mall: General',
        'category_payments' => 'Mall: Payments',
        'category_orders' => 'Mall: Orders',
        'label' => 'Configuration',
        'description' => 'General settings',
        'product_page' => 'Product details page',
        'product_page_comment' => 'This is where the product details are displayed',
        'address_page' => 'Address page',
        'address_page_comment' => 'The addressForm component has to be present on this page',
        'checkout_page' => 'Checkout page',
        'checkout_page_comment' => 'The checkout component has to be present on this page',
        'account_page' => 'Account page',
        'account_page_comment' => 'The myAccount component has to be present on this page',
        'cart_page' => 'Cart page',
        'cart_page_comment' => 'The cart component has to be present on this page',
        'category_page' => 'Category page for products listing',
        'redirect_to_cart' => 'Redirect to cart',
        'redirect_to_cart_comment' => 'Redirect to cart after the user added a product',
        'use_state' => 'Use State/County/Province field',
        'use_state_comment' => 'Customers have to select a State/County/Province during signup',
        'group_search_results_by_product' => 'Group search results by product',
        'group_search_results_by_product_comment' => 'Include a Product only once in the search results, don\'t display all matching Variants',
        'shipping_selection_before_payment' => 'Select shipping method BEFORE payment during checkout',
        'shipping_selection_before_payment_comment' => 'By default, during checkout, the user is first asked to select a payment method before selecting a shipping method; use this option to reverse this logic',
        'admin_email' => 'Admin email',
        'admin_email_comment' => 'Admin notifications will be sent to this addres',
        'base' => 'Base settings',
        'links' => 'CMS pages',
        'links_comment' => 'Choose which pages are used to display your products',
        'customizations' => 'Customizations',
        'customizations_comment' => 'Customize the features of your shop',
        'category_page_comment' => 'Add the "products" component to this page.',
        'order_number_start' => 'First order number',
        'order_number_start_comment' => 'Initial id of the first order',
        'index_driver' => 'Index driver',
        'index_driver_comment' => 'If your database supports JSON use the database driver.',
        'index_driver_filesystem' => 'Filesystem',
        'index_driver_database' => 'Database (only for MySQL 5.7+ or MariaDB 10.2+)',
        'index_driver_hint' => 'If you change this option make sure to run "php artisan mall:reindex" on the command line to re-index your products!',
    ],
    'feed_settings' => [
        'description' => 'Configure mall feeds',
        'google_merchant_enabled' => 'Enable Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'A product feed will be generated',
        'google_merchant_url' => 'Your Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Add ?locale=xy to get a localized feed.',
    ],
    'review_settings' => [
        'description' => 'Configure reviews',
        'enabled' => 'Reviews enabled',
        'enabled_comment' => 'Customers can create reviews',
        'moderated' => 'Moderate reviews',
        'moderated_comment' => 'New reviews have to be published manually by the site admin',
        'allow_anonymous' => 'Allow anonymous reviews',
        'allow_anonymous_comment' => 'Unregistered users can create reviews',
    ],
    'common' => [
        'shop' => 'Shop',
        'products' => 'Products',
        'product' => 'Product',
        'orders' => 'Orders',
        'cart' => 'Cart',
        'shipping' => 'Shipping',
        'taxes' => 'Taxes',
        'rates' => 'Rates',
        'inventory' => 'Inventory',
        'accessories' => 'Accessories',
        'shipping_methods' => 'Shipping methods',
        'accessory' => 'Accessory',
        'custom_fields' => 'Custom fields',
        'variants' => 'Variants',
        'variant' => 'Variant',
        'discounts' => 'Discounts',
        'discount' => 'Discount',
        'discount_percentage' => 'Discount (%)',
        'select_placeholder' => '-- Please choose',
        'main_image' => 'Main image',
        'images' => 'Images',
        'image_set' => 'Image set',
        'attachments' => 'Images/Downloads/Embeds',
        'downloads' => 'Downloads',
        'select_image' => 'Choose image',
        'select_file' => 'Choose file',
        'allowed' => 'Allowed',
        'not_allowed' => 'Not allowed',
        'yes' => 'Yes',
        'no' => 'No',
        'seo' => 'SEO',
        'properties_links' => 'Properties/Links',
        'categories' => 'Categories',
        'category' => 'Category',
        'meta_title' => 'Meta title',
        'meta_description' => 'Meta description',
        'meta_keywords' => 'Meta keywords',
        'reorder' => 'Reorder entries',
        'id' => 'ID',
        'created_at' => 'Created at',
        'updated_at' => 'Updated at',
        'approved_at' => 'Approved at',
        'hide_published' => 'Hide published',
        'slug' => 'URL',
        'name' => 'Name',
        'display_name' => 'Display name',
        'group_name' => 'Group name',
        'add_value' => 'Add value',
        'export_orders' => 'Export orders',
        'use_backend_defaults' => 'Use defaults configured in backend settings',
        'api_error' => 'Could not save discount. Error while sending changes to the Mall API.',
        'includes_tax' => 'Including taxes',
        'conditions' => 'Conditions',
        'general' => 'General',
        'logo' => 'Logo',
        'payment_gateway' => 'Payment gateway',
        'payment_provider' => 'Payment provider',
        'payment_methods' => 'Payment methods',
        'payment' => 'Payment',
        'payments' => 'Payments',
        'image' => 'Image',
        'color' => 'Color',
        'unit' => 'Unit',
        'dont_group' => '-- Do not group',
        'properties' => 'Properties',
        'old_price' => 'Old price',
        'property' => 'Property',
        'property_groups' => 'Property groups',
        'property_group' => 'Property group',
        'options' => 'Options',
        'option' => 'Option',
        'catalogue' => 'Catalogue',
        'out_of_stock' => 'This product is out of stock.',
        'out_of_stock_short' => 'Out of stock',
        'stock_limit_reached' => 'You cannot add any more items of this product to your cart since the stock limit has been reached.',
        'deleted_at' => 'Deleted at',
        'sort_order' => 'Sort order',
        'order_states' => 'Order states',
        'website' => 'Website',
        'brands' => 'Brands',
        'brand' => 'Brand',
        'sorting_updated' => 'Sort order has been updated',
        'not_in_use' => 'Option is not in use',
        'saved_changes' => 'Saved changes successfully',
        'none' => '-- None',
        'customers' => 'Customers',
        'customer_groups' => 'Customer groups',
        'customer_group' => 'Customer group',
        'product_or_variant' => 'Product/Variant',
        'code' => 'Code',
        'code_comment' => 'This code can be used to identify this record programmatically',
        'checked' => 'Checked',
        'unchecked' => 'Unchecked',
        'notifications' => 'Notifications',
        'notification' => 'Notification',
        'price_missing' => 'Enter at least a price for the default currency',
        'slug_unique' => 'The URL has to be unique',
        'fees' => 'Fees',
        'value' => 'Value',
        'action_required' => 'Action required!',
        'invalid_quantity' => 'The specified quantity is not valid',
        'addresses' => 'Addresses',
        'address' => 'Address',
        'reference' => 'Reference',
        'session_id' => 'Session ID',
        'message' => 'Message',
        'payment_method' => 'Payment method',
        'data' => 'Data',
        'successful' => 'Successful',
        'failed' => 'Failed',
        'caution' => 'Caution',
        'since_begin' => 'Since begin',
        'weekly' => 'Weekly',
        'feeds' => 'Feeds',
        'services' => 'Services',
        'service' => 'Service',
        'review' => 'Review',
        'reviews' => 'Reviews',
        'review_categories' => 'Review categories',
        'review_category' => 'Review category',
        'title' => 'Title',
        'version' => 'Version',
        'duplicate_selected' => 'Duplicate selected',
        'duplicated' => 'Duplicated successfully',
    ],
    'variant' => [
        'method' => [
            'single' => 'Article',
            'variant' => 'Article variants',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Use for variants',
        'use_for_variants_comment' => 'This property is different for different variants of this product',
        'filter_type' => 'Filter type',
        'filter_types' => [
            'none' => 'Without filter',
            'set' => 'Set',
            'range' => 'Range',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Textfield',
        'integer' => 'Integer',
        'float' => 'Float',
        'textarea' => 'Multi-line textfield',
        'richeditor' => 'Richtext',
        'dropdown' => 'Dropdown',
        'checkbox' => 'Checkbox',
        'color' => 'Color',
        'image' => 'Image',
        'switch' => 'Switch',
        'add' => 'Add option',
        'name' => 'Name',
        'price' => 'Price',
        'attributes' => 'Attribute',
        'option' => 'Option',
        'date' => 'Date',
        'datetime' => 'Date Time',
    ],
    'product' => [
        'user_defined_id' => 'Product ID',
        'name' => 'Product name',
        'published' => 'Published',
        'published_short' => 'Publ.',
        'is_virtual' => 'Is virtual',
        'is_virtual_comment' => 'This product is virtual (a file, no shipping)',
        'product_file' => 'Product file',
        'product_files' => 'Product files',
        'product_files_section_comment' => 'This is a virtual product. You can upload new file versions below. The latest version will be downloadable by customers.',
        'product_file_version' => 'file version',
        'not_published' => 'Not published',
        'published_comment' => 'This product is visible on the website',
        'stock' => 'Stock',
        'price' => 'Price',
        'description_short' => 'Short description',
        'description' => 'Description',
        'weight' => 'Weight',
        'length' => 'Length',
        'height' => 'Height',
        'width' => 'Width',
        'quantity_default' => 'Default quantity',
        'quantity_min' => 'Minimum quantity',
        'quantity_max' => 'Maximum quantity',
        'inventory_management_method' => 'Inventory management method',
        'allow_out_of_stock_purchases' => 'Allow out of stock purchases',
        'allow_out_of_stock_purchases_comment' => 'This product can be ordered even if it is out of stock',
        'stackable' => 'Stack in cart',
        'stackable_comment' => 'If this product is added to the cart multiple times only show one entry (increase quantity)',
        'shippable' => 'Shippable',
        'shippable_comment' => 'This product can be shipped',
        'taxable' => 'Taxable',
        'taxable_comment' => 'Calculate taxes on this product',
        'add_currency' => 'Add currency',
        'is_taxable' => 'Use tax',
        'is_not_taxable' => 'Use no tax',
        'currency' => 'Currency',
        'general' => 'General',
        'duplicate_currency' => 'You have entered multiple prices for the same currency',
        'property_title' => 'Title',
        'property_value' => 'Value',
        'link_title' => 'Title',
        'link_target' => 'Target URL',
        'embed_title' => 'Title',
        'embed_code' => 'Embed code',
        'properties' => 'Properties',
        'links' => 'Links',
        'embeds' => 'Embeds',
        'details' => 'Details',
        'price_includes_tax' => 'Price includes taxes',
        'price_includes_tax_comment' => 'The defined price includes all taxes',
        'group_by_property' => 'Attribute for variant grouping',
        'additional_descriptions' => 'Additional descriptions',
        'additional_properties' => 'Additional properties',
        'gtin' => 'Global Trade Item Number (GTIN)',
        'mpn' => 'Manufacturer Part Number (MPN)',
        'price_table_modal' => [
            'trigger' => 'Edit stock and price values',
            'label' => 'Price and stock',
            'title' => 'Price and stock overview',
            'currency_dropdown' => 'Currency: ',
        ],
        'missing_category' => 'The product does not have a category associated with it. Please select a category below to edit this product.',
        'variant_support_header' => 'Variants not supported',
        'variant_support_text' => 'The selected category has no Variant properties defined. Please switch the inventory management method to "Article" or select another category.',
        'filter_virtual' => 'Show only virtual products',
    ],
    'product_file' => [
        'display_name_comment' => 'This name will be visible to the customer.',
        'version_comment' => 'A unique version helps a customer to recognize updated files.',
        'expires_after_days' => 'Download valid for days',
        'expires_after_days_comment' => 'The file can only be downloaded for this many days after purchase. Leave empty for no limit.',
        'max_download_count' => 'Maximum number of downloads',
        'max_download_count_comment' => 'The file can only be downloaded this many times. Leave empty for no limit.',
        'session_required' => 'Login required',
        'session_required_comment' => 'The file can only be downloaded when the customer is logged in (download link is not shareable).',
        'file' => 'File',
        'download_count' => 'Download count',
        'errors' => [
            'invalid' => 'Invalid download link',
            'expired' => 'Download link expired',
            'too_many_attempts' => 'Too many download attempts',
            'not_found' => 'Cannot find requested file, please contact us for support.',
        ],
        'hint' => [
            'intro' => 'This product does not have a file attached. Please make sure to add one or programmatically gerenate it during checkout.',
            'info_text' => 'You can find information on how to do this',
            'info_link' => 'in the documentation',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Is main set',
        'is_main_set_comment' => 'Use this image set for this product',
        'create_new' => 'Create new set',
    ],
    'category' => [
        'name' => 'Name',
        'code' => 'Code',
        'code_comment' => 'This code can be used to identify this category in your frontend partials.',
        'parent' => 'Parent',
        'no_parent' => 'No parent',
        'inherit_property_groups' => 'Inherit properties of parent category',
        'inherit_property_groups_comment' => 'Use the property groups of this category\'s parent category',
        'inherit_review_categories' => 'Inherit review categories of parent category',
        'inherit_review_categories_comment' => 'Use the review categories of this category\'s parent category',
        'google_product_category_id' => 'Google Product Category ID',
        'google_product_category_id_comment' => 'Used for Google Merchant integration, see https://support.google.com/merchants/answer/6324436',
    ],
    'custom_fields' => [
        'name' => 'Field name',
        'type' => 'Field type',
        'options' => 'Options',
        'required' => 'Required',
        'required_comment' => 'This field is required to place an order',
        'is_required' => 'Required',
        'is_not_required' => 'Not required',
    ],
    'tax' => [
        'percentage' => 'Percent',
        'countries' => 'Only apply tax when shipping to these countries',
        'countries_comment' => 'If no country is selected the tax is applied worldwide.',
        'is_default' => 'Is default',
        'is_default_comment' => 'This tax is used if the shipping destination country is not known yet',
    ],
    'discounts' => [
        'name' => 'Name',
        'code' => 'Discount code',
        'code_comment' => 'Leave empty to generate a random code',
        'total_to_reach' => 'Minimal order total for discount to be valid',
        'type' => 'Discount type',
        'trigger' => 'Valid if',
        'rate' => 'Rate (%)',
        'amount' => 'Fixed amount',
        'max_number_of_usages' => 'Max number of usages',
        'valid_from' => 'Valid from',
        'expires' => 'Expires',
        'number_of_usages' => 'Number of usages',
        'shipping_description' => 'Name of alternative shipping method',
        'payment_method_description' => 'Choose a payment method',
        'shipping_price' => 'Price of alternative shipping method',
        'shipping_guaranteed_days_to_delivery' => 'Guaranteed days to delivery',
        'section_type' => 'What does this discount do?',
        'section_trigger' => 'When is this discount applicable?',
        'types' => [
            'fixed_amount' => 'Fixed amount',
            'rate' => 'Rate',
            'shipping' => 'Alternate shipping',
        ],
        'triggers' => [
            'total' => 'Order total is reached',
            'code' => 'Discount code is entered',
            'product' => 'A specific product is present in the cart',
            'shipping_method' => 'The shipping method is one of the following',
            'customer_group' => 'The user belongs to a specific customer group',
            'payment_method' => 'Depending on the payment method',
        ],
        'validation' => [
            'empty' => 'Enter a promo code.',
            'shipping' => 'You can only apply one promo code that lowers your shipping fees.',
            'duplicate' => 'You can use the same promo code only once.',
            'expired' => 'This promo code has expired.',
            'not_found' => 'This promo code is not valid.',
            'usage_limit_reached' => 'This promo code has been applied to many times and is therefore no longer valid.',
            'cart_limit_reached' => 'Promo code limit reached. You can no longer add promo codes for this cart.',
        ],
    ],
    'payment_method' => [
        'price' => 'Fixed fee',
        'price_comment' => 'The amount to add to the order\'s total',
        'fee_percentage' => 'Percentage fee',
        'fee_percentage_comment' => 'The percentage of the total to add to the order\'s total',
        'fee_label' => 'Fee label',
        'fee_label_comment' => 'This text will be displayed to the customer when checking out.',
        'instructions' => 'Payment instructions',
        'instructions_comment' => 'Twig syntax supported. Use {{ order }} or {{ cart }} to access corresponding information if available',
        'pdf_partial' => 'PDF attachment partial',
        'pdf_partial_comment' => 'For all orders with this payment method a rendered PDF of the selected partial will be attached to the notification mail',
        'pdf_partial_none' => 'No PDF attachment',
    ],
    'order' => [
        'order_number' => '# Order',
        'invoice_number' => '# Invoice',
        'payment_hash' => 'Payment hash',
        'customer' => 'Customer',
        'creation_date' => 'Created at',
        'modification_date' => 'Modified at',
        'completion_date' => 'Completed at',
        'credit_card' => 'Credit card',
        'payment_status' => 'Payment status',
        'grand_total' => 'Grand total',
        'billing_address' => 'Billing address',
        'shipping_address' => 'Shipping address',
        'currency' => 'Currency',
        'status' => 'Status',
        'email' => 'Email',
        'will_be_paid_later' => 'Will be paid later',
        'shipping_address_same_as_billing' => 'Shipping address is same as billing',
        'credit_card_last4_digits' => 'Last 4 digits',
        'tracking_number' => 'Tracking number',
        'tracking_url' => 'Tracking url',
        'tracking_shipped' => 'Mark order as shipped',
        'tracking_shipped_comment' => 'The order will be marked as shipped',
        'tracking_completed' => 'Mark order as complete',
        'tracking_completed_comment' => 'The order will be marked as complete',
        'tracking_notification' => 'Send notification',
        'tracking_notification_comment' => 'A notification containing the tracking information will be sent to the customer',
        'shipping_fees' => 'Shipping fees',
        'shipping_provider' => 'Shipping provider',
        'shipping_method' => 'Shipping method',
        'card_holder_name' => 'Card holder',
        'card_type' => 'Card type',
        'payment_method' => 'Payment method',
        'payment_gateway_used' => 'Payment gateway',
        'tax_provider' => 'Tax provider',
        'lang' => 'Language',
        'refunds_amount' => 'Refunds amount',
        'adjusted_amount' => 'Adjusted amount',
        'rebate_amount' => 'Rebate amount',
        'total' => 'Total',
        'taxes_total' => 'Taxes total',
        'items_total' => 'Items total',
        'subtotal' => 'Subtotal',
        'taxable_total' => 'Taxable total',
        'total_weight' => 'Total weight',
        'total_rebate_rate' => 'Total rebate',
        'notes' => 'Notes',
        'custom_fields' => 'Custom fields',
        'shipping_enabled' => 'Shipping enabled',
        'payment_transaction_id' => 'Payment transaction id',
        'change_order_status' => 'Change order status',
        'change_payment_status' => 'Change payment status',
        'items' => 'Items',
        'quantity' => 'Quantity',
        'shipping_address_is_same_as_billing' => 'Shipping address is same as billing address',
        'update_shipping_state' => 'Update shipping state',
        'invalid_status' => 'The selected status does not exist.',
        'updated' => 'Order update successful',
        'deleted' => 'Order successfully deleted',
        'deleting' => 'Deleting order...',
        'delete_confirm' => 'Do you really want to delete this order?',
        'update_invoice_number' => 'Set invoice number',
        'shipped' => 'Shipped',
        'shipping_pending' => 'Shipping pending',
        'not_shipped' => 'Pending',
        'data' => 'Order data',
        'total_revenue' => 'Total revenue',
        'download_invoice' => 'Download invoice',
        'order_file_name' => 'order-:order',
        'virtual_product_download_hint' => 'Download links will be sent separately after payment.',
        'modal' => [
            'cancel' => 'Cancel',
            'update' => 'Update information',
        ],
        'payment_states' => [
            'pending_state' => 'Payment pending',
            'failed_state' => 'Payment failed',
            'refunded_state' => 'Payment refunded',
            'paid_state' => 'Paid',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Guaranteed delivery in days',
        'available_above_total' => 'Available if total is greater than or equals',
        'available_below_total' => 'Available if total is lower than',
        'countries' => 'Available for shipping to these countries',
        'countries_comment' => 'If no country is selected this method is available worldwide.',
        'not_required_name' => 'No shipping required',
        'not_required_description' => 'The current cart does not require any shipping.',
    ],
    'payment_status' => [
        'paid' => 'Paid',
        'deferred' => 'Deferred',
        'paid_deferred' => 'Paid deferred',
        'paiddeferred' => 'Paid deferred',
        'charged_back' => 'Charged back',
        'refunded' => 'Refunded',
        'paidout' => 'Paidout',
        'failed' => 'Failed',
        'pending' => 'Pending',
        'expired' => 'Expired',
        'cancelled' => 'Cancelled',
        'open' => 'Open',
    ],
    'permissions' => [
        'manage_products' => 'Can manage products',
        'manage_categories' => 'Can manage categories',
        'manage_orders' => 'Can manage orders',
        'manage_discounts' => 'Can manage discounts',
        'settings' => [
            'manage_general' => 'Can change general shop settings',
            'manage_payment_gateways' => 'Can change payment gateway settings',
            'manage_currency' => 'Can change currency shop settings',
            'manage_payment_methods' => 'Can change payment methods',
        ],
        'manage_properties' => 'Can edit product properties',
        'manage_customer_groups' => 'Can manage customer groups',
        'manage_customer_addresses' => 'Can manage customer addresses',
        'manage_notifications' => 'Can manage notifications',
        'manage_price_categories' => 'Can manage price categories',
        'manage_order_states' => 'Can manage order states',
        'manage_shipping_methods' => 'Can manage shipping methods',
        'manage_taxes' => 'Can manage taxes',
        'manage_payment_log' => 'Can manage payment log',
        'manage_feeds' => 'Can manage feeds',
        'manage_wishlists' => 'Can manage wishlists',
        'manage_services' => 'Can manage services',
        'manage_reviews' => 'Can manage reviews',
        'manage_brands' => 'Can manage brands',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Products',
                'description' => 'Displays a list of products',
            ],
            'properties' => [
                'no_category_filter' => 'Don\'t filter by category',
                'use_url' => 'Use category slug from URL',
                'filter_component' => [
                    'title' => 'Filter component alias',
                    'description' => 'Alias of the ProductsFilter component that filters this Products component',
                ],
                'filter' => [
                    'title' => 'Filter string',
                    'description' => 'Forced filter for this component',
                ],
                'include_variants' => [
                    'title' => 'Show article variants',
                    'description' => 'Don\'t show single products but all available product variants',
                ],
                'include_children' => [
                    'title' => 'Include children',
                    'description' => 'Show all products of child categories as well',
                ],
                'per_page' => [
                    'title' => 'Per page',
                    'description' => 'How many products to display per page',
                ],
                'paginate' => [
                    'title' => 'Paginate',
                    'description' => 'Paginate the result (show more than one page)',
                ],
                'sort' => [
                    'title' => 'Sort',
                    'description' => 'This overrides the user\'s sort preference',
                ],
                'set_page_title' => [
                    'title' => 'Set page title',
                    'description' => 'Use the category\'s name as page title',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Products filter',
                'description' => 'Filters the products from a category',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Show price filter',
                ],
                'showBrandFilter' => [
                    'title' => 'Show brand filter',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Show on sale filter',
                ],
                'includeChildren' => [
                    'title' => 'Include children',
                    'description' => 'Include properties and filters from products in child categories as well',
                ],
                'includeVariants' => [
                    'title' => 'Include variants',
                    'description' => 'Show filters for variant properties',
                ],
                'includeSliderAssets' => [
                    'title' => 'Include noUI Slider',
                    'description' => 'Include all dependencies of noUI Slider via cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Sort order',
                    'description' => 'Initial sort order',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Bestseller',
                'priceLow' => 'Lowest price',
                'priceHigh' => 'Highest price',
                'latest' => 'Latest',
                'oldest' => 'Oldest',
                'random' => 'Random',
                'manual' => 'Manual',
                'name' => 'Name',
                'ratings' => 'Ratings',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'User account',
                'description' => 'Displays different forms where a user can view and edit his profile',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Active subpage',
                ],
            ],
            'pages' => [
                'orders' => 'Orders',
                'profile' => 'Profile',
                'addresses' => 'Addresses',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Customer profile',
                'description' => 'Displays a customer profile edit form.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Currency picker',
                'description' => 'Shows a picker to select the currently active shop currency',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Frontend dependencies',
                'description' => 'Includes all needed frontend dependencies',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Address list',
                'description' => 'Displays a list of all registered user addresses',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'The requested address could not be found',
                'cannot_delete_last_address' => 'You cannot delete your last address',
            ],
            'messages' => [
                'address_deleted' => 'Address deleted',
                'default_billing_address_changed' => 'Default billing address changed',
                'default_shipping_address_changed' => 'Default shipping address changed',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Orders list',
                'description' => 'Displays a list of all customer orders',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Product details',
                'description' => 'Displays details of a product',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Redirect on property change',
                    'description' => 'Redirect the user to the new detail page if a property was changed',
                ],
            ],
            'added_to_cart' => 'Added product successfully',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Product reviews',
                'description' => 'Displays all reviews of a product',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Number of reviews per page',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Show only ratings of this Variant',
                    'description' => "Don't show reviews of other Variants of this Product",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Cart',
                'description' => 'Displays the shopping cart',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Show discount applier',
                ],
                'discountCodeLimit' => [
                    'title' => 'Discount code limit',
                    'description' => 'Set to 0 for unlimited codes',
                ],
                'showShipping' => [
                    'title' => 'Show shipping cost',
                ],
                'showTaxes' => [
                    'title' => 'Show taxes',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Show proceed to checkout button',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Checkout',
                'description' => 'Handles the checkout process',
            ],
            'errors' => [
                'missing_settings' => 'Please select a payment and shipping method.',
            ],
            'properties' => [
                'step' => [
                    'name' => 'Active checkout step (is set automatically)',
                ],
            ],
        ],
        'quickCheckout' => [
            'details' => [
                'name' => 'Quick Checkout',
                'description' => 'Single-page checkout process',
            ],
            'errors' => [
                'signup_failed' => 'Failed to create user account.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Promo code input',
                'description' => 'Displays a promo code input field',
            ],
            'discount_applied' => 'Discount applied successfully!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Shipping selector',
                'description' => 'Displays a list of all available shipping methods',
            ],
            'errors' => [
                'unavailable' => 'The selected shipping method is not available for your order.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Payment method selector',
                'description' => 'Displays a list of all available payment methods',
            ],
            'errors' => [
                'unavailable' => 'The selected payment method is not available for your order.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Address selector',
                'description' => 'Displays a list of all existing user addresses',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Address form',
                'description' => 'Displays a form to edit a user\'s address',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Address',
                ],
                'redirect' => [
                    'title' => 'Redirect (after save)',
                ],
                'set' => [
                    'title' => 'Use this address as',
                ],
            ],
            'redirects' => [
                'checkout' => 'Checkout page',
            ],
            'set' => [
                'billing' => 'Billing address',
                'shipping' => 'Shipping address',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Signup',
                'description' => 'Displays a signup and signin form',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Redirect after login',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'You are trying to sign in with a guest account.',
                'unknown_user' => 'The credentials you have entered are invalid.',
                'not_activated' => 'Your account needs to be activated before you can login.',
                'login' => [
                    'required' => 'Please enter an email address.',
                    'email' => 'Please enter a valid email address.',
                    'between' => 'Please enter a valid email address.',
                ],
                'password' => [
                    'required' => 'Please enter your password.',
                    'max' => 'The provided password is too long.',
                    'min' => 'The provided password is too short. Please enter at least 8 characters.',
                ],
                'password_repeat' => [
                    'required' => 'Please repeat your password.',
                    'same' => 'Your password confirmation does not match your entered password.',
                ],
                'email' => [
                    'required' => 'Please enter an email address.',
                    'email' => 'This email address is invalid.',
                    'unique' => 'A user with this email address is already registered.',
                    'non_existing_user' => 'A user with this email address is already registered. Use the password reset function.',
                ],
                'firstname' => [
                    'required' => 'Please enter your first name.',
                ],
                'lastname' => [
                    'required' => 'Please enter your last name.',
                ],
                'lines' => [
                    'required' => 'Please enter your address.',
                ],
                'zip' => [
                    'required' => 'Please enter your zip code.',
                ],
                'city' => [
                    'required' => 'Please enter a city.',
                ],
                'country_id' => [
                    'required' => 'Choose a country.',
                    'exists' => 'The provided country is not valid.',
                ],
                'state_id' => [
                    'required' => 'Choose a state',
                    'exists' => 'The selected value is not valid.',
                ],
                'terms_accepted' => [
                    'required' => 'Please accept our terms and conditions.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Categories',
                'description' => 'Lists available categories',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Start from category',
                    'description' => 'Only show child categories of this category',
                ],
                'categorySlug' => [
                    'title' => 'Category slug parameter',
                    'description' => 'Use this parameter to load the parent category from the url',
                ],
                'categoryPage' => [
                    'title' => 'Category page',
                    'description' => 'Links will point to this page. If nothing is entered the default settings from the backend settings will be used.',
                ],
            ],
            'no_parent' => 'Show all categories',
            'by_slug' => 'Use category in url as parent',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Cart summary',
                'description' => 'Displays the number of products in and total value of the cart',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Show product count',
                    'description' => 'Displays the count of items in the cart',
                ],
                'showTotalPrice' => [
                    'title' => 'Show total value',
                    'description' => 'Displays the total value of all items in the cart',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Customer dashboard',
                'description' => 'Displays a link for the customer to login and change her account settings',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Customer dashboard label',
                    'description' => 'Link text for the customer account page',
                ],
                'logoutLabel' => [
                    'title' => 'Logout label',
                    'description' => 'Link text for the logout link',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Enhanced Ecommerce (UA) Component',
                'description' => 'Implements a Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Wishlist button',
                'description' => 'Displays a wishlist button',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Product',
                    'description' => 'ID of the product',
                ],
                'variant' => [
                    'name' => 'Variant',
                    'description' => 'ID of the variant',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Wishlists',
                'description' => 'Displays the wishlist manager',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Show shipping',
                    'description' => 'Show shipping cost and selector',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'From (Weight in grams)',
        'to_weight' => 'To (Weight in grams)',
    ],
    'products' => [
        'variants_comment' => 'Create different variants of the same product',
    ],
    'order_states' => [
        'name' => 'Name',
        'description' => 'Description',
        'color' => 'Color',
        'flag' => 'Special flag',
        'flags' => [
            'new' => 'Set the state of the order as "new"',
            'complete' => 'Set the state of the order as "done"',
            'cancelled' => 'Set the state of the order as "cancelled"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'This code can be used to identify this group programmatically',
        'discount_comment' => 'Give this customer group a specific discount in % on your whole catalogue',
    ],
    'order_status' => [
        'processed' => 'Processed',
        'disputed' => 'Disputed',
        'shipped' => 'Shipped',
        'delivered' => 'Delivered',
        'pending' => 'Pending',
        'cancelled' => 'Cancelled',
    ],
    'notifications' => [
        'enabled' => 'Enabled',
        'enabled_comment' => 'This notification is enabled',
        'template' => 'Mail template',
    ],
    'payment_log' => [
        'payment_data' => 'Payment data',
        'data_comment' => 'This data has been returned by the payment provider',
        'order_data_comment' => 'This is all the order data for this payment',
        'message_comment' => 'This message has been returned by the payment provider',
        'code_comment' => 'This code has been returned by the payment provider',
        'failed_only' => 'Failed only',
    ],
    'services' => [
        'options' => 'Options',
        'option' => 'Option',
        'required' => 'Service is required',
        'required_comment' => 'One option of this service has to be selected when a product is added to the cart.',
    ],
    'reviews' => [
        'rating' => 'Rating',
        'review' => 'Review details',
        'title' => 'Title of your review',
        'pros' => 'Positive aspects',
        'cons' => 'Negative aspects',
        'anonymous' => 'Anonymous',
        'only_unapproved' => 'Show only unapproved',
        'no_more' => 'No more unapproved reviews',
        'approved' => 'Review approved',
        'approve' => 'Approve review',
        'approve_next' => 'Approve and go to next',
    ],
];
