<?php return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'Ecommerce-Plattform für October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Produkt erstellen',
            'update' => 'Produkt bearbeiten',
            'preview' => 'Produkt-Vorschau',
        ],
        'categories' => [
            'create' => 'Kategorie erstellen',
            'update' => 'Kategorie bearbeiten',
            'preview' => 'Kategorie-Vorschau',
        ],
        'orders' => [
            'show' => 'Bestellungsdetails',
            'export' => 'Bestellungen exportieren',
        ],
        'discounts' => [
            'create' => 'Rabatt erstellen',
            'update' => 'Rabatt bearbeiten',
            'preview' => 'Rabatt-Vorschau',
        ],
        'services' => [
            'create' => 'Service erstellen',
            'update' => 'Service bearbeiten',
        ],
        'shipping_methods' => [
            'create' => 'Versandmethode erstellen',
            'update' => 'Versandmethode bearbeiten',
            'preview' => 'Versandmethode-Vorschau',
        ],
        'payment_methods' => [
            'create' => 'Zahlungsmethode erstellen',
            'edit' => 'Zahlungsmethode bearbeiten',
            'reorder' => 'Sortieren',
        ],
        'custom_field_options' => [
            'edit' => 'Feldoptionen bearbeiten',
        ],
        'properties' => [
            'create' => 'Eigenschaft erstellen',
            'edit' => 'Eigenschaft bearbeiten',
        ],
        'order_states' => [
            'create' => 'Status erstellen',
            'edit' => 'Status bearbeiten',
            'reorder' => 'Status sortieren',
        ],
        'brands' => [
            'create' => 'Marke erstellen',
            'edit' => 'Marke bearbeiten',
        ],
        'property_groups' => [
            'create' => 'Gruppe erstellen',
            'edit' => 'Gruppe bearbeiten',
        ],
        'customer_groups' => [
            'create' => 'Kundengruppe erstellen',
            'update' => 'Kundengruppe bearbeiten',
        ],
        'notifications' => [
            'update' => 'Benachrichtigung aktualisieren',
        ],
        'taxes' => [
            'create' => 'Steuer erstellen',
            'update' => 'Steuer bearbeiten',
        ],
        'reviews' => [
            'create' => 'Review erstellen',
            'update' => 'Review bearbeiten',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Alle Shop-Kategorien',
        'single_category' => 'Einzelne Shop-Kategorie',
        'all_products' => 'Alle Shop-Produkte',
        'all_variants' => 'Alle Shop-Varianten',
    ],
    'currency_settings' => [
        'label' => 'Währungen',
        'description' => 'Einstellungen zu den verwendeten Währungen',
        'currencies' => 'Geben Sie jeweils nur den offiziellen dreistelligen Währungscode ein.',
        'currency_code' => 'Währungscode',
        'currency_decimals' => 'Anz. Dezimalstellen',
        'currency_rounding' => 'Rundung des Totals',
        'currency_rounding_comment' => 'Das Gesamttotal inklusive Steuern wird auf diesen Wert gerundet, wenn diese Währung aktiv ist.',
        'currency_format' => 'Formatierung',
        'currency_symbol' => 'Symbol',
        'currency_rate' => 'Kurs zu Basiswährung',
        'is_default' => 'Ist Standard',
        'unknown' => 'Unbekannte Währung',
    ],
    'payment_gateway_settings' => [
        'label' => 'Zahlungsanbieter',
        'description' => 'Einstellungen zu den Zahlungsanbietern',
        'stripe' => [
            'api_key' => 'Stripe API-Key',
            'api_key_comment' => 'Du findest diesen in deinem Stripe Dashboard',
            'publishable_key' => 'Stripe Publishable-Key',
            'publishable_key_comment' => 'Du findest diesen in deinem Stripe Dashboard',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client-ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Test-Modus',
            'test_mode_comment' => 'Führe alle Zahlungen in der PayPal Sandbox aus.',
        ],
        'postfinance' => [
            'test_mode' => 'Test-Modus',
            'test_mode_comment' => 'Führe alle Zahlungen im Test-Modus aus.',
            'pspid' => 'PSPID (Benutzername)',
            'hashing_method' => 'Hash-Algorithmus',
            'hashing_method_comment' => 'Konfiguration -> Technische Informationen -> Globale Sicherheitsparameter',
            'sha_in' => 'SHA-IN Signatur',
            'sha_in_comment' => 'Konfiguration -> Technische Informationen -> Daten- und Ursprungsüberprüfung',
            'sha_out' => 'SHA-OUT Signatur',
            'sha_out_comment' => 'Konfiguration -> Technische Informationen -> Transaktions-Feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'Benachrichtigungen',
        'description' => 'Benachrichtigungen konfigurieren',
    ],
    'price_category_settings' => [
        'label' => 'Preiskategorien',
        'description' => 'Zusätzliche Preiskategorien verwalten',
    ],
    'order_state_settings' => [
        'description' => 'Mögliche Status für Bestellungen verwalten',
    ],
    'payment_method_settings' => [
        'description' => 'Zahlungsmethoden verwalten',
    ],
    'shipping_method_settings' => [
        'description' => 'Versandmethoden verwalten',
    ],
    'tax_settings' => [
        'description' => 'Steuern verwalten',
    ],
    'general_settings' => [
        'category' => 'Mall: Allgemein',
        'category_payments' => 'Mall: Zahlungen',
        'category_orders' => 'Mall: Bestellungen',
        'label' => 'Grundkonfiguration',
        'description' => 'Allgemeine Einstellungen',
        'product_page' => 'Produkt-Seite',
        'product_page_comment' => 'Auf dieser Seite werden die Produkt-Details angezeigt',
        'address_page' => 'Adressen-Seite',
        'address_page_comment' => 'Auf dieser Seite muss die addressForm Komponente platziert werden',
        'checkout_page' => 'Checkout-Seite',
        'checkout_page_comment' => 'Auf dieser Seite muss die checkout Komponente platziert werden',
        'account_page' => 'Account-Seite',
        'account_page_comment' => 'Auf dieser Seite muss die myAccount Komponente platziert werden',
        'cart_page' => 'Warenkorb-Seite',
        'cart_page_comment' => 'Auf dieser Seite muss die cart Komponente platziert werden',
        'category_page' => 'Kategorie-Seite für Produkte-Übersicht',
        'redirect_to_cart' => 'Warenkorb nach Hinzufügen anzeigen',
        'redirect_to_cart_comment' => 'Der Warenkorb wird direkt angezeigt, wenn ein Produkt hinzugefügt wurde',
        'use_state' => 'Verwende «Kanton/Bundesstaat»',
        'use_state_comment' => 'Kunden müssen bei der Registrierung ein Kanton/Bundesstaat auswählen',
        'group_search_results_by_product' => 'Suchresultate nach Produkt gruppieren',
        'group_search_results_by_product_comment' => 'Zeige in den Suchresultaten nur das Hauptprodukt an, nicht alle passenden Varianten',
        'shipping_selection_before_payment' => 'Versand- vor Zahlungsmethode auswählen',
        'shipping_selection_before_payment_comment' => 'Standardmässig wird die Zahlungsmethode vor der Versandmethode ausgewählt. Wird diese Option aktiviert, ist die Reihenfolge umgekehrt.',
        'admin_email' => 'E-Mail des Admins',
        'admin_email_comment' => 'Benachrichtigungen werden an diese E-Mail versendet',
        'base' => 'Allgemein',
        'links' => 'Verlinkungen',
        'links_comment' => 'Wähle aus, auf welche Seiten für dein Shop verwendet werden sollen',
        'customizations' => 'Optionen',
        'customizations_comment' => 'Globale Konfigurationseinstellungen für deinen Shop',
        'order_number_start' => 'Beginn Bestellungsnummerierung',
        'order_number_start_comment' => 'Die erste Bestellung erhält diese Nummer',
        'index_driver' => 'Index-Treiber',
        'index_driver_comment' => 'Wenn deine Datenbank JSON unterstützt wird der Datenbank-Treiber empfohlen.',
        'index_driver_filesystem' => 'Dateisystem',
        'index_driver_database' => 'Datenbank (nur für MySQL 5.7+ oder MariaDB 10.2+)',
        'index_driver_hint' => 'Nachdem diese Option geändert wurde muss "php artisan mall:reindex" auf der Konsole ausgeführt werden!',
    ],
    'feed_settings' => [
        'description' => 'Feeds konfigurieren',
        'google_merchant_enabled' => 'Verwende Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'Ein Produktfeed wird über eine URL zugänglich gemacht',
        'google_merchant_url' => 'Deine Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Füge ?locale=xy zur URL hinzu um einen übersetzten Feed zu erhalten.',
    ],
    'review_settings' => [
        'description' => 'Reviews konfigurieren',
        'enabled' => 'Reviews aktiviert',
        'enabled_comment' => 'Kunden können Produkte bewerten',
        'moderated' => 'Reviews moderieren',
        'moderated_comment' => 'Reviews werden erst nach manueller Prüfung auf der Website sichtbar',
        'allow_anonymous' => 'Anonyme Reviews zulassen',
        'allow_anonymous_comment' => 'Unregistrierte Benutzer dürfen Reviews erstellen',
    ],
    'common' => [
        'shop' => 'Shop',
        'products' => 'Produkte',
        'product' => 'Produkt',
        'orders' => 'Bestellungen',
        'cart' => 'Warenkorb',
        'shipping' => 'Versand',
        'taxes' => 'Steuern',
        'rates' => 'Konditionen',
        'inventory' => 'Lagerbestand',
        'accessories' => 'Zubehör',
        'shipping_methods' => 'Versandmethoden',
        'accessory' => 'Zubehör',
        'custom_fields' => 'Benutzerdefinierte Felder',
        'variants' => 'Varianten',
        'variant' => 'Variante',
        'discounts' => 'Rabatte',
        'discount' => 'Rabatt',
        'discount_percentage' => 'Rabatt (in %)',
        'select_placeholder' => '-- Bitte wählen',
        'main_image' => 'Hauptbild',
        'images' => 'Bilder',
        'image_set' => 'Bilderset',
        'attachments' => 'Bilder/Downloads/Embeds',
        'downloads' => 'Downloads',
        'select_image' => 'Bild auswählen',
        'select_file' => 'Datei auswählen',
        'allowed' => 'Erlaubt',
        'not_allowed' => 'Nicht erlaubt',
        'yes' => 'Ja',
        'no' => 'Nein',
        'seo' => 'SEO',
        'properties_links' => 'Eigenschaften/Links',
        'categories' => 'Kategorien',
        'category' => 'Kategorie',
        'meta_title' => 'Meta-Titel',
        'meta_description' => 'Meta-Beschreibung',
        'meta_keywords' => 'Meta-Keywords',
        'reorder' => 'Reihenfolge ändern',
        'id' => 'ID',
        'created_at' => 'Erstellt',
        'updated_at' => 'Aktualisiert',
        'approved_at' => 'Freigegeben am',
        'hide_published' => 'Verstecke veröffentlichte',
        'slug' => 'URL',
        'name' => 'Name',
        'display_name' => 'Anzeigename',
        'group_name' => 'Gruppenname',
        'add_value' => 'Wert hinzufügen',
        'export_orders' => 'Bestellungen exportieren',
        'use_backend_defaults' => 'Standard-Einstellung aus Backend-Settings übernehmen',
        'api_error' => 'Fehler beim Speichern der Änderungen. Die API-Anfrage war fehlerhaft.',
        'includes_tax' => 'Inklusive Steuern',
        'conditions' => 'Konditionen',
        'general' => 'Allgemein',
        'logo' => 'Logo',
        'payment_gateway' => 'Zahlungsgateway',
        'payment_provider' => 'Zahlungsanbieter',
        'payment_methods' => 'Zahlungsmethoden',
        'payment' => 'Zahlung',
        'payments' => 'Zahlungen',
        'image' => 'Bild',
        'color' => 'Farbe',
        'unit' => 'Einheit',
        'dont_group' => '-- Nicht gruppieren',
        'properties' => 'Eigenschaften',
        'old_price' => 'Alter Preis',
        'property' => 'Eigenschaft',
        'property_groups' => 'Eigenschaftsgruppen',
        'property_group' => 'Eigenschaftsgruppe',
        'options' => 'Optionen',
        'option' => 'Option',
        'catalogue' => 'Katalog',
        'out_of_stock' => 'Es sind nur noch :quantity Stück von diesem Artikel an Lager',
        'out_of_stock_short' => 'Dieser Artikel ist ausverkauft',
        'stock_limit_reached' => 'Es stehen keine weiteren Stücke dieses Artikels zur Verfügung',
        'deleted_at' => 'Gelöscht am',
        'sort_order' => 'Sortierreihenfolge',
        'order_states' => 'Bestellungs-Status',
        'website' => 'Website',
        'brands' => 'Marken',
        'brand' => 'Marke',
        'sorting_updated' => 'Reihenfolge aktualisiert',
        'not_in_use' => 'Option nicht verwendet',
        'saved_changes' => 'Änderungen gespeichert',
        'none' => '-- Nicht definiert',
        'customers' => 'Kunden',
        'customer_groups' => 'Kundengruppen',
        'customer_group' => 'Kundengruppe',
        'product_or_variant' => 'Produkt/Variante',
        'code' => 'Code',
        'code_comment' => 'Dieser Code kann zur Identifikation genutzt werden',
        'checked' => 'Aktiv',
        'unchecked' => 'Inaktiv',
        'notifications' => 'Benachrichtigungen',
        'notification' => 'Benachrichtigung',
        'price_missing' => 'Gib mindestens ein Preis in der Hauptwährung an',
        'slug_unique' => 'Die URL existiert bereits',
        'fees' => 'Gebühren',
        'value' => 'Wert',
        'action_required' => 'Aktion wird benötigt!',
        'invalid_quantity' => 'Die eingetragene Anzahl ist ungültig.',
        'addresses' => 'Adressen',
        'address' => 'Adresse',
        'reference' => 'Referenz',
        'session_id' => 'Session-ID',
        'message' => 'Nachricht',
        'payment_method' => 'Zahlungsmethode',
        'data' => 'Data',
        'successful' => 'Erfolgreich',
        'failed' => 'Fehlgeschlagen',
        'caution' => 'Achtung',
        'since_begin' => 'Seit Beginn',
        'weekly' => 'Wöchentlich',
        'feeds' => 'Feeds',
        'services' => 'Services',
        'service' => 'Service',
        'review' => 'Review',
        'reviews' => 'Reviews',
        'review_categories' => 'Review-Kategorien',
        'review_category' => 'Review-Kategorie',
        'title' => 'Titel',
        'version' => 'Version',
        'duplicate_selected' => 'Markierte duplizieren',
        'duplicated' => 'Erfolgreich dupliziert',
    ],
    'variant' => [
        'method' => [
            'single' => 'Artikel',
            'variant' => 'Artikelvarianten',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Verwende für Varianten',
        'use_for_variants_comment' => 'Diese Eigenschaft unterscheidet sich für die verschiedenen Produkt-Varianten',
        'filter_type' => 'Filter-Typ',
        'filter_types' => [
            'none' => 'Ohne Filtermöglichkeit',
            'set' => 'Mehrfachauswahl',
            'range' => 'Bereichsauswahl',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Textfeld',
        'integer' => 'Ganzzahl',
        'float' => 'Gleitkommazahl',
        'textarea' => 'Mehrzeiliges Textfeld',
        'richeditor' => 'Richtext',
        'dropdown' => 'Auswahlliste',
        'checkbox' => 'Checkbox',
        'color' => 'Farbe',
        'image' => 'Bild/Motiv',
        'add' => 'Option hinzufügen',
        'name' => 'Name',
        'price' => 'Aufpreis',
        'attributes' => 'Attribute',
        'option' => 'Option',
        'date' => 'Datum',
        'datetime' => 'Datum und Uhrzeit',
    ],
    'product' => [
        'user_defined_id' => 'Artikelnummer',
        'name' => 'Produktname',
        'published' => 'Veröffentlicht',
        'published_short' => 'Veröffentl.',
        'is_virtual' => 'Ist virtuell',
        'is_virtual_comment' => 'Dieses Produkt ist virtuell (Datei, kein Versand)',
        'product_file' => 'Produkt-Datei',
        'product_files' => 'Produkt-Dateien',
        'product_files_section_comment' => 'Dieses Produkt ist virtuell. Laden Sie hier beliebig viele Dateiversionen hoch. Die neuste Version wird dem Kunden beim Kauf zum Download angeboten.',
        'product_file_version' => 'Datei-Version',
        'not_published' => 'Nicht veröffentlicht',
        'published_comment' => 'Dieser Artikel ist im Shop sichtbar',
        'stock' => 'Lagerbestand',
        'price' => 'Preis',
        'description_short' => 'Kurzbeschreibung',
        'description' => 'Beschreibung',
        'weight' => 'Gewicht',
        'length' => 'Länge',
        'height' => 'Höhe',
        'width' => 'Breite',
        'quantity_default' => 'Standard-Bestellmenge',
        'quantity_min' => 'Minimale Bestellmenge',
        'quantity_max' => 'Maximale Bestellmenge',
        'inventory_management_method' => 'Inventarverwaltungs-Methode',
        'allow_out_of_stock_purchases' => 'Nicht-an-Lager-Kauf erlauben',
        'allow_out_of_stock_purchases_comment' => 'Produkt darf bestellt werden, wenn es nicht an Lager ist',
        'stackable' => 'In Warenkorb zusammenfassen',
        'stackable_comment' => 'Beim mehrmaligen Hinzufügen zum Warenkorb diesen Artikel nur einmal auflisten (Anzahl erhöhen)',
        'shippable' => 'Versand möglich',
        'shippable_comment' => 'Dieser Artikel kann versendet werden',
        'taxable' => 'Besteuert',
        'taxable_comment' => 'Auf diesen Artikel fallen Steuern an',
        'add_currency' => 'Währung hinzufügen',
        'is_taxable' => 'Besteuert',
        'is_not_taxable' => 'Nicht besteuert',
        'currency' => 'Währung',
        'general' => 'Allgemein',
        'duplicate_currency' => 'Sie haben für eine Währung mehrere Preise eingetragen.',
        'property_title' => 'Titel',
        'property_value' => 'Wert',
        'link_title' => 'Titel',
        'link_target' => 'Link-Ziel',
        'embed_title' => 'Titel',
        'embed_code' => 'Embed-Code',
        'properties' => 'Eigenschaften',
        'links' => 'Links',
        'embeds' => 'Embeds',
        'details' => 'Details',
        'price_includes_tax' => 'Preis ist inkl. Steuern',
        'price_includes_tax_comment' => 'Der angegebene Preis enthält bereits alle Steuern',
        'group_by_property' => 'Attribut für Varianten-Gruppierung',
        'additional_descriptions' => 'Zusätzliche Beschreibungen',
        'additional_properties' => 'Zusätzliche Eigenschaften',
        'gtin' => 'Global Trade Item Number (GTIN)',
        'mpn' => 'Manufacturer Part Number (MPN)',
        'price_table_modal' => [
            'trigger' => 'Preise und Lagerbestand bearbeiten',
            'label' => 'Preise und Lagerbestand',
            'title' => 'Übersicht für Preise und Lagerbestand',
            'currency_dropdown' => 'Währung: ',
        ],
        'missing_category' => 'Dieses Produkt gehört derzeit zu keiner Kategorie. Bitte wählen Sie eine Kategorie aus.',
        'variant_support_header' => 'Varianten nicht unterstützt',
        'variant_support_text' => 'Die ausgewählte Kategorie hat keine Varianten-Eigenschaften definiert. Wechseln Sie die Inventarverwaltungs-Methode auf "Artikel" oder wählen Sie eine andere Kategorie aus.',
        'filter_virtual' => 'Zeige nur virtuelle Produkte',
    ],
    'product_file' => [
        'display_name_comment' => 'Dieser Name wird dem Kunden angezeigt.',
        'version_comment' => 'Die Versionsnummer erleichtert es Kunden neue Datei zu bemerken.',
        'expires_after_days' => 'Gültigkeitsdauer in Tagen nach Kauf',
        'expires_after_days_comment' => 'Die Datei kann für so viele Tage nach dem Kauf heruntergeladen werden. Leer lassen für unbegrenzt.',
        'max_download_count' => 'Anzahl erlaubter Downloads',
        'max_download_count_comment' => 'Die Datei kann nach erreichen dieser Anzahl nicht mehr heruntergeladen werden. Leer lassen für unbegrenzt.',
        'session_required' => 'Login benötigt',
        'session_required_comment' => 'Die Datei kann nur nach dem Login mit einem Kundenkonto heruntergeladen werden (Link ist nicht teilbar).',
        'file' => 'Datei',
        'download_count' => 'Anz. Downloads',
        'errors' => [
            'invalid' => 'Ungültiger Download-Link',
            'expired' => 'Download-Link ist nicht mehr gültig',
            'too_many_attempts' => 'Maximale Anzahl der Download-Versuche erreicht',
            'not_found' => 'Die aufgerufene Datei konnte nicht gefunden werden. Bitte kontaktieren Sie uns.',
        ],
        'hint' => [
            'intro' => 'Dieses Produkt hat noch keinen Dateianhang. Laden Sie eine Datei hoch oder generieren Sie diese während des Checkouts.',
            'info_text' => 'Informationen über automatisch generierte Dateien finden Sie',
            'info_link' => 'in der Online-Dokumentation',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Ist Hauptset',
        'is_main_set_comment' => 'Verwende dieses Set für die Produktbilder',
        'create_new' => 'Erstelle neues Set',
    ],
    'category' => [
        'name' => 'Name',
        'code' => 'Code',
        'code_comment' => 'Dieser Code kann im Frontend zur Identifikation der Kategorie genutzt werden.',
        'parent' => 'Elternelement',
        'no_parent' => 'Kein Elternelement',
        'inherit_property_groups' => 'Übernehme Eigenschaften von Elternkategorie',
        'inherit_property_groups_comment' => 'Für diese Kategorie werden die gleichen Eigenschaften wie für die Elternkategorie verwendet',
        'inherit_review_categories' => 'Übernehme Review-Kategorien von Elternkategorie',
        'inherit_review_categories_comment' => 'Für diese Kategorie werden die gleichen Review-Kategorien wie für die Elternkategorie verwendet',
        'google_product_category_id' => 'Google Produkt-Kategorie ID',
        'google_product_category_id_comment' => 'Für Google Merchant Integration, siehe https://support.google.com/merchants/answer/6324436?hl=de',
    ],
    'custom_fields' => [
        'name' => 'Feldname',
        'type' => 'Typ',
        'options' => 'Optionen',
        'required' => 'Pflichtfeld',
        'required_comment' => 'Dieses Feld muss beim Tätigen einer Bestellung ausgefüllt werden',
        'is_required' => 'Pflichtfeld',
        'is_not_required' => 'Kein Pflichtfeld',
    ],
    'tax' => [
        'percentage' => 'Prozent',
        'countries' => 'Steuer gilt nur für Versand in diese Länder',
        'countries_comment' => 'Wird kein Land ausgewhält gilt die Steuer weltweit.',
        'is_default' => 'Ist Standard',
        'is_default_comment' => 'Diese Steuer wird verwendet falls das Versand-Land noch nicht bekannt ist',
    ],
    'discounts' => [
        'name' => 'Name',
        'code' => 'Gutschein-Code',
        'code_comment' => 'Leer lassen, um automatisch zu generieren',
        'total_to_reach' => 'Gültig ab Bestellwert',
        'type' => 'Gutschein-Typ',
        'trigger' => 'Gültig wenn',
        'rate' => 'Rabatt (%)',
        'amount' => 'Rabatt-Betrag',
        'max_number_of_usages' => 'Maximale Anzahl Anwendungen',
        'expires' => 'Gültig bis',
        'number_of_usages' => 'Anzahl Anwendungen',
        'shipping_description' => 'Name für alternative Versand-Methode',
        'shipping_price' => 'Preis für alternative Versand-Methode',
        'shipping_guaranteed_days_to_delivery' => 'Garantierte Lieferung in Tagen',
        'section_type' => 'Was bewirkt der Gutschein?',
        'section_trigger' => 'Wann ist der Gutschein gültig?',
        'types' => [
            'fixed_amount' => 'Fixer-Rabatt',
            'rate' => 'Prozentualer-Rabatt',
            'shipping' => 'Alternativer Versand-Preis',
        ],
        'triggers' => [
            'total' => 'Bestimmter Bestellwert erreicht wird',
            'code' => 'Gutschein-Code eingegeben wird',
            'product' => 'Bestimmtes Produkt im Warenkorb liegt',
            'shipping_method' => 'Die Versandart eine der ausgewählten ist',
            'customer_group' => 'Der Benutzer zu einer Kundengruppe gehört',
            'payment_method' => 'Eine bestimmte Zahlungsmethode ausgewählt wird',
        ],
        'validation' => [
            'empty' => 'Geben Sie einen Gutschein-Code ein.',
            'shipping' => 'Es kann nur ein Gutschein für einen Versandrabatt angewendet werden.',
            'duplicate' => 'Ein Gutschein kann nur einmal verwendet werden.',
            'expired' => 'Der verwendete Gutschein ist nicht mehr gültig.',
            'not_found' => 'Der verwendete Gutschein ist nicht gültig.',
            'usage_limit_reached' => 'Dieser Gutschein wurde zu oft verwendet und ist daher nicht mehr gültig.',
        ],
    ],
    'payment_method' => [
        'price' => 'Fixkosten',
        'price_comment' => 'Der Betrag wird zum Total dazugerechnet',
        'fee_percentage' => 'Prozentuale Kosten',
        'fee_percentage_comment' => 'Prozent des Gesamttotals, wird zum Total dazugerechnet',
        'fee_label' => 'Gebührenbezeichnung',
        'fee_label_comment' => 'Dieser Text wird dem Kunden im Warenkorb angezeigt',
        'instructions' => 'Zahlungsanweisung',
        'instructions_comment' => 'Unterstützt Twig Syntax. Verwende {{ order }} oder {{ cart }} um Infos zur Bestellung abzurufen (falls vorhanden)',
        'pdf_partial' => 'Partial für PDF-Versand',
        'pdf_partial_comment' => 'Bei einer Bestellung mit dieser Zahlungsmethode wird das ausgewählte Partial als PDF versendet',
        'pdf_partial_none' => 'Kein PDF-Versand',
    ],
    'order' => [
        'order_number' => '# Bestl.',
        'invoice_number' => '# Rechn.',
        'payment_hash' => 'Bezahl-ID',
        'customer' => 'Kunde',
        'creation_date' => 'Erstellt am',
        'modification_date' => 'Bearbeitet am',
        'completion_date' => 'Abgeschlossen am',
        'credit_card' => 'Kreditkarte',
        'payment_status' => 'Bezahlstatus',
        'grand_total' => 'Gesamttotal',
        'billing_address' => 'Rechnungsadresse',
        'shipping_address' => 'Versandadresse',
        'currency' => 'Währung',
        'status' => 'Status',
        'email' => 'Email',
        'will_be_paid_later' => 'Wird später bezahlt',
        'shipping_address_same_as_billing' => 'Versandadresse gleich wie Rechnungsadresse',
        'credit_card_last4_digits' => 'Letzte 4 Ziffern',
        'tracking_number' => 'Trackingnummer',
        'tracking_url' => 'Tracking-URL',
        'tracking_shipped' => 'Bestellung als versendet markieren',
        'tracking_shipped_comment' => 'Die Bestellung wird nach dem Speichern als versendet markiert',
        'tracking_completed' => 'Bestellung als abgeschlossen markieren',
        'tracking_completed_comment' => 'Die Bestellung wird als abgeschlossen markiert',
        'tracking_notification' => 'Benachrichtigung versenden',
        'tracking_notification_comment' => 'Eine Benachrichtigung mit den Trackinginformationen wird an den Kunden gesendet',
        'shipping_fees' => 'Versandkosten',
        'shipping_provider' => 'Spediteur',
        'shipping_method' => 'Versandmethode',
        'card_holder_name' => 'Kartenhalter',
        'card_type' => 'Kartentyp',
        'payment_method' => 'Zahlungsmethode',
        'payment_gateway_used' => 'Zahlungsgateway',
        'tax_provider' => 'Steuern-Anbieter',
        'lang' => 'Sprache',
        'refunds_amount' => 'Rückerstattungsbetrag',
        'adjusted_amount' => 'Korrigierter Betrag',
        'rebate_amount' => 'Rabatt',
        'total' => 'Total',
        'taxes_total' => 'Steuerntotal',
        'items_total' => 'Artikeltotal',
        'subtotal' => 'Zwischentotal',
        'taxable_total' => 'Steuerbares Total',
        'total_weight' => 'Gesamgtgewicht',
        'total_rebate_rate' => 'Gesamt-Rabatt',
        'notes' => 'Notiz',
        'custom_fields' => 'Benutzerdefinierte Felder',
        'shipping_enabled' => 'Versand aktiv',
        'payment_transaction_id' => 'Transaktions-ID',
        'change_order_status' => 'Bestellungsstatus ändern',
        'change_payment_status' => 'Bezahlstatus ändern',
        'items' => 'Artikel',
        'quantity' => 'Menge',
        'shipping_address_is_same_as_billing' => 'Rechnungs- und Versandadresse sind gleich',
        'update_shipping_state' => 'Versandstatus aktualisieren',
        'invalid_status' => 'Der ausgewählte Status existiert nicht',
        'updated' => 'Bestellung aktualisiert',
        'deleted' => 'Bestellung gelöscht',
        'deleting' => 'Bestellung wird gelöscht...',
        'delete_confirm' => 'Möchtest du diese Bestellung wirklich löschen?',
        'update_invoice_number' => 'Rechnungsnummer ändern',
        'shipped' => 'Versendet',
        'shipping_pending' => 'Versand pendent',
        'not_shipped' => 'Versand ausstehend',
        'data' => 'Bestellungsdaten',
        'total_revenue' => 'Gesamteinnahmen',
        'download_invoice' => 'Rechnung herunterladen',
        'order_file_name' => 'bestellung-:order',
        'virtual_product_download_hint' => 'Der Download-Link wird in einer separaten Mail nach erfolgreicher Bezahlung zugestellt.',
        'modal' => [
            'cancel' => 'Abbrechen',
            'update' => 'Daten aktualisieren',
        ],
        'payment_states' => [
            'pending_state' => 'Zahlung ausstehend',
            'failed_state' => 'Zahlung fehlgeschlagen',
            'refunded_state' => 'Zahlung zurückerstattet',
            'paid_state' => 'Zahlung erhalten',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Garantierte Lieferung in Tagen',
        'available_above_total' => 'Verfügbar wenn Totalbetrag grösser oder gleich',
        'available_below_total' => 'Verfügbar wenn Totalbetrag kleiner',
        'countries' => 'Verfügbar für den Versand in diese Länder',
        'countries_comment' => 'Wird kein Land ausgewählt kann die Versandmethode weltweit verwendet werden.',
        'not_required_name' => 'Kein Versand notwendig',
        'not_required_description' => 'Der Warenkorb benötigt keinen Versand.',
    ],
    'payment_status' => [
        'paid' => 'Bezahlt',
        'deferred' => 'Auf Rechnung',
        'paid_deferred' => 'Auf Rechnung bezahlt',
        'paiddeferred' => 'Auf Rechnung bezahlt',
        'charged_back' => 'Zahlung beglichen',
        'refunded' => 'Zahlung rückerstattet',
        'paidout' => 'Ausgezahlt',
        'failed' => 'Zahlung fehlerhaft',
        'pending' => 'Zahlung pendent',
        'expired' => 'Zahlung abgelaufen',
        'cancelled' => 'Zahlung abgebrochen',
        'open' => 'Zahlung ausstehend',
    ],
    'permissions' => [
        'manage_products' => 'Kann Produkte verwalten',
        'manage_categories' => 'Kann Kategorien verwalten',
        'manage_orders' => 'Kann Bestellungen verwalten',
        'manage_discounts' => 'Kann Rabatte verwalten',
        'settings' => [
            'manage_general' => 'Kann die Grundeinstellungen des Shops verändern',
            'manage_payment_gateways' => 'Kann die Zahlungsanbieter-Einstellungen des Shops verändern',
            'manage_currency' => 'Kann die Währungs-Einstellungen des Shops verändern',
            'manage_payment_methods' => 'Zahlungsmethoden verwalten',
        ],
        'manage_properties' => 'Kann Produkt-Eigenschaften verwalten',
        'manage_customer_groups' => 'Kann Kundengruppen verwalten',
        'manage_customer_addresses' => 'Kann Kundenadressen verwalten',
        'manage_notifications' => 'Kann Benachrichtigungen verwalten',
        'manage_price_categories' => 'Kann Preiskategorien verwalten',
        'manage_order_states' => 'Kann Bestellstatus verwalten',
        'manage_shipping_methods' => 'Kann Versandmethoden verwalten',
        'manage_taxes' => 'Kann Steuern verwalten',
        'manage_payment_log' => 'Kann Zahlungslog verwalten',
        'manage_feeds' => 'Kann Feeds verwalten',
        'manage_wishlists' => 'Kann Merklisten verwalten',
        'manage_services' => 'Kann Services verwalten',
        'manage_reviews' => 'Kann Reviews verwalten',
        'manage_brands' => 'Kann Marken verwalten',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produkte',
                'description' => 'Zeigt eine Liste von Produkten an',
            ],
            'properties' => [
                'no_category_filter' => 'Nicht nach Kategorie filtern',
                'use_url' => 'Verwende Kategorie-Slug aus URL',
                'filter_component' => [
                    'title' => 'Alias der Filter-Komponente',
                    'description' => 'Alias der Filter-Komponente die für diese Produkte-Komponente zuständig ist',
                ],
                'filter' => [
                    'title' => 'Filter-String',
                    'description' => 'Forcierter Filter für diese Komponente',
                ],
                'include_variants' => [
                    'title' => 'Zeige einzelne Varianten an',
                    'description' => 'Zeige nicht nur alle Produkte, sondern auch deren Varianten direkt in der Übersicht an',
                ],
                'include_children' => [
                    'title' => 'Zeige Produkte aus Kinderkategorien an',
                    'description' => 'Zeige alle Produkte von Kinderkategorien ebenfalls an',
                ],
                'per_page' => [
                    'title' => 'Produkte pro Seite',
                    'description' => 'Wie viele Produkte pro Seite angezeigt werden',
                ],
                'paginate' => [
                    'title' => 'Verwende Seiten',
                    'description' => 'Zeige Seitenauswahl um mehr Produkte zu laden',
                ],
                'sort' => [
                    'title' => 'Sortierung',
                    'description' => 'Sortier-Einstellungen des Benutzers werden übersteuert',
                ],
                'set_page_title' => [
                    'title' => 'Setze Seitentitel',
                    'description' => 'Verwende den Name der Kategorie als Seitentitel',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Produkte-Filter',
                'description' => 'Filtert die Produkte einer Kategorie',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Zeige Preis-Filter an',
                ],
                'showBrandFilter' => [
                    'title' => 'Zeige Marken-Filter an',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Zeige «Reduziert» Filter an',
                ],
                'includeChildren' => [
                    'title' => 'Zeige Filter aus Kinderkategorien auch an',
                    'description' => 'Verwende die Filter und Eigenschaften von Produkten aus Kinderkategorien ebenfalls',
                ],
                'includeVariants' => [
                    'title' => 'Varianten verwenden',
                    'description' => 'Zeige Filter für alle Eigenschaften der Produktvarianten an',
                ],
                'includeSliderAssets' => [
                    'title' => 'Binde noUI Slider ein',
                    'description' => 'Lädt die Abhängigkeiten für den noUI Slider via cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Sortierung',
                    'description' => 'Standard Sortierung',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Bestseller',
                'priceLow' => 'Günstigste',
                'priceHigh' => 'Teuerste',
                'latest' => 'Neuste',
                'oldest' => 'Älteste',
                'random' => 'Zufällig',
                'manual' => 'Manuell',
                'name' => 'Name',
                'ratings' => 'Bewertung',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Benutzeraccount',
                'description' => 'Zeigt dem Kunden alle Informationen zu seinem Bentzerkonto an',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Aktive Unterseite',
                ],
            ],
            'pages' => [
                'orders' => 'Bestellungen',
                'profile' => 'Benutzerprofil',
                'addresses' => 'Adressliste',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Kundenprofil',
                'description' => 'Zeigt ein Formular zur Bearbeitung der Kundendaten an.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Währungsauswahl',
                'description' => 'Zeigt eine Auswahl für die aktive Währung an',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Frontend-Abhängigkeiten',
                'description' => 'Bindet alle benötigten Frontend-Abhängigkeiten ein',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Adressliste',
                'description' => 'Zeigt alle erfassten Adressen eines Kunden an',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'Die gesuchte Addresse wurde nicht gefunden',
                'cannot_delete_last_address' => 'Sie können Ihre letzte Adresse nicht löschen',
            ],
            'messages' => [
                'address_deleted' => 'Adresse gelöscht',
                'default_billing_address_changed' => 'Standard Rechnungsadresse wurde geändert',
                'default_shipping_address_changed' => 'Standard Lieferadresse wurde geändert',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Bestellungsliste',
                'description' => 'Zeigt alle Bestellungen eines Kunden an',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Produkt-Details',
                'description' => 'Zeigt die Details zu einem Produkt an',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Zu neuer Detailseite umleiten',
                    'description' => 'Leite den Besucher zur neuen Detailseite um wenn eine Eigenschaft geändert wird',
                ],
            ],
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Produkt-Reviews',
                'description' => 'Zeigt alle Reviews zu einem Produkt an',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Anzahl Reviews pro Seite',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Zeige nur Reviews der Variante',
                    'description' => 'Zeige keine Reviews von anderen Varianten des Produkts an',
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Warenkorb',
                'description' => 'Zeigt den Warenkorb an',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Rabatt-Code-Feld anzeigen',
                ],
                'showShipping' => [
                    'title' => 'Versandkosten anzeigen',
                ],
                'showTaxes' => [
                    'title' => 'Steuern ausweisen',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Zur Kasse-Button anzeigen',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Checkout',
                'description' => 'Komponente für den Bestellvorgang',
            ],
            'errors' => [
                'missing_settings' => 'Bitte wählen Sie eine Zahlungs- und Versandmethode aus.',
            ],
            'properties' => [
                'step' => [
                    'name' => 'Aktiver Schritt des Checkouts (wird automatisch gesetzt)',
                ],
            ],
        ],
        'quickCheckout' => [
            'details' => [
                'name' => 'Schneller Checkout',
                'description' => 'Checkout auf einer Seite',
            ],
            'errors' => [
                'signup_failed' => 'Fehler beim Erstellen Ihres Benutzerkontos.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Gutschein-Code Eingabe',
                'description' => 'Zeigt eine Eingabemöglichkeit für Gutscheincodes an',
            ],
            'discount_applied' => 'Gutschein zum Warenkorb hinzugefügt!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Auswahl für Versandmethode',
                'description' => 'Zeige eine Auflistung aller Versandmethoden an',
            ],
            'errors' => [
                'unavailable' => 'Die ausgewählte Versandmethode ist für Ihre Bestellung nicht verfügbar.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Auswahl für Zahlungsmethode',
                'description' => 'Zeige eine Auflistung aller Zahlungsmethoden an',
            ],
            'errors' => [
                'unavailable' => 'Die ausgewählte Zahlungsmethode ist für Ihre Bestellung nicht verfügbar.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Auswahl für Adressen',
                'description' => 'Zeige eine Auflistung aller Adressen eines Kunden an',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Bearbeitungsformular für Adressen',
                'description' => 'Zeigt ein Formular an um Adressen zu bearbeiten',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Adresse',
                ],
                'redirect' => [
                    'title' => 'Weiterleitung (nach Speichern)',
                ],
                'set' => [
                    'title' => 'Übernehme die Adresse für die Bestellung als...',
                ],
            ],
            'redirects' => [
                'checkout' => 'Checkout-Seite',
            ],
            'set' => [
                'billing' => 'Rechnungsadresse',
                'shipping' => 'Versandadresse',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Anmeldung',
                'description' => 'Zeigt ein Formular für die Registrierung oder das Login an',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Weiterleitung nach Login',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Sie versuchen sich mit einem Gast-Konto einzuloggen.',
                'unknown_user' => 'Die eingegebenen Login-Daten sind ungültig.',
                'not_activated' => 'Ihr Konto ist noch nicht bestätigt worden.',
                'login' => [
                    'required' => 'Geben Sie eine Email-Adresse ein.',
                    'email' => 'Geben Sie eine gültige Email-Adresse ein.',
                    'between' => 'Geben Sie eine gültige Email-Adresse ein.',
                ],
                'password' => [
                    'required' => 'Geben Sie ein Passwort ein.',
                    'max' => 'Das eingegebene Passwort ist zu lang.',
                    'min' => 'Das eingegebene Passwort ist zu kurz. Geben Sie mindestens 8 Zeichen ein.',
                ],
                'password_repeat' => [
                    'required' => 'Bestätigen Sie Ihr Passwort.',
                    'same' => 'Die Passwörter stimmen nicht überein.',
                ],
                'email' => [
                    'required' => 'Geben Sie eine Email ein.',
                    'email' => 'Die Email-Adresse ist ungültig.',
                    'unique' => 'Es existiert bereits ein Benutzerkonto mit dieser Email',
                    'non_existing_user' => 'Es existiert bereits ein Benutzer mit dieser Email. Nutzen Sie die Passwort vergessen Funktion',
                ],
                'firstname' => [
                    'required' => 'Geben Sie Ihren Vornamen ein.',
                ],
                'lastname' => [
                    'required' => 'Geben Sie Ihren Nachnamen ein.',
                ],
                'lines' => [
                    'required' => 'Geben Sie Ihre Adresse ein.',
                ],
                'zip' => [
                    'required' => 'Geben Sie Ihre PLZ ein.',
                ],
                'city' => [
                    'required' => 'Geben Sie eine Stadt ein.',
                ],
                'country_id' => [
                    'required' => 'Wählen Sie Ihr Land aus.',
                    'exists' => 'Das ausgewählte Land ist ungültig.',
                ],
                'state_id' => [
                    'required' => 'Wählen Sie Ihr Kanton/Bundesstaat',
                    'exists' => 'Der ausgewählte Wert ist ungültig.',
                ],
                'terms_accepted' => [
                    'required' => 'Bitte bestätigen Sie unsere AGBs.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Kategorien',
                'description' => 'Listet vorhandene Kategorien auf',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Startkategorie',
                    'description' => 'Zeige nur dieser Kategorie untergeordnete Kategorien an',
                ],
                'categorySlug' => [
                    'title' => 'Kategorie URL-Parameter',
                    'description' => 'Verwende diesen Parameter um die Startkategorie aus der URL zu übernehmen',
                ],
                'categoryPage' => [
                    'title' => 'Kategorie-Seite',
                    'description' => 'Die Links werden auf diese Seite verweisen. Wenn nichts ausgewählt wird, wird die Page aus den Backend Settings verwendet.',
                ],
            ],
            'no_parent' => 'Zeige alle Kategorien',
            'by_slug' => 'Verwende Kategorie aus URL als Startkategorie',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Warenkorb',
                'description' => 'Zeigt die Anzahl Produkte und den Gesamtwert des Warenkorbes an',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Zeige Produkte-Anzahl',
                    'description' => 'Zeigt an, wie viele Produkte sich im Warenkorb befinden',
                ],
                'showTotalPrice' => [
                    'title' => 'Zeige Gesamtwert',
                    'description' => 'Zeigt den Wert aller Artikel im Warenkorb an',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Kundenkonto',
                'description' => 'Zeigt den Link zum Öffnen des Kundenkontos an',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Kundenkonto-Text',
                    'description' => 'Link-Text für den Kundenkonto-Link',
                ],
                'logoutLabel' => [
                    'title' => 'Logout-Text',
                    'description' => 'Link-Text für den Logout-Link',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Enhanced Ecommerce (UA) Component',
                'description' => 'Implements a Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Merklisten-Button',
                'description' => 'Zeigt einen Merklisten-Button an',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produkt',
                    'description' => 'Die ID des Produkts',
                ],
                'variant' => [
                    'name' => 'Variante',
                    'description' => 'Die ID der Variante',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Merklisten-Verwaltung',
                'description' => 'Zeigt die Merklisten-Verwaltung an',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Versandkosten anzeigen',
                    'description' => 'Zeige Auswahlliste und Kosten für Versand',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'Von (Gewicht in Gramm)',
        'to_weight' => 'Bis (Gewicht in Gramm)',
    ],
    'products' => [
        'variants_comment' => 'Erstelle verschiedene Varianten des gleichen Produkts',
    ],
    'order_states' => [
        'name' => 'Name',
        'description' => 'Beschreibung',
        'color' => 'Farbe',
        'flag' => 'Spezielle Funktion',
        'flags' => [
            'new' => 'Status für neue Bestellungen setzen',
            'complete' => 'Bestellung gilt als abgeschlossen',
            'cancelled' => 'Bestellung wurde storniert',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Dieser Code kann verwendet werden, um diese Gruppe programmtechnisch anzusteuern',
        'discount_comment' => 'Dieser Benutzergruppe wird dieser Rabatt in % auf das komplette Sortiment gewährt',
    ],
    'order_status' => [
        'processed' => 'Verarbeitet',
        'disputed' => 'Beanstandet',
        'shipped' => 'Versendet',
        'delivered' => 'Zugestellt',
        'pending' => 'Pendent',
        'cancelled' => 'Storniert',
    ],
    'notifications' => [
        'enabled' => 'Aktiviert',
        'enabled_comment' => 'Diese Benachrichtigung versenden',
        'template' => 'Mail-Template',
    ],
    'payment_log' => [
        'payment_data' => 'Zahlungsdaten',
        'data_comment' => 'Diese Daten wurden vom Zahlungsanbieter zurückgegeben',
        'order_data_comment' => 'Diese Bestellungsdaten gehören zu der Zahlung',
        'message_comment' => 'Diese Nachricht wurde vom Zahlungsanbieter zurückgegeben',
        'code_comment' => 'Dieser Code wurde vom Zahlungsanbieter zurückgegeben',
        'failed_only' => 'Nur fehlgeschlagene',
    ],
    'services' => [
        'options' => 'Optionen',
        'option' => 'Option',
        'required' => 'Pflichtservice',
        'required_comment' => 'Bei der Bestellung muss zwingend eine Service-Option ausgewählt werden',
    ],
    'reviews' => [
        'rating' => 'Bewertung',
        'review' => 'Details zur Bewertung',
        'title' => 'Titel der Bewertung',
        'pros' => 'Positive Punkte',
        'cons' => 'Negative Punkte',
        'anonymous' => 'Anonym',
        'only_unapproved' => 'Zeige nur zu überprüfende Reviews',
        'no_more' => 'Alle Reviews sind freigeschaltet',
        'approved' => 'Review freigegeben',
        'approve' => 'Review freigeben',
        'approve_next' => 'Review freigeben und weiter',
    ],
];
