<?php

return [
    'auth' => [
        'title' => 'Administration Area',
        'invalid_login' => 'The details you entered did not match our records. Please double-check and try again.',
    ],
    'field' => [
        'invalid_type' => 'Invalid field type used :type.',
        'options_method_invalid_model' => "The attribute ':field' does not resolve to a valid model. Try specifying the options method for model class :model explicitly.",
        'options_method_not_exists' => "The model class :model must define a method :method() returning options for the ':field' form field.",
        'options_static_method_invalid_value' => "The static method ':method()' on :class did not return a valid options array.",
        'colors_method_not_exists' => "The model class :model must define a method :method() returning html color HEX codes for the ':field' form field.",
    ],
    'widget' => [
        'not_registered' => "A widget class name ':name' has not been registered",
        'not_bound' => "A widget with class name ':name' has not been bound to the controller",
    ],
    'page' => [
        'untitled' => 'Untitled',
        '404' => [
            'label' => 'Page Not Found',
            'help' => "We searched and searched but the requested URL just couldn't be found. Perhaps you were looking for something else?",
            'back_link' => 'Go back to the previous page',
        ],
        'access_denied' => [
            'label' => 'Access denied',
            'help' => "You don't have the required permissions to view this page.",
            'cms_link' => 'Return to the back-end',
        ],
        'no_database' => [
            'label' => 'Database missing',
            'help' => "A database is required to access the back-end. Check the database is configured and migrated before trying again.",
            'cms_link' => 'Return to the homepage',
        ],
    ],
    'partial' => [
        'not_found_name' => "The partial ':name' is not found.",
        'invalid_name' => 'Invalid partial name: :name.',
    ],
    'ajax_handler' => [
        'invalid_name' => 'Invalid AJAX handler name: :name.',
        'not_found' => "AJAX handler ':name' was not found.",
    ],
    'account' => [
        'impersonate' => 'Impersonate user',
        'impersonate_confirm' => 'Are you sure you want to impersonate this user? You can revert to your original state by logging out.',
        'impersonate_success' => 'You are now impersonating this user',
        'impersonate_working' => 'Impersonating...',
        'impersonating' => 'You are temporarily logged in as :impersonatee. Logs are still able to identify you as :impersonator',
        'stop_impersonating' => 'Stop impersonating',
        'unsuspend' => 'Unsuspend',
        'unsuspend_confirm' => 'Are you sure you want to unsuspend this user?',
        'unsuspend_success' => 'User has been unsuspended.',
        'unsuspend_working' => 'Unsuspending...',
        'signed_in_as' => 'Signed in as :full_name',
        'sign_out' => 'Sign out',
        'login' => 'Login',
        'reset' => 'Reset',
        'restore' => 'Restore',
        'login_placeholder' => 'login',
        'password_placeholder' => 'password',
        'remember_me' => 'Stay logged in',
        'forgot_password' => 'Forgot your password?',
        'enter_email' => 'Enter your email',
        'enter_login' => 'Enter your login',
        'email_placeholder' => 'email',
        'enter_new_password' => 'Enter a new password',
        'password_reset' => 'Password Reset',
        'restore_success' => 'If your account exists, an email has been sent to you with reset instructions.',
        'reset_success' => 'Password has been reset. You may now sign in.',
        'reset_error' => 'Invalid password reset data supplied. Please try again!',
        'reset_fail' => 'Unable to reset your password!',
        'apply' => 'Apply',
        'cancel' => 'Cancel',
        'delete' => 'Delete',
        'ok' => 'OK',
        'sending' => 'Sending...',
        'password_reset_email' => 'Send password reset email',
        'manual_password_reset_confirm' => 'Are you sure you want to send a password reset email to this user?',
        'manual_password_reset_success' => 'An email has been sent to the user with instructions to reset their password.',
    ],
    'dashboard' => [
        'menu_label' => 'Dashboard',
        'widget_label' => 'Widget',
        'widget_width' => 'Width',
        'full_width' => 'full width',
        'manage_widgets' => 'Manage widgets',
        'add_widget' => 'Add widget',
        'widget_inspector_title' => 'Widget configuration',
        'widget_inspector_description' => 'Configure the report widget',
        'widget_columns_label' => 'Width :columns',
        'widget_columns_description' => 'The widget width, a number between 1 and 12.',
        'widget_columns_error' => 'Please enter the widget width as a number between 1 and 12.',
        'columns' => '{1} column|[2,Inf] columns',
        'widget_new_row_label' => 'Force new row',
        'widget_new_row_description' => 'Put the widget in a new row.',
        'widget_title_label' => 'Widget title',
        'widget_title_error' => 'The Widget Title is required.',
        'reset_layout' => 'Reset layout',
        'reset_layout_confirm' => 'Reset layout back to default?',
        'reset_layout_success' => 'Layout has been reset',
        'make_default' => 'Make default',
        'make_default_confirm' => 'Set the current layout as the default?',
        'make_default_success' => 'Current layout is now the default',
        'collapse_all' => 'Collapse all',
        'expand_all' => 'Expand all',
        'status' => [
            'widget_title_default' => 'System status',
            'update_available' => '{0} updates available!|{1} update available!|[2,Inf] updates available!',
            'updates_pending' => 'Pending software updates',
            'updates_nil' => 'Software is up to date',
            'updates_link' => 'Update',
            'warnings_pending' => 'Some issues need attention',
            'warnings_nil' => 'No warnings to display',
            'warnings_link' => 'View',
            'core_build' => 'System build',
            'event_log' => 'Event log',
            'request_log' => 'Request log',
            'app_birthday' => 'Online since',
        ],
        'welcome' => [
            'widget_title_default' => 'Welcome',
            'welcome_back_name' => 'Welcome back to :app, :name.',
            'welcome_to_name' => 'Welcome to :app, :name.',
            'first_sign_in' => 'This is the first time you have signed in.',
            'last_sign_in' => 'Your last sign in was',
            'view_access_logs' => 'View access logs',
            'nice_message' => 'Have a great day!',
        ],
    ],
    'user' => [
        'name' => 'Administrator',
        'menu_label' => 'Administrators',
        'menu_description' => 'Manage back-end administrator users, groups and permissions.',
        'list_title' => 'Manage Administrators',
        'new' => 'New Administrator',
        'login' => 'Login',
        'first_name' => 'First Name',
        'last_name' => 'Last Name',
        'full_name' => 'Full Name',
        'email' => 'Email',
        'role_field' => 'Role',
        'role_comment' => 'Roles define user permissions, which can be overriden on the user level, on the Permissions tab.',
        'groups' => 'Groups',
        'groups_comment' => 'Specify which groups this account should belong to.',
        'avatar' => 'Avatar',
        'password' => 'Password',
        'password_confirmation' => 'Confirm Password',
        'permissions' => 'Permissions',
        'account' => 'Account',
        'superuser' => 'Super User',
        'superuser_comment' => 'Grants this account unlimited access to all areas of the system. Super users can add and manage other users. ',
        'send_invite' => 'Send invitation by email',
        'send_invite_comment' => 'Sends a welcome message containing login and password information.',
        'delete_confirm' => 'Delete this administrator?',
        'return' => 'Return to admin list',
        'allow' => 'Allow',
        'inherit' => 'Inherit',
        'deny' => 'Deny',
        'activated' => 'Activated',
        'last_login' => 'Last login',
        'created_at' => 'Created at',
        'updated_at' => 'Updated at',
        'deleted_at' => 'Deleted at',
        'show_deleted' => 'Show deleted',
        'group' => [
            'name' => 'Group',
            'name_field' => 'Name',
            'name_comment' => 'The name is displayed in the group list on the Administrator form.',
            'description_field' => 'Description',
            'is_new_user_default_field_label' => 'Default group',
            'is_new_user_default_field_comment' => 'Add new administrators to this group by default',
            'code_field' => 'Code',
            'code_comment' => 'Enter a unique code if you want to access the group object with the API.',
            'menu_label' => 'Manage Groups',
            'list_title' => 'Manage Groups',
            'new' => 'New Group',
            'delete_confirm' => 'Delete this administrator group?',
            'return' => 'Return to group list',
            'users_count' => 'Users',
        ],
        'role' => [
            'name' => 'Role',
            'name_field' => 'Name',
            'name_comment' => 'The name is displayed in the role list on the Administrator form.',
            'description_field' => 'Description',
            'code_field' => 'Code',
            'code_comment' => 'Enter a unique code if you want to access the role object with the API.',
            'menu_label' => 'Manage Roles',
            'list_title' => 'Manage Roles',
            'new' => 'New Role',
            'delete_confirm' => 'Delete this administrator role?',
            'return' => 'Return to role list',
            'users_count' => 'Users',
        ],
        'preferences' => [
            'not_authenticated' => 'There is no an authenticated user to load or save preferences for.',
        ],
        'trashed_hint_title' => 'This account has been deleted',
        'trashed_hint_desc' => 'This account has been deleted and will be unable to be signed in under. To restore it, click the restore user icon in the bottom right',
    ],
    'list' => [
        'default_title' => 'List',
        'search_prompt' => 'Search...',
        'no_records' => 'There are no records in this view.',
        'missing_model' => 'List behavior used in :class does not have a model defined.',
        'missing_column' => 'There are no column definitions for :columns.',
        'missing_columns' => 'List used in :class has no list columns defined.',
        'missing_definition' => "List behavior does not contain a column for ':field'.",
        'missing_parent_definition' => "List behavior does not contain a definition for ':definition'.",
        'behavior_not_ready' => 'List behavior has not been initialized, check that you have called makeLists() in your controller.',
        'invalid_column_datetime' => "Column value ':column' is not a DateTime object, are you missing a \$dates reference in the Model?",
        'pagination' => 'Displayed records: :from-:to of :total',
        'first_page' => 'First page',
        'last_page' => 'Last page',
        'prev_page' => 'Previous page',
        'next_page' => 'Next page',
        'refresh' => 'Refresh',
        'updating' => 'Updating...',
        'loading' => 'Loading...',
        'setup_title' => 'List setup',
        'setup_help' => 'Use checkboxes to select columns you want to see in the list. You can change position of columns by dragging them up or down.',
        'records_per_page' => 'Records per page',
        'records_per_page_help' => 'Select the number of records per page to display. Please note that high number of records on a single page can reduce performance.',
        'check' => 'Check',
        'delete_selected' => 'Delete selected',
        'delete_selected_empty' => 'There are no selected records to delete.',
        'delete_selected_confirm' => 'Delete the selected records?',
        'delete_selected_success' => 'Deleted selected records.',
        'column_switch_true' => 'Yes',
        'column_switch_false' => 'No',
    ],
    'fileupload' => [
        'attachment' => 'Attachment',
        'help' => 'Add a title and description for this attachment.',
        'title_label' => 'Title',
        'description_label' => 'Description',
        'default_prompt' => 'Click the %s or drag a file here to upload',
        'attachment_url' => 'Attachment URL',
        'upload_file' => 'Upload file',
        'upload_error' => 'Upload error',
        'remove_confirm' => 'Are you sure?',
        'remove_file' => 'Remove file',
    ],
    'repeater' => [
        'add_new_item' => 'Add new item',
        'min_items_failed' => ':name requires a minimum of :min items, only :items were provided',
        'max_items_failed' => ':name only allows up to :max items, :items were provided',
    ],
    'form' => [
        'create_title' => 'New :name',
        'update_title' => 'Edit :name',
        'preview_title' => 'Preview :name',
        'create_success' => ':name created',
        'update_success' => ':name updated',
        'delete_success' => ':name deleted',
        'restore_success' => ':name restored',
        'reset_success' => 'Reset complete',
        'missing_id' => 'Form record ID has not been specified.',
        'missing_model' => 'Form behavior used in :class does not have a model defined.',
        'missing_definition' => "Form behavior does not contain a field for ':field'.",
        'not_found' => 'Form record with an ID of :id could not be found.',
        'action_confirm' => 'Are you sure?',
        'create' => 'Create',
        'create_and_close' => 'Create and close',
        'creating' => 'Creating...',
        'creating_name' => 'Creating :name...',
        'save' => 'Save',
        'save_and_close' => 'Save and close',
        'saving' => 'Saving...',
        'saving_name' => 'Saving :name...',
        'delete' => 'Delete',
        'deleting' => 'Deleting...',
        'confirm_delete' => 'Delete record?',
        'confirm_delete_multiple' => 'Delete selected records?',
        'deleting_name' => 'Deleting :name...',
        'restore' => 'Restore',
        'restoring' => 'Restoring...',
        'confirm_restore' => 'Are you sure you want to restore this record?',
        'reset_default' => 'Reset to default',
        'resetting' => 'Resetting',
        'resetting_name' => 'Resetting :name',
        'undefined_tab' => 'Misc',
        'field_off' => 'Off',
        'field_on' => 'On',
        'add' => 'Add',
        'apply' => 'Apply',
        'cancel' => 'Cancel',
        'close' => 'Close',
        'confirm' => 'Confirm',
        'reload' => 'Reload',
        'complete' => 'Complete',
        'ok' => 'OK',
        'or' => 'or',
        'confirm_tab_close' => 'Close the tab? Unsaved changes will be lost.',
        'behavior_not_ready' => 'Form behavior has not been initialized, check that you have called initForm() in your controller.',
        'preview_no_files_message' => 'There are no files uploaded.',
        'preview_no_media_message' => 'There is no media selected.',
        'preview_no_record_message' => 'There is no record selected.',
        'select' => 'Select',
        'select_all' => 'Select all',
        'select_none' => 'Select none',
        'select_placeholder' => 'please select',
        'insert_row' => 'Insert Row',
        'insert_row_below' => 'Insert Row Below',
        'delete_row' => 'Delete Row',
        'concurrency_file_changed_title' => 'File was changed',
        'concurrency_file_changed_description' => "The file you're editing has been changed on disk by another user. You can either reload the file and lose your changes or override the file on the disk.",
        'return_to_list' => 'Return to the list',
    ],
    'recordfinder' => [
        'find_record' => 'Find Record',
        'invalid_model_class' => 'The provided model class ":modelClass" for the recordfinder is invalid',
        'cancel' => 'Cancel',
    ],
    'pagelist' => [
        'page_link' => 'Page link',
        'select_page' => 'Select a page...',
    ],
    'relation' => [
        'missing_config' => "Relation behavior does not have any configuration for ':config'.",
        'missing_definition' => "Relation behavior does not contain a definition for ':field'.",
        'missing_model' => 'Relation behavior used in :class does not have a model defined.',
        'invalid_action_single' => 'This action cannot be performed on a singular relationship.',
        'invalid_action_multi' => 'This action cannot be performed on a multiple relationship.',
        'relationwidget_unsupported_type' => 'The ":type" relation type is unsupported by the Relation widget.',
        'help' => 'Click on an item to add',
        'related_data' => 'Related :name data',
        'add' => 'Add',
        'add_selected' => 'Add selected',
        'add_a_new' => 'Add a new :name',
        'link_selected' => 'Link selected',
        'link_a_new' => 'Link a new :name',
        'cancel' => 'Cancel',
        'close' => 'Close',
        'add_name' => 'Add :name',
        'create' => 'Create',
        'create_name' => 'Create :name',
        'update' => 'Update',
        'update_name' => 'Update :name',
        'preview' => 'Preview',
        'preview_name' => 'Preview :name',
        'remove' => 'Remove',
        'remove_name' => 'Remove :name',
        'delete' => 'Delete',
        'delete_name' => 'Delete :name',
        'delete_confirm' => 'Are you sure?',
        'link' => 'Link',
        'link_name' => 'Link :name',
        'unlink' => 'Unlink',
        'unlink_name' => 'Unlink :name',
        'unlink_confirm' => 'Are you sure?',
    ],
    'reorder' => [
        'default_title' => 'Reorder records',
        'no_records' => 'There are no records available to sort.',
    ],
    'model' => [
        'name' => 'Model',
        'not_found' => "Model ':class' with an ID of :id could not be found",
        'missing_id' => 'There is no ID specified for looking up the model record.',
        'missing_relation' => "Model ':class' does not contain a definition for ':relation'.",
        'missing_method' => "Model ':class' does not contain a method ':method'.",
        'invalid_class' => "Model :model used in :class is not valid, it must inherit the \Model class.",
        'mass_assignment_failed' => "Mass assignment failed for Model attribute ':attribute'.",
    ],
    'warnings' => [
        'tips' => 'System configuration tips',
        'tips_description' => 'There are issues you need to pay attention to in order to configure the system properly.',
        'permissions' => 'Directory :name or its subdirectories is not writable for PHP. Please set corresponding permissions for the webserver on this directory.',
        'extension' => 'The PHP extension :name is not installed. Please install this library and activate the extension.',
        'plugin_missing' => 'The plugin :name is a dependency but is not installed. Please install this plugin.',
        'debug' => 'Debug mode is enabled. This is not recommended for production installations.',
        'decompileBackendAssets' => 'Assets in the Backend are currently decompiled. This is not recommended for production installations.',
        'default_backend_user' => 'A user with the default login details (admin / admin@domain.tld) was found. Change their username and / or email address to help protect the system.',
    ],
    'editor' => [
        'menu_label' => 'Editor settings',
        'menu_description' => 'Customize the global editor preferences, such as font size and color scheme.',
        'preview' => 'Preview',
        'font_size' => 'Font size',
        'tab_size' => 'Tab size',
        'use_hard_tabs' => 'Indent using tabs',
        'code_folding' => 'Code folding',
        'code_folding_begin' => 'Mark begin',
        'code_folding_begin_end' => 'Mark begin and end',
        'autocompletion' => 'Autocompletion',
        'word_wrap' => 'Word wrap',
        'highlight_active_line' => 'Highlight active line',
        'auto_closing' => 'Automatically close tags',
        'show_invisibles' => 'Show invisible characters',
        'show_gutter' => 'Show gutter',
        'basic_autocompletion' => 'Basic Autocompletion (Ctrl + Space)',
        'live_autocompletion' => 'Live Autocompletion',
        'enable_snippets' => 'Enable code snippets (Tab)',
        'display_indent_guides' => 'Show indent guides',
        'show_print_margin' => 'Show print margin',
        'mode_off' => 'Off',
        'mode_fluid' => 'Fluid',
        '40_characters' => '40 Characters',
        '80_characters' => '80 Characters',
        'theme' => 'Color scheme',
        'markup_styles' => 'Markup Styles',
        'custom_styles' => 'Custom stylesheet',
        'custom_styles_comment' => 'Custom styles to include in the HTML editor.',
        'markup_classes' => 'Markup Classes',
        'paragraph' => 'Paragraph',
        'link' => 'Link',
        'table' => 'Table',
        'table_cell' => 'Table Cell',
        'image' => 'Image',
        'label' => 'Label',
        'class_name' => 'Class name',
        'markup_tags' => 'Markup Tags',
        'markup_tag' => 'Markup Tag',
        'allowed_empty_tags' => 'Allowed empty tags',
        'allowed_empty_tags_comment' => 'The list of tags that are not removed when they have no content inside.',
        'allowed_tags' => 'Allowed tags',
        'allowed_tags_comment' => 'The list of allowed tags.',
        'allowed_attributes' => 'Allowed attributes',
        'allowed_attributes_comment' => 'The list of allowed attributes.',
        'no_wrap' => 'Do not wrap tags',
        'no_wrap_comment' => 'The list of tags that should not be wrapped inside block tags.',
        'remove_tags' => 'Remove tags',
        'remove_tags_comment' => 'The list of tags that are removed together with their content.',
        'line_breaker_tags' => 'Line breaker tags',
        'line_breaker_tags_comment' => 'The list of tags that are used to place a line breaker element between.',
        'toolbar_options' => 'Toolbar Options',
        'toolbar_buttons' => 'Toolbar Buttons',
        'toolbar_buttons_comment' => 'The Toolbar Buttons to be displayed in the Rich Editor by default.',
        'toolbar_buttons_preset' => 'Insert a preset toolbar button configuration:',
        'toolbar_buttons_presets' => [
            'default' => 'Default',
            'minimal' => 'Minimal',
            'full' => 'Full',
        ],
        'paragraph_formats' => 'Paragraph Formats',
        'paragraph_formats_comment' => 'The options that will appear in the Paragraph Format dropdown.',
    ],
    'tooltips' => [
        'preview_website' => 'Preview the website',
    ],
    'mysettings' => [
        'menu_label' => 'My Settings',
        'menu_description' => 'Settings related to your administration account',
    ],
    'myaccount' => [
        'menu_label' => 'My account',
        'menu_description' => 'Update your account details such as name, email address and password.',
        'menu_keywords' => 'security login',
    ],
    'branding' => [
        'menu_label' => 'Customize back-end',
        'menu_description' => 'Customize the administration area such as name, colors and logo.',
        'brand' => 'Brand',
        'logo' => 'Logo',
        'logo_description' => 'Upload a custom logo to use in the back-end.',
        'favicon' => 'Favicon',
        'favicon_description' => 'Upload a custom favicon to use in the back-end',
        'app_name' => 'App Name',
        'app_name_description' => 'This name is shown in the title area of the back-end.',
        'app_tagline' => 'App Tagline',
        'app_tagline_description' => 'This name is shown on the sign in screen for the back-end.',
        'colors' => 'Colors',
        'branding_colors' => 'Branding colors',
        'branding_colors_comment' => 'These colors will be used throughout the Backend UI to match your branding.',
        'default_colors' => 'Default colors',
        'default_colors_comment' => 'These colors will be available as swatches on all color pickers, unless overridden.',
        'add_default_color' => 'Add a default color',
        'primary_color' => 'Primary color',
        'secondary_color' => 'Secondary color',
        'accent_color' => 'Accent color',
        'styles' => 'Styles',
        'custom_stylesheet' => 'Custom stylesheet',
        'navigation' => 'Navigation',
        'menu_mode' => 'Menu style',
        'menu_mode_inline' => 'Inline',
        'menu_mode_inline_no_icons' => 'Inline (no icons)',
        'menu_mode_tile' => 'Tiles',
        'menu_mode_collapsed' => 'Collapsed',
    ],
    'backend_preferences' => [
        'menu_label' => 'Back-end preferences',
        'menu_description' => 'Manage your account preferences such as desired language.',
        'region' => 'Region',
        'code_editor' => 'Code editor',
        'timezone' => 'Timezone',
        'timezone_comment' => 'Adjust displayed dates to this timezone.',
        'locale' => 'Locale',
        'locale_comment' => 'Select your desired locale for language use.',
    ],
    'access_log' => [
        'hint' => 'This log displays a list of successful sign in attempts by administrators. Records are kept for a total of :days days.',
        'menu_label' => 'Access log',
        'menu_description' => 'View a list of successful back-end user sign ins.',
        'id' => 'ID',
        'created_at' => 'Date & Time',
        'type' => 'Type',
        'login' => 'Login',
        'ip_address' => 'IP address',
        'first_name' => 'First name',
        'last_name' => 'Last name',
        'email' => 'Email',
    ],
    'filter' => [
        'all' => 'all',
        'options_method_not_exists' => "The model class :model must define a method :method() returning options for the ':filter' filter.",
        'date_all' => 'all periods',
        'number_all' => 'all numbers',
    ],
    'import_export' => [
        'upload_csv_file' => '1. Upload a CSV file',
        'import_file' => 'Import file',
        'row' => 'Row :row',
        'first_row_contains_titles' => 'First row contains column titles',
        'first_row_contains_titles_desc' => 'Leave this checked if the first row in the CSV is used as the column titles.',
        'match_columns' => '2. Match the file columns to database fields',
        'file_columns' => 'File columns',
        'database_fields' => 'Database fields',
        'set_import_options' => '3. Set import options',
        'export_output_format' => '1. Export output format',
        'file_format' => 'File format',
        'standard_format' => 'Standard format',
        'custom_format' => 'Custom format',
        'delimiter_char' => 'Delimiter character',
        'enclosure_char' => 'Enclosure character',
        'escape_char' => 'Escape character',
        'select_columns' => '2. Select columns to export',
        'column' => 'Column',
        'columns' => 'Columns',
        'set_export_options' => '3. Set export options',
        'show_ignored_columns' => 'Show ignored columns',
        'auto_match_columns' => 'Auto match columns',
        'created' => 'Created',
        'updated' => 'Updated',
        'skipped' => 'Skipped',
        'warnings' => 'Warnings',
        'errors' => 'Errors',
        'skipped_rows' => 'Skipped Rows',
        'import_progress' => 'Import progress',
        'processing' => 'Processing',
        'import_error' => 'Import error',
        'upload_valid_csv' => 'Please upload a valid CSV file.',
        'drop_column_here' => 'Drop column here...',
        'ignore_this_column' => 'Ignore this column',
        'processing_successful_line1' => 'File export process completed!',
        'processing_successful_line2' => 'The browser will now redirect to the file download.',
        'export_progress' => 'Export progress',
        'export_error' => 'Export error',
        'column_preview' => 'Column preview',
        'file_not_found_error' => 'File not found',
        'empty_error' => 'There was no data supplied to export',
        'empty_import_columns_error' => 'Please specify some columns to import.',
        'match_some_column_error' => 'Please match some columns first.',
        'required_match_column_error' => 'Please specify a match for the required field :label.',
        'empty_export_columns_error' => 'Please specify some columns to export.',
        'behavior_missing_uselist_error' => 'You must implement the controller behavior ListController with the export "useList" option enabled.',
        'missing_model_class_error' => 'Please specify the modelClass property for :type',
        'missing_column_id_error' => 'Missing column identifier',
        'unknown_column_error' => 'Unknown column',
        'encoding_not_supported_error' => 'Source file encoding is not recognized. Please select the custom file format option with the proper encoding to import your file.',
        'encoding_format' => 'File encoding',
        'encodings' => [
            'utf_8' => 'UTF-8',
            'us_ascii' => 'US-ASCII',
            'iso_8859_1' => 'ISO-8859-1 (Latin-1, Western European)',
            'iso_8859_2' => 'ISO-8859-2 (Latin-2, Central European)',
            'iso_8859_3' => 'ISO-8859-3 (Latin-3, South European)',
            'iso_8859_4' => 'ISO-8859-4 (Latin-4, North European)',
            'iso_8859_5' => 'ISO-8859-5 (Latin, Cyrillic)',
            'iso_8859_6' => 'ISO-8859-6 (Latin, Arabic)',
            'iso_8859_7' => 'ISO-8859-7 (Latin, Greek)',
            'iso_8859_8' => 'ISO-8859-8 (Latin, Hebrew)',
            'iso_8859_9' => 'ISO-8859-9 (Latin-5, Turkish)',
            'iso_8859_10' => 'ISO-8859-10 (Latin-6, Nordic)',
            'iso_8859_11' => 'ISO-8859-11 (Latin, Thai)',
            'iso_8859_13' => 'ISO-8859-13 (Latin-7, Baltic Rim)',
            'iso_8859_14' => 'ISO-8859-14 (Latin-8, Celtic)',
            'iso_8859_15' => 'ISO-8859-15 (Latin-9, Western European revision with euro sign)',
            'windows_1250' => 'Windows-1250 (CP1250, Central and Eastern European)',
            'windows_1251' => 'Windows-1251 (CP1251)',
            'windows_1252' => 'Windows-1252 (CP1252)',
        ],
    ],
    'permissions' => [
        'manage_media' => 'Upload and manage media contents - images, videos, sounds, documents',
        'allow_unsafe_markdown' => 'Use unsafe Markdown (Can include Javascript)',
    ],
    'mediafinder' => [
        'label' => 'Media Finder',
        'default_prompt' => 'Click the %s button to find a media item',
        'no_image' => 'The image could not be found',
    ],
    'media' => [
        'menu_label' => 'Media',
        'upload' => 'Upload',
        'move' => 'Move',
        'delete' => 'Delete',
        'add_folder' => 'Add folder',
        'search' => 'Search',
        'display' => 'Display',
        'filter_all' => 'Everything',
        'filter_images' => 'Images',
        'filter_video' => 'Video',
        'filter_audio' => 'Audio',
        'filter_documents' => 'Documents',
        'library' => 'Library',
        'size' => 'Size',
        'title' => 'Title',
        'last_modified' => 'Last modified',
        'public_url' => 'URL',
        'click_here' => 'Click here',
        'thumbnail_error' => 'Error generating thumbnail.',
        'return_to_parent' => 'Return to the parent folder',
        'return_to_parent_label' => 'Go up ..',
        'nothing_selected' => 'Nothing is selected.',
        'multiple_selected' => 'Multiple items selected.',
        'uploading_file_num' => 'Uploading :number file(s)...',
        'uploading_complete' => 'Upload complete',
        'uploading_error' => 'Upload failed',
        'type_blocked' => 'The file type used is blocked for security reasons.',
        'order_by' => 'Order by',
        'direction' => 'Direction',
        'direction_asc' => 'Ascending',
        'direction_desc' => 'Descending',
        'folder' => 'Folder',
        'no_files_found' => 'No files found by your request.',
        'delete_empty' => 'Please select items to delete.',
        'delete_confirm' => 'Delete the selected item(s)?',
        'error_renaming_file' => 'Error renaming the item.',
        'new_folder_title' => 'New folder',
        'folder_name' => 'Folder name',
        'error_creating_folder' => 'Error creating folder',
        'folder_or_file_exist' => 'A folder or file with the specified name already exists.',
        'move_empty' => 'Please select items to move.',
        'move_popup_title' => 'Move files or folders',
        'move_destination' => 'Destination folder',
        'please_select_move_dest' => 'Please select a destination folder.',
        'move_dest_src_match' => 'Please select another destination folder.',
        'empty_library' => 'It looks a bit empty here. Upload files or create folders to get started.',
        'insert' => 'Insert',
        'crop_and_insert' => 'Crop & Insert',
        'select_single_image' => 'Please select a single image.',
        'selection_not_image' => 'The selected item is not an image.',
        'restore' => 'Undo all changes',
        'resize' => 'Resize...',
        'selection_mode_normal' => 'Normal',
        'selection_mode_fixed_ratio' => 'Fixed ratio',
        'selection_mode_fixed_size' => 'Fixed size',
        'height' => 'Height',
        'width' => 'Width',
        'selection_mode' => 'Selection mode',
        'resize_image' => 'Resize image',
        'image_size' => 'Image size:',
        'selected_size' => 'Selected:',
        'rename_popup_title' => 'Rename',
        'rename_new_name' => 'New name',
        'move_please_select' => 'please select',
        'move_button' => 'Move',
    ],
];
