<?php

declare(strict_types=1);

namespace Winter\Redirect\Classes\Util;

final class Str
{
    public static function removeTrailingSlash(string $url): string
    {
        if (strpos($url, '?') !== false) {
            [$part1, $part2] = explode('?', $url, 2);

            return implode('?', [rtrim($part1, '/'), $part2]);
        }

        return rtrim($url, '/');
    }
}
