# Winter.Redirect documentation

This plugin should be easy to understand if you are familiar with the basics of the web. If you have issues setting up some redirects, please do not hesitate to contact me.

## Redirect types

This plugins ships with two types of redirects:

* **Exact**; performs an exact match on the Source path.
* **Placeholders**; matches placeholders like {id} or {category} (like the defined routes in Symfony or Laravel framework).
* **Regular expression**; Use regular expressions to match multiple patterns at once (advanced). If the regex contains named groups, groups will get matched to cms page params.

## Redirect target types

This plugin allows you to redirect to the following types:

* An internal path
* An internal CMS Page
* An internal Static Page (`Winter.Pages` plugin)
* An external URL

## Relative vs. Absolute URLs

Both types are supported by the Redirect plugin. Absolute URLs are generated by default.
This setting can be changed at the Redirect Settings page.

In some cases it is necessary to use Relative URLs only. When using a reverse proxy for example. Or when you are
hosting multiple domains on one single codebase.

Example when Absolute URLs are enabled (default):

```
Source path: /path/from
Target path: /path/to
Result path when matched: https://example.com/path/to
```

Example when Relative URLs are enabled:

```
Source path: /path/from
Target path: /path/to
Result path when matched: /path/to
```

## Scheme matching

This plugin allows you to match requests from a `http://` scheme to a `https://` scheme and vice versa.

## Placeholders

Every placeholder can be attached to a requirement. A requirement consists of a `placeholder`, `requirement` and an optional `replacement` value.

Example:

```
Input path:
/blog.php?category=cat&id=145

Source path:
/blog.php?category={category}&id={id}

Target path:
/blog/{category}/{id}

Result path:
/blog/cat/145
```

* The requirement for `{category}` would be: `[a-zA-Z]` or could be more specific like `(dog|cat|mouse)`.
* The requirement for `{id}` would be: `[0-9]+`.

**Replacement value**

A requirement can also contain a replacement value. Provide this replacement value if you need to rewrite a certain placeholder to a static value.

Example:

The requirement for `{category}` is `(dog|cat|mouse)`, with replacement value `animals`.

```
Input path:
/blog.php?category=mouse&id=1337

Source path:
/blog.php?category={category}&id={id}

Target path:
/blog/{category}/{id}

Result:
/blog/animals/1337
```

![](https://i.imgur.com/928z7pI.png)

Result in TestLab:

![](https://i.imgur.com/BswnUAo.png)

## Regular expression (advanced)

For advanced users there's the Regular Expression matching logic. Please refer to the PHP.net `preg_match` manual.

The actual `$matches` result from the `preg_match($sourcePath, $url, $matches)` function can be used in the target path and will be replaced with the matched value.

Example (with matches replacement):

```
Input path: /foo/my-match
Source Path: @/foo/(.*)?@
Target Path: /bar/{1}
Result: /bar/my-match
```

## Redirect Target

You can select a CMS Page as a Redirect target. Placeholders are supported. Let's assume there is a page 'Blog' with the following URL: `/blog/:category/:subcategory`.

It is possible to create a Redirect with placeholders that has this CMS Page as a target:

````
Redirect with:
Source: `/blog.php?cat={category}&subcat={subcategory}`
Placeholders: {category}, {subcategory}
Target: CMS Page `Blog`

Request path: /blog.php?cat=news&subcat=general
Result: /blog/news/general
````

## Events

### Fires events

| Event | Payload | Description |
| --- | --- | --- |
| `winter.redirect.match` | none | When a request matched, right before the redirect response.
| `winter.redirect.changed` | int[] $redirectId | When one or more redirects are changed.

### Listens to events

| Event | Payload | Description |
| --- | --- | --- |
| `winter.redirect.toUrlChanged` | `string $oldUrl, string $newUrl` | Can be fired from a third-party plugin.

## Commands

| Command | Description |
| --- | --- |
| `winter:redirect:publish-redirects` | Publish all redirects. |
