<?php

return [
    "plugin" => [
        "name" => "Posts",
        "description" => "Posts pour Winter CMS."
    ],
    "posts" => [
        "titles" => [
            "post" => "Article",
            "manage" => "Gérer les articles"
        ],
        "tabs" => [
            "categories" => "Catégories",
            "tags" => "Tags"
        ],
        "labels" => [
            "author" => "Auteur",
            "editor" => "Rédacteur en chef",
            "is_published" => "Publié",
            "published_at" => "Publié le",
            "publishing_time" => "Heure de publication",
            "publishing_date" => "Date de publication",
            "published_until" => "Publié jusqu'au",
            "hide_published" => "Cacher Publié",
            "show_contents" => "Afficher le contenu ?",
            "primary_category" => "Catégorie primaire",
            "category_list" => "Liste des catégories",
            "tags" => "Tags"
        ],
        "comments" => [
            "primary_category" => "La catégorie la plus pertinente",
            "published_at" => "Par défaut maintenant, si publié",
            "published_until" => "Délai d'expiration facultatif de l'article"
        ],
        "buttons" => [
            "new" => "Nouvel article"
        ]
    ],

    "postslugs" => [
        "titles" => [
            "postslug" => "Post Slug",
            "manage" => "Gérer les slugs de poteau"
        ],
        "buttons" => [
            "new" => "Nouveau Post Slug"
        ]
    ],

    "posttranslations" => [
        "titles" => [
            "posttranslation" => "Traduction postale",
            "manage" => "Gérer les traductions des articles"
        ],
        "buttons" => [
            "new" => "Traduction des nouveaux posts"
        ]
    ],

    "categories" => [
        "titles" => [
            "category" => "Catégorie",
            "manage" => "Gérer les catégories",
            "reorder" => "Réorganiser les catégories"
        ],
        "buttons" => [
            "new" => "Nouvelle catégorie"
        ]
    ],

    "categoryslugs" => [
        "titles" => [
            "categoryslug" => "Catégorie Slug",
            "manage" => "Gérer les slugs de catégorie"
        ],
        "buttons" => [
            "new" => "Nouveau slug de catégorie"
        ]
    ],

    "categorytranslations" => [
        "titles" => [
            "categorytranslation" => "Traduction par catégorie",
            "manage" => "Gérer les traductions des catégories"
        ],
        "buttons" => [
            "new" => "Traduction de la nouvelle catégorie"
        ]
    ],

    "tags" => [
        "titles" => [
            "tag" => "Étiquette",
            "manage" => "Gérer les étiquettes"
        ],
        "labels" => [
            "is_approved" => "Approuvé ?"
        ],
        "buttons" => [
            "new" => "Nouvelle étiquette",
            "approve" => "Approuver la sélection"
        ],
        "messages" => [
            "approve_selected_confirm" => "Êtes-vous sûr de vouloir approuver les étiquettes sélectionnées ?"
        ]
    ],

    "tagslugs" => [
        "titles" => [
            "tagslug" => "Tag Slug",
            "manage" => "Gérer les bouchons de balises"
        ],
        "buttons" => [
            "new" => "Nouveau Tag Slug"
        ]
    ],

    "tagtranslations" => [
        "titles" => [
            "tagtranslation" => "Traduction des tags",
            "manage" => "Gérer les traductions de balises"
        ],
        "buttons" => [
            "new" => "Traduction des nouveaux tags"
        ]
    ],

    "blocks" => [
        "names" => [
            "richeditor_block" => "Bloc éditeur enrichi",
            "markdown_block" => "Bloc Markdown",
            "html_block" => "Bloc HTML",
            "image_block" => "Bloc d'images",
            "cms_content_block" => "Contenu du CMS",
            "cms_partial_block" => "Partiel du CMS",
            "page_break" => "Saut de page",
            "heading_block" => "Bloc d'en-tête"
        ],
        "descriptions" => [
            "richeditor_block" => "Ajouter une section de contenu (Richeditor)",
            "markdown_block" => "Ajouter une section de contenu (Markdown)",
            "html_block" => "Ajouter un bloc de HTML",
            "image_block" => "Ajouter un bloc d'images",
            "cms_content_block" => "Ajouter du contenu CMS",
            "cms_partial_block" => "Ajouter un partiel du CMS",
            "page_break" => "Ajouter un saut de page",
            "heading_block" => "Ajouter un titre"
        ],
        "tabs" => [
            "main" => "Principal",
            "data" => "Données"
        ],
        "labels" => [
            "cms_content_block" => "Contenu du CMS",
            "cms_partial_block" => "CMS partiel",
            "heading_type" => "Type d'en-tête",
            "heading_content" => "Contenu de l'en-tête",
            "html_block" => "Bloc HTML",
            "in_contents" => "Inclure dans le contenu ?",
            "contents_title" => "Titre pour le contenu",
            "block_id" => "ID de la section",
            "partial_data" => "Passer des variables au partiel",
            "partial_data_key" => "Clé",
            "partial_data_value" => "Valeur"
        ],
        "empty" => [
            "cms_content_block" => "Sélectionnez le contenu",
            "cms_partial_block" => "Sélectionnez la partie"
        ]
    ],

    "common" => [
        "titles" => [
            "reorder" => "Commander à nouveau",
            "previewing" => "Prévisualisation de ':name'.",
            "editing" => "Modification de ':name'."
        ],
        "tabs" => [
            "detail" => "Détail",
            "images" => "Images",
            "image" => "Image",
            "body" => "Corps",
            "seo" => "SEO",
            "posts" => "Posts",
            "settings" => "Paramètres",
            "main" => "Principal",
            "translations" => "Traductions",
            "slugs" => "Slugs liés",
            "preview" => "Prévisualisation"
        ],
        "labels" => [
            "id" => "ID",
            "name" => "Nom",
            "title" => "Titre",
            "description" => "Description",
            "slug" => "Slug",
            "slugs" => "Slugs",
            "excerpt" => "Extrait",
            "seo" => "SEO",
            "post" => "Article",
            "posts" => "Articles",
            "new_post" => "Nouvel article",
            "postslugs" => "Slugs de poteau",
            "posttranslations" => "Traductions de posts",
            "category" => "Catégorie",
            "categories" => "Catégories",
            "categoryslugs" => "Catégorie Slugs",
            "categorytranslations" => "Traductions de catégories",
            "tag" => "Étiquette",
            "tags" => "Tags",
            "tagslugs" => "Étiquette Slugs",
            "tagtranslations" => "Traductions de balises",
            "cms_layout" => "Mise en page du CMS",
            "author" => "Auteur",
            "editor" => "Rédacteur en chef",
            "block_heading" => "Intitulé de la section",
            "block_id" => "ID de la section",
            "block_content" => "Contenu de la section",
            "empty_option" => "Veuillez choisir",
            "approved" => "Approuvé",
            "locale" => "Langue",
            "refresh" => "Rafraîchir",
            "body_type" => "Type de corps",
            "link" => "Lien",
            "published_posts" => "Posts publiés",
            "unpublished_posts" => "Posts non publiés",
            "active" => "Actif",
            'locale' => 'Langue',
            "translations" => "Traductions",
            "primary_locale" => "Langue principale",
            "populate_from" => "Populate From",
            "live_view" => "Live View"
        ],
        "dropdown" => [
            "empty_option" => "Veuillez sélectionner",
            "newest_first" => "Le plus récent en premier",
            "oldest_first" => "Le plus ancien en premier",
            "recent_update" => "Récemment mis à jour",
            "random" => "Random",
            "yes" => "Oui",
            "no" => "Non",
            "none" => "Aucun(e)",
            "inherit" => "Hérité(e)",
            "locale_placeholder" => "--- Sélectionnez parmi les langues disponibles ---",
            "body_type" => [
                "repeater" => "Blocs répétés",
                "richeditor" => "Éditeur enrichi",
                "markdown" => "Éditeur Markdown",
                "theme_template" => "Choisissez parmi les modèles de thèmes"
            ]
        ],
        "buttons" => [
            "reorder" => "Réorganiser"
        ]
    ],
    "images" => [
        "tabs" => [
            "list" => "Image de la liste",
            "banner" => "Image de la bannière",
            "default" => "Défaut",
            "responsive" => "Responsive",
            "social" => "Images sociales",
            "facebook" => "Facebook",
            "twitter" => "Twitter"
        ],
        "labels" => [
            "image_select" => "Choisissez une image",
            "alt_text" => "Texte alternatif de l'image",
            "caption" => "Légende",
            "css_class" => "Classe CSS de l'image",
            "image_style" => "Style de l'image",
            "media_query" => "Media Query",
            "screen_width" => "Largeur de l'écran"
        ],
        "comments" => [
            "facebook" => "Image de partage social pour Facebook",
            "twitter" => "Image de partage social pour Twitter"
        ],
        "options" => [
            "min_width" => "Largeur minimale",
            "max_width" => "Largeur maximale",
            "above" => "Au-dessus",
            "below" => "En dessous",
            "inline_left" => "En ligne à gauche",
            "inline_right" => "En ligne à droite"
        ]
    ],
    "seo" => [
        "tabs" => [
            "general" => "Général",
            "search" => "Recherche",
            "opengraph" => "Facebook/Opengraph",
            "twitter" => "Cartes Twitter",
            "schema" => "Schéma"
        ],
        "labels" => [
            "post_type" => "Type de contenu",
            "about" => "Le contenu concerne",
            "keywords" => "Mots clés",
            "page_title" => "Titre de la page",
            "meta_description" => "Meta Description"

        ],
        // Pas dans la configuration car ils sont définis par le schéma et n'ont pas besoin d'être modifiés.
        "dropdown" => [
            "article" => "Article",
            "blogPosting" => "Blog Post",
            "newsArticle" => "Article de presse"
        ],
        "schema" => [
            "names" => [
                "thing" => "Chose"
            ],
            "descriptions" => [
                "thing" => "Le plus basique des types de schémas"
            ],
            "tabs" => [
                "about" => "À propos de",
                "mentions" => "Mentions"
            ],
            "labels" => [
                "thing_name" => "Nom de la chose",
                "thing_description" => "Description de la chose",
                "thing_image" => "Image de la chose",
                "thing_same_as" => "Chose identique à"
            ],
            "comments" => [
                "thing_same_as" => "Un lien wikipedia est utile ici"
            ]
        ]
    ],

    "settings" => [
        "tabs" => [
            "publisher" => "Editeur",
            "posts" => "Articles",
            "categories" => "Catégories",
            "tags" => "Étiquettes",
            "users" => "Utilisateurs",
            "cms_layouts" => "Mises en page CMS",
            "translation" => "Traduction",
            "rss" => "RSS"
        ],
        "labels" => [
            "settings" => "Paramètres",
            "page_label" => "Paramètres des articles de Dynamedia",
            "page_description" => "Gérer les paramètres des articles.",
            "publisher_name" => "Nom de l'éditeur",
            "publisher_type" => "Type d'éditeur",
            "publisher_url" => "URL de l'éditeur",
            "publisher_logo" => "Logo de l'éditeur",
            "posts_sort_order" => "Ordre de tri des articles",
            "default_posts_sort_order" => "Ordre de tri des articles par défaut",
            "posts_per_page" => "Articles par page",
            "include_subcategories" => "Lister les articles des sous-catégories",
            "post_page" => "Page d'affichage des articles",
            "category_page" => "Page d'affichage des catégories",
            "tag_page" => "Page d'affichage des étiquettes",
            "user_page" => "Page d'affichage de l'utilisateur",
            "default_post_layout" => "Mise en page par défaut des posts",
            "default_category_layout" => "Mise en page par défaut des catégories",
            "default_tag_layout" => "Mise en page par défaut des balises",
            "rss_title" => "Titre du flux RSS principal",
            "rss_description" => "Description du flux RSS principal",
            "rss_posts_per_feed" => "Articles par flux",

        ],

        "dropdown" => [
            "organization" => "Organisation",
            "person" => "Personne",
        ]
    ],
    "components" => [
        "display_post" => [
            "name" => "Affichage article",
            "description" => "Afficher un article"
        ],
        "display_category" => [
            "name" => "Affichage catégorie",
            "description" => "Afficher les catégories avec les articles"
        ],
        "display_tag" => [
            "name" => "Affichage étiquette",
            "description" => "Afficher les étiquettes avec les articles"
        ],
        "display_user" => [
            "name" => "Afficher l'utilisateur",
            "description" => "Afficher le profil de l'utilisateur avec les articles rédigés"
        ],
        "list_posts" => [
            "name" => "Liste des articles",
            "description" => "Liste configurable des articles",
            "properties" => [
                "category_filter" => [
                    "title" => "Filtre de catégorie",
                    "description" => "Restreindre les résultats à cette catégorie"
                ],
                "include_subcategories" => [
                    "title" => "Inclure les sous-catégories",
                    "description" => "Lister les messages des sous-catégories de la catégorie sélectionnée"
                ],
                "tag_filter" => [
                    "title" => "Filtre des étiquettes",
                    "description" => "Restreindre les résultats à cette étiquette"
                ],
                "post_ids" => [
                    "title" => "Filtre des articles",
                    "description" => "Limiter les résultats à ces identifiants d'article",
                    "validation" => "Veuillez entrer une liste d'identifiants d'articles séparés par des virgules."
                ],
                "not_post_ids" => [
                    "title" => "Exclure les articles",
                    "description" => "Exclure ces identifiants d'article",
                    "validation" => "Veuillez entrer une liste d'identifiants des articles séparés par des virgules."
                ],
                "not_category_ids" => [
                    "title" => "Exclure les messages de la catégorie",
                    "description" => "Exclure les ID de ces catégories",
                    "validation" => "Veuillez entrer une liste d'identifiants de catégorie séparés par des virgules."
                ],
                "not_tag_ids" => [
                    "title" => "Exclure les messages des balises",
                    "description" => "Exclure ces identifiants d'étiquettes",
                    "validation" => "Veuillez entrer une liste d'identifiants séparés par des virgules."
                ],
                "posts_limit" => [
                    "title" => "Total des posts",
                    "description" => "Limiter le nombre de posts à récupérer",
                    "validation" => "Veuillez entrer un nombre entier positif ou laisser en blanc"
                ],
                "posts_per_page" => [
                    "title" => "Messages par page",
                    "description" => "Limiter le nombre d'articles par page",
                    "validation" => "Veuillez entrer un nombre entier positif"
                ],
                "no_posts_message" => [
                    "title" => "Message aucun article",
                    "description" => "Message à afficher lorsqu'aucun article n'est trouvé",
                    "default" => "Aucun article trouvé"
                ],
                "sort_order" => [
                    "title" => "Ordre de tri",
                    "description" => "Trier les messages recherchés"
                ]
            ]
        ],
        "search_posts" => [
            "name" => "Recherche d'articles",
            "description" => "Afficher les résultats d'une recherche",
            "properties" => [
                "posts_limit" => [
                    "title" => "Total d'articles",
                    "description" => "Limiter le nombre d'articles à récupérer",
                    "validation" => "Veuillez entrer un nombre entier positif ou laisser vide"
                ],
                "posts_per_page" => [
                    "title" => "Articles par page",
                    "description" => "Limiter le nombre d'articles par page",
                    "validation" => "Veuillez entrer un nombre entier positif"
                ],
                "sort_order" => [
                    "title" => "Ordre de tri",
                    "description" => "Trier les messages recherchés"
                ]
            ]
        ],
        "main_rss" => [
            "name" => "Composant flux Rss",
            "description" => "Fournit une méthode pour imposer l'url du flux rss principal."
        ],
        "main_sitemap" => [
            "name" => "Composant Sitemap",
            "description" => "Fournit une méthode pour imposer l'url du plan du site principal."
        ]
    ],

    // Control d'accès
    "acl" => [
        "permissions_settings" => [
            "tabs" => [
                "posts" => "Articles"
            ],
            "labels" => [
                "access_plugin" => "Plugin Access Posts",
                "create_posts" => "Créer des posts",
                "categorize_posts" => "Catégoriser les articles",
                "tag_posts" => "Étiquettes d'articles",
                "set_post_layout" => "Définir la mise en page du message",
                "publish_own_posts" => "Publier ses propres articles",
                "unpublish_own_posts" => "Dépublier ses propres articles",
                "edit_own_published_posts" => "Modifier vos propres articles publiés",
                "delete_own_unpublished_posts" => "Supprimer ses propres articles non publiés",
                "delete_own_published_posts" => "Supprimer ses propres articles publiés",
                "publish_all_posts" => "Publier tous les articles",
                "unpublish_all_posts" => "Dépublier tous les articles",
                "edit_all_unpublished_posts" => "Modifier tous les articles non publiés",
                "edit_all_published_posts" => "Modifier tous les articles publiés",
                "delete_all_unpublished_posts" => "Supprimer tous les articles non publiés",
                "delete_all_published_posts" => "Supprimer tous les articles publiés",
                "assign_posts" => "Attribuer des articles à un utilisateur",
                "view_categories" => "Voir les catégories",
                "manage_categories" => "Gérer les catégories",
                "view_tags" => "Afficher les étiquettes",
                "manage_tags" => "Gérer les étiquettes",
                "manage_translations" => "Gérer les traductions",
                "manage_slugs" => "Gérer les slugs",
                "view_settings" => "Afficher les paramètres",
                "manage_settings" => "Gérer les paramètres"
            ]
        ],
        "error" => [
            "manage_categories" => "Permissions insuffisantes pour gérer les catégories",
            "edit_post" => "Permissions insuffisantes pour modifier :post",
            "publish_post" => "Permissions insuffisantes pour publier :post",
            "unpublish_post" => "Permissions insuffisantes pour dépublier :post",
            "delete_post" => "Permissions insuffisantes pour supprimer :post",
            "edit_tag" => "Permissions insuffisantes pour modifier :tag",
            "delete_tag" => "Permissions insuffisantes pour publier :tag",
            "manage_settings" => "Permissions insuffisantes pour gérer les paramètres"
        ]
    ],

    "validation" => [
        "slug_unavailable" => "Le slug ':slug' n'est pas disponible."
    ],

    "static_pages" => [
        "tabs" => [
            "banner_image" => "Image de bannière",
            "social_images" => "Images sociales",
            "seo" => "SEO"
        ],
        "labels" => [
            "default" => "Image par défaut",
            "responsive" => "Images responsives",
            "facebook_image" => "Image de partage pour Facebook",
            "twitter_image" => "Image de partage pour Twitter",
            "seo_page_about" => "La page concerne",
            "seo_keywords" => "Mots clés",
            "seo_search_description" => "Description pour les moteurs de recherche",
            "seo_opengraph_title" => "Titre pour le partage sur Facebook et Open Graph",
            "seo_opengraph_description" => "Description pour le partage sur Facebook et Open Graph",
            "seo_twitter_title" => "Titre pour le partage sur Twitter",
            "seo_twitter_description" => "Description pour le partage sur Twitter"
        ],
        "menu_types" => [
            "category" => "Articles : Une seule catégorie",
            "all_categories" => "Articles : Toutes les catégories",
            "post" => "Articles : Un article",
            "all_posts" => "Articles : Tous les articles",
            "tag" => "Articles : Une étiquette",
            "all_tags" => "Articles : Toutes les étiquettes",
            "category_posts" => "Articles : Articles de la catégorie",
            "tag_posts" => "Articles : Articles avec étiquette"
        ]
    ],

    "backend_user" => [
        "tabs" => [
            "profile" => "Profil",
            "biography" => "Biographie"
        ],
        "labels" => [
            "username" => "Nom d'utilisateur :",
            "twitter_handle" => "Nom d'utilisateur Twitter",
            "instagram_handle" => "Nom d'utilisateur Instagram",
            "facebook_handle" => "Nom d'utilisateur Facebook",
            "website_url" => "URL du site web",
            "mini_biography" => "Mini biographie",
            "full_biography" => "Biographie complète"
        ],
        "placeholders" => [
            "handle" => "Votre nom d'utilisateur",
            "at_handle" => "@VotreNomUtilisateur",
            "website" => "https://votresiteweb.com"
        ]
    ],

    "theme_form_config" => [
        "tabs" => [
            "branding" => "Image de marque",
            "social" => "Social",
            "images" => "Images",
            "site_operator" => "Opérateur de site",
            "detail" => "Détail",
            "address" => "Adresse",
            "contact" => "Contact"
        ],
        "labels" => [
            "site_brand" => "Marque du site",
            "site_name" => "Nom du site",
            "site_description" => "Description du site",
            "append_to_title" => "Ajouter au titre",
            "facebook_url" => "URL de Facebook",
            "facebook_app_id" => "ID de l'application Facebook",
            "twitter_handle" => "Nom d'utilisateur Twitter",
            "operator_type" => "Type d'opérateur",
            "name" => "Nom",
            "logo" => "Logo",
            "address_street" => "Adresse de la rue",
            "address_city" => "Ville",
            "address_region" => "Région",
            "address_postcode" => "Code postal",
            "address_country" => "Pays",
            "address_latitude" => "Latitude",
            "address_longitude" => "Longitude",
            "contact_telephone" => "Téléphone",
            "contact_email" => "Courriel :",
            "contact_fax" => "Fax",

        ],
        "placeholders" => [
            "facebook_url" => "https://facebook.com/YourUsername",
            "facebook_app_id" => "0123456789",
            "twitter_handle" => "@VotreNomDePoste"
        ],
        "options" => [
            "append_title_none" => "Aucun",
            "append_title_name" => "Nom du site",
            "append_title_brand" => "Marque du site",
            "append_title_name_brand" => "Nom du site et marque",
            "person" => "Personne / individu",
            "organization" => "Organisation"
        ]
    ],
    "aboutposts" => [
        "page_title" => "A propos de Posts"
    ]
];
