<?php return [
    'plugin' => [
        'name' => 'E-shop',
        'description' => 'E-shop pre October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Vytvoriť produkt',
            'update' => 'Upraviť produkt',
            'preview' => 'Náhľad produktu',
        ],
        'categories' => [
            'create' => 'Vytvoriť kategóriu',
            'update' => 'Upraviť kategóriu',
            'preview' => 'Náhľad kategórie',
        ],
        'orders' => [
            'show' => 'Detaily objednávky',
            'export' => 'Exportovať objednávky',
        ],
        'discounts' => [
            'create' => 'Vytvoriť zľavu',
            'update' => 'Upraviť zľavu',
            'preview' => 'Náhľad zľavy',
        ],
        'services' => [
            'create' => 'Vytvoriť službu',
            'update' => 'Upraviť službu',
        ],
        'shipping_methods' => [
            'create' => 'Vytvoriť typ dopravy',
            'update' => 'Upraviť typ dopravy',
            'preview' => 'Náhľad typu dopravy',
        ],
        'payment_methods' => [
            'create' => 'Vytvoriť typ platby',
            'edit' => 'Upraviť typ platby',
            'reorder' => 'Zmena poradia',
        ],
        'custom_field_options' => [
            'edit' => 'Upraviť možnosti poľa',
        ],
        'properties' => [
            'create' => 'Vytvoriť vlastnosti',
            'edit' => 'Upraviť vlastnosti',
        ],
        'order_states' => [
            'create' => 'Vytvoriť stav',
            'edit' => 'Upraviť stav',
            'reorder' => 'Zmena poradia',
        ],
        'brands' => [
            'create' => 'Vytvoriť značku',
            'edit' => 'Upraviť značku',
        ],
        'property_groups' => [
            'create' => 'Vytvoriť filtre',
            'edit' => 'Upraviť filtre',
        ],
        'customer_groups' => [
            'create' => 'Vytvoriť skupinu',
            'update' => 'Upraviť skupinu',
        ],
        'notifications' => [
            'update' => 'Aktualizovať správu',
        ],
        'taxes' => [
            'create' => 'Vytvoriť DPH',
            'update' => 'Upraviť DPH',
        ],
        'reviews' => [
            'create' => 'Vytvoriť recenziu',
            'update' => 'Upraviť recenziu',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Všetky kategórie obchodu',
        'single_category' => 'Jedna kategória obchodu',
        'all_products' => 'Všetky produkty obchodu',
        'all_variants' => 'Všetky varianty obchodu',
    ],
    'currency_settings' => [
        'label' => 'Mena',
        'description' => 'Konfigurácia mien',
        'currencies' => 'Vložte oficiálne 3-znakové kódy mien.',
        'currency_code' => 'Kód meny',
        'currency_decimals' => 'Počet desatinných miest',
        'currency_format' => 'Formát',
        'currency_symbol' => 'Symbol',
        'currency_rate' => 'Kurz',
        'is_default' => 'Predvolená mena',
        'unknown' => 'Neznáma mena',
    ],
    'payment_gateway_settings' => [
        'label' => 'Platobné brány',
        'description' => 'Konfigurácia platobných brán',
        'stripe' => [
            'api_key' => 'Stripe API kľúč',
            'api_key_comment' => 'Kľúč najdete v Stripe Dashboard',
            'publishable_key' => 'Stripe verejný kľúč',
            'publishable_key_comment' => 'klúč nájdete v  Stripe Dashboard',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Testovací mód',
            'test_mode_comment' => 'Všetky platby pomocou PayPal Sandbox.',
        ],
        'postfinance' => [
            'test_mode' => 'Testovací mód',
            'test_mode_comment' => 'Všetky platby budú v testovacom režime',
            'pspid' => 'PSPID (Užívateľské meno)',
            'hashing_method' => 'Hash algoritmus',
            'hashing_method_comment' => 'Configuration -> Technical information -> Global security parameters',
            'sha_in' => 'SHA-IN podpis',
            'sha_in_comment' => 'Configuration -> Technical information -> Data and origin verification',
            'sha_out' => 'SHA-OUT podpis',
            'sha_out_comment' => 'Configuration -> Technical information -> Transaction feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'Notifikácie',
        'description' => 'Konfigurácia notifikácií',
    ],
    'price_category_settings' => [
        'label' => 'Kategórie cien',
        'description' => 'Konfigurácia ďalších cenových kategórií',
    ],
    'order_state_settings' => [
        'description' => 'Konfigurácia stavu objednávok',
    ],
    'payment_method_settings' => [
        'description' => 'Konfigurácia platobných možností',
    ],
    'shipping_method_settings' => [
        'description' => 'Konfigurácia dopravy',
    ],
    'tax_settings' => [
        'description' => 'Konfigurácia DPH',
    ],
    'general_settings' => [
        'category' => 'E-shop: Obecné',
        'category_payments' => 'E-shop: Platby',
        'category_orders' => 'E-shop: Objednávky',
        'label' => 'Konfigurácia',
        'description' => 'Obecné nastavenia',
        'product_page' => 'Stránka Detail produktu',
        'product_page_comment' => 'Na tejto stránke bude zobrazený detail produktu',
        'address_page' => 'Stránka Adresa',
        'address_page_comment' => 'Komponent "addressForm" musí byť na tejto stránke',
        'checkout_page' => 'Stránka Pokladňa',
        'checkout_page_comment' => 'Komponent "checkout" musí byť na tejto stránke',
        'account_page' => 'Stránka Účet',
        'account_page_comment' => 'Komponent "myAccount" musí býť na tejto stránke',
        'cart_page' => 'Stránka košík',
        'cart_page_comment' => 'Komponent "cart" musí byť na tejto stránke',
        'category_page' => 'Stránka Kategória',
        'redirect_to_cart' => 'Presmerovať do košíka',
        'redirect_to_cart_comment' => 'Presmerujte do košíka potom, čo zákazník pridal produkt',
        'use_state' => 'Použiť pole Štát/Krajina/Provincia',
        'use_state_comment' => 'Zákazník musí použiť pole Štát/Krajina/Provincia počas registrácie',
        'group_search_results_by_product' => 'Skupinové hľadanie - výsledky produktov',
        'group_search_results_by_product_comment' => 'Produkt zonraziť vo výsledkoch hľadania iba raz, nezobrazovať všetky varianty',
        'shipping_selection_before_payment' => 'Zákazník si volí spôsob doručenia PRED spôsobom platby počas platby',
        'shipping_selection_before_payment_comment' => 'Predvolené, počas platby, zákazník najprv volí spôsob platby pred voľbou spôsobu doručenia; použite túto možnosť na zmenu poradia',
        'admin_email' => 'Email administrátora',
        'admin_email_comment' => 'Správy pre administrátora budú zasielané na túto adresu',
        'base' => 'Základné nastavenia',
        'links' => 'CMS stránky',
        'links_comment' => 'Vyberte, ktoré stránky budú zobrazovať produkty',
        'customizations' => 'Prispôsobenie',
        'customizations_comment' => 'Upravte funkcie eshopu',
        'category_page_comment' => 'Komponent "products" musí byť na tejto stránke.',
        'order_number_start' => 'Číslo prvej objednávky',
        'order_number_start_comment' => 'Prednastavené ID prvej objednávky',
        'index_driver' => 'Ovládač indexu',
        'index_driver_comment' => 'Pokiaľ Vaša databáza podporuje JSON, použite databázový ovládač.',
        'index_driver_filesystem' => 'Súborový systém',
        'index_driver_database' => 'Databáza (iba pre MySQL 5.7+ nie MariaDB 10.2+)',
        'index_driver_hint' => 'Pokiaľ zmeníte túto možnosť, spusťte "php artisan mall:reindex" v príkazovom riadku pre reindexáciu Vašich produktov!',
    ],
    'feed_settings' => [
        'description' => 'Konfigurácia kanálov',
        'google_merchant_enabled' => 'Povoliť Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'Bude vytvorený kanál produktov',
        'google_merchant_url' => 'Vaše Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Pridajte ?locale=xy pre získanie lokalizovaného kanálu.',
    ],
    'review_settings' => [
        'description' => 'Konfigurácia recenzií',
        'enabled' => 'Recenzie povolené',
        'enabled_comment' => 'Zákazník môže vytvárať recenzie',
        'moderated' => 'Kontrola recenzií',
        'moderated_comment' => 'Nové recenzie budú publikované ručne správcom',
        'allow_anonymous' => 'Povoliť anonymné recenzie',
        'allow_anonymous_comment' => 'Nezaregistrovaný užívatelia môžu vytvárať recenzie',
    ],
    'common' => [
        'shop' => 'E-shop',
        'products' => 'Produkty',
        'product' => 'Produkt',
        'orders' => 'Objednávky',
        'cart' => 'Košík',
        'shipping' => 'Doprava',
        'taxes' => 'DPH',
        'rates' => 'Sadzba',
        'inventory' => 'Inventár',
        'accessories' => 'Príslušenstvo',
        'shipping_methods' => 'Doprava',
        'accessory' => 'Doplnky',
        'custom_fields' => 'Vlastné pole',
        'variants' => 'Varianty',
        'variant' => 'Variant',
        'discounts' => 'Zľavy',
        'discount' => 'Zľava',
        'discount_percentage' => 'Zľava (%)',
        'select_placeholder' => '-- Prosím vyberte',
        'main_image' => 'Hlavný obrázok',
        'images' => 'Obrázok',
        'image_set' => 'Skupina obrázkov',
        'attachments' => 'Obrázky/Súbory',
        'downloads' => 'Súbory',
        'select_image' => 'Vyberte obrázok',
        'select_file' => 'Vyberte súbor',
        'allowed' => 'Povolené',
        'not_allowed' => 'Zakázané',
        'yes' => 'Áno',
        'no' => 'Nie',
        'seo' => 'SEO',
        'properties_links' => 'Vlastnosti/Odkazy',
        'categories' => 'Kategórie',
        'category' => 'Kategória',
        'meta_title' => 'Meta - titulok',
        'meta_description' => 'Meta - popis',
        'meta_keywords' => 'Meta - kľúčové slová',
        'reorder' => 'Zmena poradia',
        'id' => 'ID',
        'created_at' => 'Vytvorené',
        'updated_at' => 'Aktualizované',
        'approved_at' => 'Schválené',
        'hide_published' => 'Skryť publikované',
        'slug' => 'URL',
        'name' => 'Meno',
        'display_name' => 'Názov filtru - zobrazí sa na stránke',
        'group_name' => 'Názov skupiny',
        'add_value' => 'Pridať',
        'export_orders' => 'Exportovať objednávky',
        'use_backend_defaults' => 'Použijte predvolené nastavenia nakonfigurované v nastaveniach backendu',
        'api_error' => 'Zľavu nejde uložiť. Chyba pri odosielaní zmien do rozhrania API Mall.',
        'includes_tax' => 'Vrátane daní',
        'conditions' => 'Podmienky dopravy',
        'general' => 'Obecné',
        'logo' => 'Logo',
        'payment_gateway' => 'Platebná brána',
        'payment_provider' => 'Poskytovateľ platieb',
        'payment_methods' => 'Spôsob platby',
        'payment' => 'Platba',
        'payments' => 'Platby',
        'image' => 'Obrázok',
        'color' => 'Farba',
        'unit' => 'Jednotka',
        'dont_group' => '-- Nezoskupovať',
        'properties' => 'Filtre',
        'old_price' => 'Stará cena',
        'property' => 'Filter',
        'property_groups' => 'Skupiny filtrov',
        'property_group' => 'Skupinu filtrov',
        'options' => 'Možnosti',
        'option' => 'Možnosť',
        'catalogue' => 'Katalóg produktov',
        'out_of_stock' => 'Tento produkt nie je skladom',
        'out_of_stock_short' => 'Nie je skladom',
        'stock_limit_reached' => 'Nemôžete pridať viac kusov do košíka, protože bol dosiahnutý limit zásob.',
        'deleted_at' => 'Zmazané',
        'sort_order' => 'Poradie',
        'order_states' => 'Stavy objednávok',
        'website' => 'www',
        'brands' => 'Značky',
        'brand' => 'Značka',
        'sorting_updated' => 'Poradie bolo aktualizované',
        'not_in_use' => 'Možnosť se nepoužíva',
        'saved_changes' => 'Zmeny boli uložené',
        'none' => '-- Žiadna',
        'customers' => 'Zákazníci',
        'customer_groups' => 'Skupiny zákazníkov',
        'customer_group' => 'Skupina zakazníkov',
        'product_or_variant' => 'Produkt/Varianta',
        'code' => 'Kód',
        'code_comment' => 'Tento kód môže byť použitý k identifikácií tohoto záznamu programovo',
        'checked' => 'Označené',
        'unchecked' => 'Neoznačené',
        'notifications' => 'Správy',
        'notification' => 'Správa',
        'price_missing' => 'Zadejte aspoň cenu pro prednastavenú menu',
        'slug_unique' => 'WWW adresa musí byť unikátna',
        'fees' => 'Poplatky',
        'value' => 'Hodnota',
        'action_required' => 'Je vyžadovaná akcia!',
        'invalid_quantity' => 'Vybraná hodnota nie je platná',
        'addresses' => 'Adresy',
        'address' => 'Adresa',
        'reference' => 'Referencie',
        'session_id' => 'ID relácie',
        'message' => 'Správa',
        'payment_method' => 'Typ platby',
        'data' => 'Dáta',
        'successful' => 'Úspešný',
        'failed' => 'Neúspešný',
        'caution' => 'Pozor',
        'since_begin' => 'Od začiatku',
        'weekly' => 'Týždenne',
        'feeds' => 'Kanály',
        'services' => 'Služby',
        'service' => 'Služba',
        'review' => 'Recenzia',
        'reviews' => 'Recenzie',
        'review_categories' => 'Recenzia - kategórie',
        'review_category' => 'Recenzia - kategória',
        'title' => 'Názov',
        'version' => 'Verzia',
    ],
    'variant' => [
        'method' => [
            'single' => 'Samostatný produkt',
            'variant' => 'Produkt s variantami',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Použiť pre varianty',
        'use_for_variants_comment' => 'Táto vlastnosť je rôzná pre rôzné varianty tohoto produktu',
        'filter_type' => 'Typ filtra',
        'filter_types' => [
            'none' => 'Bez filtra',
            'set' => 'Sada',
            'range' => 'Rozmedzie od do',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Textové pole',
        'integer' => 'Číslo',
        'float' => 'Float',
        'textarea' => 'Viacriadkové textové pole',
        'richeditor' => 'Editor',
        'dropdown' => 'Rozbaľovací zoznam',
        'checkbox' => 'Zaškrtávacie políčko',
        'color' => 'Farba',
        'image' => 'Obrázok',
        'add' => 'Pridať možnosť',
        'name' => 'Názov',
        'price' => 'Cena',
        'attributes' => 'Atribút',
        'option' => 'Možnosť',
    ],
    'product' => [
        'user_defined_id' => 'ID produktu',
        'name' => 'Meno produktu',
        'published' => 'Zobrazené',
        'published_short' => 'Zobr.',
        'is_virtual' => 'Virtuálny produkt',
        'is_virtual_comment' => 'Tento produkt je virtuálny (bez dopravy)',
        'product_file' => 'Súbor produktu',
        'product_files' => 'Súbory produktu',
        'product_files_section_comment' => 'Toto je virtuálny produkt. Nižšie môžete nahrať nové verzie súboru. Posledná verzia bude stiahnuteľná zákazníkmi.',
        'product_file_version' => 'Verzia súboru',
        'not_published' => 'Nezverejnené',
        'published_comment' => 'Tento produkt je zverejnený v e-shope',
        'stock' => 'Počet ks',
        'price' => 'Cena',
        'description_short' => 'Krátký popis',
        'description' => 'Popis',
        'weight' => 'Váha (g)',
        'length' => 'Dľžka (mm)',
        'height' => 'Výška (mm)',
        'width' => 'Šírka (mm)',
        'quantity_default' => 'Prednastavený počet ks',
        'quantity_min' => 'Minimálny počet ks',
        'quantity_max' => 'Maximálny počet ks',
        'inventory_management_method' => 'Spôsob riadenia zásob',
        'allow_out_of_stock_purchases' => 'Povoliť objednávku pri vyprodaní zásob',
        'allow_out_of_stock_purchases_comment' => 'Tento produkt môže byť objednaný aj pri nulových zásobách',
        'stackable' => 'Produkt v košíku',
        'stackable_comment' => 'Pokiaľ je produkt pridaný do košíka viackrát, zobraziť ho ako jednu položku (zmení sa počet ks)',
        'shippable' => 'Dodateľné',
        'shippable_comment' => 'Tento produkt môže byť dodaný',
        'taxable' => 'DPH',
        'taxable_comment' => 'Vypočítajte dane z tohoto produktu',
        'add_currency' => 'Pridať menu',
        'is_taxable' => 'Použite daň',
        'is_not_taxable' => 'Nepoužívajte žiadnu daň',
        'currency' => 'Mena',
        'general' => 'Obecné',
        'duplicate_currency' => 'Vložili ste viac cien pre rovnakú menu',
        'property_title' => 'Názov',
        'property_value' => 'Hodnota',
        'link_title' => 'Názov',
        'link_target' => 'Adresa www',
        'embed_title' => 'Názov',
        'embed_code' => 'Vložiť kód',
        'properties' => 'Vlastnosti',
        'links' => 'Odkazy',
        'embeds' => 'Vložiť kód',
        'details' => 'Podrobnosti',
        'price_includes_tax' => 'Cena zahrňuje DPH',
        'price_includes_tax_comment' => 'Definovaná cena zahrňuje DPH',
        'group_by_property' => 'Atribút pre zoskupenie variánt',
        'additional_descriptions' => 'Ďalšie popisky',
        'additional_properties' => 'Ďalšie vlastnosti',
        'gtin' => 'Číslo globálnej obchodnej položky (GTIN)',
        'mpn' => 'Číslo dielu výrobcu (MPN)',
        'price_table_modal' => [
            'trigger' => 'Upravi5 ceny a zásoby',
            'label' => 'Ceny a zásoby',
            'title' => 'Prehľad cien a zásob',
            'currency_dropdown' => 'Mena: ',
        ],
        'missing_category' => 'Produkt nemá kategóriu. Vyberte kategóriu pre úpravu produktu.',
        'variant_support_header' => 'Varianty nie sú podporované',
        'variant_support_text' => 'Vybraná kategória nemá nadefinované varianty. Zmeňte spôsob riadenia zásob na "Samostatný produkt" alebo vyberte inú kategóriu.',
        'filter_virtual' => 'Zobraziť iba virtuálne produkty',
    ],
    'product_file' => [
        'display_name_comment' => 'Tento názov bude viditeľný pre zákazníka.',
        'version_comment' => 'Unikátna verzia pomôže zákazníkovi rozoznať aktualizované súbory.',
        'expires_after_days' => 'Sťahovánie platné po dobu dní',
        'expires_after_days_comment' => 'Súbor môže byť stiahnutý iba tento počet dní po zakúpení. Nechajte prázdne pre neobmedzený počet dní.',
        'max_download_count' => 'Maximálny počet stiahnutí',
        'max_download_count_comment' => 'Súbor môže byť stiahnutý iba toľkokrát. Nechajte prázdne pro neobmedzené sťahovanie.',
        'session_required' => 'Prihlásenie je vyžadované',
        'session_required_comment' => 'Súbor môže byť stiahnutý iba pokiaľ je zákazník prihlásený (odkaz nie je s zdieľaný).',
        'file' => 'Súbor',
        'download_count' => 'Počet stiahnutí',
        'errors' => [
            'invalid' => 'Neplatný odkaz na stiahnutie',
            'expired' => 'Platnosť odkazu na sitahnutie vypršala',
            'too_many_attempts' => 'Príliš veľa pokusov o stiahnutie',
            'not_found' => 'Požadovaný súbor sa nepodarilo nájsť, kontaktujte nás kvôli podpore.',
        ],
        'hint' => [
            'intro' => 'Tento produkt nemá pripojený súbor. Nezabudnite pri platení jeden pridať alebo ho programovo generovať.',
            'info_text' => 'Nájdete informácie ako na to',
            'info_link' => 'v dokumentácií',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Hlavný obrázok',
        'is_main_set_comment' => 'Použiť ako hlavný obrázok',
        'create_new' => 'Vytvoriť novú sadu',
    ],
    'category' => [
        'name' => 'Názov',
        'code' => 'Kód',
        'code_comment' => 'Tento kód môže byť použitý pre identifikáciu tejto kategórie na vašej stránke.',
        'parent' => 'Nadradená kategórie',
        'no_parent' => 'bez nadradenej kategórie',
        'inherit_property_groups' => 'Zdediť vlastnosti nadradenej kategórie',
        'inherit_property_groups_comment' => 'Použite skupiny vlastností nadradenej kategórie',
        'inherit_review_categories' => 'Zdediť kategórie recenzií nadradenej kategórie',
        'inherit_review_categories_comment' => 'Použite kategórie recenzií nadradenej kategórie',
    ],
    'custom_fields' => [
        'name' => 'Názov poľa',
        'type' => 'Typ poľa',
        'options' => 'Možnosti',
        'required' => 'Povinné',
        'required_comment' => 'Toto pole je povinné pre vytvorenie objednávky',
        'is_required' => 'Povinné',
        'is_not_required' => 'Nepovinné',
    ],
    'tax' => [
        'percentage' => 'Počet percent',
        'countries' => 'Pridať DPH pri doprave do týchto krajín',
        'countries_comment' => 'Pokiaľ nie je vybraná krajina,  bude DPH použitá celosvetovo.',
        'is_default' => 'Prednastavené',
        'is_default_comment' => 'Táto DPH je použitá, pokiaľ ešte nie je známa cieľová krajina.',
    ],
    'discounts' => [
        'name' => 'Názov',
        'code' => 'Kód zľavy',
        'code_comment' => 'Nechajte prázdne pre vytvorenie náhodného kódu',
        'total_to_reach' => 'Minimálna celková čiastka pre uplatnenie zľavy',
        'type' => 'Typ zľavy',
        'trigger' => 'Platná pokiaľ',
        'rate' => 'Procenta (%)',
        'amount' => 'Pevná čiastka',
        'max_number_of_usages' => 'Maximálny počet použití zľavy',
        'valid_from' => 'Platné od',
        'expires' => 'Platnosť končí',
        'number_of_usages' => 'počet použití zľavy',
        'shipping_description' => 'Meno alternatívneho spôsobu dopravy',
        'shipping_price' => 'Cena alternatívneho spôsobu dopravy',
        'shipping_guaranteed_days_to_delivery' => 'Zaručené dni na doručenie',
        'section_type' => 'K čomu tato zľava slúži?',
        'section_trigger' => 'Kedy sa zľava aplikuje?',
        'types' => [
            'fixed_amount' => 'Pevná čiastka',
            'rate' => 'Percentá',
            'shipping' => 'Alternatívna doprava',
        ],
        'triggers' => [
            'total' => 'Dosiahnutá celková cena objednávky',
            'code' => 'je zadaný zľavový kód',
            'product' => 'Určitý produkt je v košíku',
        ],
        'validation' => [
            'empty' => 'Vložte kupón.',
            'shipping' => 'Môžete použiť iba jeden kupón, ktorý zníži Vašu dopravu.',
            'duplicate' => 'Rovnaký kupón môžete použiť iba raz.',
            'expired' => 'Platnosť tohto kupónu vypršala.',
            'not_found' => 'Tento kupón nie je platný.',
            'usage_limit_reached' => 'Tento kupón bol už použiť a preto je neplatný.',
        ],
    ],
    'payment_method' => [
        'price' => 'Pevný poplatok',
        'price_comment' => 'Čiastka, ktorá sa má pridať k objednávke',
        'fee_percentage' => 'Percentuálny poplatok',
        'fee_percentage_comment' => 'Percento z celkovej sumy, ktoré se pridá k objednávke',
        'fee_label' => 'Poplatok',
        'fee_label_comment' => 'Tento text sa zákazníkovi zobrazí pri platení.',
        'instructions' => 'Platobné pokyny',
        'instructions_comment' => 'Podporovaná twig syntax. Pomocou {{ order }} alebo {{ cart }} získate prístup k odpovedajúcim informáciám, ak sú k dispozícií',
        'pdf_partial' => 'príloha PDF',
        'pdf_partial_comment' => 'U všetkých objednávok s týmto spôsobom platby bude k emailu priložený súbor PDF',
        'pdf_partial_none' => 'Bez prílohy PDF',
    ],
    'order' => [
        'order_number' => 'Číslo objednávky',
        'invoice_number' => 'Číslo faktúry',
        'payment_hash' => 'Platobný reťazec',
        'customer' => 'Zákazník',
        'creation_date' => 'Vytvorené',
        'modification_date' => 'Zmenené',
        'completion_date' => 'Vybavené',
        'credit_card' => 'Kreditná karta',
        'payment_status' => 'Stav platby',
        'grand_total' => 'Celkom',
        'billing_address' => 'Fakturačná adresa',
        'shipping_address' => 'Doručovacia adresa',
        'currency' => 'Mena',
        'status' => 'Stav',
        'email' => 'Email',
        'will_be_paid_later' => 'Bude zaplatené neskôr',
        'shipping_address_same_as_billing' => 'Doručovacia adresa je rovnaká',
        'credit_card_last4_digits' => 'Posledné 4 čísla',
        'tracking_number' => 'Sledovacie číslo',
        'tracking_url' => 'Sledovacia www adresa ',
        'tracking_shipped' => 'Označiť ako odoslané',
        'tracking_shipped_comment' => 'Objednávka bude označená ako odoslaná',
        'tracking_completed' => 'Označiť aako vybavené',
        'tracking_completed_comment' => 'Objednávka bude označená ako vybavená',
        'tracking_notification' => 'Poslať notifikáciu',
        'tracking_notification_comment' => 'Notifikácia s informáciami o stave objednávky bude odoslaná zákazníkovi',
        'shipping_fees' => 'Poplatky za dopravu',
        'shipping_provider' => 'Dopravca',
        'shipping_method' => 'Spôsob dopravy',
        'card_holder_name' => 'Majiteľ karty',
        'card_type' => 'Typ karty',
        'payment_method' => 'Spôsob platby',
        'payment_gateway_used' => 'Platba',
        'tax_provider' => 'Poskytovateľ dane',
        'lang' => 'Jazyk',
        'refunds_amount' => 'Vrátenie čiastky',
        'adjusted_amount' => 'Upravená čiastka',
        'rebate_amount' => 'Čiastka zľavy',
        'total' => 'Cena celkem',
        'taxes_total' => 'Dane celkom',
        'items_total' => 'Kusy celkom',
        'subtotal' => 'Medzisúčet',
        'taxable_total' => 'Zdaniteľný súčet',
        'total_weight' => 'Celková váha',
        'total_rebate_rate' => 'Celková zľava',
        'notes' => 'Poznámky',
        'custom_fields' => 'Vlastné polia',
        'shipping_enabled' => 'Preprava povolená',
        'payment_transaction_id' => 'ID platobnej transakcie',
        'change_order_status' => 'Zmeniť stav objednávky',
        'change_payment_status' => 'Zmeniť stav platby',
        'items' => 'Položky',
        'quantity' => 'Množstvo',
        'shipping_address_is_same_as_billing' => 'Dodacia adresa je rovnaká ako fakturačná',
        'update_shipping_state' => 'Aktualizovať stav dopravy',
        'invalid_status' => 'Vybraný stav neexistuje.',
        'updated' => 'Objednávka úspešne aktualizovaná',
        'deleted' => 'Objednávka úspešne zmazaná',
        'deleting' => 'Mazanie objednávky..',
        'delete_confirm' => 'Naozaj chcete zmazať túto objednávku?',
        'update_invoice_number' => 'Nastaviť číslo faktúry',
        'shipped' => 'Odoslané',
        'shipping_pending' => 'Čaká sa na dopravu',
        'not_shipped' => 'Čaká sa',
        'data' => 'Dáta objednávky',
        'total_revenue' => 'Celkové píjmy',
        'download_invoice' => 'Stiahnuť faktúru',
        'modal' => [
            'cancel' => 'Zrušiť',
            'update' => 'Aktualizovať informácie',
        ],
        'payment_states' => [
            'pending_state' => 'Na platbu sa čaká',
            'failed_state' => 'Platba neúspešná',
            'refunded_state' => 'Platba vrátená',
            'paid_state' => 'Zaplatené',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Zaručený počet dní na doručenie',
        'available_above_total' => 'Použiť, pokiaľ je celková cena rovnaká alebo vyššia',
        'available_below_total' => 'Použiť, pokiaľ je celková cena nižšia než',
        'countries' => 'Doprava dostupná do týchto krajín',
        'countries_comment' => 'Pokiaľ nie je vybraná krajina, bude tento typ dostupný do všetkých krajín.',
        'not_required_name' => 'Doprava',
        'not_required_description' => 'Košík nevyžaduje dopravu.',
    ],
    'payment_status' => [
        'paid' => 'Zaplatené',
        'deferred' => 'Odložené',
        'paid_deferred' => 'Zaplatené odložené',
        'paiddeferred' => 'Zaplatené odložené',
        'charged_back' => 'Naúčtované späť',
        'refunded' => 'Vrátené',
        'paidout' => 'Vyplatené',
        'failed' => 'Zlyhalo',
        'pending' => 'Prebieha',
        'expired' => 'Vypršalo',
        'cancelled' => 'Zrušené',
        'open' => 'Otvorené',
    ],
    'permissions' => [
        'manage_products' => 'Správa produktov',
        'manage_categories' => 'Správa kategórií',
        'manage_orders' => 'Správa objednávok',
        'manage_discounts' => 'Správa zliav',
        'settings' => [
            'manage_general' => 'Správa konfigurácií',
            'manage_payment_gateways' => 'Správa platobných brán',
            'manage_currency' => 'Správa meny',
            'manage_payment_methods' => 'Správa platieb',
        ],
        'manage_properties' => 'Správa vlastností produktu',
        'manage_customer_groups' => 'Správa skupin zákazníkov',
        'manage_customer_addresses' => 'Správa adries zákazníkov',
        'manage_notifications' => 'Správa oznámení',
        'manage_price_categories' => 'Správa kategórií cien',
        'manage_order_states' => 'Správa stavu objednávok',
        'manage_shipping_methods' => 'Správa dopravy',
        'manage_taxes' => 'Správa DPH',
        'manage_payment_log' => 'Správa záznamov platieb',
        'manage_feeds' => 'Správa kanálov',
        'manage_wishlists' => 'Správa zoznamov prianí',
        'manage_services' => 'Správa služieb',
        'manage_reviews' => 'Správa recenzií',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produkty',
                'description' => 'Zobrazí zoznam produktov',
            ],
            'properties' => [
                'no_category_filter' => 'Nefiltrovať podľe kategórie',
                'use_url' => 'Použite slug kategórie z URL',
                'filter_component' => [
                    'title' => 'Filtrovať alias komponenty',
                    'description' => 'Alias komponenty ProductsFilter, ktorý tento komponent filtruje',
                ],
                'filter' => [
                    'title' => 'Reťazec filtrov',
                    'description' => 'Vynútený filter pre tento komponent',
                ],
                'include_variants' => [
                    'title' => 'Zobraziť varianty produktu',
                    'description' => 'Nezobrazovať jednotlivé produkty, ale všetky dostupné varianty produktov',
                ],
                'include_children' => [
                    'title' => 'Zahrnúť podradené',
                    'description' => 'Zobraziť tiež všetkyy produkty podradených kategórií',
                ],
                'per_page' => [
                    'title' => 'Na stránke',
                    'description' => 'Koľko produktov sa zobrazí na stránke',
                ],
                'paginate' => [
                    'title' => 'Stránkovanie',
                    'description' => 'Stránkovať výsledky (zobrazit viac než jednu stránku)',
                ],
                'sort' => [
                    'title' => 'Zoradiť',
                    'description' => 'Toto prepíše preferencie radenia užívateľa',
                ],
                'set_page_title' => [
                    'title' => 'Nastaviť názov stránky',
                    'description' => 'Ako názov stránky použite názov kategórie',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filter produktov',
                'description' => 'Filtruje produkty z kategórie',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Zobraziť filter cien',
                ],
                'showBrandFilter' => [
                    'title' => 'Zobraziť filter značiek',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Zobraziť filter AKCIA',
                ],
                'includeChildren' => [
                    'title' => 'Zahrnúť podradené',
                    'description' => 'Zahrnúť tiež vlastnosti a filtre z produktov z podradených kategórií',
                ],
                'includeVariants' => [
                    'title' => 'Zahrnúť varianty',
                    'description' => 'Zobraziť filtre pre vlastnosti variant',
                ],
                'includeSliderAssets' => [
                    'title' => 'Pridať noUI Slider',
                    'description' => 'Pridať všetky pluginy noUI Slider cez cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Zoraďovanie',
                    'description' => 'Prednastavené zoraďovanie',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Najčastejšie kupovaný',
                'priceLow' => 'Najnižšia cena',
                'priceHigh' => 'Najvyššia cena',
                'latest' => 'Najnovšie',
                'oldest' => 'Najstaršie',
                'random' => 'Náhodné',
                'manual' => 'Ručne',
                'name' => 'Názov',
                'ratings' => 'Hodnotenie',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Užívateľský účet',
                'description' => 'Zobrazuje rôzné formuláre, kde si zákazník môže prezerať a upravovať svoje údaje',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Aktívna podstránka',
                ],
            ],
            'pages' => [
                'orders' => 'Objednávky',
                'profile' => 'Profil',
                'addresses' => 'Adresy',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Profil zákazníka',
                'description' => 'Zobrazuje formulár profilu zákazníka.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Výber meny',
                'description' => 'Možnosť výberu meny',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Frontendové závislosti',
                'description' => 'Zahrňuje všetkyny potrebné závislosti frontendu',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Zoznam adries',
                'description' => 'Zobrazuje zoznam adries všetkých registrovaných zákazníkov',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'Požadovaná adresa nebola nájdená',
                'cannot_delete_last_address' => 'Nemôžete zmazať svoju poslednú adresu',
            ],
            'messages' => [
                'address_deleted' => 'Adresa zmazaná',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Zoznam objednávok',
                'description' => 'Zobrazuje zoznam objednávok všetkých zákazníkov',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Detaily produktu',
                'description' => 'Zobrazuje detaily produktu',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Presmerovanie pri zmene vlastnosti',
                    'description' => 'Presmeruje zákazníka na novú stránku detailu produktu pokiaľ bola zmenená vlastnosť',
                ],
            ],
            'added_to_cart' => 'Produkt byl úspešne pridaný',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Recenzie produktov',
                'description' => 'Zobrazuje všetky recenzie produktov',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Počet recenzií na stránke',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Zobraziť iba hodnotenia tejto varianty',
                    'description' => "Nezobrazovať recenzie iných variant tohoto produktu",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Košík',
                'description' => 'Zobrazuje košík',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Zobraziť aplikátor zliav',
                ],
                'showShipping' => [
                    'title' => 'Zobraziť cenu dopravy',
                ],
                'showTaxes' => [
                    'title' => 'Zobraziť DPH',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Zobraziť tlačítko "prejsť k pokladni',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Pokladňa',
                'description' => 'Stará sa o proces platby',
            ],
            'errors' => [
                'missing_settings' => 'Prosím, vyberte spôsob platby a dopravy.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Zadanie promo kódu',
                'description' => 'Zobrazuje vstupné pole promo kódu',
            ],
            'discount_applied' => 'Zľava bola úspešne uplatnená!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Výber spôsobu prepravy',
                'description' => 'Zobrazí zoznam všetkých dostupných spôsobov dopravy',
            ],
            'errors' => [
                'unavailable' => 'Vybraný spôsob dopravy nie je pre vašu objednávku k dispozícií.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Výber spôsobu platby',
                'description' => 'Zobrazí zoznam všetkých dostupných platobných metód
                ',
            ],
            'errors' => [
                'unavailable' => 'Vybraný spôsob platby nie je pre vašu objednávku k dispozícií.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Výber adries',
                'description' => 'Zobrazí zoznam všetkých existujúcisch adries zákazníka',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formulár adresy',
                'description' => 'Zobrazí formulár pre úpravu adresy užívateľa',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Adresa',
                ],
                'redirect' => [
                    'title' => 'Presmerovať (po uložení)',
                ],
                'set' => [
                    'title' => 'Použiť túto adresu ako',
                ],
            ],
            'redirects' => [
                'checkout' => 'Pokladňa',
            ],
            'set' => [
                'billing' => 'Fakturačná adresa',
                'shipping' => 'Doručovacia adresa',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Prihlásenie',
                'description' => 'Zobrazí formulár pre registráciu a prihlásenie',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Presmerovať po prihlásení',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Snažíte sa prihlásiť s účtem neregistrovaného zákazníka.',
                'unknown_user' => 'Email alebo heslo je neplatné.',
                'not_activated' => 'Váš účet musí byť aktivovaný pred prihlásením.',
                'login' => [
                    'required' => 'Vložte emailovú adresu.',
                    'email' => 'Vložte správnu emailovú adresu.',
                    'between' => 'Vložte správnu emailovú adresu.',
                ],
                'password' => [
                    'required' => 'Vložte svoje heslo.',
                    'max' => 'Heslo je príliš dlhé.',
                    'min' => 'Heslo je príliš krátke - musí mať aspoň 8 znakov. ',
                ],
                'password_repeat' => [
                    'required' => 'Zopakujte svoje heslo.',
                    'same' => 'Heslá sa nezhodujú.',
                ],
                'email' => [
                    'required' => 'Vložte emailovú adresu.',
                    'email' => 'Emailová adresa je neplatná.',
                    'unique' => 'Zákazník s touto emailovou adresou už existuje.',
                    'non_existing_user' => 'Zákazník s touto emailovou adresou už existuje. Použite funkciu "Zabudnuté heslo" .',
                ],
                'firstname' => [
                    'required' => 'Vložte svoje meno.',
                ],
                'lastname' => [
                    'required' => 'Vložte svoje piezvisko.',
                ],
                'lines' => [
                    'required' => 'Vložte svoju adresu.',
                ],
                'zip' => [
                    'required' => 'Vložte smerovacie číslo.',
                ],
                'city' => [
                    'required' => 'Vložte mesto.',
                ],
                'country_id' => [
                    'required' => 'Vyberte krajinu.',
                    'exists' => 'Táto hodnota nie je platná.',
                ],
                'state_id' => [
                    'required' => 'Vyberte štát',
                    'exists' => 'Vybraná hodnota nie je platná.',
                ],
                'terms_accepted' => [
                    'required' => 'Prijmite podmienky.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Kategórie',
                'description' => 'Zoznam dostupných kategórií',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Začať od kategórie',
                    'description' => 'Zobraziť iba podradené kategórie tejto kategórie',
                ],
                'categorySlug' => [
                    'title' => 'Slug parameter kategórie',
                    'description' => 'Tento parameter použite k načítení nadradenej kategórie z adresy URL',
                ],
                'categoryPage' => [
                    'title' => 'Stránka kategórie',
                    'description' => 'Odkazy odkazujú na túto stránku. Pokiaľ nie je zadané nič, použije se prednastavené nastavenie z backendu.',
                ],
            ],
            'no_parent' => 'Zobraziť všetky kategórie',
            'by_slug' => 'Ako nadradenú použite kategóriu v adrese URL',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Sumár košíka',
                'description' => 'Zobrazí počet produktov a celkovú cenu košíka',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Zobraziť počet produktov',
                    'description' => 'Zobrazí počet produktov v košíku',
                ],
                'showTotalPrice' => [
                    'title' => 'Zobraziť celkovú cenu',
                    'description' => 'Zobrazí celkovú cenu všetkých produktov v košíku',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Hlavný panel zákazníka',
                'description' => 'Zobrazí odkaz pro prihlásenie a zmeny nastavení zákazníckeho účtu',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Štítok hlavného panelu zákazníka',
                    'description' => 'Text odkazu na stránku zákaznického účtu',
                ],
                'logoutLabel' => [
                    'title' => 'Štítok odhlásenia',
                    'description' => 'Text odkazu pre odhlásenie',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Rozsšírený Ecommerce (UA) komponent',
                'description' => 'Implementuje Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Tlačítko Zoznam prianí',
                'description' => 'Zobrazí tlačítko Zoznam prianí',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produkt',
                    'description' => 'ID produktu',
                ],
                'variant' => [
                    'name' => 'Variant',
                    'description' => 'ID variantu',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Zoznamy prianí',
                'description' => 'Zobrazí správcu Zoznamov prianí',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Zobraziť dopravu',
                    'description' => 'Zobrazí cenu dopravy',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'Od (Váha v gramoch)',
        'to_weight' => 'Do (Váha v gramoch)',
    ],
    'products' => [
        'variants_comment' => 'Vytvoriť rôzne varianty rovnakého produktu',
    ],
    'order_states' => [
        'name' => 'Názov',
        'description' => 'Popis',
        'color' => 'Farba',
        'flag' => 'Zvláštna značka',
        'flags' => [
            'new' => 'Nastaviť stav objednávky ako "Nová"',
            'complete' => 'Nastaviť stav objednávky ako "Vybavená"',
            'cancelled' => 'Nastaviť stav objednávky ako "Zrušená"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Tento kód môže býť použitý na identifikáciu tejto skupiny programovo',
        'discount_comment' => 'Dajte tejto skupine zákazníkov určitú zľavu v % na všetky produkty',
    ],
    'order_status' => [
        'processed' => 'Spracované',
        'disputed' => 'Sporné',
        'shipped' => 'Odoslané',
        'delivered' => 'Dodané',
        'pending' => 'Prebiehajúce',
        'cancelled' => 'Zrušené',
    ],
    'notifications' => [
        'enabled' => 'Povolené',
        'enabled_comment' => 'Toto oznámenie je povolené',
        'template' => 'Šabóna emailu',
    ],
    'payment_log' => [
        'payment_data' => 'Platobné údaje',
        'data_comment' => 'Tieto dáta boli vrátené poskytovateľom platieb',
        'order_data_comment' => 'Toto sú všetky údaje o objednávke pro túto platbu',
        'message_comment' => 'Túto správu vrátil poskytovateľ platieb',
        'code_comment' => 'Tento kód bol vrátený poskytovateľom plateb',
        'failed_only' => 'Iba neuspešné',
    ],
    'services' => [
        'options' => 'Možnosti',
        'option' => 'Možnosť',
        'required' => 'Služba je povinná',
        'required_comment' => 'Jedna z možností tejto služby musí byť vybraná, keď je produkt pridaný do košíka.',
    ],
    'reviews' => [
        'rating' => 'Hodnotenie',
        'review' => 'Text recenzie',
        'title' => 'Názov recenzie',
        'pros' => 'Pozitíva',
        'cons' => 'Negatíva',
        'anonymous' => 'Anonymná',
        'only_unapproved' => 'Zobraziť iba neschválené',
        'no_more' => 'Žiadne neschválené recenzie',
        'approve_next' => 'Schváliť a prejsť na dalšiu',
    ],
];

