<?php
return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'Solução E-commerce para o October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Criar produto',
            'update' => 'Editar produto',
            'preview' => 'Pre-visualizar produto',
        ],
        'categories' => [
            'create' => 'Criar categoria',
            'update' => 'Editar categoria',
            'preview' => 'Pre-visualizar Categoria',
        ],
        'orders' => [
            'show' => 'Detalhes do pedido',
            'export' => 'Exportar pedidos',
        ],
        'discounts' => [
            'create' => 'Criar desconto',
            'update' => 'Editar desconto',
            'preview' => 'Pre-visualizar desconto',
        ],
        'services' => [
            'create' => 'Criar serviço',
            'update' => 'Editar serviço',
        ],
        'shipping_methods' => [
            'create' => 'Criar método de entrega',
            'update' => 'Editar método de entrega',
            'preview' => 'Pre-visualizar método de entrega',
        ],
        'payment_methods' => [
            'create' => 'Criar método de pagamento',
            'edit' => 'Editar método de pagamento',
            'reorder' => 'Reordernar',
        ],
        'custom_field_options' => [
            'edit' => 'Editar opções do campo',
        ],
        'properties' => [
            'create' => 'Criar propriedades',
            'edit' => 'Editar propriedades',
        ],
        'order_states' => [
            'create' => 'Criar estado',
            'edit' => 'Editar estado',
            'reorder' => 'Reordernar estado',
        ],
        'brands' => [
            'create' => 'Criar marca',
            'edit' => 'Editar marca',
        ],
        'property_groups' => [
            'create' => 'Criar grupo',
            'edit' => 'Editar grupo',
        ],
        'customer_groups' => [
            'create' => 'Criar grupo',
            'update' => 'Editar grupo',
        ],
        'notifications' => [
            'update' => 'Notificação de atualização',
        ],
        'taxes' => [
            'create' => 'Criar imposto',
            'update' => 'Editar imposto',
        ],
        'reviews' => [
            'create' => 'Criar recomendação',
            'update' => 'Editar recomendação',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Todas categorias',
        'single_category' => 'Categoria única',
        'all_products' => 'Todos produtos',
        'all_variants' => 'Todas variações',
    ],
    'currency_settings' => [
        'label' => 'Moedas',
        'description' => 'Configure suas moedas',
        'currencies' => 'Digite somente os 3 caracteres oficiais da moeda.',
        'currency_code' => 'Código da Moeda',
        'currency_decimals' => 'Casas decimais',
        'currency_rounding' => 'Arredondar total',
        'currency_rounding_comment' => 'O total, includindo impostos, é arredondado para este valor caso a moeda esteja ativa.',
        'currency_format' => 'Formato',
        'currency_symbol' => 'Símbolo',
        'currency_rate' => 'Taxa',
        'is_default' => 'É padrão?',
        'unknown' => 'Moeda desconhecida',
    ],
    'payment_gateway_settings' => [
        'label' => 'Gateway de pagamentos',
        'description' => 'Configure os gateways de pagamento',
        'stripe' => [
            'api_key' => 'Stripe API Key',
            'api_key_comment' => 'Você pode encontrar esta chave no Dashboard do Stripe',
            'publishable_key' => 'Stripe Publishable Key',
            'publishable_key_comment' => 'Você pode encontrar esta chave no Dashboard do Stripe',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Modo TESTE',
            'test_mode_comment' => 'Executar todos os pagamento na sandbox do PayPal.',
        ],
        'postfinance' => [
            'test_mode' => 'Modo TESTE',
            'test_mode_comment' => 'Executar todos os pagamento no sandbox',
            'pspid' => 'PSPID (Username)',
            'hashing_method' => 'Hash algorithm',
            'hashing_method_comment' => 'Configuration -> Technical information -> Global security parameters',
            'sha_in' => 'SHA-IN Signature',
            'sha_in_comment' => 'Configuration -> Technical information -> Data and origin verification',
            'sha_out' => 'SHA-OUT Signature',
            'sha_out_comment' => 'Configuration -> Technical information -> Transaction feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'Notificações',
        'description' => 'Configure as notificações da loja',
    ],
    'price_category_settings' => [
        'label' => 'Categorias de Preços',
        'description' => 'Configure categorias de preços adicionais',
    ],
    'order_state_settings' => [
        'description' => 'Configure os estados do pedido',
    ],
    'payment_method_settings' => [
        'description' => 'Gerenciar métodos de pagamento',
    ],
    'shipping_method_settings' => [
        'description' => 'Gerenciar métodos de entrega',
    ],
    'tax_settings' => [
        'description' => 'Gerenciar impostos',
    ],
    'general_settings' => [
        'category' => 'Mall: Geral',
        'category_payments' => 'Mall: Pagamentos',
        'category_orders' => 'Mall: Pedidos',
        'label' => 'Configurações',
        'description' => 'Configurações gerais',
        'product_page' => 'Página de detalhes do produto',
        'product_page_comment' => 'Aqui é onde os detalhes do produto serão exibidos',
        'address_page' => 'Página de endereços',
        'address_page_comment' => 'O componente addressForm precisa estar presente nesta página',
        'checkout_page' => 'Página de pagamento',
        'checkout_page_comment' => 'O componente checkout precisa estar presente nesta página',
        'account_page' => 'Página da conta',
        'account_page_comment' => 'O componente myAccount precisa estar presente nesta página',
        'cart_page' => 'Página do Carrinho',
        'cart_page_comment' => 'O componente cart precisa estar presente nesta página',
        'category_page' => 'Página de categoria para listar produtos',
        'redirect_to_cart' => 'Redirecionar ao carrinho',
        'redirect_to_cart_comment' => 'Redirecionar ao carrinho após o usuário adicionar um produto ao carrinho',
        'use_state' => 'Usar campo Estado/País/Província',
        'use_state_comment' => 'Clientes precisam selecionar o estado durante o cadastro',
        'group_search_results_by_product' => 'Agrupar resultados da busca por produto',
        'group_search_results_by_product_comment' => 'Incluir um produto somente uma vez nos resultados de busca, não mostrará todas as Variações',
        'shipping_selection_before_payment' => 'Selecionar método de entrega ANTES do pagamento',
        'shipping_selection_before_payment_comment' => 'Por padrão, durante o pagamento, o cliente é perguntado sobre o método de pagamento antes de selecionar o método de entrega; use esta opção para reverter essa lógica',
        'admin_email' => 'E-mail do admin',
        'admin_email_comment' => 'Notificações do admin serão enviadas para este email',
        'base' => 'Configurações base',
        'links' => 'CMS',
        'links_comment' => 'Escolha quais páginas serão usadas para mostrar seus produtos',
        'customizations' => 'Customizações',
        'customizations_comment' => 'Customize algumas funções da sua loja',
        'category_page_comment' => 'Adicionar o componente "products" nesta página.',
        'order_number_start' => 'Número do primeiro pedido',
        'order_number_start_comment' => 'Código inicial do primeiro pedido',
        'index_driver' => 'Index driver',
        'index_driver_comment' => 'Se sua base de dados suporta JSON, selecione Database.',
        'index_driver_filesystem' => 'Filesystem',
        'index_driver_database' => 'Database (somente para MySQL 5.7+ ou MariaDB 10.2+)',
        'index_driver_hint' => 'Se você mudar esta opção lembre-se de rodar "php artisan mall:reindex" na linha de comando reindexar seus produtos!',
    ],
    'feed_settings' => [
        'description' => 'Configurar feeds',
        'google_merchant_enabled' => 'Ativar Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'Um feed de produto será gerado',
        'google_merchant_url' => 'Sua URL do Google Merchant Feed',
        'google_merchant_url_locale' => 'Adicionar ?locale=xy para obter um feed traduzido.',
    ],
    'review_settings' => [
        'description' => 'Configurar avaliações',
        'enabled' => 'Avaliações ativas',
        'enabled_comment' => 'Clientes podem criar avaliações',
        'moderated' => 'Moderar avaliações',
        'moderated_comment' => 'Novas avaliações precisam ser publicadas manualmente',
        'allow_anonymous' => 'Permitir avaliações anônimas?',
        'allow_anonymous_comment' => 'Usuários não cadastrados podem criar avaliações',
    ],
    'common' => [
        'shop' => 'Loja',
        'products' => 'Produtos',
        'product' => 'Produto',
        'orders' => 'Pedidos',
        'cart' => 'Carrinho',
        'shipping' => 'Entrega',
        'taxes' => 'Imposto',
        'rates' => 'Taxas',
        'inventory' => 'Inventário',
        'accessories' => 'Acessórios',
        'shipping_methods' => 'Métodos de entrega',
        'accessory' => 'Acessório',
        'custom_fields' => 'Campos customizados',
        'variants' => 'Variações',
        'variant' => 'Variação',
        'discounts' => 'Descontos',
        'discount' => 'Desconto',
        'discount_percentage' => 'Desconto (%)',
        'select_placeholder' => '-- Escolher',
        'main_image' => 'Imagem principal',
        'images' => 'Imagens',
        'image_set' => 'Conjunto de imagens',
        'attachments' => 'Imagens/Downloads/Embeds',
        'downloads' => 'Downloads',
        'select_image' => 'Escolher imagem',
        'select_file' => 'Escolher arquivo',
        'allowed' => 'Permitido',
        'not_allowed' => 'Não permitido',
        'yes' => 'Sim',
        'no' => 'Não',
        'seo' => 'SEO',
        'properties_links' => 'Propriedades/Links',
        'categories' => 'Categorias',
        'category' => 'Categoria',
        'meta_title' => 'Meta title',
        'meta_description' => 'Meta description',
        'meta_keywords' => 'Meta keywords',
        'reorder' => 'Reordernar registros',
        'id' => 'ID',
        'created_at' => 'Criado em',
        'updated_at' => 'Atualizado em',
        'approved_at' => 'Aprovado em',
        'hide_published' => 'Esconder publicados',
        'slug' => 'URL',
        'name' => 'Nome',
        'display_name' => 'Nome',
        'group_name' => 'Nome do grupo',
        'add_value' => 'Adicionar valor',
        'export_orders' => 'Exportar pedidos',
        'use_backend_defaults' => 'Usar padrões configurados no backend',
        'api_error' => 'Não foi possível salvar o desconto. Erro ao enviar alterações para o Mall API.',
        'includes_tax' => 'Incluindo impostos',
        'conditions' => 'Condições',
        'general' => 'Geral',
        'logo' => 'Logo',
        'payment_gateway' => 'Gateway de pagamento',
        'payment_provider' => 'Provider de Pagamento',
        'payment_methods' => 'Método de pagamentos',
        'payment' => 'Pagamento',
        'payments' => 'Pagamentos',
        'image' => 'Imagem',
        'color' => 'Cor',
        'unit' => 'Unidade',
        'dont_group' => '-- Não agrupar',
        'properties' => 'Propriedades',
        'old_price' => 'Preço antigo',
        'property' => 'Propriedade',
        'property_groups' => 'Grupo de Propriedades',
        'property_group' => 'Grupo de Propriedade',
        'options' => 'Opções',
        'option' => 'Opção',
        'catalogue' => 'Catálogo',
        'out_of_stock' => 'Este produto indisponível.',
        'out_of_stock_short' => 'Sem estoque',
        'stock_limit_reached' => 'You cannot add any more items of este produto to your cart since the estoque limit has been reached.',
        'deleted_at' => 'Removido em',
        'sort_order' => 'Ordenar por',
        'order_states' => 'Estados do pedido',
        'website' => 'Site',
        'brands' => 'Marcas',
        'brand' => 'Marca',
        'sorting_updated' => 'A ordem de classificação foi atualizada',
        'not_in_use' => 'Opção não está em uso',
        'saved_changes' => 'Alterações salvas',
        'none' => '-- Nenhum',
        'customers' => 'Clientes',
        'customer_groups' => 'Grupos de clientes',
        'customer_group' => 'Grupo de cliente',
        'product_or_variant' => 'Produto/Variações=',
        'code' => 'Código',
        'code_comment' => 'Este código será usado para identificar este registro na programação',
        'checked' => 'Ativo',
        'unchecked' => 'Inativo',
        'notifications' => 'Notificações',
        'notification' => 'Notificação',
        'price_missing' => 'Digite ao menos um preço para a moeda padrão',
        'slug_unique' => 'A URL precisa ser única',
        'fees' => 'Taxas',
        'value' => 'Valor',
        'action_required' => 'Ação obrigatória!',
        'invalid_quantity' => 'A quantidade não é váluda',
        'addresses' => 'Endereços',
        'address' => 'Endereço',
        'reference' => 'Referencias',
        'session_id' => 'ID da sessão',
        'message' => 'Mensagem',
        'payment_method' => 'Método de pagamento',
        'data' => 'Data',
        'successful' => 'Sucesso',
        'failed' => 'Falhou',
        'caution' => 'Atenção',
        'since_begin' => 'Desde o início',
        'weekly' => 'Semanalmente',
        'feeds' => 'Feeds',
        'services' => 'Serviços',
        'service' => 'Serviço',
        'review' => 'Avaliação',
        'reviews' => 'Avaliações',
        'review_categories' => 'Categorias de avaliações',
        'review_category' => 'Categoria de avaliação',
        'title' => 'Título',
        'version' => 'Versão',
    ],
    'variant' => [
        'method' => [
            'single' => 'Artigo',
            'variant' => 'Artigo variações',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Usar para variações',
        'use_for_variants_comment' => 'Esta propriedade é diferente para variações deste produto',
        'filter_type' => 'Tipo de filtro',
        'filter_types' => [
            'none' => 'Sem filtro',
            'set' => 'Set',
            'range' => 'Range',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Texto',
        'integer' => 'Número',
        'float' => 'Flutuante',
        'textarea' => 'Editor de texto',
        'richeditor' => 'Editor de texto rico',
        'dropdown' => 'Listagem',
        'checkbox' => 'Escolha',
        'color' => 'Cor',
        'image' => 'Imagem',
        'switch' => 'Ligado/Desligado',
        'add' => 'Adicionar opção',
        'name' => 'Nome',
        'price' => 'Preço',
        'attributes' => 'Atributo',
        'option' => 'Opção',
        'date' => 'Data',
        'datetime' => 'Data Hora',
    ],
    'product' => [
        'user_defined_id' => 'Código do Produto',
        'name' => 'Produto',
        'published' => 'Ativo?',
        'published_short' => 'Publi.',
        'is_virtual' => 'É virtual?',
        'is_virtual_comment' => 'Este produto é virtual (ex. arquivo, sem frete)',
        'product_file' => 'Arquivo do Produto',
        'product_files' => 'Arquivos do Produto',
        'product_files_section_comment' => 'Este é um produto virtual. Você pode subir novas versões abaixo. A última versão sera baixada pelo cliente.',
        'product_file_version' => 'versão do arquivo',
        'not_published' => 'Não publicado',
        'published_comment' => 'Este produto está visível na loja',
        'stock' => 'Estoque',
        'price' => 'Preço',
        'description_short' => 'Descrição curta',
        'description' => 'Descrição',
        'weight' => 'Peso',
        'length' => 'Largura',
        'height' => 'Altura',
        'width' => 'Comprimento',
        'quantity_default' => 'Quantidade padrão',
        'quantity_min' => 'Quantidade mínima',
        'quantity_max' => 'Quantidade máxima',
        'inventory_management_method' => 'Método de gestão de estoque',
        'allow_out_of_stock_purchases' => 'Permitir comprar mesmo sem estoque',
        'allow_out_of_stock_purchases_comment' => 'Este produto pode ser comprado se estiver indisponível?',
        'stackable' => 'Empilhar no carrinho',
        'stackable_comment' => 'Se este produto é adicionado ao carrinho várias vezes aparecerá somente uma vez (aumenta a quantidade)',
        'shippable' => 'Enviável',
        'shippable_comment' => 'Este produto pode ser entregue fisicamente',
        'taxable' => 'Tributável',
        'taxable_comment' => 'Calcular impostos deste produto',
        'add_currency' => 'Adicionar moeda',
        'is_taxable' => 'É tributável',
        'is_not_taxable' => 'Não é tributável',
        'currency' => 'Moeda',
        'general' => 'Geral',
        'duplicate_currency' => 'Você digitou vários preços para mesma moeda',
        'property_title' => 'Título',
        'property_value' => 'Valor',
        'link_title' => 'Título',
        'link_target' => 'URL Destino',
        'embed_title' => 'Título',
        'embed_code' => 'Código',
        'properties' => 'Propriedades',
        'links' => 'Links',
        'embeds' => 'Embeds',
        'details' => 'Detalhes',
        'price_includes_tax' => 'Preço incluindo impostos',
        'price_includes_tax_comment' => 'O preço definido incluindo todos os impostos',
        'group_by_property' => 'Atributo para grupo de variações',
        'additional_descriptions' => 'Descrições adicionais',
        'additional_properties' => 'Propriedades adicionais',
        'gtin' => 'Global Trade Item Number (GTIN)',
        'mpn' => 'Manufacturer Part Number (MPN)',
        'price_table_modal' => [
            'trigger' => 'Editar estoque e valores',
            'label' => 'Preço e estoque',
            'title' => 'Preço e estoque overview',
            'currency_dropdown' => 'Moeda: ',
        ],
        'missing_category' => 'O produto não tem uma categoria associada. Por favor selecione um categoria abaixo para este produto.',
        'variant_support_header' => 'Variações não suportadas',
        'variant_support_text' => 'A categoria selecionado não tem propriedades das variações definidas. Por favor alterar o médoto de gestã ode estoque para "Artigo" ou selecione outra categoria.',
        'filter_virtual' => 'Mostar somente produtos virtuais',
    ],
    'product_file' => [
        'display_name_comment' => 'Este nome estará visível ao cliente.',
        'version_comment' => 'Uma versão única ajuda o cliente a reconhecer arquivos atualizados.',
        'expires_after_days' => 'Download valido por dias',
        'expires_after_days_comment' => 'O arquivo pode ser baixado X dias após a compra. Deixar em branco para não limitar',
        'max_download_count' => 'Número máximo de downloads',
        'max_download_count_comment' => 'O arquivo pode ser baixado X vezez. Deixar em branco para não limitar',
        'session_required' => 'Login obrigatório',
        'session_required_comment' => 'O arquivo pode ser baixado quando o cliente está logado (link de download não pode ser compartilhado).',
        'file' => 'Arquivo',
        'download_count' => 'Qtde. Downloads',
        'errors' => [
            'invalid' => 'Link de download inválido',
            'expired' => 'Link de download expirou',
            'too_many_attempts' => 'Muitas tentativas de download',
            'not_found' => 'Arquivo não encontrado, entre em contato com o suporte.',
        ],
        'hint' => [
            'intro' => 'Este produto não tem nenhum arquivo anexado. Lembre-se de adicionar um ou gerar isso durante o pagamento.',
            'info_text' => 'Você pode encontrar informações sobre como fazer isso',
            'info_link' => 'na documentação',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Conjunto principal?',
        'is_main_set_comment' => 'Usar este conjunto de imagens para este produto',
        'create_new' => 'Criar novo conjunto',
    ],
    'category' => [
        'name' => 'Nome',
        'code' => 'Código',
        'code_comment' => 'Este código pode ser usado para identificar esta categoria nos partials do frontend.',
        'parent' => 'Pai',
        'no_parent' => 'Sem pai',
        'inherit_property_groups' => 'Herdar propriedades da categoria pai',
        'inherit_property_groups_comment' => 'Usar a propriedade grupos da categoria pai',
        'inherit_review_categories' => 'Herdar categorias de avaliações da categoria pai',
        'inherit_review_categories_comment' => 'Usar a recomendação de categorias da categoria pai',
        'google_product_category_id' => 'ID da Categoria do Produto no Google',
        'google_product_category_id_comment' => 'Usado para o Google Merchant integration, veja https://support.google.com/merchants/answer/6324436',
    ],
    'custom_fields' => [
        'name' => 'Nome do campo',
        'type' => 'Tipo do campo',
        'options' => 'Opções',
        'required' => 'Obrigatório',
        'required_comment' => 'Este campo é obrigatório para fazer o pedido',
        'is_required' => 'Obrigatório',
        'is_not_required' => 'Não obrigatório',
    ],
    'tax' => [
        'percentage' => 'Porcentagem',
        'countries' => 'Aplicar somente nestes países',
        'countries_comment' => 'Se nenhum país for selecionado, o imposto será aplicado em todo o mundo.',
        'is_default' => 'É padrão?',
        'is_default_comment' => 'Este imposto é usado se o país de entrega é desconhecido ainda',
    ],
    'discounts' => [
        'name' => 'Nome',
        'code' => 'Código',
        'code_comment' => 'Deixe em branco para gerar um código aleatório',
        'total_to_reach' => 'Valor mínimo de pedido para aplicar o cupom',
        'type' => 'Tipo de desconto',
        'trigger' => 'Válido se',
        'rate' => 'Taxa (%)',
        'amount' => 'Valor fixo',
        'max_number_of_usages' => 'Número máximo de usos',
        'valid_from' => 'Valido a partir',
        'expires' => 'Expira',
        'number_of_usages' => 'Número de usos',
        'shipping_description' => 'Nome do método de entrega alternativo',
        'shipping_price' => 'Preço do método de entrega alternativo',
        'shipping_guaranteed_days_to_delivery' => 'Dias para entrega',
        'section_type' => 'O que este desconto faz?',
        'section_trigger' => 'Quando este desconto é aplicável?',
        'types' => [
            'fixed_amount' => 'Valor fixo',
            'rate' => 'Taxa',
            'shipping' => 'Entrega diferenciada',
        ],
        'triggers' => [
            'total' => 'Valor total do pedido alcançado',
            'code' => 'Código de desconto digitado',
            'product' => 'Produto específico esta no carrinho',
            'customer_group' => 'O cliente pertence à um grupo de clientes',
        ],
        'validation' => [
            'empty' => 'Digite o código promocional.',
            'shipping' => 'Você só pode usar um cupom que reduz o frete por vez.',
            'duplicate' => 'Você só pode usar o cupom uma vez.',
            'expired' => 'Este cupom expirou.',
            'not_found' => 'Este cupom não é valido.',
            'usage_limit_reached' => 'Este cupoem foi usado muitas vezes e não está mais disponível.',
            'cart_limit_reached' => 'Limite de usos do cupom alcançado. Você não pode mais adicionar cupons neste carrinho.',
        ],
    ],
    'payment_method' => [
        'price' => 'Taxa fixa',
        'price_comment' => 'O valor a ser adicionaro ao total do pedido',
        'fee_percentage' => 'Taxa percentual',
        'fee_percentage_comment' => 'O percentual do total do pedido a ser adicionado',
        'fee_label' => 'Nome da taxa',
        'fee_label_comment' => 'Este texto irá aparecer para o cliente quando estiver pagando.',
        'instructions' => 'Instruções de Pagamento',
        'instructions_comment' => 'Suporta sintaxe Twig. Use {{ order }} ou {{ cart }} para acessar informações disponíveis',
        'pdf_partial' => 'Resumo em PDF',
        'pdf_partial_comment' => 'Para todos pedidos com este método de pagamento um resumo em PDF será anexado no email de notificação',
        'pdf_partial_none' => 'Sem PDF anexado',
    ],
    'order' => [
        'order_number' => '# Pedido',
        'invoice_number' => '# Invoice',
        'payment_hash' => 'Hash do Pagamento',
        'customer' => 'Cliente',
        'creation_date' => 'Criado em',
        'modification_date' => 'Modificado em',
        'completion_date' => 'Completado em',
        'credit_card' => 'Cartão de Crédito',
        'payment_status' => 'Pagamento',
        'grand_total' => 'Total',
        'billing_address' => 'Endereço de cobrança',
        'shipping_address' => 'Endereço de entrega',
        'currency' => 'Moeda',
        'status' => 'Status',
        'email' => 'Email',
        'will_be_paid_later' => 'Vai pagar depois',
        'shipping_address_same_as_billing' => 'Endereço de entrega é o mesmo de cobrança',
        'credit_card_last4_digits' => 'Últimos 4 digitos',
        'tracking_number' => 'Código de rastreio',
        'tracking_url' => 'Link de rastreio',
        'tracking_shipped' => 'Marcar como enviado',
        'tracking_shipped_comment' => 'O pedido será marcado como enviado',
        'tracking_completed' => 'Marcar como completo',
        'tracking_completed_comment' => 'O pedido será marcado como completo',
        'tracking_notification' => 'Enviar notificação',
        'tracking_notification_comment' => 'A notificação com o rastreio será enviada ao cliente.',
        'shipping_fees' => 'Taxas de entrega',
        'shipping_provider' => 'Provedor de entrega',
        'shipping_method' => 'Método de envio',
        'card_holder_name' => 'Nome no cartão',
        'card_type' => 'Tipo do cartão',
        'payment_method' => 'Método de pagamento',
        'payment_gateway_used' => 'Gateway de pagamento',
        'tax_provider' => 'Tax provider',
        'lang' => 'Idioma',
        'refunds_amount' => 'Total de reembolso',
        'adjusted_amount' => 'Valor ajustado',
        'rebate_amount' => 'Valor de desconto',
        'total' => 'Total',
        'taxes_total' => 'Total de impostos',
        'items_total' => 'Total dos itens',
        'subtotal' => 'Subtotal',
        'taxable_total' => 'Total tributável',
        'total_weight' => 'Peso total',
        'total_rebate_rate' => 'Total descontado',
        'notes' => 'Notas',
        'custom_fields' => 'Campos customizados',
        'shipping_enabled' => 'Frete ativo',
        'payment_transaction_id' => 'ID da transação de pagamento',
        'change_order_status' => 'Mudar etapa do pedido',
        'change_payment_status' => 'Mudar etapa do pagamento',
        'items' => 'Itens',
        'quantity' => 'Quantidade',
        'shipping_address_is_same_as_billing' => 'Endereço de entrega é o mesmo de cobrança',
        'update_shipping_state' => 'Atualizar etapa da entrega',
        'invalid_status' => 'O estado selecionado não existe.',
        'updated' => 'Pedido atualizado',
        'deleted' => 'Pedido removido',
        'deleting' => 'Removendo pedido...',
        'delete_confirm' => 'Você tem certeza que deseja remover este pedido?',
        'update_invoice_number' => 'Número do Invoice',
        'shipped' => 'Envio',
        'shipping_pending' => 'Entrega pendente',
        'not_shipped' => 'Pendente',
        'data' => 'Dados do pedido',
        'total_revenue' => 'Faturamento total',
        'download_invoice' => 'Baixar invoice',
        'order_file_name' => 'pedido-:order',
        'virtual_product_download_hint' => 'Linkds de download serão enviados separadamente após confirmação de pagamento.',
        'modal' => [
            'cancel' => 'Cancelar',
            'update' => 'Atualizar informação',
        ],
        'payment_states' => [
            'pending_state' => 'Pagamento pendente',
            'failed_state' => 'Pagamento recusado',
            'refunded_state' => 'Pagamento estornado',
            'paid_state' => 'Pago',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Dias para entrega garantidos',
        'available_above_total' => 'Disponível se o total é maior que ou igual',
        'available_below_total' => 'Disponível se o total é menor que',
        'countries' => 'Disponível para entregar nestes países',
        'countries_comment' => 'Se nenhum país for selecionado, este método estará disponível para o mundo todo.',
        'not_required_name' => 'Sem frete',
        'not_required_description' => 'O carrinho atual não precisa de frete.',
    ],
    'payment_status' => [
        'paid' => 'Pago',
        'deferred' => 'Deferred',
        'paid_deferred' => 'Paid deferred',
        'paiddeferred' => 'Paid deferred',
        'charged_back' => 'Cobrança duplicada',
        'refunded' => 'Estornado',
        'paidout' => 'Pago',
        'failed' => 'Falhou',
        'pending' => 'Pendente',
        'expired' => 'Expirou',
        'cancelled' => 'Cancelado',
        'open' => 'Aberto',
    ],
    'permissions' => [
        'manage_products' => 'Pode gerenciar produtos',
        'manage_categories' => 'Pode gerenciar categorias',
        'manage_orders' => 'Pode gerenciar pedidos',
        'manage_discounts' => 'Pode gerenciar descontos',
        'settings' => [
            'manage_general' => 'Pode mudar configurações gerais da loja ',
            'manage_payment_gateways' => 'Pode mudar configurações do gateway de pagamento ',
            'manage_currency' => 'Pode mudar configurações da moeda',
            'manage_payment_methods' => 'Pode mudar método de pagamentos',
        ],
        'manage_properties' => 'Pode editar propriedades do produto',
        'manage_customer_groups' => 'Pode gerenciar grupos de clientes',
        'manage_customer_addresses' => 'Pode gerenciar endereços de clientes',
        'manage_notifications' => 'Pode gerenciar notificações',
        'manage_price_categories' => 'Pode gerenciar categorias de preços',
        'manage_order_states' => 'Pode gerenciar estados dos pedidos',
        'manage_shipping_methods' => 'Pode gerenciar método de entregas',
        'manage_taxes' => 'Pode gerenciar impostos',
        'manage_payment_log' => 'Pode gerenciar registros de pagamento',
        'manage_feeds' => 'Pode gerenciar feeds',
        'manage_wishlists' => 'Pode gerenciar listas',
        'manage_services' => 'Pode gerenciar serviços',
        'manage_reviews' => 'Pode gerenciar recomendações',
        'manage_brands' => 'Pode gerenciar marcas',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produtos',
                'description' => 'Exibe uma lista de produtos',
            ],
            'properties' => [
                'no_category_filter' => 'Não filtrar por categoria',
                'use_url' => 'Usar slug da categoria através da URL',
                'filter_component' => [
                    'title' => 'Apelido do componente de filtro',
                    'description' => 'Apelido para o componente ProdutosFilter que filtra o componente de Produtos',
                ],
                'filter' => [
                    'title' => 'Texto do filtro',
                    'description' => 'Filtro forçado para este componente',
                ],
                'include_variants' => [
                    'title' => 'Mostrar variações',
                    'description' => 'Não mostrar somente um produto mas todas as variações',
                ],
                'include_children' => [
                    'title' => 'Incluir filhos',
                    'description' => 'Mostrar todos os produtos filtros das categorias',
                ],
                'per_page' => [
                    'title' => 'Por página',
                    'description' => 'Quantos produtos serão mostrados por página',
                ],
                'paginate' => [
                    'title' => 'Paginar',
                    'description' => 'Paginar o resultado (mostrar mais de uma página)',
                ],
                'sort' => [
                    'title' => 'Ordenar',
                    'description' => 'Isso sobrescreve a preferencia de ordenação do cliente',
                ],
                'set_page_title' => [
                    'title' => 'Título da página',
                    'description' => 'Usa o nome da categoria como o título da página',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filtro de Produtos',
                'description' => 'Filtra os produtos da categoria',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Mostrar filtro de preço',
                ],
                'showBrandFilter' => [
                    'title' => 'Mostrar filtro de marca',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Mostrar filtro de mais vendidos',
                ],
                'includeChildren' => [
                    'title' => 'Incluir filhos',
                    'description' => 'Inclui propriedades e filtros dos produtos nas categorias filhas',
                ],
                'includeVariants' => [
                    'title' => 'Incluir variações',
                    'description' => 'Mostrar filtro das propriedades das variações',
                ],
                'includeSliderAssets' => [
                    'title' => 'Incluir noUI Slider',
                    'description' => 'Incluir todas as dependencias do noUI Slider via cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Ordenar por',
                    'description' => 'Ordenação inicial',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Mais vendidos',
                'priceLow' => 'Menor preço',
                'priceHigh' => 'Maior preço',
                'latest' => 'Mais novos',
                'oldest' => 'Mais antigo',
                'random' => 'Aleatório',
                'manual' => 'Manual',
                'name' => 'Nome',
                'ratings' => 'Avaliações',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Conta',
                'description' => 'Exibe diversos formulários para o cliente gerenciar seus dados',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Sub-página ativa',
                ],
            ],
            'pages' => [
                'orders' => 'Pedidos',
                'profile' => 'Perfil',
                'addresses' => 'Endereços',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Perfil do cliente',
                'description' => 'Exibe o formulário de edição do perfil do cliente.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Seletor de moeda',
                'description' => 'Mostra um seletor de moedas na loja',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Dependências do frontend',
                'description' => 'Inclui todas as dependências necessárias do frontend',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Lista de endereço',
                'description' => 'Exibe uma lista com todos os endereços do cliente',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'O endereço não pode ser encontrado',
                'cannot_delete_last_address' => 'Você não pode remover seu último endereço',
            ],
            'messages' => [
                'address_deleted' => 'Endereço removido',
                'default_billing_address_changed' => 'Endereço de cobrança padrão foi alterado',
                'default_shipping_address_changed' => 'Endereço de entrega padrão foi alterado',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Lista de Pedidos',
                'description' => 'Exibe uma lista com todos os pedidos do cliente',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Detalhes do Produto',
                'description' => 'Exibe detalhes de um produto',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Redirecionar quando uma propriedade for alterada',
                    'description' => 'Redireciona o cliente para uma nova página de detalhes se uma propriedade for alterada',
                ],
            ],
            'added_to_cart' => 'Produto adicionado',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Avaliações do Produto',
                'description' => 'Exibe todas as avaliações de um produto',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Número de avaliações por página',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Mostrar somente avaliações deste Variação',
                    'description' => "Não mostrar avaliações de outras variações deste produto",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Carrinho',
                'description' => 'Exibe o carrinho',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Mostrar desconto aplicado',
                ],
                'discountCodeLimit' => [
                    'title' => 'Limite de cupom de desconto',
                    'description' => 'Deixe como 0 para cupons ilimitados',
                ],
                'showShipping' => [
                    'title' => 'Mostrar valor da entrega',
                ],
                'showTaxes' => [
                    'title' => 'Mostrar impostos',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Mostrar botão para efetuar compra',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Finalizar compra',
                'description' => 'Cuida do processo de compra',
            ],
            'errors' => [
                'missing_settings' => 'Por favor selecione uma forma de pagamento e um método de entrega.',
            ],
        ],
        'quickCheckout' => [
            'details' => [
                'name' => 'Compra rápida',
                'description' => 'Compra em uma única página',
            ],
            'errors' => [
                'signup_failed' => 'Falhou ao criar conta.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Campo de cuspom de desconto',
                'description' => 'Exibe um campo para o cupom de desconto',
            ],
            'discount_applied' => 'Desconto aplicado!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Seletor de frete',
                'description' => 'Exibe uma lista com todos métodos de entregas disponíveis',
            ],
            'errors' => [
                'unavailable' => 'O método de entrega selecionado não é válido para o seu pedido.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Seletor de Método de pagamento',
                'description' => 'Exibe uma lista com todos os métodos de pagamentos disponíveis',
            ],
            'errors' => [
                'unavailable' => 'O método de pagamento não é válido para o seu pedido.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Seletor de endereço',
                'description' => 'Exibe uma lista com todos os endereços do cliente',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formulário de endereço',
                'description' => 'Exibe um formulário para alterar o endereço do cliente',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Endereço',
                ],
                'redirect' => [
                    'title' => 'Redirecionar (após salvar)',
                ],
                'set' => [
                    'title' => 'Usar este endereço como',
                ],
            ],
            'redirects' => [
                'checkout' => 'Página de pagamento',
            ],
            'set' => [
                'billing' => 'Endereço de cobrança',
                'shipping' => 'Endereço de entrega',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Cadastrp',
                'description' => 'Exibe o formulário de cadastro',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Redireciona após o login',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Você esta tentando entrar com uma conta de visitante.',
                'unknown_user' => 'Dados inseridos são inválidos.',
                'not_activated' => 'Sua conta precisa ser ativada antes de entrar.',
                'login' => [
                    'required' => 'Por favor digite um endereço de email.',
                    'email' => 'Por favor digite um endereço de email válido.',
                    'between' => 'Por favor digite um endereço de email válido.',
                ],
                'password' => [
                    'required' => 'Por favor digite sua senha.',
                    'max' => 'A senha digitada é muito longa.',
                    'min' => 'A senha digitada é muito curta. Por favor digite ao menos 8 caracteres.',
                ],
                'password_repeat' => [
                    'required' => 'Por favor repita sua senha.',
                    'same' => 'Sua confirmação de senha não é igual a senha digitada.',
                ],
                'email' => [
                    'required' => 'Por favor digite um endereço de email.',
                    'email' => 'Email inválido.',
                    'unique' => 'Já existe um usuário cadastrado com este email.',
                    'non_existing_user' => 'Já existe um usuário cadastrado com este email. Use a opção "Esqueceu sua senha?"',
                ],
                'firstname' => [
                    'required' => 'Por favor digite seu nome.',
                ],
                'lastname' => [
                    'required' => 'Por favor digite seu sobrenome.',
                ],
                'lines' => [
                    'required' => 'Por favor digite seu endereço.',
                ],
                'zip' => [
                    'required' => 'Por favor digite seu CEP.',
                ],
                'city' => [
                    'required' => 'Por favor digite a cidade.',
                ],
                'country_id' => [
                    'required' => 'Escolha um país.',
                    'exists' => 'O país informado é inválido.',
                ],
                'state_id' => [
                    'required' => 'Escolha um estado',
                    'exists' => 'O valor selecionado é inválido.',
                ],
                'terms_accepted' => [
                    'required' => 'Por favor aceite os temos e condições.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Categorias',
                'description' => 'Listar categorias disponíveis',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Começar com a categoria',
                    'description' => 'Mostrar somente categorias filhas desta categoria',
                ],
                'categorySlug' => [
                    'title' => 'Categoria slug',
                    'description' => 'Use este parâmetro para carregar a categoria pai da url',
                ],
                'categoryPage' => [
                    'title' => 'Página de Categoria',
                    'description' => 'Links vão apontar para esta página. Se nada for inserido as configurações padrão serão utilizadas.',
                ],
            ],
            'no_parent' => 'Mostrar todas categorias',
            'by_slug' => 'Use categoria na url como pai',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Resumo do carrinho',
                'description' => 'Exibe o número de produtos e o valor total do carrinho',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Mostrar total de produtos',
                    'description' => 'Exibe o total de produtos no carrinho',
                ],
                'showTotalPrice' => [
                    'title' => 'Mostrar valor total',
                    'description' => 'Exibe o valor total do carrinho',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Painel do usuário',
                'description' => 'Exibe um link para o usuário entrar e alterar suas configurações',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Nome do painel do usuário',
                    'description' => 'Texto para o link do painel do usuário',
                ],
                'logoutLabel' => [
                    'title' => 'Texto para sair',
                    'description' => 'Texto do link para sair da conta',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Enhanced Ecommerce (UA) Component',
                'description' => 'Implements a Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Botão para lista de desejo',
                'description' => 'Exibe um botão para as listas de desejos',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produto',
                    'description' => 'ID do produto',
                ],
                'variant' => [
                    'name' => 'Variação',
                    'description' => 'ID da variação',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Lista de desejos',
                'description' => 'Exibe o gerenciador de listas',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Mostrar frete',
                    'description' => 'Mostrar seletor de frete',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'De (Peso em gramas)',
        'to_weight' => 'Até (Peso em gramas)',
    ],
    'products' => [
        'variants_comment' => 'Criar variações diferentes do mesmo produto',
    ],
    'order_states' => [
        'name' => 'Nome',
        'description' => 'Descrição',
        'color' => 'Cor',
        'flag' => 'Estado especial',
        'flags' => [
            'new' => 'Muda o estado do pedido para "novo"',
            'complete' => 'Muda o estado do pedido para "finalizado"',
            'cancelled' => 'Muda o estado do pedido para "cancelado"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Este código pode ser usado para identificar esse grupo na programação',
        'discount_comment' => 'Dê a esse grupo de clientes um desconto específico em % em todos os produtos',
    ],
    'order_status' => [
        'processed' => 'Recebido',
        'disputed' => 'Disputa',
        'shipped' => 'Enviado',
        'delivered' => 'Entregue',
        'pending' => 'Pendente',
        'cancelled' => 'Cancelado',
    ],
    'notifications' => [
        'enabled' => 'Ativo',
        'enabled_comment' => 'Esta notificação esta ativa',
        'template' => 'Template de email',
    ],
    'payment_log' => [
        'payment_data' => 'Dados de Pagamento',
        'data_comment' => 'Estes dados foram retornados pelo provedor de pagamento',
        'order_data_comment' => 'Estes são todos os dados do pagamento',
        'message_comment' => 'Esta mensagem foi retornado pelo provedor de pagamento',
        'code_comment' => 'Este code foi retornado pelo provedor de pagamento',
        'failed_only' => 'Somente recusados',
    ],
    'services' => [
        'options' => 'Opções',
        'option' => 'Opção',
        'required' => 'Serviço é obrigatório',
        'required_comment' => 'Uma opção deste serviço precisa ser selecionada quando um produto é adicionado ao carrinho.',
    ],
    'reviews' => [
        'rating' => 'Avaliação',
        'review' => 'Revisar detalhes',
        'title' => 'Título da sua avaliação',
        'pros' => 'Aspectos positivos',
        'cons' => 'Aspectos negativos',
        'anonymous' => 'Anônimo',
        'only_unapproved' => 'Mostar somente não aprovadas',
        'no_more' => 'Sem mais avaliações não aprovadas',
        'approved' => 'Avaliação aprovada',
        'approve' => 'Aprovar avaliação',
        'approve_next' => 'Aprovar e ir para a próxima',
    ],
];
