<?php
return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'E-commerce solution for October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Utwórz produkt',
            'update' => 'Aktualizuj produkt',
            'preview' => 'Podgląd produktu',
        ],
        'categories' => [
            'create' => 'Utwórz kategorię',
            'update' => 'Aktualizuj kategorię',
            'preview' => 'Podgląd kategorii',
        ],
        'orders' => [
            'show' => 'Szczegóły zamówienia',
            'export' => 'Wyeksportuj zamówienia',
        ],
        'discounts' => [
            'create' => 'Utwórz zniżkę',
            'update' => 'Edytuj zniżkę',
            'preview' => 'Podgląd zniżki',
        ],
        'services' => [
            'create' => 'Utwórz usługę',
            'update' => 'Edytuj usługę',
        ],
        'shipping_methods' => [
            'create' => 'Utwórz metodę wysyłki',
            'update' => 'Edytuj metodę wysyłki',
            'preview' => 'Podgląd metody wysyłki',
        ],
        'payment_methods' => [
            'create' => 'Utwórz metodę płatności',
            'edit' => 'Edytuj metodę płatności',
            'reorder' => 'Zmień kolejność',
        ],
        'custom_field_options' => [
            'edit' => 'Edytuj opcje pola',
        ],
        'properties' => [
            'create' => 'Utwórz właściwości',
            'edit' => 'Edytuj właściwości',
        ],
        'order_states' => [
            'create' => 'Utwórz status',
            'edit' => 'Edytuj status',
            'reorder' => 'Zmień kolejność statusów',
        ],
        'brands' => [
            'create' => 'Utwórz markę',
            'edit' => 'Edytuj markę',
        ],
        'property_groups' => [
            'create' => 'Utwórz grupę',
            'edit' => 'Edytuj grupę',
        ],
        'customer_groups' => [
            'create' => 'Utwórz grupę',
            'update' => 'Edytuj grupę',
        ],
        'notifications' => [
            'update' => 'Aktualizuj powiadomienie',
        ],
        'taxes' => [
            'create' => 'Utwórz podatek',
            'update' => 'Edytuj podatek',
        ],
        'reviews' => [
            'create' => 'Utwórz opinię',
            'update' => 'Edytuj opinię',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Wszystkie kategorie sklepu',
        'single_category' => 'Pojedyncza kategoria sklepu',
        'all_products' => 'Wszystkie produkty sklepu',
        'all_variants' => 'Wszystkie warianty sklepu',
    ],
    'currency_settings' => [
        'label' => 'Waluty',
        'description' => 'Ustaw swoje waluty',
        'currencies' => 'Wprowadzaj tylko oficjalne 3-znakowe kody walut.',
        'currency_code' => 'Kod waluty',
        'currency_decimals' => 'Miejsca dziesiętne',
        'currency_rounding' => 'Zaokrąglanie sumy',
        'currency_rounding_comment' => 'Suma wraz z podatkami jest zaokrąglana do tej wartości, jeśli ta waluta jest aktywna.',
        'currency_format' => 'Format',
        'currency_symbol' => 'Symbol',
        'currency_rate' => 'Wskaźnik',
        'is_default' => 'Jest domyślny.',
        'unknown' => 'Nieznana waluta',
    ],
    'payment_gateway_settings' => [
        'label' => 'Bramki płatnicze',
        'description' => 'Skonfiguruj Twoje bramki płatnicze',
        'stripe' => [
            'api_key' => 'Klucz API Stripe',
            'api_key_comment' => 'Możesz znaleźć ten klucz w swoim Panelu Stripe',
            'publishable_key' => 'Klucz do publikacji Stripe',
            'publishable_key_comment' => 'Możesz znaleźć ten klucz w swoim Panelu Stripe',
        ],
        'paypal' => [
            'client_id' => 'Identyfikator klienta PayPal',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Tryb testowy',
            'test_mode_comment' => 'Uruchamiaj wszystkie płatności PayPal Sandbox.',
        ],
        'postfinance' => [
            'test_mode' => 'Tryb testowy',
            'test_mode_comment' => 'Uruchamiaj wszystkie płatności w środowisku testowym',
            'pspid' => 'PSPID (Nazwa Użytkownika)',
            'hashing_method' => 'Algorytm hash',
            'hashing_method_comment' => 'Konfiguracja -> Informacja techniczna -> Globalne parametry bezpieczeństwa',
            'sha_in' => 'Podpis SHA-IN',
            'sha_in_comment' => 'Konfiguracja -> Informacja techniczna -> Weryfikacja danych i pochodzenia',
            'sha_out' => 'Podpis SHA-OUT',
            'sha_out_comment' => 'Konfiguracja -> Informacja techniczna -> Podsumowanie transakcji',
        ],
    ],
    'notification_settings' => [
        'label' => 'Powiadomienia',
        'description' => 'Skonfiguruj powiadomienia sklepu',
    ],
    'price_category_settings' => [
        'label' => 'Kategorie ceny',
        'description' => 'Skonfiguruj dodatkowe kategorie cen',
    ],
    'order_state_settings' => [
        'description' => 'Skonfiguruj stany zamówień',
    ],
    'payment_method_settings' => [
        'description' => 'Zarządzaj metodami płatności',
    ],
    'shipping_method_settings' => [
        'description' => 'Zarządzaj metodami wysyłki',
    ],
    'tax_settings' => [
        'description' => 'Zarządzaj podatkami',
    ],
    'general_settings' => [
        'category' => 'Sklep: Ogólne',
        'category_payments' => 'Sklep: Płatności',
        'category_orders' => 'Sklep: Zamówienia',
        'label' => 'Konfiguracja',
        'description' => 'Ustawienia ogólne',
        'product_page' => 'Strona szczegółów produktu',
        'product_page_comment' => 'Tutaj wyświetlają się szczegóły produktu',
        'address_page' => 'Adres strony',
        'address_page_comment' => 'Komponent addressForm musi być obecny na tej stronie',
        'checkout_page' => 'Strona Do kasy',
        'checkout_page_comment' => 'Komponent Do kasy musi być obecny na tej stronie',
        'account_page' => 'Strona konta',
        'account_page_comment' => 'Komponent Moje Konto musi byc obecny na tej stronie',
        'cart_page' => 'strona Koszyka',
        'cart_page_comment' => 'Komponent Koszyk musi byc obecny na tej stronie',
        'category_page' => 'Strona kategorii dla listy produktów',
        'redirect_to_cart' => 'Przenieś do koszyka',
        'redirect_to_cart_comment' => 'Przekieruj do koszyka kiedy użytkownik doda produkt',
        'use_state' => 'Uzyj pola Województwo/Powiat/Gmina',
        'use_state_comment' => 'Klienci muszą wybrać Województwo/Powiat/Gmina podczas rejestracji',
        'group_search_results_by_product' => 'Grupuj wyniki wyszukiwania według produktu',
        'group_search_results_by_product_comment' => 'Uwzględnij produkt tylko raz w wynikach wyszukiwania, nie wyświetlaj wszystkich pasujących wariantów',
        'shipping_selection_before_payment' => 'Wybierz metodę wysyłki PRZED płatnością podczas finalizacji zamówienia',
        'shipping_selection_before_payment_comment' => 'Domyślnie podczas realizacji transakcji użytkownik jest najpierw proszony o wybranie metody płatności przed wybraniem metody wysyłki; użyj tej opcji, aby odwrócić tę logikę',
        'admin_email' => 'Adres email administratora',
        'admin_email_comment' => 'Powiadomienia dla administratora będą wysyłane na ten adres',
        'base' => 'Ustawienia bazy',
        'links' => 'Strony CMS',
        'links_comment' => 'Wybierz, które strony są używane do wyświetlania Twoich produktów',
        'customizations' => 'Dostosuj',
        'customizations_comment' => 'Dostosuj funkcje swojego sklepu',
        'category_page_comment' => 'Dodaj komponent "products" do tej strony.',
        'order_number_start' => 'Numer pierwszego zamówienia',
        'order_number_start_comment' => 'Identyfikator początkowy pierwszego zamówienia',
        'index_driver' => 'Sterownik Index',
        'index_driver_comment' => 'Jeśli twoja baza danych obsługuje JSON, użyj sterownika bazy danych.',
        'index_driver_filesystem' => 'System plików',
        'index_driver_database' => 'Baza danych (tylko dla MySQL 5.7+ lub MariaDB 10.2+)',
        'index_driver_hint' => 'Jeśli zmienisz tę opcję, uruchom „php artisan mall:reindex” w wierszu poleceń, aby ponownie zindeksować produktys!',
    ],
    'feed_settings' => [
        'description' => 'Skonfiguruj kanały centrum handlowego',
        'google_merchant_enabled' => 'Włącz kanał Google Merchant Center',
        'google_merchant_enabled_comment' => 'Feed produktowy zostanie wygenerowany',
        'google_merchant_url' => 'Twój URL do Feeda Google Merchant',
        'google_merchant_url_locale' => 'Dodaj ?locale=xy żeby otrzymać lokalny feed.',
    ],
    'review_settings' => [
        'description' => 'Skonfiguruj recenzje',
        'enabled' => 'Recenzje włączone',
        'enabled_comment' => 'Klienci mogą tworzyć recenzje',
        'moderated' => 'Moderuj recenzje',
        'moderated_comment' => 'Nowe recenzje muszą być publikowane ręcznie przez administratora strony',
        'allow_anonymous' => 'Zezwalaj na anonimowe recenzje',
        'allow_anonymous_comment' => 'Niezarejestrowani użytkownicy mogą tworzyć recenzje',
    ],
    'common' => [
        'shop' => 'Sklep',
        'products' => 'Produkty',
        'product' => 'Produkt',
        'orders' => 'Zamowienia',
        'cart' => 'Koszyk',
        'shipping' => 'Wysyłka',
        'taxes' => 'Podatki',
        'rates' => 'Ceny',
        'inventory' => 'Katalog',
        'accessories' => 'Akcesoria',
        'shipping_methods' => 'Metody wysyłki',
        'accessory' => 'Dodatkowe',
        'custom_fields' => 'Pola niestandardowe',
        'variants' => 'Warianty',
        'variant' => 'Wariant',
        'discounts' => 'Zniżki',
        'discount' => 'Zniżka',
        'discount_percentage' => 'Zniżka (%)',
        'select_placeholder' => '-- Proszę wybrać',
        'main_image' => 'Zdjęcie główne',
        'images' => 'Zdjęcia',
        'image_set' => 'Zestaw zdjeć',
        'attachments' => 'Obrazy/Pobrane/Osadzone',
        'downloads' => 'Pobrane',
        'select_image' => 'Wybierz zdjęcie',
        'select_file' => 'Wybierz plik',
        'allowed' => 'Dozwolone',
        'not_allowed' => 'Niedozwolone',
        'yes' => 'Tak',
        'no' => 'Nie',
        'seo' => 'SEO',
        'properties_links' => 'Właściwości/Linki',
        'categories' => 'Kategorie',
        'category' => 'Kategoria',
        'meta_title' => 'Meta tytuł',
        'meta_description' => 'Meta opis',
        'meta_keywords' => 'Meta słowa kluczowe',
        'reorder' => 'Zmień kolejność wpisów',
        'id' => 'ID',
        'created_at' => 'Utworzony',
        'updated_at' => 'Zaktualizowany',
        'approved_at' => 'Zatwierdzony',
        'hide_published' => 'Ukryj datę publikacji',
        'slug' => 'URL',
        'name' => 'Nazwa',
        'display_name' => 'Wyświetlaj nazwę',
        'group_name' => 'Nazwa grupy',
        'add_value' => 'Dodaj wartość',
        'export_orders' => 'Wyeksportuj zamówienia',
        'use_backend_defaults' => 'Użyj ustawień domyślnych skonfigurowanych w ustawieniach zaplecza',
        'api_error' => 'Nie udało się zapisać rabatu. Błąd podczas wysyłania zmian do Mall API.',
        'includes_tax' => 'Zawiera podatki',
        'conditions' => 'Warunki',
        'general' => 'Ogólne',
        'logo' => 'Logo',
        'payment_gateway' => 'Bramki płatności',
        'payment_provider' => 'Dostawca Płatności',
        'payment_methods' => 'Metody płatności',
        'payment' => 'Płatność',
        'payments' => 'Płatności',
        'image' => 'Zdjęcie',
        'color' => 'Kolor',
        'unit' => 'Jednostka',
        'dont_group' => '-- Nie grupuj',
        'properties' => 'Właściwości',
        'old_price' => 'Stara cena',
        'property' => 'Właściwość',
        'property_groups' => 'Grupy właściwości',
        'property_group' => 'Grupa właściwości',
        'options' => 'Opcje',
        'option' => 'Opcja',
        'catalogue' => 'Katalog',
        'out_of_stock' => 'Ten produkt jest niedostępny.',
        'out_of_stock_short' => 'Brak w magazynie',
        'stock_limit_reached' => 'Nie możesz dodać większych ilości tego produktu do koszyka, ponieważ osiągnięto limit zapasów.',
        'deleted_at' => 'Usunięto',
        'sort_order' => 'Sortuj zamówienie',
        'order_states' => 'Statusy zamówienia',
        'website' => 'Strona internetowa',
        'brands' => 'Marki',
        'brand' => 'Marka',
        'sorting_updated' => 'Kolejność sortowania została zaktualizowana',
        'not_in_use' => 'Opcja nie jest w użyciu',
        'saved_changes' => 'Zmiany zachowane',
        'none' => '-- Żaden',
        'customers' => 'Klienci',
        'customer_groups' => 'Grypu klientów',
        'customer_group' => 'Grupa klientów',
        'product_or_variant' => 'Produkt/Wariant',
        'code' => 'Kod',
        'code_comment' => 'Ten kod może służyć do programowej identyfikacji tego rekordu',
        'checked' => 'Sprawdzone',
        'unchecked' => 'Niesprawdzone',
        'notifications' => 'Powiadomienia',
        'notification' => 'Powiadomienie',
        'price_missing' => 'Wpisz przynajmniej cenę dla domyślnej waluty',
        'slug_unique' => 'Adres URL musi być unikalny',
        'fees' => 'Opłaty',
        'value' => 'Wartość',
        'action_required' => 'Akcja wymagana!',
        'invalid_quantity' => 'Podana ilość jest nieprawidłowa',
        'addresses' => 'Adresy',
        'address' => 'Adres',
        'reference' => 'Odnieisienie',
        'session_id' => 'ID sesji',
        'message' => 'Wiadomość',
        'payment_method' => 'Metoda płatności',
        'data' => 'Data',
        'successful' => 'Pomyślnie',
        'failed' => 'Nieudane',
        'caution' => 'Uwaga',
        'since_begin' => 'Od początku',
        'weekly' => 'Tygodniowo',
        'feeds' => 'Kanały',
        'services' => 'Usługi',
        'service' => 'Usługa',
        'review' => 'Recenzja',
        'reviews' => 'Recenzje',
        'review_categories' => 'Kategorie recenzji',
        'review_category' => 'Kategoria recenzji',
        'title' => 'Tytul',
        'version' => 'Wersja',
    ],
    'variant' => [
        'method' => [
            'single' => 'Artykuł',
            'variant' => 'Warianty artykułu',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Użyj dla wariantów',
        'use_for_variants_comment' => 'Ta właściwość jest inna dla różnych wariantów tego produktu',
        'filter_type' => 'Typ filtra',
        'filter_types' => [
            'none' => 'Bez filtra',
            'set' => 'Ustaw',
            'range' => 'Zasięg',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Pole tekstowe',
        'integer' => 'Liczba całkowita',
        'float' => 'Platforma',
        'textarea' => 'Wielowierszowe pole tekstowe',
        'richeditor' => 'Tekst sformatowany',
        'dropdown' => 'Upuść',
        'checkbox' => 'Pole wyboru',
        'color' => 'Kolor',
        'image' => 'Zdjęcie',
        'switch' => 'Zamien',
        'add' => 'Dodaj opcję',
        'name' => 'Nazwa',
        'price' => 'Cena',
        'attributes' => 'Atrybut',
        'option' => 'Opcja',
        'date' => 'Data',
        'datetime' => 'Data Czas',
    ],
    'product' => [
        'user_defined_id' => 'ID produktu',
        'name' => 'Nazwa produktu',
        'published' => 'Opublikowany',
        'published_short' => 'Opubl.',
        'is_virtual' => 'Jest wirtualny',
        'is_virtual_comment' => 'Ten produkt jest wirtualny (plik, bez wysłki)',
        'product_file' => 'Plik produktu',
        'product_files' => 'Pliki produktu',
        'product_files_section_comment' => 'To jest produkt wirtualny. Możesz przesłać nowe wersje plików poniżej. Najnowsza wersja będzie dostępna do pobrania dla klientów.',
        'product_file_version' => 'wersja pliku',
        'not_published' => 'Nieopublikowany',
        'published_comment' => 'Ten produkt jest widoczny na stronie',
        'stock' => 'Zapasy',
        'price' => 'Cena',
        'description_short' => 'Krótki opis',
        'description' => 'Opis',
        'weight' => 'Waga',
        'length' => 'Długość',
        'height' => 'Wysokość',
        'width' => 'Szerokość',
        'quantity_default' => 'Domyślna ilość',
        'quantity_min' => 'Minimalna ilość',
        'quantity_max' => 'Maksymalna ilość',
        'inventory_management_method' => 'Metoda zarządzania zapasami',
        'allow_out_of_stock_purchases' => 'Zezwalaj na zakup bez zapasów',
        'allow_out_of_stock_purchases_comment' => 'Można zamówić ten produkt, nawet jeśli jest niedostępny w magazynie',
        'stackable' => 'Sortowanie w koszyku',
        'stackable_comment' => 'Jeśli ten produkt jest wielokrotnie dodawany do koszyka, pokaż tylko jeden wpis (zwiększ ilość)',
        'shippable' => 'Możliwy do wysyłki',
        'shippable_comment' => 'Ten produkt może zostać wysłany na podany adres',
        'taxable' => 'Podlegający opodatkowaniu',
        'taxable_comment' => 'Oblicz podatki od tego produktu',
        'add_currency' => 'Dodaj walutę',
        'is_taxable' => 'Użyj podatku',
        'is_not_taxable' => 'Użyj bez podatku',
        'currency' => 'Waluta',
        'general' => 'Ogólnie',
        'duplicate_currency' => 'Wprowadziłeś wiele cen dla tej samej waluty',
        'property_title' => 'Tytuł',
        'property_value' => 'Wartość',
        'link_title' => 'Tytuł',
        'link_target' => 'Docelowy adres URL',
        'embed_title' => 'Tytuł',
        'embed_code' => 'Kod do umieszczenia na stronie',
        'properties' => 'Właściwości',
        'links' => 'Linki',
        'embeds' => 'Osadzenia',
        'details' => 'Szczegóły',
        'price_includes_tax' => 'Cena zawiera podatki',
        'price_includes_tax_comment' => 'Określona cena obejmuje wszystkie podatki',
        'group_by_property' => 'Atrybut dla grupowania wariantów',
        'additional_descriptions' => 'Dodatkowe opisy',
        'additional_properties' => 'Dodatkowe właściwości',
        'gtin' => 'Global Trade Item Number (GTIN)',
        'mpn' => 'Manufacturer Part Number (MPN)',
        'price_table_modal' => [
            'trigger' => 'Edytuj wartości zapasów i cen',
            'label' => 'Cena i zapasy',
            'title' => 'Przegląd cen i zapasów',
            'currency_dropdown' => 'Waluta: ',
        ],
        'missing_category' => 'Produkt nie ma przypisanej kategorii. Wybierz kategorię poniżej, aby edytować ten produkt.',
        'variant_support_header' => 'Warianty nie wspierane',
        'variant_support_text' => 'Wybrana kategoria nie ma zdefiniowanych właściwości wariantu. Zmień metodę zarządzania zapasami na „Artykuł” lub wybierz inną kategorię.',
        'filter_virtual' => 'Pokaż tylko produkty wirtualne',
    ],
    'product_file' => [
        'display_name_comment' => 'Ta nazwa będzie widoczna dla klienta.',
        'version_comment' => 'Unikalna wersja pomaga klientowi rozpoznać zaktualizowane pliki.',
        'expires_after_days' => 'Pobranie możliwe przez',
        'expires_after_days_comment' => 'Plik można pobrać tylko przez tyle dni po zakupie. Pozostaw puste dla bezterminowego.',
        'max_download_count' => 'Maksymalna liczba pobrań',
        'max_download_count_comment' => 'Plik można pobrać tylko tyle razy. Pozostaw puste gdy bez limitu.',
        'session_required' => 'Wymagane logowanie',
        'session_required_comment' => 'Plik można pobrać tylko wtedy, gdy klient jest zalogowany (link do pobrania nie jest udostępniany).',
        'file' => 'Plik',
        'download_count' => 'Licznik pobrań',
        'errors' => [
            'invalid' => 'Niewłaściwy link pobierania',
            'expired' => 'Link pobierania wygasł',
            'too_many_attempts' => 'Zbyt wiele prób pobrania',
            'not_found' => 'Nie można znaleźć żądanego pliku, skontaktuj się z nami, aby uzyskać pomoc.',
        ],
        'hint' => [
            'intro' => 'Ten produkt nie ma dołączonego pliku. Pamiętaj, aby go dodać lub wygenerować programistycznie podczas przejścia do płatności.',
            'info_text' => 'Możesz znaleźć informacje, jak to zrobić',
            'info_link' => 'W dokumentacji',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Główny zbiór',
        'is_main_set_comment' => 'Użyj tego zdjęcia do ustawienia dla tego produktu',
        'create_new' => 'Utwórz nowy zbiór',
    ],
    'category' => [
        'name' => 'Nazwa',
        'code' => 'Kod',
        'code_comment' => 'Ten kod może być użyty do identyfikacji tej kategorii w podszablonach frontendowych.',
        'parent' => 'Nadrzędna',
        'no_parent' => 'Brak nadrzędnej',
        'inherit_property_groups' => 'Przypisz właściwości kategorii nadrzędnej',
        'inherit_property_groups_comment' => 'Użyj grup właściwości kategorii nadrzędnej tej kategorii',
        'inherit_review_categories' => 'Przypisz kategorie recenzji kategorii nadrzędnej',
        'inherit_review_categories_comment' => 'Użyj kategorii recenzji dla nadrzędnej kategorii',
        'google_product_category_id' => 'Identyfikator kategorii produktów Google',
        'google_product_category_id_comment' => 'Używany do integracji Google Merchant, zobacz https://support.google.com/merchants/answer/6324436',
    ],
    'custom_fields' => [
        'name' => 'Nazwa pola',
        'type' => 'Typ pola',
        'options' => 'Opcje',
        'required' => 'Wymagane',
        'required_comment' => 'To pole jest wymagane do złożenia zamówienia',
        'is_required' => 'Wymagane',
        'is_not_required' => 'Opcjonalne',
    ],
    'tax' => [
        'percentage' => 'Percent',
        'countries' => 'Only apply tax when shipping to these countries',
        'countries_comment' => 'If no country is selected the tax is applied worldwide.',
        'is_default' => 'Is default',
        'is_default_comment' => 'This tax is used if the shipping destination country is not known yet',
    ],
    'discounts' => [
        'name' => 'Nazwa',
        'code' => 'Kod rabatowy',
        'code_comment' => 'Pozostaw puste, aby wygenerować przypadkowy kod',
        'total_to_reach' => 'Minimalna wartość zamówienia, aby kod rabatowy był aktywny',
        'type' => 'Typ zniżki',
        'trigger' => 'Ważne jeśli',
        'rate' => 'Poziom (%)',
        'amount' => 'Stała kwota',
        'max_number_of_usages' => 'Max liczba użyć',
        'valid_from' => 'Ważny od',
        'expires' => 'Wygasa',
        'number_of_usages' => 'Liczba użyć',
        'shipping_description' => 'Nazwa alternatywnej metody wysyłki',
        'payment_method_description' => 'Wybierz metodę płatności',
        'shipping_price' => 'Cena alternatywnej metody wysyłki',
        'shipping_guaranteed_days_to_delivery' => 'Dostawa gwarantowana w dni',
        'section_type' => 'Co robi ta zniżka?',
        'section_trigger' => 'Kiedy można skorzystać z tej zniżki?',
        'types' => [
            'fixed_amount' => 'Kwota stała',
            'rate' => 'Stawka',
            'shipping' => 'Alternatywna wysyłka',
        ],
        'triggers' => [
            'total' => 'Osiągnięto sumę zamówienia',
            'code' => 'Kod rabatowy został wprowadzony',
            'product' => 'Konkretny produkt jest obecny w koszyku',
            'shipping_method' => 'Metoda wysyłki jest jedną z następujących',
            'customer_group' => 'Użytkownik należy do określonej grupy klientów',
            'payment_method' => 'W zależności od metody płatności',
        ],
        'validation' => [
            'empty' => 'Wprowadź kod promocyjny.',
            'shipping' => 'YMożesz zastosować tylko jeden kod promocyjny obniżający koszty wysyłki.',
            'duplicate' => 'Możesz użyć tego samego kodu promocyjnego tylko raz.',
            'expired' => 'Ten kod promocyjny wygasł.',
            'not_found' => 'Ten kod promocyjny jest nieprawidłowy.',
            'usage_limit_reached' => 'Ten kod promocyjny był stosowany zbyt wiele razy i dlatego nie jest już ważny.',
            'cart_limit_reached' => 'Limit kodów promocyjnych osiągnięty. Nie możesz już dodawać kodów promocyjnych do tego koszyka.',
        ],
    ],
    'payment_method' => [
        'price' => 'Opłata stała',
        'price_comment' => 'Kwota, którą należy dodać do sumy zamówienia',
        'fee_percentage' => 'Opłata wyrażona w procentach',
        'fee_percentage_comment' => 'Procent sumy, który należy dodać do sumy całkowitej zamówienia',
        'fee_label' => 'Etykieta opłaty',
        'fee_label_comment' => 'Ten tekst zostanie wyświetlony klientowi podczas wypisywania się z konta.',
        'instructions' => 'Instrukcje dotyczące płatności',
        'instructions_comment' => 'Wsparcie składni Twig. Użyj {{ order }} (zamówienia) lub {{ cart }} (koszyk) aby dotrzeć do odpowiednich informacji jeśli są dostępne',
        'pdf_partial' => 'Fragment załącznika PDF',
        'pdf_partial_comment' => 'Dla wszystkich zleceń z tą formą płatności do maila z powiadomieniem zostanie dołączony wyrenderowany PDF wybranej części.',
        'pdf_partial_none' => 'Brak załącznika PDF',
    ],
    'order' => [
        'order_number' => '# Zamówienie',
        'invoice_number' => '# Faktura',
        'payment_hash' => 'Klucz płatności',
        'customer' => 'Klient',
        'creation_date' => 'Utworzono',
        'modification_date' => 'Zmodyfikowano',
        'completion_date' => 'Ukończono',
        'credit_card' => 'Karta kredytowa',
        'payment_status' => 'Status płatności',
        'grand_total' => 'Suma całkowita',
        'billing_address' => 'Adres płatności',
        'shipping_address' => 'Adres wysyłki',
        'currency' => 'Waluta',
        'status' => 'Status',
        'email' => 'Email',
        'will_be_paid_later' => 'Zostanie opłacone później',
        'shipping_address_same_as_billing' => 'Adres wysyłki ten sam co płatności',
        'credit_card_last4_digits' => 'Ostatnie 4 cyfry',
        'tracking_number' => 'Numer śledzenia',
        'tracking_url' => 'URL śledzenia',
        'tracking_shipped' => 'Oznacz zamówienie jako wysłane',
        'tracking_shipped_comment' => 'Zamówienie zostanie oznaczone jako wysłane',
        'tracking_completed' => 'Oznacz jako ukończone',
        'tracking_completed_comment' => 'Zamówienie zostanie oznaczone jako ukończone',
        'tracking_notification' => 'Wyślij powiadomienie',
        'tracking_notification_comment' => 'Powiadomienie zawierające informacje o śledzeniu zamówienia zostanie wysłane do klienta',
        'shipping_fees' => 'Koszty wysyłkis',
        'shipping_provider' => 'Dostawca wysyłki',
        'shipping_method' => 'Metoda wysyłki',
        'card_holder_name' => 'Nazwa posiadacza karty',
        'card_type' => 'Typ karty',
        'payment_method' => 'Metoda płatności',
        'payment_gateway_used' => 'Bramka płatności',
        'tax_provider' => 'Podmiot podatkowy',
        'lang' => 'Język',
        'refunds_amount' => 'Kwota refundacji',
        'adjusted_amount' => 'Kwota skorygowana',
        'rebate_amount' => 'Kwota zwrotu',
        'total' => 'Suma',
        'taxes_total' => 'Wartość podatku',
        'items_total' => 'Wartość przedmiotów w koszyku',
        'subtotal' => 'Suma cząstkowa',
        'taxable_total' => 'Podlegające opodatkowaniu ogółem',
        'total_weight' => 'Waga całkowita',
        'total_rebate_rate' => 'Rabat całkowity',
        'notes' => 'Notatki',
        'custom_fields' => 'Pola niestandardowe',
        'shipping_enabled' => 'Wysyłka włączona',
        'payment_transaction_id' => 'ID transakcji płatności',
        'change_order_status' => 'Zmień status zamówienia',
        'change_payment_status' => 'Zmień status płatności',
        'items' => 'Przedmioty',
        'quantity' => 'Ilość',
        'shipping_address_is_same_as_billing' => 'Adres wysyłki jest taki sam jak adres do faktury',
        'update_shipping_state' => 'Aktualizacja stanu wysyłki',
        'invalid_status' => 'Wybrany status nie istnieje.',
        'updated' => 'Aktualizacja zamówienia zakończona sukcesem',
        'deleted' => 'Zamówienie zostało pomyślnie usunięte',
        'deleting' => 'Kasowanie zamówienia...',
        'delete_confirm' => 'Czy naprawdę chcesz usunąć to zamówienie?',
        'update_invoice_number' => 'Ustaw numer faktury',
        'shipped' => 'Wysłane',
        'shipping_pending' => 'Oczekuje na wysyłkę',
        'not_shipped' => 'Oczekujące',
        'data' => 'Data zamówienia',
        'total_revenue' => 'Przychody ogółem',
        'download_invoice' => 'Pobierz fakturę',
        'order_file_name' => 'zamówienie-:order',
        'virtual_product_download_hint' => 'Linki do pobrania zostaną wysłane oddzielnie, po dokonaniu płatności.',
        'modal' => [
            'cancel' => 'Anuluj',
            'update' => 'Aktualizuj informacje',
        ],
        'payment_states' => [
            'pending_state' => 'Oczekuje na płatność',
            'failed_state' => 'Płatność nie powiodła się',
            'refunded_state' => 'Dokonano zwrotu płatności',
            'paid_state' => 'Opłacone',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Dostawa gwarantowana w dni',
        'available_above_total' => 'Dostępne, jeśli suma jest większa lub równa',
        'available_below_total' => 'Dostępne, jeśli suma jest mniejsza',
        'countries' => 'Dostępne do wysyłki dla tych krajów',
        'countries_comment' => 'Jeśli nie zostanie wybrany żaden kraj, ta metoda jest dostępna na całym świecie.',
        'not_required_name' => 'Wysyłka nie jest wymagana',
        'not_required_description' => 'Produkty w koszyku nie wymagają wysyłki.',
    ],
    'payment_status' => [
        'paid' => 'Opłacone',
        'deferred' => 'Odroczone',
        'paid_deferred' => 'Płatność odroczona',
        'paiddeferred' => 'Odroczone',
        'charged_back' => 'Obciążony z powrotem',
        'refunded' => 'Zwrócone',
        'paidout' => 'Wypłacone',
        'failed' => 'Nieudane',
        'pending' => 'Oczekujące',
        'expired' => 'Wygasło',
        'cancelled' => 'Anulowane',
        'open' => 'Otwarte',
    ],
    'permissions' => [
        'manage_products' => 'Może zarządzać produktami',
        'manage_categories' => 'Może zarządzać kategoriami',
        'manage_orders' => 'Może zarządzać zamówieniami',
        'manage_discounts' => 'Może zarządzać zniżkami',
        'settings' => [
            'manage_general' => 'Może zmienić ogólne ustawienia sklepu',
            'manage_payment_gateways' => 'Może zmienić ustawienia bramki płatności',
            'manage_currency' => 'Może zmienić ustawienia waluty sklepu',
            'manage_payment_methods' => 'Może zmienić metody płatności',
        ],
        'manage_properties' => 'Może zmienić właściwości produktów',
        'manage_customer_groups' => 'Może zarządzać grupami odbiorców',
        'manage_customer_addresses' => 'Może zarządzać adresami klientów',
        'manage_notifications' => 'Może zarządzać powiadomieniami',
        'manage_price_categories' => 'Może zarządzać kategoriami cen',
        'manage_order_states' => 'Może zarządzać statusami zamówień',
        'manage_shipping_methods' => 'Może zarządzać metodami wysyłki',
        'manage_taxes' => 'Może zarządzać podatkami',
        'manage_payment_log' => 'Może zarządzać dziennikiem płatności',
        'manage_feeds' => 'Może zarządzać kanałami',
        'manage_wishlists' => 'Może zarządzać listami życzeń',
        'manage_services' => 'Może zarządzać usługami',
        'manage_reviews' => 'Może zarządzać opiniami',
        'manage_brands' => 'Może zarządzać markami',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produkty',
                'description' => 'Wyświetla listę produktów',
            ],
            'properties' => [
                'no_category_filter' => 'Nie filtruj według kategorii',
                'use_url' => 'Użyj tagu kategorii z adresu URL',
                'filter_component' => [
                    'title' => 'Alias elementu filtrującego',
                    'description' => 'Alias komponentu ProductsFilter, który filtruje ten komponent Produkty',
                ],
                'filter' => [
                    'title' => 'Łańcuch filtrów',
                    'description' => 'Wymuszony filtr dla tego komponentu',
                ],
                'include_variants' => [
                    'title' => 'Pokaż warianty artykułu',
                    'description' => 'Nie pokazuj pojedynczych produktów, ale wszystkie dostępne warianty produktów',
                ],
                'include_children' => [
                    'title' => 'Uwzględnij dzieci',
                    'description' => 'Pokaż również wszystkie produkty z kategorii dziecięcych',
                ],
                'per_page' => [
                    'title' => 'Na stronę',
                    'description' => 'Ile produktów ma być wyświetlanych na stronie',
                ],
                'paginate' => [
                    'title' => 'Paginuj',
                    'description' => 'Paginuj wyniki (pokaż więcej niż jeden na stronę)',
                ],
                'sort' => [
                    'title' => 'Sortuj',
                    'description' => 'To zastępuje preferencje sortowania użytkownika',
                ],
                'set_page_title' => [
                    'title' => 'Ustaw tytuł strony',
                    'description' => 'Użyj nazwy kategorii jako tytułu strony',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filtr produktów',
                'description' => 'Filtruje produkty z danej kategorii',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Pokaż filtr po cenie',
                ],
                'showBrandFilter' => [
                    'title' => 'Pokaż filtr po marce',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Pokaż filtr na wyprzedaży',
                ],
                'includeChildren' => [
                    'title' => 'Uwzględnij dzieci',
                    'description' => 'Uwzględnij właściwości i filtrów z produktów do kategorii dziecięcych',
                ],
                'includeVariants' => [
                    'title' => 'Uwzględnij warianty',
                    'description' => 'Pokaż filtry dla właściwości wariantu',
                ],
                'includeSliderAssets' => [
                    'title' => 'Uwzględnij noUI Slider',
                    'description' => 'Dołącz wszystkie zależności noUI Slider poprzez cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Sortuj zamówienie',
                    'description' => 'Początkowa kolejność sortowania',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Bestseller',
                'priceLow' => 'Najniższa cena',
                'priceHigh' => 'Najwyższa cena',
                'latest' => 'Najnowsze',
                'oldest' => 'Najstarsze',
                'random' => 'Losowe',
                'manual' => 'Ręcznie',
                'name' => 'Nazwa',
                'ratings' => 'Oceny',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Konto użytkownika',
                'description' => 'Wyświetla różne formy, w których użytkownik może przeglądać i edytować swój profil',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Aktywna podstrona',
                ],
            ],
            'pages' => [
                'orders' => 'Zamówienia',
                'profile' => 'Profil',
                'addresses' => 'Adresy',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Profil klienta',
                'description' => 'Wyświetla formularz edycji profilu klienta.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Wybór walut',
                'description' => 'Pokazuje opcje do wyboru aktualnie aktywnej waluty sklepu.',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Zależności frontendowe',
                'description' => 'Zawiera wszystkie potrzebne zależności frontendowe',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Lista adresów',
                'description' => 'Wyświetla listę wszystkich zarejestrowanych adresów użytkowników',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'The requested address could not be found',
                'cannot_delete_last_address' => 'You cannot delete your last address',
            ],
            'messages' => [
                'address_deleted' => 'Address deleted',
                'default_billing_address_changed' => 'Default billing address changed',
                'default_shipping_address_changed' => 'Default shipping address changed',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Lista zamówień',
                'description' => 'Wyświetla listę wszystkich zamówień klienta',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Szczegóły produktu',
                'description' => 'Wyświetla szczegóły produktu',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Przekierowanie przy zmianie właściwości',
                    'description' => 'Redirect the user to the new detail page if a property was changed',
                ],
            ],
            'added_to_cart' => 'Pomyślnie dodano produkt',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Recenzje produktu',
                'description' => 'Wyświetla recenzje produktu',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Liczba recenzji na stronie',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Pokaż tylko oceny tego wariantu',
                    'description' => "Nie pokazuj opinii o innych wariantach tego produktu",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Koszyk',
                'description' => 'Wyświetla koszyk',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Pokaż zniżkę',
                ],
                'discountCodeLimit' => [
                    'title' => 'Limit kodów rabatowych',
                    'description' => 'Ustaw na 0 dla nieograniczonej liczby kodów',
                ],
                'showShipping' => [
                    'title' => 'Pokaż koszt wysyłki',
                ],
                'showTaxes' => [
                    'title' => 'Pokaż podatki',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Pokaż przycisk przejdź do kasy',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Do kasy',
                'description' => 'Obsługuje proces finalizacji zamówienia',
            ],
            'errors' => [
                'missing_settings' => 'Wybierz metodę płatności i wysyłki.',
            ],
            'properties' => [
                'step' => [
                    'name' => 'Aktywny etap finalizacji zamówienia (ustawiany automatycznie)',
                ],
            ],
        ],
        'quickCheckout' => [
            'details' => [
                'name' => 'Szybka finalizacja zamówienia',
                'description' => 'Proces realizacji transakcji na jednej stronie',
            ],
            'errors' => [
                'signup_failed' => 'Nie udało się utworzyć konta użytkownika.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Wprowadzanie kodu promocyjnego',
                'description' => 'Wyświetla pole do wprowadzania kodu promocyjnego',
            ],
            'discount_applied' => 'Zniżka została zastosowana pomyślnie!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Wybór wysyłki',
                'description' => 'Wyświetla listę wszystkich dostępnych metod wysyłki',
            ],
            'errors' => [
                'unavailable' => 'Wybrana metoda wysyłki nie jest dostępna dla Twojego zamówienia.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Wybór metody płatności',
                'description' => 'Wyświetla listę wszystkich dostępnych metod płatności',
            ],
            'errors' => [
                'unavailable' => 'Wybrana metoda płatności nie jest dostępna dla Twojego zamówienia.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Wybór adresu do wysyłki',
                'description' => 'Wyświetla listę wszystkich istniejących adresów użytkowników',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formularz adresowy',
                'description' => 'Wyświetla formularz do edycji adresu użytkownika',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Adres',
                ],
                'redirect' => [
                    'title' => 'Przekieruj (po zapisaniu)',
                ],
                'set' => [
                    'title' => 'Użyj tego adresu jako',
                ],
            ],
            'redirects' => [
                'checkout' => 'Strona finalizacji zamówienia',
            ],
            'set' => [
                'billing' => 'Adres do faktury',
                'shipping' => 'Adres do wysyłki',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Zapisz się',
                'description' => 'Wyświetla formularz rejestracji i logowania',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Przekieruj po zalogowaniu',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Próbujesz zalogować się na konto gościa.',
                'unknown_user' => 'Wprowadzone dane logowania są nieprawidłowe.',
                'not_activated' => 'Twoje konto musi być aktywowane, zanim będziesz mógł się zalogować.',
                'login' => [
                    'required' => 'Wprowadź adres email.',
                    'email' => 'Wprowadź prawidłowy adres email.',
                    'between' => 'Wprowadź prawidłowy adres email.',
                ],
                'password' => [
                    'required' => 'Wprowadź hasło',
                    'max' => 'Podane hasło jest zbyt długie.',
                    'min' => 'Podane hasło jest zbyt krótkie. Proszę wprowadzić co najmniej 8 znaków.',
                ],
                'password_repeat' => [
                    'required' => 'Powtórz hasło.',
                    'same' => 'Wprowadzone hasła nie sa identyczne',
                ],
                'email' => [
                    'required' => 'Wprowadź adres e-mail.',
                    'email' => 'Adres email jest nieprawidłowy.',
                    'unique' => 'Użytkownik o tym adresie email jest już zarejestrowany.',
                    'non_existing_user' => 'Użytkownik o tym adresie e-mail jest już zarejestrowany. Użyj funkcji resetowania hasła.',
                ],
                'firstname' => [
                    'required' => 'Wprowadź imię.',
                ],
                'lastname' => [
                    'required' => 'Wprowadź nazwisko.',
                ],
                'lines' => [
                    'required' => 'Wprowadź  adres.',
                ],
                'zip' => [
                    'required' => 'Wprowadź kod pocztowy.',
                ],
                'city' => [
                    'required' => 'Wprowadź miasto.',
                ],
                'country_id' => [
                    'required' => 'Wybierz kraj.',
                    'exists' => 'Wybrany kraj jest nieprawidłowy.',
                ],
                'state_id' => [
                    'required' => 'Wybierz województwo',
                    'exists' => 'Wybrana wartośc jest nieprawidłowa.',
                ],
                'terms_accepted' => [
                    'required' => 'Zaakceptuj Regulamin i Politykę Prywatności.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Kategorie',
                'description' => 'Wyświetla dostępne kategorie',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Rozpocznij od kategorii',
                    'description' => 'Pokaż tylko kategorie podrzędne tej kategorii',
                ],
                'categorySlug' => [
                    'title' => 'Parametr slug kategorii',
                    'description' => 'Użyj tego parametru, aby załadować kategorię nadrzędną z adresu url',
                ],
                'categoryPage' => [
                    'title' => 'Strona kategorii',
                    'description' => 'Linki będą wskazywać na tę stronę. Jeśli nic nie zostanie wprowadzone, zostaną użyte ustawienia domyślne z ustawień backendowych.',
                ],
            ],
            'no_parent' => 'Pokaż wszystkie kategorie',
            'by_slug' => 'Użyj kategorii w adresie URL jako nadrzędnej',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Podsumowanie koszyka',
                'description' => 'Wyświetla liczbę produktów w koszyku i całkowitą wartość koszyka',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Pokaż liczbę produktów',
                    'description' => 'Wyświetla liczbę przedmiotów w koszyku',
                ],
                'showTotalPrice' => [
                    'title' => 'Pokaż sumę całkowitą',
                    'description' => 'Pokaż sumę całkowita wszystkich produktów w koszyku',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Panel klienta',
                'description' => 'Wyświetl link dla klienta do logowania i zmiany ustawień konta',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'CEtykieta panelu klienta',
                    'description' => 'Link text for the customer account page',
                ],
                'logoutLabel' => [
                    'title' => 'Logout label',
                    'description' => 'Tekst linku do strony konta klienta',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Komponent ulepszonego ecommerce (UA)',
                'description' => 'Implementuje wartstwę danych Google Tag Manager',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Przycisk lista życzeń',
                'description' => 'Wyświetla przycisk listy życzeń',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produkt',
                    'description' => 'ID produktu',
                ],
                'variant' => [
                    'name' => 'Wariant',
                    'description' => 'ID wariantu',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Lista życzeń',
                'description' => 'Wyświetla zarządzanie listą życzeń',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Pokaż wysyłkę',
                    'description' => 'Pokaż koszt i opcje wysyłki',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'Od (Waga w gramach)',
        'to_weight' => 'Do (Waga w gramach)',
    ],
    'products' => [
        'variants_comment' => 'Utwórz różne warianty tego samego produktu',
    ],
    'order_states' => [
        'name' => 'Nazwa',
        'description' => 'Opis',
        'color' => 'Kolor',
        'flag' => 'Specjalne oznaczenie',
        'flags' => [
            'new' => 'Ustaw status zamówienia jako "nowe"',
            'complete' => 'Ustaw status zamówienia jako "zrealizowane"',
            'cancelled' => 'Ustaw status zamówienia jako "anulowane"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Ten kod można zostać użyty do identyfikacji tej grupy programistycznie',
        'discount_comment' => 'Nadaj tej grupie klientów określoną zniżkę w % na cały Twój katalog',
    ],
    'order_status' => [
        'processed' => 'Przetworzone',
        'disputed' => 'W trakcie sporu',
        'shipped' => 'Wysłane',
        'delivered' => 'Dostarczone',
        'pending' => 'Oczekujące',
        'cancelled' => 'Anulowane',
    ],
    'notifications' => [
        'enabled' => 'Włączone',
        'enabled_comment' => 'To powiadomienie jest włączone',
        'template' => 'Szablon maila',
    ],
    'payment_log' => [
        'payment_data' => 'Dane płątności',
        'data_comment' => 'Te dane zostały dostarczone przez dostawcę Płatności',
        'order_data_comment' => 'To są wszystkie dane zamówienia dla tej płatności',
        'message_comment' => 'Te wiadomość została dostarczona przez dostawcę Płatności',
        'code_comment' => 'Ten kod został dostarczony przez dostawcę Płatności',
        'failed_only' => 'Niepowodzenie',
    ],
    'services' => [
        'options' => 'Opcje',
        'option' => 'Opcja',
        'required' => 'Usługa jest wymagana',
        'required_comment' => 'Jedna opcja tej usługi musi zostać wybrana kiedy produkt zostaje dodany do koszyka.',
    ],
    'reviews' => [
        'rating' => 'Oceny',
        'review' => 'Szczegóły opinii',
        'title' => 'Tytuł Twojej opinii',
        'pros' => 'Zalety',
        'cons' => 'Wady',
        'anonymous' => 'Anonimowo',
        'only_unapproved' => 'Pokaż tylko niezatwierdzone',
        'no_more' => 'Brak niezatwierdzonych opinii',
        'approved' => 'Opinia zatwierdzona',
        'approve' => 'Zatwierdź opinię',
        'approve_next' => 'Zatwierdź i przejdź do następnej',
    ],
];