<?php return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'E-commerce solution for October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'ایجاد محصول',
            'update' => 'ویرایش محصول',
            'preview' => 'نمایش محصول',
        ],
        'categories' => [
            'create' => 'ایجاد دسته بندی',
            'update' => 'ویرایش دسته بندی',
            'preview' => 'نمایش دسته بندی',
        ],
        'orders' => [
            'show' => 'جزئیات سفارش',
            'export' => 'برون ریزی سفارش',
        ],
        'discounts' => [
            'create' => 'ایجاد تخفیف',
            'update' => 'ویرایش تخفیف',
            'preview' => 'نمایش تخفیف',
        ],
        'services' => [
            'create' => 'ایجاد سرویس',
            'update' => 'ویرایش سرویس',
        ],
        'shipping_methods' => [
            'create' => 'ایجاد روش ارسال',
            'update' => 'ویرایش روش ارسال',
            'preview' => 'نمایش روش ارسال',
        ],
        'payment_methods' => [
            'create' => 'ایجاد روش پرداخت',
            'edit' => 'ویرایش روش پرداخت',
            'reorder' => 'مرتب سازی',
        ],
        'custom_field_options' => [
            'edit' => 'ویرایش فیلد گزینه ها',
        ],
        'properties' => [
            'create' => 'ایجاد ویژگی',
            'edit' => 'ویرایش ویژگی',
        ],
        'order_states' => [
            'create' => 'ایجاد وضعیت',
            'edit' => 'ویرایش وضعیت',
            'reorder' => 'مرتب سازی ویژگی',
        ],
        'brands' => [
            'create' => 'ایجاد برند',
            'edit' => 'ویرایش برند',
        ],
        'property_groups' => [
            'create' => 'ایجاد گروه',
            'edit' => 'ویرایش گروه',
        ],
        'customer_groups' => [
            'create' => 'ایجاد گروه',
            'update' => 'ویرایش گروه',
        ],
        'notifications' => [
            'update' => 'بروز رسانی اعلان',
        ],
        'taxes' => [
            'create' => 'ایجاد مالیات',
            'update' => 'بروز رسانی مالیات',
        ],
        'reviews' => [
            'create' => 'ایجاد نمایش',
            'update' => 'ویرایش نمایش',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'همه دسته بندی های فروشگاه',
        'single_category' => 'تک دسته بندی فروشگاه',
        'all_products' => 'همه محصولات',
        'all_variants' => 'همه محصولات متغیر',
    ],
    'currency_settings' => [
        'label' => 'واحدهای ارزی',
        'description' => 'تنظیم واحدهای ارزی',
        'currencies' => ' فقط سه کاراکتر رسمتی برای کد ارز وارد کنید',
        'currency_code' => 'کد واحد ارز',
        'currency_decimals' => 'محل دسیمال',
        'currency_format' => 'فرمت',
        'currency_symbol' => 'سمبل',
        'currency_rate' => 'نرخ',
        'is_default' => 'پیشفرض ',
        'unknown' => 'واحد ارزی ناشناس',
    ],
    'payment_gateway_settings' => [
        'label' => 'درگاه پرداخت',
        'description' => 'راه اندازی درگاه پرداخت',
        'stripe' => [
            'api_key' => 'Stripe API Key',
            'api_key_comment' => 'You can find this key in your Stripe Dashboard',
            'publishable_key' => 'Stripe Publishable Key',
            'publishable_key_comment' => 'You can find this key in your Stripe Dashboard',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'حالت آزمایشی',
            'test_mode_comment' => 'Run all payments in the PayPal Sandbox.',
        ],
        'postfinance' => [
            'test_mode' => 'حالت آزمایشی',
            'test_mode_comment' => 'Run all payments against the test environment',
            'pspid' => 'PSPID (Username)',
            'hashing_method' => 'Hash algorithm',
            'hashing_method_comment' => 'Configuration -> Technical information -> Global security parameters',
            'sha_in' => 'SHA-IN Signature',
            'sha_in_comment' => 'Configuration -> Technical information -> Data and origin verification',
            'sha_out' => 'SHA-OUT Signature',
            'sha_out_comment' => 'Configuration -> Technical information -> Transaction feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'اعلان ها',
        'description' => 'تنظیمات اعلانات فروشگاه',
    ],
    'price_category_settings' => [
        'label' => 'دسته بندی های قیمت',
        'description' => ' تنظیمات دسته بندی های قیمت اضافی',
    ],
    'order_state_settings' => [
        'description' => ' تنظیمات وضعیت سفارش',
    ],
    'payment_method_settings' => [
        'description' => ' مدیریت روش های پرداخت',
    ],
    'shipping_method_settings' => [
        'description' => ' مدیریت روش های ارسال',
    ],
    'tax_settings' => [
        'description' => ' مدیریت مالیات',
    ],
    'general_settings' => [
        'category' => 'Mall: عمومی',
        'category_payments' => 'Mall: پرداخت ها',
        'category_orders' => 'Mall: سفارش ها',
        'label' => 'تنظیمات',
        'description' => 'تنظیمات عمومی',
        'product_page' => 'صفحه جزئیات محصول',
        'product_page_comment' => 'اینجا جایی است که جزئیات محصول قابل نمایش است',
        'address_page' => 'صفحه آدرس',
        'address_page_comment' => 'کامپوننت فرم آدرس در این صفحه قابل نمایش است',
        'checkout_page' => 'صفحه پرداخت',
        'checkout_page_comment' => ' کامپوننت پرداخت در این صفحه قابل نمایش است',
        'account_page' => 'صفحه حساب کاربری',
        'account_page_comment' => 'کامپوننت حساب کاربری در این صفحه قابل نمایش اس',
        'cart_page' => 'صفحه سبدخرید',
        'cart_page_comment' => 'کامپوننت سبدخرید در این صفحه قابل نمایش است',
        'category_page' => 'صفحه دسته بندی برای فهرست کردن محصولات',
        'redirect_to_cart' => 'انتقال به سبد خرید',
        'redirect_to_cart_comment' => ' ریدایرکت به سبد بعد از اینکه محصولی به سبد اضافه شد',
        'use_state' => ' استفاده از فیلد استان/ایالت',
        'use_state_comment' => 'مشتریان مجبور به انتخاب استان/ایالت در هنگام ثبت نام باشند',
        'group_search_results_by_product' => ' گروه بندی نتیجه جستجو براساس محصول ',
        'group_search_results_by_product_comment' => 'فقط یک بار در نتایج جستجو یک محصول را نمایش دهد ، تمام متغیرهای مطابق با آنها نمایش داده نشود',
        'shipping_selection_before_payment' => 'Select shipping method BEFORE payment during checkout',
        'shipping_selection_before_payment_comment' => 'By default, during checkout, the user is first asked to select a payment method before selecting a shipping method; use this option to reverse this logic',
        'admin_email' => 'ایمیل مدیریت',
        'admin_email_comment' => 'اعلان های مدیریت به این آدرس ایمیل ارسال می شوند',
        'base' => 'تنظمیات پایه',
        'links' => 'صفحات مدیریت محتوا',
        'links_comment' => ' صفحاتی که برای نمایش محصولات استفاده می شود .تغییر دهید',
        'customizations' => 'شخصی سازی',
        'customizations_comment' => ' شخصی سازی ویژگیهای از فروشگاه شما',
        'category_page_comment' => '  افزودن کامپوننت "محصولات"  به این صفحه',
        'order_number_start' => 'شماره اول سفارش ',
        'order_number_start_comment' => '  شناسه ابتدای اول شماره سفارش',
        'index_driver' => ' درایور ایندکس',
        'index_driver_comment' => ' اگر پایگاه داده شما جی سون  را پشتیبانی می کند . از درایور پایگاه داده استفاده کنید',
        'index_driver_filesystem' => ' سیستم فایل',
        'index_driver_database' => 'Database (only for MySQL 5.7+ or MariaDB 10.2+)',
        'index_driver_hint' => 'If you change this option make sure to run "php artisan mall:reindex" on the command line to re-index your products!',
    ],
    'feed_settings' => [
        'description' => 'تنظیمات خوراک mall',
        'google_merchant_enabled' => 'Enable Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'A product feed will be generated یک خوراک محصول تولید شد',
        'google_merchant_url' => 'Your Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Add ?locale=xy to get a localized feed.',
    ],
    'review_settings' => [
        'description' => ' تنظیمات دیدگاه ها ',
        'enabled' => 'دیدگاه فعال شد',
        'enabled_comment' => ' مشتریان می توانند دیدگاه 
        کنند',
        'moderated' => 'مدیریت دیدگاه ها',
        'moderated_comment' => ' دیدگاه جدید به صورت دستی توسط مدیریت سایت انتشار می شود',
        'allow_anonymous' => ' دیدگاه ناشناس مجاز ',
        'allow_anonymous_comment' => 'کاربران عضو نشده  می توانند دیدگاه ایجاد کنند',
    ],
    'common' => [
        'shop' => 'فروشگاه',
        'products' => 'محصولات',
        'product' => 'محصول',
        'orders' => 'سفارش ها',
        'cart' => 'سبدخرید',
        'shipping' => 'ارسال',
        'taxes' => 'مالیات ها',
        'rates' => 'نرخ ها',
        'inventory' => 'اقلام',
        'accessories' => 'لوازم جانبی ها',
        'shipping_methods' => 'روش های ارسال',
        'accessory' => 'لوازم جانبی',
        'custom_fields' => 'فیلد سفارشی',
        'variants' => 'متغیرها',
        'variant' => 'متغیر',
        'discounts' => 'تخفیفات',
        'discount' => 'تخفیف',
        'discount_percentage' => 'تخفیف (%)',
        'select_placeholder' => '-- لطفا انتخاب کن',
        'main_image' => 'عکس اصلی',
        'images' => 'عکس ها',
        'image_set' => 'مجموعه عکس',
        'attachments' => 'عکس ها/دانلودها/تعبیه شده',
        'downloads' => 'دانلود ها',
        'select_image' => 'تعییر عکس',
        'select_file' => 'تغییر فایل',
        'allowed' => 'مجاز',
        'not_allowed' => 'غیر مجاز',
        'yes' => 'بله',
        'no' => 'غیر',
        'seo' => 'سئو',
        'properties_links' => 'ویژگی ها/پیوندها',
        'categories' => 'دسته بندی ها',
        'category' => 'دسته بندی',
        'meta_title' => 'عنوان متا',
        'meta_description' => 'توضیحات متا',
        'meta_keywords' => 'کلمات کلیدی متا',
        'reorder' => 'مرتب سازی ورودی ها',
        'id' => 'شناسه',
        'created_at' => 'ایجاد شده در',
        'updated_at' => 'بروزرسانی شده در',
        'approved_at' => 'تایید شده در',
        'hide_published' => 'مخفی سازی انتشار',
        'slug' => 'URL',
        'name' => 'نام',
        'display_name' => 'نمایش نام',
        'group_name' => 'نمایش گروه',
        'add_value' => 'افزودن مقدار',
        'export_orders' => 'برون ریزی سفارش ها',
        'use_backend_defaults' => ' استفاده از تنظمیات پیش فرض در تنظیمات بک اند',
        'api_error' => ' نمی توان تخفیف را ذخیرکرد.خطا برای ارسال تغییرات به ای پی آ فروشگاه',
        'includes_tax' => ' مشمول مالیات',
        'conditions' => 'شرایط',
        'general' => 'عمومی',
        'logo' => 'لگو',
        'payment_gateway' => 'درگاه پرداخت',
        'payment_provider' => 'سرویس دهنده پرداخت',
        'payment_methods' => 'روش های پرداخت',
        'payment' => 'پرداخت',
        'payments' => 'پرداخت ها',
        'image' => 'عکس',
        'color' => 'رنگ',
        'unit' => 'واح',
        'dont_group' => '-- Do not group',
        'properties' => 'ویژگی ها',
        'old_price' => ' قیمت قدیمی',
        'property' => 'ویژگی',
        'property_groups' => 'گروه های ویژگی',
        'property_group' => 'گروه ویژگی',
        'options' => 'گزینه ها',
        'option' => 'گزینه',
        'catalogue' => 'فروشگاه',
        'out_of_stock' => 'هیچ تعدادی از این محصول موجود نیست.',
        'out_of_stock_short' => 'ناموجود',
        'stock_limit_reached' => ' شما نمی توانید اقلامی از این محصول را به سبد اضافه کنید .زیرا تعداد درخواستی محدود یا ناموجود است',
        'deleted_at' => 'حذف شده در',
        'sort_order' => 'مرتب سازی سفارش',
        'order_states' => 'وضعیت های سفارش',
        'website' => 'وبسایت',
        'brands' => 'برندها',
        'brand' => 'برند',
        'sorting_updated' => 'مرتب سازی سفارش بروز رسانی شد',
        'not_in_use' => 'گزینه ای برای استفاده موجود نیست',
        'saved_changes' => 'ذخیره تغییرات با موفقیت انجام شد',
        'none' => '-- هیچ',
        'customers' => 'مشتری ها',
        'customer_groups' => 'گروه های مشتری',
        'customer_group' => 'گروه مشتری',
        'product_or_variant' => 'محصول/محصول متغییر',
        'code' => 'کد',
        'code_comment' => 'این کد می تواند برای شناسایی یک رکورد استفاده شود',
        'checked' => 'انتخاب شده',
        'unchecked' => 'انتخاب نشده',
        'notifications' => 'اعلان ها',
        'notification' => 'اعلان',
        'price_missing' => ' حداقل یک قیمت برای ارز پیشفرض وارد کنید',
        'slug_unique' => 'این آدرس باید منحصر به فرد باشد',
        'fees' => 'هزینه',
        'value' => 'مقدار',
        'action_required' => 'اقدام لازم است!',
        'invalid_quantity' => 'مقدار مشخص شده معتبر نیست ',
        'addresses' => 'آدرس ها',
        'address' => 'آدرس',
        'reference' => 'مرجع',
        'session_id' => 'شناسه سشن',
        'message' => 'پیام',
        'payment_method' => 'روش پرداخت',
        'data' => 'داده',
        'successful' => 'موفق',
        'failed' => 'ناموفق',
        'caution' => 'هشدار',
        'since_begin' => 'از شروغ',
        'weekly' => 'هفتگی',
        'feeds' => 'خوراک',
        'services' => 'سرویس ها',
        'service' => 'سرویس',
        'review' => 'دیدگاه',
        'reviews' => 'دیدگاه ها',
        'review_categories' => 'دسته بندی های دیدگاه',
        'review_category' => 'دسته دیدگاه',
        'title' => 'عنوان',
        'version' => 'ورژن',
    ],
    'variant' => [
        'method' => [
            'single' => 'محصول ساده',
            'variant' => 'محصول متغیر',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'استفاده بعنوان متغیر ها',
        'use_for_variants_comment' => ' این ویژگی متفاوت است برای  متغیر های مختلفی از این محصول ',
        'filter_type' => 'نوع فیلتر',
        'filter_types' => [
            'none' => ' بدون فیلتر',
            'set' => 'مجموعه',
            'range' => 'رنج',
        ],
    ],
    'custom_field_options' => [
        'text' => 'فیلد رشته ای',
        'integer' => 'عددی',
        'float' => 'اعشاری',
        'textarea' => 'فیلد رشته ای چند خطی',
        'richeditor' => 'متن بلند',
        'dropdown' => 'آبشاری',
        'checkbox' => 'چک باکس',
        'color' => 'رنگ',
        'image' => 'عکس',
        'add' => 'افزودن گزینه',
        'name' => 'نام',
        'price' => 'قیمت',
        'attributes' => 'ویژگی',
        'option' => 'گزینه',
    ],
    'product' => [
        'user_defined_id' => 'شناسه محصول',
        'name' => 'نام محصول',
        'published' => 'منتشرشده',
        'published_short' => 'Publ.',
        'is_virtual' => 'مجازی',
        'is_virtual_comment' => ' (a file, no shipping) این محصول مجازی است ',
        'product_file' => 'فایل محصول',
        'product_files' => 'فایل های محصول',
        'product_files_section_comment' => ' این یک محصول مجازی است،شما می توانید ورژن جدید را بارگزاری کنید،جدیدترین ورژن قابل دانلود برای کاربر است.',
        'product_file_version' => 'ورژن فایل',
        'not_published' => 'منتشر نشده',
        'published_comment' => ' این محصول قابل نمایش در سایت است',
        'stock' => 'تعداد',
        'price' => 'قیمت',
        'description_short' => 'توضیحات کوتاه',
        'description' => 'توضیحات',
        'weight' => 'وزن (g)',
        'length' => 'طول (mm)',
        'height' => 'ارتفاع (mm)',
        'width' => 'عرض (mm)',
        'quantity_default' => 'تعداد پیشفرض',
        'quantity_min' => 'کمترین تعداد',
        'quantity_max' => 'بیشترین تعداد',
        'inventory_management_method' => 'روش مدیریت اقلام',
        'allow_out_of_stock_purchases' => 'خرید مجاز ، درصورت ناموجود بودن',
        'allow_out_of_stock_purchases_comment' => ' این محصول قابل سفارش است حتی اگر ناموجود باشد',
        'stackable' => 'موجود در سبد',
        'stackable_comment' => ' اگر این محصول به سبدخرید اضافه شود، به هر تعداد، فقط یک قلم از آن نمایش و خرید است',
        'shippable' => 'شامل ارسال',
        'shippable_comment' => ' قابلیت ارسال برای این محصول',
        'taxable' => ' شامل مالیات',
        'taxable_comment' => 'محاسبه مالیات برای این محصول',
        'add_currency' => ' افزودن ارز',
        'is_taxable' => 'استفاده از مالیات',
        'is_not_taxable' => 'عدم استفاده از مالیات',
        'currency' => 'واحد ارز',
        'general' => 'عمومی',
        'duplicate_currency' => 'شما تعدادی قیمت برای یک ارز یکسان وارد کرده اید',
        'property_title' => 'عنوان',
        'property_value' => 'مقدار',
        'link_title' => 'عنوان',
        'link_target' => 'Target URL',
        'embed_title' => 'عنوان',
        'embed_code' => 'کد تعبیه شده',
        'properties' => 'ویژگی ها',
        'links' => 'پیوند ها',
        'embeds' => 'تعبیه شده ها',
        'details' => 'جزئیات',
        'price_includes_tax' => ' قیمت شامل مالیات باشد',
        'price_includes_tax_comment' => ' تعریف قیمت شامل همه مالیات ها',
        'group_by_property' => ' ویژگی برای گروه بندی متغیر',
        'additional_descriptions' => 'توضیحات اضافی',
        'additional_properties' => 'ویژگی های اضافی',
        'gtin' => 'شماره کالای تجارت جهانی (GTIN)',
        'mpn' => 'شماره قطعه تولید کننده (MPN)',
        'price_table_modal' => [
            'trigger' => ' ویرایش تعداد و قیمت ',
            'label' => ' قیمت و تعداد',
            'title' => ' خلاصه قیمت و تعداد',
            'currency_dropdown' => 'ارز: ',
        ],
        'missing_category' => '.هیچ دسته بندی برای این محصول انتخاب نشده است، لطفا یک دسته انتخاب برای ویرایش محصول انتخاب کنید',
        'variant_support_header' => ' متغیر پشتیبانی نمی شود',
        'variant_support_text' => 'هیچ دسته ای برای ویژگی های متغیر تعریف نشده است، لطفا به محصول ساده تغییر دهید یا به دسته دیگری   تغییر دهید. ',
        'filter_virtual' => ' نمایش فقط محصولات مجازی',
    ],
    'product_file' => [
        'display_name_comment' => '.  این نام قابل نمایش برای مشتری است',
        'version_comment' => '.یک ورژن واحد به کاربر کمک می کند تا فایل های بروز شده را شناسایی کند',
        'expires_after_days' => ' دانلود معتبر برای تعداد روز',
        'expires_after_days_comment' => '.  این فایل قابل دانلود است برای تعداد روز بعد از خرید، برای نامحدود بودن، باید خالی باشد',
        'max_download_count' => ' تعداد حداکثر برای دانلودها',
        'max_download_count_comment' => ' این فایل قابل دانلو است به تعداد، برای نامحدود بودن، باید خالی باشد',
        'session_required' => ' ورود لازم است',
        'session_required_comment' => ' (download link is not shareable). این فایل فقط هنگامی قابل دانلود است که مشتری وارد سایت شود',
        'file' => ' فایل',
        'download_count' => 'شماره دانلود',
        'errors' => [
            'invalid' => 'لینک دانلود معتبر نیست',
            'expired' => ' لینک دانلود منقضی شده',
            'too_many_attempts' => ' تعداد زیاد تلاش برای دانلود',
            'not_found' => '. نمی توان فایل دانلودی شما را پیدا کرد، لطفا برای پشتیبانی با ما در ارتباط باشید',
        ],
        'hint' => [
            'intro' => ' این محصول هیچ فایل العاق نشده است، لطفا مطمئن باشد که یک فایل اضافه کنید یا در هنگام پرداخت اضافه شود',
            'info_text' => 'You can find information on how to do this',
            'info_link' => ' در مستندات',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'مجموعه اصلی است',
        'is_main_set_comment' => 'استفاده این مجموعه عکس برای این محصول',
        'create_new' => 'ایجاد مجموعه جدید',
    ],
    'category' => [
        'name' => 'نام',
        'code' => 'کد',
        'code_comment' => ' این کد می تواند به عنوان شناسه دسته در فرنت اند استفاده شود',
        'parent' => ' والد',
        'no_parent' => ' بدون والد',
        'inherit_property_groups' => ' ارث بری ویژگی ها از دسته والد',
        'inherit_property_groups_comment' => ' استفاده گروه های  ویژگی  از والد این دسته ',
        'inherit_review_categories' => 'ارث بری دسته بندی های دیدگاه از دسته والد',
        'inherit_review_categories_comment' => ' استفاده دسته بندی های دیدگاه از والد  دسته بندی',
    ],
    'custom_fields' => [
        'name' => 'نام فیلد',
        'type' => 'نوع فیلد',
        'options' => 'گزینه ها',
        'required' => 'لازم است',
        'required_comment' => ' این فیلد برای سفارش لازم است',
        'is_required' => ' لازم است',
        'is_not_required' => ' لازم نیست',
    ],
    'tax' => [
        'percentage' => 'درصد',
        'countries' => ' مالیات فقط زمانی که در این کشورها ارسال شود،قابل اعمال است',
        'countries_comment' => ' اگر کشوری انتخاب نشده باشد ، مالیات برای سراسر جهان قابل اعمال است',
        'is_default' => 'پیشفرض است',
        'is_default_comment' => 'این مالیات استفاده می شود، اگر کشور مقصد حل ناشناس باشد',
    ],
    'discounts' => [
        'name' => 'نام',
        'code' => 'کد تخفیف',
        'code_comment' => ' برای تولید کد تضادفی ، خالی باشد',
        'total_to_reach' => ' حداقل تعداد سفارش برای معتبر سازی این کد تخفیف',
        'type' => 'نوع تخفیف',
        'trigger' => 'Valid if معتبر است اگر',
        'rate' => 'نرخ (%)',
        'amount' => 'قیمت ثابت',
        'max_number_of_usages' => 'تعداد قابل استفاده',
        'valid_from' => 'معتبراست از',
        'expires' => 'منقضی',
        'number_of_usages' => 'تعداد موارد استفاده',
        'shipping_description' => 'نام  روش ارسال جایگزین ',
        'shipping_price' => 'قیمت روش ارسال جایگزین ',
        'shipping_guaranteed_days_to_delivery' => ' روز های تضمین شده برای تحویل',
        'section_type' => 'این کد تخفیف چیکار می کند?',
        'section_trigger' => 'چه زمانی این کد تخفیف اعمال شود?',
        'types' => [
            'fixed_amount' => 'قیمت ثابت',
            'rate' => 'نرخ',
            'shipping' => 'ارسال جایگزین',
        ],
        'triggers' => [
            'total' => 'کل سفارشات رسیده است',
            'code' => 'کد تخفیف وارد شده',
            'product' => 'یک محصول خاص موجود در سبدخرید',
        ],
        'validation' => [
            'empty' => '.کد تخفیف را وارد کنید',
            'shipping' => ' .شما می توانید فقط یک کد تخفیف استفاده کنید که هزینه ارسال شما را کاهش دهد',
            'duplicate' => '.شما می توانید یکبار از این کد استفاده کنید',
            'expired' => '.این کد تخفیف منقضی شده',
            'not_found' => '.این کد معتبر نیست',
            'usage_limit_reached' => '.این کد به تعداد زیاد استفاده شد، معتبر نمی باشد',
        ],
    ],
    'payment_method' => [
        'price' => ' هزینه ثابت',
        'price_comment' => ' این هزینه به جمع سفارش افزوده می شود',
        'fee_percentage' => ' درصد هزینه',
        'fee_percentage_comment' => 'درصدی از جمع کل که به جمع سفارش اضافه شودد',
        'fee_label' => ' برچسب هزینه',
        'fee_label_comment' => ' این متن در هنگام پرداخت به مشتری نمایش داده می شود',
        'instructions' => ' دستورالعمل پرداخت',
        'instructions_comment' => 'Twig syntax supported. Use {{ order }} or {{ cart }} to access corresponding information if available',
        'pdf_partial' => 'PDF بخش پیوست',
        'pdf_partial_comment' => 'برای همه سفارشات با روش پرداخت ، یک پیوست تولید می شود از که با ایمیل اعلان خواهد شد',
        'pdf_partial_none' => ' PDF هیچ پیوستی یافت نشد',
    ],
    'order' => [
        'order_number' => '# سفارش',
        'invoice_number' => '# رسید',
        'payment_hash' => 'Payment hash',
        'customer' => 'مشتری',
        'creation_date' => 'ایجاد شده در',
        'modification_date' => 'ویرایش شده در',
        'completion_date' => 'تکمیل شده در',
        'credit_card' => 'شماره کارت',
        'payment_status' => 'وضعیت پرداخت',
        'grand_total' => 'جمع کل',
        'billing_address' => 'آدرس',
        'shipping_address' => 'آدرس ارسال',
        'currency' => 'واحد ارز',
        'status' => 'وضعیت',
        'email' => 'ایمیل',
        'will_be_paid_later' => 'بعدا پرداخت می شود',
        'shipping_address_same_as_billing' => ' آدرس ارسال با صورتحساب یکی است',
        'credit_card_last4_digits' => 'Last 4 digits ',
        'tracking_number' => 'شماره پیگیری',
        'tracking_url' => 'آدرس پیگیری',
        'tracking_shipped' => ' انتخاب سفارش برای ارسال',
        'tracking_shipped_comment' => 'سفارش به عنوان ارسال شده انتخاب می شود',
        'tracking_completed' => ' انتخاب سفارش به عنوان تکمیل شده',
        'tracking_completed_comment' => 'سفارش به عنوان تکمیل شده انتخاب می شود',
        'tracking_notification' => 'ارسال اعلان',
        'tracking_notification_comment' => 'یک اعلان شامل اطلاعات پیگیری برای مشتری ارسال می شود',
        'shipping_fees' => 'هزینه ارسال',
        'shipping_provider' => 'سرویس دهنده ارسال',
        'shipping_method' => 'روش ارسال',
        'card_holder_name' => 'نام صاحب حساب',
        'card_type' => 'نوع سبد',
        'payment_method' => 'روش پرداخت',
        'payment_gateway_used' => 'درگاه پرداخت',
        'tax_provider' => 'سرویس دهنده مالیات',
        'lang' => 'زبان',
        'refunds_amount' => 'مبلغ بازپرداخت',
        'adjusted_amount' => 'مقدار تسویه',
        'rebate_amount' => 'مبلغ تخفیف',
        'total' => 'جمع',
        'taxes_total' => 'جمع مالیات',
        'items_total' => 'حمع اقلام ',
        'subtotal' => 'جمع جزء',
        'taxable_total' => 'جمع مالیات',
        'total_weight' => 'وزن کل',
        'total_rebate_rate' => 'جمع تخفیف',
        'notes' => 'یادداشت ها',
        'custom_fields' => 'فیلد های سفارشی',
        'shipping_enabled' => 'ارسال فعال شد',
        'payment_transaction_id' => 'شناسه تراکنش پرداخت',
        'change_order_status' => 'تغییر وضغیت سفارش',
        'change_payment_status' => 'تغییر وضعیت پرداخت',
        'items' => 'اقلام',
        'quantity' => 'تعداد',
        'shipping_address_is_same_as_billing' => ' آدرس ارسال با آدرس صورتحساب یکسان اسست',
        'update_shipping_state' => 'بروز رسانی وضعیت ارسال',
        'invalid_status' => ' وضعیت انتخابی موجود نمی باشد',
        'updated' => ' سفارش باموفقیت بروزرسانی شد',
        'deleted' => ' سفارش با موفقیت حذف شد',
        'deleting' => 'حذف سفارش...',
        'delete_confirm' => '? آیا واقعا می خواهید این سفارش را حذف کنید',
        'update_invoice_number' => 'تنظیم شماره صورتحساب',
        'shipped' => 'ارسال شده',
        'shipping_pending' => 'در انتظار ارسال',
        'not_shipped' => 'درانتظار',
        'data' => 'داده های سفارش',
        'total_revenue' => 'جمع درآمد',
        'download_invoice' => 'دانلود صورتحساب',
        'modal' => [
            'cancel' => 'لغو',
            'update' => 'بروزرسانی اطلاعات',
        ],
        'payment_states' => [
            'pending_state' => 'در انتظار پرداخت',
            'failed_state' => 'پرداخت ناموفق',
            'refunded_state' => 'پرداخت برگشت خورد',
            'paid_state' => 'پرداخت شد.',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'تضمین تحویل در تعداد روز',
        'available_above_total' => ' موجوداست، اگر جمع قیمت بیشتر یا مساوی باشد با',
        'available_below_total' => 'موجوداست، به شرط جمع قیمت کمتر از',
        'countries' => 'ارسال برای این کشور ها موجود است ',
        'countries_comment' => ' اگر کشوری انتخاب نشده باشد، این روش برای سراسر جهان در دسترس است',
        'not_required_name' => 'ارسال مورد نیاز نیست',
        'not_required_description' => ' سبد فعلی نیازی به ارسال  ندارد',
    ],
    'payment_status' => [
        'paid' => 'پرداخت',
        'deferred' => 'معوق',
        'paid_deferred' => 'پرداخت معوق',
        'paiddeferred' => 'پرداخت معوق',
        'charged_back' => 'هزینه برگشت خورد',
        'refunded' => 'استرداد',
        'paidout' => 'پرداخت',
        'failed' => 'ناموفق',
        'pending' => 'در انتظار بررسی',
        'expired' => 'منقضی شده',
        'cancelled' => 'لغو شده',
        'open' => 'باز کردن',
    ],
    'permissions' => [
        'manage_products' => ' بتواند محصولات را مدیریت کند',
        'manage_categories' => ' بتواند دسته بندی ها را مدیریت کند',
        'manage_orders' => ' بتواند سفارشات را مدیریت کند',
        'manage_discounts' => 'بتواند تخفیف ها را مدیریت کند',
        'settings' => [
            'manage_general' => 'بتواند تنظیمات عمومی فروشگاه را تغییر دهد',
            'manage_payment_gateways' => 'بتواند تنظیمات درگاه پرداخت را تغییر دهد',
            'manage_currency' => 'بتواند تنظیمات ارز فروشگاه را تغییر دهد',
            'manage_payment_methods' => 'بتواند روش های پرداخت را تغییر دهد',
        ],
        'manage_properties' => 'بتواند ویژگی های محصول را ویرایش کند',
        'manage_customer_groups' => 'بتواند گروه های کاربری را مدیریت کند',
        'manage_customer_addresses' => 'بتواند آدرس های مشتریان را مدیریت کند',
        'manage_notifications' => 'بتواند اعلانات را مدیریت کند',
        'manage_price_categories' => 'بتواند دسته های قیمت را مدیریت کند',
        'manage_order_states' => 'بتواند وضعیت سفارشات را مدیریت کند',
        'manage_shipping_methods' => 'بتواند روش های ارسال را مدیریت کند',
        'manage_taxes' => 'بتواند مالیات را مدیریت کند',
        'manage_payment_log' => 'بتواند لاگ پرداخت را مدیریت کند',
        'manage_feeds' => 'بتواند خوراک را مدیریت کند',
        'manage_wishlists' => 'بتواند علاقه مندی را مدیریت کند',
        'manage_services' => 'بتواند سرویس ها را مدیریت کند',
        'manage_reviews' => 'بتواند دیدگاه ها را مدیریت کند',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'محصولات',
                'description' => 'نمایش یک لیست از محصولات',
            ],
            'properties' => [
                'no_category_filter' => ' عدم فیلتر برای دسته بندی',
                'use_url' => 'Use category slug from URL',
                'filter_component' => [
                    'title' => 'Filter component alias',
                    'description' => 'Alias of the ProductsFilter component that filters this Products component',
                ],
                'filter' => [
                    'title' => ' فیلتر رشته',
                    'description' => 'فیلتر اجباری برای این کامپوننت ',
                ],
                'include_variants' => [
                    'title' => ' نمایش متغیر های محصول',
                    'description' => ' عدم نمایش تک محصولات اما همه محصولات متغیر می باشند',
                ],
                'include_children' => [
                    'title' => ' مشمول زیر مجموعه',
                    'description' => ' نمایش همه محصولات زیردسته ها ',
                ],
                'per_page' => [
                    'title' => ' برای هر صفحه',
                    'description' => ' تعداد محصولات برای نمایش در هر صفحه',
                ],
                'paginate' => [
                    'title' => 'Paginate',
                    'description' => 'Paginate the result (show more than one page)',
                ],
                'sort' => [
                    'title' => ' مرتب سازی',
                    'description' => 'This overrides the user\'s sort preference ',
                ],
                'set_page_title' => [
                    'title' => ' تنظیم عنوان صفحه',
                    'description' => ' استفاده از عنوان دسته بندی به عنوان سر صفحه',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'فیلتر محصولات',
                'description' => ' فیلتر محصولات از یک دسته بندی',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'نمایش فیلتر قیمت',
                ],
                'showBrandFilter' => [
                    'title' => 'نمایش فیلتر برند',
                ],
                'showOnSaleFilter' => [
                    'title' => 'نمایش فیلتر حراج',
                ],
                'includeChildren' => [
                    'title' => 'مشمول زیر مجموعه',
                    'description' => 'مشمول ویژگی ها و فیلترها از محصولات در زیر دسته ها',
                ],
                'includeVariants' => [
                    'title' => ' مشمول  متغیر ها',
                    'description' => ' نمایش فیلترها برای ویژگی های متغیر',
                ],
                'includeSliderAssets' => [
                    'title' => 'Include noUI Slider',
                    'description' => 'Include all dependencies of noUI Slider via cdnjs',
                ],
                'sortOrder' => [
                    'title' => ' مرتب سازی',
                    'description' => ' راه اندازی مرتب سازی',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'برترین فروشنده',
                'priceLow' => ' کمترین قیمت',
                'priceHigh' => ' بیشترین قیمت',
                'latest' => 'تازه ترین ',
                'oldest' => 'قدیمی ترین',
                'random' => 'تصادفی',

                'manual' => 'دستی',
                'name' => 'نام',
                'ratings' => 'رتبه بندی',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'حساب کاربری',
                'description' => 'e نمایش فرم متفاوت برای جایی که کاربر بتواندد پروفایل خود را ویرایش و تماشا کند',
            ],
            'properties' => [
                'page' => [
                    'title' => 'فعال سازی زیر صفحه',
                ],
            ],
            'pages' => [
                'orders' => 'سفارش ها',
                'profile' => 'پروفایل',
                'addresses' => 'آدرس ها',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'پروفیال مشتری',
                'description' => 'نمایش فرم ویرایش پروفایل کاربر.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'انتخاب کننده واحد ارزی',
                'description' => '. نمایش یک انتخاب کننده برای انتخاب واحد ارز فعال فروشگاه',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'وابستگی های فرنداند',
                'description' => 'Includes all needed frontend dependencies',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'لیست آدرس',
                'description' => ' نمایش یک لیست از آدرس های کاربرهای ثبت شده',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'آدرس درخواستی شما را نمی توان حذف کرد',
                'cannot_delete_last_address' => 'شما نمی توانید اخرین آدرس را حذف کنید',
            ],
            'messages' => [
                'address_deleted' => 'آدرس حذف شد',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'لیست سفارش ها',
                'description' => 'نمایش یک لیست از سفارش های مشتریان',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'جزئیات محصول',
                'description' => 'نمایش جزئیات یک محصول',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => ' ریدایرکت با تغییر ویژگی',
                    'description' => ' ریدایرکت کاربر به صفحه جزئیات محصول جدید، هنگامی که ویژگی تغییر کرد',
                ],
            ],
            'added_to_cart' => 'محصول با موفقیت اضافه شد',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'دیدگاه های محصول',
                'description' => 'نمایش همه دیدگاه های محصول',
            ],
            'properties' => [
                'perPage' => [
                    'title' => ' تعداد دیدگاه برای هر صفحه',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'نمایش فقط رتبه بندی این متغیر',
                    'description' => " عدم نمایش دیدگاه ها برای دیگر متغیر های این محصول",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'سبدخرید',
                'description' => 'نمایش سبدخرید',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'نمایش ورودی تخفیف',
                ],
                'showShipping' => [
                    'title' => 'نمایش هزینه ارسال',
                ],
                'showTaxes' => [
                    'title' => 'نمایش مالیات ها',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'نمایش دکمه پرداخت',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'پرداخت',
                'description' => 'کنترل فرایند پرداخت',
            ],
            'errors' => [
                'missing_settings' => 'لطفا یک روش پرداخت و ارسال را انتخاب کنید.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => ' ورودی کد تخفیف',
                'description' => ' نمایش فیلد ورودی کد تخفیف',
            ],
            'discount_applied' => 'تخفیف با موفقیت اعمال شد!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'انتخاب کننده ارسال',
                'description' => ' نمایش یک لیست از روش های ارسال موجود',
            ],
            'errors' => [
                'unavailable' => '. روش ارسال انتخابی در سفارش شما موجود نیست',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'انتخاب کننده روش پرداخت',
                'description' => 'نمایش یک لیست از روش های پرداخت موجود',
            ],
            'errors' => [
                'unavailable' => '.روش پرداخت انتخابی شما در سفارش شما موجود نمی باشد',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'انتخاب کننده آدرس',
                'description' => 'نمایش یک لیست از آدرس های موجود کاربر',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'فرم آدرس',
                'description' => 'نمایش یک فرم برای ویرایش آدرس کاربر',
            ],
            'properties' => [
                'address' => [
                    'title' => 'آدرس',
                ],
                'redirect' => [
                    'title' => 'ریداریکت (بعد از ذخیره)',
                ],
                'set' => [
                    'title' => 'استفاه این آدرس به عنوان',
                ],
            ],
            'redirects' => [
                'checkout' => 'صفحه پرداخت',
            ],
            'set' => [
                'billing' => 'آدرس صورتحساب',
                'shipping' => 'آدرس ارسال',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'ثبت نام',
                'description' => 'ثبت نام فرم ورود و ثبت نام',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'ریدایرکت  بعد از ورود',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'شما در حال ورود به عنوان مهمان هستید',
                'unknown_user' => 'اطلاعات شما برای ورود معتبر نمی باشد.',
                'not_activated' => 'حساب شما نیاز به فعال سازی است .بعد می توانید وارد شوید',
                'login' => [
                    'required' => 'لطفا ایمیل خود را وارد کنید.',
                    'email' => 'لطفا یک ایمیل معتبر وارد کنید.',
                    'between' => 'لطفا یک ایمیل معتبر وارد کندی.',
                ],
                'password' => [
                    'required' => 'لطفا گذرواژه خود را وارد کنید.',
                    'max' => 'گذرواژه ارائه شده خیلی طولانی است.',
                    'min' => 'گذرواژه ارائه شده کوتاه است. لطفا حداقل 8 کاراکتر وارد کنید.',
                ],
                'password_repeat' => [
                    'required' => 'لطفا گذرواژه خود را تکرار کنید.',
                    'same' => 'تأیید رمز عبور با رمز وارد شده شما مطابقت ندارد.',
                ],
                'email' => [
                    'required' => 'لطفا یک آدرس ایمیل وارد کنید.',
                    'email' => 'لطفا یک آدرس ایمیل معتبر وارد کنید.',
                    'unique' => '. یک کاربر با ایمیل وارد شد ، قبلا ثبت نام کرده است',
                    'non_existing_user' => 'یک کاربر با ایمیل وارد شده موجود است ، لطفا از بازیابی گذرواژه استفاده کنید',
                ],
                'firstname' => [
                    'required' => 'لطفا نام خود را وارد کنید.',
                ],
                'lastname' => [
                    'required' => 'لطفا نام خانوادگی خود را وارد کنید.',
                ],
                'lines' => [
                    'required' => 'لطفا آدرس خود را وارد کنید.',
                ],
                'zip' => [
                    'required' => ' لطفا کدپستی را وارد کنید',
                ],
                'city' => [
                    'required' => 'لطفا شهر خود را وار د کنید.',
                ],
                'country_id' => [
                    'required' => 'کشور خود را انتخاب کنید.',
                    'exists' => ' کشور انتخاب شده معتبر نیست',
                ],
                'state_id' => [
                    'required' => 'استان خود را وارد کنید',
                    'exists' => 'مقدار انتخابی شما معتبر نمی باشد.',
                ],
                'terms_accepted' => [
                    'required' => 'لطفا قوانین و شرایط را قبول کنید.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'دسته بندی ها',
                'description' => 'لیست هایی از دسته بندی  های موجود',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'شروع از دسته بندی',
                    'description' => ' فقط نمایش زیر دسته های این دسته بندی',
                ],
                'categorySlug' => [
                    'title' => 'r پارامتر  آدرس دسته بندی',
                    'description' => 'استفاده این پارامتر برای بارگذاری  دسته بندی والد از این آدرس',
                ],
                'categoryPage' => [
                    'title' => 'صفحه دسته بندی',
                    'description' => ' پیوند ها به این صفحه اشاره می کنند. اگر هیج تنظیمات پیشفرضی از بک اند برای آن وارد نشده باشد',
                ],
            ],
            'no_parent' => 'نمایش همه دسته بندی ها',
            'by_slug' => ' استفاده دسته بندی در آدرس به عنوان والد',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'جزئیات سبدخرید',
                'description' => 'نمایش تعدادی از محصولات و جمع مقدار از سبد خرید',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'نمایش شماره محصولات',
                    'description' => 'نمایش شمارنده اقلام در سبد خرید',
                ],
                'showTotalPrice' => [
                    'title' => 'نمایش جمع مقادیر',
                    'description' => ' نمایش جمع مقادیر از همه اقلام در سبد خرید',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'پیشخوان مشتریان',
                'description' => 'نمایش یک پیوند برای مشتری  برای ورود وو تغییر تنظیمات حساب کاربری',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'برچسب پیشخوان مشتری',
                    'description' => 'متن پیوند برای صفحه حساب کاربری مشتری',
                ],
                'logoutLabel' => [
                    'title' => 'برچسب خروج',
                    'description' => 'متن پیوند برای لینک خروج',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'مؤلفه تجارت الکترونیکی پیشرفته (UA)',
                'description' => ' پیاده سازی لایه مدیریت تگ گوگل',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'دکمه لیست علاقه مندی',
                'description' => ' نمایش دکمه لیست علاقه مندی',
            ],
            'properties' => [
                'product' => [
                    'name' => 'محصول',
                    'description' => 'شناسه محصول',
                ],
                'variant' => [
                    'name' => 'متغیر',
                    'description' => 'شناسه محصول متغیر',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'لیست های علاقه مندی',
                'description' => ' نمایش مدیریت لیست علاقه مندی',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'نمایش ارسال',
                    'description' => 'نمایش هزینه و انتخاب کننده ارسال',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'از (Weight in grams)',
        'to_weight' => 'به (Weight in grams)',
    ],
    'products' => [
        'variants_comment' => ' ایجاد متغیر های متفاوت برای یک محصول یکسان',
    ],
    'order_states' => [
        'name' => 'نام',
        'description' => 'توضیحات',
        'color' => 'رنگ',
        'flag' => 'پرچم مخصوص',
        'flags' => [
            'new' => '  تنظیم یک وضعیت برای سفارش -جدید',
            'complete' => ' تنظیم  وضعیت برای این سفارش - انجام شده',
            'cancelled' => '  لغو شده-  تنظیم وضعیت برای این سفارش',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'از این کد می توان برای شناسایی برنامه ای این گروه استفاده کرد',
        'discount_comment' => ' یک کد تخفیف در فروشگاه خود به گروهی از کاربران اختصاص دهید',
    ],
    'order_status' => [
        'processed' => 'پردازش شده',
        'disputed' => 'حل اختلاف',
        'shipped' => 'ارسال شده',
        'delivered' => 'تحویل داده شده',
        'pending' => 'در حال پردازش',
        'cancelled' => 'لغو شده',
    ],
    'notifications' => [
        'enabled' => 'فعال شده',
        'enabled_comment' => 'این اعلان فعال شده',
        'template' => 'قالب ایمیل',
    ],
    'payment_log' => [
        'payment_data' => 'داده پرداخت',
        'data_comment' => '  این اطلاعات به وسیله سرویس دهنده پرداخت برگشت داده شده است',
        'order_data_comment' => ' این همه اطلاعات سفارش برای این پرداخت است',
        'message_comment' => ' این پیغام به وسیله سرویس پرداخت برگشت داده شده است',
        'code_comment' => ' این کد به وسیله سرویس دهنده پرداخت برگشت داده شده است',
        'failed_only' => 'فقط ناموفق ها',
    ],
    'services' => [
        'options' => 'گزینه ها',
        'option' => 'گزینه',
        'required' => 'سرویس لازم است',
        'required_comment' => '.یک گزینه از این سرویس انتخاب می شود در هنگامی که محصول به سبدخرید اضافه می شود',
    ],
    'reviews' => [
        'rating' => 'رتبه بندی',
        'review' => 'جزئیات دیدگاه',
        'title' => 'عنوان دیدگاه شما',
        'pros' => 'جنبه های مثبت',
        'cons' => 'جنبه های منفی',
        'anonymous' => 'ناشناس',
        'only_unapproved' => 'نمایش دیدگاه تائید نشده',
        'no_more' => 'هیج دیدگاه تائید نشده یافت نشد',
        'approve_next' => 'تائید و رفتن به بعدی',
    ],
];
