<?php return [
    'plugin' => [
        'name' => 'E-shop',
        'description' => 'E-shop pro October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Vytvořit produkt',
            'update' => 'Upravit produkt',
            'preview' => 'Náhled produktu',
        ],
        'categories' => [
            'create' => 'Vytvořit kategorii',
            'update' => 'Upravit kategorii',
            'preview' => 'Náhled kategorie',
        ],
        'orders' => [
            'show' => 'Detaily objednávky',
            'export' => 'Exportovat objednávky',
        ],
        'discounts' => [
            'create' => 'Vytvořit slevu',
            'update' => 'Upravit slevu',
            'preview' => 'Náhled slevy',
        ],
        'services' => [
            'create' => 'Vytvořit službu',
            'update' => 'Upravit službu',
        ],
        'shipping_methods' => [
            'create' => 'Vytvořit typ dopravy',
            'update' => 'Upravit typ dopravy',
            'preview' => 'Náhled typu dopravy',
        ],
        'payment_methods' => [
            'create' => 'Vytvořit typ platby',
            'edit' => 'Upravit typ platby',
            'reorder' => 'Reorder',
        ],
        'custom_field_options' => [
            'edit' => 'Upravit možnosti pole',
        ],
        'properties' => [
            'create' => 'Vytvořit vlastnosti',
            'edit' => 'Upravit vlastnosti',
        ],
        'order_states' => [
            'create' => 'Vytvořit stav',
            'edit' => 'Upravit stav',
            'reorder' => 'Změna pořadí stavu',
        ],
        'brands' => [
            'create' => 'Vytvořit značku',
            'edit' => 'Upravit značku',
        ],
        'property_groups' => [
            'create' => 'Vytvořit filtry',
            'edit' => 'Upravit filtry',
        ],
        'customer_groups' => [
            'create' => 'Vytvořit skupinu',
            'update' => 'Upravit skupinu',
        ],
        'notifications' => [
            'update' => 'Aktualizovat zprávu',
        ],
        'taxes' => [
            'create' => 'Vytvořit DPH',
            'update' => 'Upravit DPH',
        ],
        'reviews' => [
            'create' => 'Vytvořit recenzi',
            'update' => 'Upravit recenzi',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Všechny kategorie obchodu',
        'single_category' => 'Jedna kategorie obchodu',
        'all_products' => 'Všechny produkty obchodu',
        'all_variants' => 'Všechny varianty obchodu',
    ],
    'currency_settings' => [
        'label' => 'Měna',
        'description' => 'Konfigurace měn',
        'currencies' => 'Vložte oficiální 3-znakové kódy měn.',
        'currency_code' => 'Kód měny',
        'currency_decimals' => 'Počet desetinných míst',
        'currency_format' => 'Formát',
        'currency_symbol' => 'Symbol',
        'currency_rate' => 'Kurz',
        'is_default' => 'Výchozí měna',
        'unknown' => 'Neznámá měna',
    ],
    'payment_gateway_settings' => [
        'label' => 'Platební brány',
        'description' => 'Konfigurace platebních bran',
        'stripe' => [
            'api_key' => 'Stripe API klíč',
            'api_key_comment' => 'Klíč najdeve v Stripe Dashboard',
            'publishable_key' => 'Stripe veřejný klíč',
            'publishable_key_comment' => 'klíč najdeve v  Stripe Dashboard',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Testovaci mód',
            'test_mode_comment' => 'Všechny platby pomocí PayPal Sandbox.',
        ],
        'postfinance' => [
            'test_mode' => 'Testovací mód',
            'test_mode_comment' => 'Všechny platby budou v testovacím režimu',
            'pspid' => 'PSPID (Uživatelské jméno)',
            'hashing_method' => 'Hash algoritmus',
            'hashing_method_comment' => 'Configuration -> Technical information -> Global security parameters',
            'sha_in' => 'SHA-IN podpis',
            'sha_in_comment' => 'Configuration -> Technical information -> Data and origin verification',
            'sha_out' => 'SHA-OUT podpis',
            'sha_out_comment' => 'Configuration -> Technical information -> Transaction feedback',
        ],
    ],
    'notification_settings' => [
        'label' => 'Oznámení',
        'description' => 'Konfigurace oznámení',
    ],
    'price_category_settings' => [
        'label' => 'Kategorie cen',
        'description' => 'Konfigurace dalších cenových kategorií',
    ],
    'order_state_settings' => [
        'description' => 'Konfigurace stavu objednávek',
    ],
    'payment_method_settings' => [
        'description' => 'Konfigurace platebních možností',
    ],
    'shipping_method_settings' => [
        'description' => 'Konfigurace dopravy',
    ],
    'tax_settings' => [
        'description' => 'Konfigurace DPH',
    ],
    'general_settings' => [
        'category' => 'E-shop: Obecné',
        'category_payments' => 'E-shop: Platby',
        'category_orders' => 'E-shop: Objednávky',
        'label' => 'Konfigurace',
        'description' => 'Obecná nastavení',
        'product_page' => 'Stránka Detail produktu',
        'product_page_comment' => 'Na této stránce bude zobrazen detail produktu',
        'address_page' => 'Stránka Adresa',
        'address_page_comment' => 'Komponent "addressForm" musí být na této stránce',
        'checkout_page' => 'Stránka Pokladna',
        'checkout_page_comment' => 'Komponent "checkout" musí být na této stránce',
        'account_page' => 'Stránka Účet',
        'account_page_comment' => 'Komponent "myAccount" musí být na této stránce',
        'cart_page' => 'Stránka košík',
        'cart_page_comment' => 'Komponent "cart" musí být na této stránce',
        'category_page' => 'Stránka Kategorie',
        'redirect_to_cart' => 'Přesměrovat do košíku',
        'redirect_to_cart_comment' => 'Přesměruje do košíku poté, co zákazník přidal produkt',
        'use_state' => 'Použijte pole Stát/Země/Provincie',
        'use_state_comment' => 'Zákazník musí použít pole Stát/Země/Provincie během registrace',
        'group_search_results_by_product' => 'Skupinové hledání - výsledky produktů',
        'group_search_results_by_product_comment' => 'Produkt zobrazit ve výsledcích hledání pouze jednou, nezobrazovat všechny varianty',
        'shipping_selection_before_payment' => 'Select shipping method BEFORE payment during checkout',
        'shipping_selection_before_payment_comment' => 'By default, during checkout, the user is first asked to select a payment method before selecting a shipping method; use this option to reverse this logic',
        'admin_email' => 'Email správce',
        'admin_email_comment' => 'Zprávy pro správce budou zasílány na tuto adresu',
        'base' => 'Základní nastavení',
        'links' => 'CMS stránky',
        'links_comment' => 'Vyberte, které stránky budou zobrazovat produkty',
        'customizations' => 'Přizpůsobení',
        'customizations_comment' => 'Upravte funkce eshopu',
        'category_page_comment' => 'Komponent "products" musí být na této stránce.',
        'order_number_start' => 'Číslo první objednávky',
        'order_number_start_comment' => 'Výchozí ID první objednávky',
        'index_driver' => 'Ovladač indexu',
        'index_driver_comment' => 'Pokud Vaše databáze podporuje JSON, použijte databázový ovladač.',
        'index_driver_filesystem' => 'Souborový systém',
        'index_driver_database' => 'Databáze (pouze pro MySQL 5.7+ ne MariaDB 10.2+)',
        'index_driver_hint' => 'Pokud změníte tuto možnost, spusťte "php artisan mall:reindex" v příkazovém řádku pro reindexaci Vašich produktů!',
    ],
    'feed_settings' => [
        'description' => 'Konfigurace kanálů',
        'google_merchant_enabled' => 'Povolit Google Merchant Center Feed',
        'google_merchant_enabled_comment' => 'Bude vytvořen kanál produktů',
        'google_merchant_url' => 'Vaše Google Merchant Feed URL',
        'google_merchant_url_locale' => 'Přidejte ?locale=xy pro získání lokalizovaného kanálu.',
    ],
    'review_settings' => [
        'description' => 'Konfigurace recenzí',
        'enabled' => 'Recenze povoleny',
        'enabled_comment' => 'Zákazník může vytvářet recenze',
        'moderated' => 'Kontrola recenzí',
        'moderated_comment' => 'Nové recenze budou publikovány ručně správcem',
        'allow_anonymous' => 'Povolit anonymní recenze',
        'allow_anonymous_comment' => 'Nezaregistrovaní uživatelé mohou vytvářet recenze',
    ],
    'common' => [
        'shop' => 'E-shop',
        'products' => 'Produkty',
        'product' => 'Produkt',
        'orders' => 'Objednávky',
        'cart' => 'Košík',
        'shipping' => 'Doprava',
        'taxes' => 'DPH',
        'rates' => 'Sazbu',
        'inventory' => 'Inventory',
        'accessories' => 'Příslušenství',
        'shipping_methods' => 'Doprava',
        'accessory' => 'Accessory',
        'custom_fields' => 'Vlastní pole',
        'variants' => 'Varianty',
        'variant' => 'Varianty',
        'discounts' => 'Slevy',
        'discount' => 'Sleva',
        'discount_percentage' => 'Sleva (%)',
        'select_placeholder' => '-- Prosím vyberte',
        'main_image' => 'Hlavní obrázek',
        'images' => 'Obrázek',
        'image_set' => 'Skupina obrázků',
        'attachments' => 'Obrázky/Soubory',
        'downloads' => 'Soubory',
        'select_image' => 'Vyberte obrázek',
        'select_file' => 'Vyberte soubor',
        'allowed' => 'Povoleno',
        'not_allowed' => 'Zakázáno',
        'yes' => 'Ano',
        'no' => 'Ne',
        'seo' => 'SEO',
        'properties_links' => 'Vlastnosti/Odkazy',
        'categories' => 'Kategorie',
        'category' => 'Kategorie',
        'meta_title' => 'Meta - titulek',
        'meta_description' => 'Meta - popis',
        'meta_keywords' => 'Meta - klíčové slova',
        'reorder' => 'Přeskupit záznamy',
        'id' => 'ID',
        'created_at' => 'Vytvořeno',
        'updated_at' => 'Aktualizováno',
        'approved_at' => 'Schváleno',
        'hide_published' => 'Skrýt publikované',
        'slug' => 'URL',
        'name' => 'Name',
        'display_name' => 'Název filtru - zobrazí se na stránce',
        'group_name' => 'Název skupiny',
        'add_value' => 'Přidat',
        'export_orders' => 'Exportovat objednávky',
        'use_backend_defaults' => 'Použijte výchozí nastavení nakonfigurovaná v nastavení backendu',
        'api_error' => 'Slevu nelze uložit. Chyba při odesílání změn do rozhraní API Mall.',
        'includes_tax' => 'Včetně daní',
        'conditions' => 'Podmínky dopravy',
        'general' => 'Obecné',
        'logo' => 'Logo',
        'payment_gateway' => 'Platební brána',
        'payment_provider' => 'Poskytovatel plateb',
        'payment_methods' => 'Způsob platby',
        'payment' => 'Platba',
        'payments' => 'Platby',
        'image' => 'Obrázek',
        'color' => 'Barva',
        'unit' => 'Jednotka',
        'dont_group' => '-- Neseskupovat',
        'properties' => 'Filtry',
        'old_price' => 'Stará cena',
        'property' => 'Filtr',
        'property_groups' => 'Skupiny filtrů',
        'property_group' => 'Skupinu filtrů',
        'options' => 'Možnosti',
        'option' => 'Možnost',
        'catalogue' => 'Katalog zboží',
        'out_of_stock' => 'Tento produkt není skladem',
        'out_of_stock_short' => 'Není skladem',
        'stock_limit_reached' => 'Nemůžete přidat více kusů do košíku, protože byl dosažen limit zásob.',
        'deleted_at' => 'Smazáno',
        'sort_order' => 'Sort order',
        'order_states' => 'Stavy objednávek',
        'website' => 'WWW',
        'brands' => 'Značky',
        'brand' => 'Značky',
        'sorting_updated' => 'Pořadí řazení bylo aktualizováno',
        'not_in_use' => 'Možnost se nepoužívá',
        'saved_changes' => 'Změny byly uloženy',
        'none' => '-- Žádná',
        'customers' => 'Zákazníci',
        'customer_groups' => 'Skupiny zákazníků',
        'customer_group' => 'Skupina zakazníků',
        'product_or_variant' => 'Produkt/Varianta',
        'code' => 'Kód',
        'code_comment' => 'Tento kód může být použit k identifikaci tohoto záznamu programově',
        'checked' => 'Označeno',
        'unchecked' => 'Neoznačené',
        'notifications' => 'Zprávy',
        'notification' => 'Zpráva',
        'price_missing' => 'Zadejte alespoň cenu pro výchozí měnu',
        'slug_unique' => 'WWW adresa musí být unikátní',
        'fees' => 'Poplatky',
        'value' => 'Hodnota',
        'action_required' => 'Je vyžadována akce!',
        'invalid_quantity' => 'Vybraná hodnota není platná',
        'addresses' => 'Adresy',
        'address' => 'Adresa',
        'reference' => 'Reference',
        'session_id' => 'ID relace',
        'message' => 'Zpráva',
        'payment_method' => 'Typ platby',
        'data' => 'Data',
        'successful' => 'Úspěšný',
        'failed' => 'neúspěšný',
        'caution' => 'Pozor',
        'since_begin' => 'Od začátku',
        'weekly' => 'Týdně',
        'feeds' => 'Kanály',
        'services' => 'Služby',
        'service' => 'Služba',
        'review' => 'Recenze',
        'reviews' => 'Recenze',
        'review_categories' => 'Recenze - kategorie',
        'review_category' => 'Recenze - kategorie',
        'title' => 'Název',
        'version' => 'Verze',
    ],
    'variant' => [
        'method' => [
            'single' => 'Samostatný produkt',
            'variant' => 'Produkt s variantami',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Použít pro varianty',
        'use_for_variants_comment' => 'Tato vlastnost je různá pro různé varianty tohoto produktu',
        'filter_type' => 'Typ filtru',
        'filter_types' => [
            'none' => 'Bez filtru',
            'set' => 'Sada',
            'range' => 'Rozmezí od do',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Textové pole',
        'integer' => 'Číslo',
        'float' => 'Float',
        'textarea' => 'Více řádkové textové pole',
        'richeditor' => 'Editor',
        'dropdown' => 'Rozbalovací seznam',
        'checkbox' => 'Zaškrtávací políčko',
        'color' => 'Barva',
        'image' => 'Obrázek',
        'add' => 'Přidat možnost',
        'name' => 'Název',
        'price' => 'Cena',
        'attributes' => 'Atribut',
        'option' => 'Možnost',
    ],
    'product' => [
        'user_defined_id' => 'ID produktu',
        'name' => 'Jméno produktu',
        'published' => 'Zobrazeno',
        'published_short' => 'Zobr.',
        'is_virtual' => 'Virtuální produkt',
        'is_virtual_comment' => 'Tento produkt je virtuální (bez dopravy)',
        'product_file' => 'Soubor produktu',
        'product_files' => 'Soubory produktu',
        'product_files_section_comment' => 'Toto je virtuální produkt. Níže můžete nahrát nové verze souboru. Poslední verze bude stáhnutelná zákazníky.',
        'product_file_version' => 'Verzi souboru',
        'not_published' => 'Nezobrazeno',
        'published_comment' => 'Tento produkt je viditelný v e-shopu',
        'stock' => 'Počet ks',
        'price' => 'Cena',
        'description_short' => 'Krátký popis',
        'description' => 'Popis',
        'weight' => 'Váha (g)',
        'length' => 'Délka (mm)',
        'height' => 'Výška (mm)',
        'width' => 'Šířka (mm)',
        'quantity_default' => 'Výchozí počet ks',
        'quantity_min' => 'Minimální počet ks',
        'quantity_max' => 'Maximální počet ks',
        'inventory_management_method' => 'Způsob řízení zásob',
        'allow_out_of_stock_purchases' => 'Povolit objednávku při vyprodání zásob',
        'allow_out_of_stock_purchases_comment' => 'Tento produkt může být objednán i při nulových zásobách',
        'stackable' => 'Produkt v košíku',
        'stackable_comment' => 'Pokud je produkt přidán do košíku vícekrát, zobrazit ho pouze jako jednu položku (změní se počet ks)',
        'shippable' => 'Dodatelné',
        'shippable_comment' => 'Tento produkt může být dodán',
        'taxable' => 'DPH',
        'taxable_comment' => 'Vypočítejte daně z tohoto produktu',
        'add_currency' => 'Přidat měnu',
        'is_taxable' => 'Použijte daň',
        'is_not_taxable' => 'Nepoužívejte žádnou daň',
        'currency' => 'Měna',
        'general' => 'Obecné',
        'duplicate_currency' => 'Vložili jste více cen pro stejnou měnu',
        'property_title' => 'Název',
        'property_value' => 'Hodnota',
        'link_title' => 'Název',
        'link_target' => 'Adresa www',
        'embed_title' => 'Název',
        'embed_code' => 'Vložit kód',
        'properties' => 'Vlastnosti',
        'links' => 'Odkazy',
        'embeds' => 'Vložit kód',
        'details' => 'Podrobnosti',
        'price_includes_tax' => 'Cena zahrnuje DPH',
        'price_includes_tax_comment' => 'Definovaná cena zahrnuje DPH',
        'group_by_property' => 'Atribut pro seskupení variant',
        'additional_descriptions' => 'Další popisky',
        'additional_properties' => 'Další vlastnosti',
        'gtin' => 'Číslo globální obchodní položky (GTIN)',
        'mpn' => 'Číslo dílu výrobce (MPN)',
        'price_table_modal' => [
            'trigger' => 'Upravit ceny a zásoby',
            'label' => 'Ceny a zásoby',
            'title' => 'Přehled cen a zásob',
            'currency_dropdown' => 'Měna: ',
        ],
        'missing_category' => 'Produkt nemá kategorii. Vyberte kategorii pro editaci produktu.',
        'variant_support_header' => 'Varianty nejsou podporovány',
        'variant_support_text' => 'Vybraná kategorie nemá nadefinované varianty. Změňte způsob řízení zásob na "Samostatný produkt" nebo vyberte jinou kategorii.',
        'filter_virtual' => 'Zobrazit pouze virtuální produkty',
    ],
    'product_file' => [
        'display_name_comment' => 'Tento název bude viditelný pro zákazníka.',
        'version_comment' => 'Unikátní verze pomůže zákazníkovi poznat aktualizované soubory.',
        'expires_after_days' => 'Stahování platné po dobu dnů',
        'expires_after_days_comment' => 'Soubor může být stáhnut pouze tento počet dnů po zakoupení. Nechte prázdné pro neomezený počet dnů.',
        'max_download_count' => 'Maximální počet stáhnutí',
        'max_download_count_comment' => 'Soubor může být stáhnut pouze tolikrát. Nechte prázdné pro neomezené stahování.',
        'session_required' => 'Přihlášení je vyžadováno',
        'session_required_comment' => 'Soubor může být stáhnutý pouze pokud je zákazník přihlášen (odkaz není sdílený).',
        'file' => 'Soubor',
        'download_count' => 'Počet stáhnutí',
        'errors' => [
            'invalid' => 'Neplatný odkaz ke stažení',
            'expired' => 'Odkaz na stažení vypršel',
            'too_many_attempts' => 'Příliš mnoho pokusů o stažení',
            'not_found' => 'Požadovaný soubor nelze najít, kontaktujte nás kvůli podpoře.',
        ],
        'hint' => [
            'intro' => 'Tento produkt nemá připojený soubor. Nezapomeňte při placení jeden přidat nebo programově gerenovat.',
            'info_text' => 'Naleznete informace o tom, jak to provést',
            'info_link' => 'v dokumentaci',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Hlavní obrázek',
        'is_main_set_comment' => 'Použít jako hlavní obrázek',
        'create_new' => 'Vytvořit novou sadu',
    ],
    'category' => [
        'name' => 'Název',
        'code' => 'Kód',
        'code_comment' => 'Tento kód může být použit pro identifikaci této kategorie na vaší stránce.',
        'parent' => 'Nadřazená kategorie',
        'no_parent' => 'bez nadřazené kategorie',
        'inherit_property_groups' => 'Zdědit vlastnosti nadřazené kategorie',
        'inherit_property_groups_comment' => 'Použijte skupiny vlastností nadřazené kategorie této kategorie',
        'inherit_review_categories' => 'Zdědit kategorie recenzí nadřazené kategorie',
        'inherit_review_categories_comment' => 'Použijte kategorie recenzí této nadřazené kategorie',
    ],
    'custom_fields' => [
        'name' => 'Název pole',
        'type' => 'Typ pole',
        'options' => 'Možnosti',
        'required' => 'Povinné',
        'required_comment' => 'Toto pole je povinné pro vytvoření objednávky',
        'is_required' => 'Povinné',
        'is_not_required' => 'Není povinné',
    ],
    'tax' => [
        'percentage' => 'Počet procent',
        'countries' => 'Přidat DPH při dopravě do těchto zemí',
        'countries_comment' => 'Pokud není vybrána země,  bude DPH použito celosvětově.',
        'is_default' => 'Výchozí',
        'is_default_comment' => 'Toto DPH je použito, pokud ještě není známá cílová země.',
    ],
    'discounts' => [
        'name' => 'Název',
        'code' => 'Kód slevy',
        'code_comment' => 'Nechte prázdné pro vytvoření náhodného kódu',
        'total_to_reach' => 'Minimální celková částka pro uplatnění slevy',
        'type' => 'Typ slevy',
        'trigger' => 'Platná pokud',
        'rate' => 'Procenta (%)',
        'amount' => 'Pevná částka',
        'max_number_of_usages' => 'Maximální počet použití slevy',
        'valid_from' => 'Platné od',
        'expires' => 'Platnost končí',
        'number_of_usages' => 'počet použití slevy',
        'shipping_description' => 'Jméno alternativního způsobu dopravy',
        'shipping_price' => 'Cena alternativního způsobu dopravy',
        'shipping_guaranteed_days_to_delivery' => 'Zaručené dny na doručení',
        'section_type' => 'K čemu tato sleva slouží?',
        'section_trigger' => 'Kdy se sleva aplikuje?',
        'types' => [
            'fixed_amount' => 'Pevná částka',
            'rate' => 'Procenta',
            'shipping' => 'Alternativní doprava',
        ],
        'triggers' => [
            'total' => 'Celková cena objednávky je dosažena',
            'code' => 'je zadán slevový kód',
            'product' => 'Určitý produkt je v košíku',
        ],
        'validation' => [
            'empty' => 'Vložte kupón.',
            'shipping' => 'Můžete použít pouze jeden kupón, který sníží Vaši dopravu.',
            'duplicate' => 'Stejný kupón můžete použít pouze jednou.',
            'expired' => 'Tento kupón již vypršel.',
            'not_found' => 'Tento kupón není platný.',
            'usage_limit_reached' => 'Tento kupón byl již použit a proto je neplatný.',
        ],
    ],
    'payment_method' => [
        'price' => 'Pevný poplatek',
        'price_comment' => 'Částka, která se má přidat k celkové objednávce',
        'fee_percentage' => 'Procentní poplatek',
        'fee_percentage_comment' => 'Procento z celkového počtu, které se přidá k celkovému objemu objednávky',
        'fee_label' => 'Poplatek',
        'fee_label_comment' => 'Tento text se zákazníkovi zobrazí při placení.',
        'instructions' => 'Platební pokyny',
        'instructions_comment' => 'Podporován twig syntax. Pomocí {{ order }} nebo {{ cart }} získáte přístup k odpovídajícím informacím, jsou-li k dispozici',
        'pdf_partial' => 'příloha PDF',
        'pdf_partial_comment' => 'U všech objednávek s tímto způsobem platby bude k emailu přiložen soubor PDF',
        'pdf_partial_none' => 'Bez přílohy PDF',
    ],
    'order' => [
        'order_number' => 'Číslo objednávky',
        'invoice_number' => 'Číslo faktury',
        'payment_hash' => 'Platební řetězec',
        'customer' => 'Zákazník',
        'creation_date' => 'Vytvořeno',
        'modification_date' => 'Změněno',
        'completion_date' => 'Vyřízeno',
        'credit_card' => 'Kreditní karta',
        'payment_status' => 'Stav platby',
        'grand_total' => 'Celkem',
        'billing_address' => 'Fakturační adresa',
        'shipping_address' => 'Doručovací adresa',
        'currency' => 'Měna',
        'status' => 'Stav',
        'email' => 'Email',
        'will_be_paid_later' => 'Bude placeno později',
        'shipping_address_same_as_billing' => 'Doručovací adresa je stejná',
        'credit_card_last4_digits' => 'Poslední 4 čísla',
        'tracking_number' => 'Sledovací číslo',
        'tracking_url' => 'Sledovací www adresa ',
        'tracking_shipped' => 'Označit jako odesláno',
        'tracking_shipped_comment' => 'Objednávka bude označená jako odeslána',
        'tracking_completed' => 'Označit jako vyřízeno',
        'tracking_completed_comment' => 'Objednávka bude označená jako vyřízená',
        'tracking_notification' => 'Poslat oznámení',
        'tracking_notification_comment' => 'Oznámení s informacemi o stavu objednávky bude zasláno zákazníkoví',
        'shipping_fees' => 'Poplatky za dopravu',
        'shipping_provider' => 'Dopravce',
        'shipping_method' => 'Způsob dopravy',
        'card_holder_name' => 'Majitel karty',
        'card_type' => 'Typ karty',
        'payment_method' => 'Způsob platby',
        'payment_gateway_used' => 'Platba',
        'tax_provider' => 'Poskytovatel daně',
        'lang' => 'Jazyk',
        'refunds_amount' => 'Vrácení částky',
        'adjusted_amount' => 'Upravená částka',
        'rebate_amount' => 'Částka slevy',
        'total' => 'Cena celkem',
        'taxes_total' => 'Daně celkem',
        'items_total' => 'Kusy celkem',
        'subtotal' => 'Mezisoučet',
        'taxable_total' => 'Zdanitelný součet',
        'total_weight' => 'Celková váha',
        'total_rebate_rate' => 'Celková sleva',
        'notes' => 'Poznámky',
        'custom_fields' => 'Vlastní pole',
        'shipping_enabled' => 'Přeprava povolena',
        'payment_transaction_id' => 'ID platební transakce',
        'change_order_status' => 'Změnit stav objednávky',
        'change_payment_status' => 'Změnit stav platby',
        'items' => 'Položky',
        'quantity' => 'Množství',
        'shipping_address_is_same_as_billing' => 'Dodací adresa je stejná jako fakturační',
        'update_shipping_state' => 'Aktualizovat stav dopravy',
        'invalid_status' => 'Vybraný stav neexistuje.',
        'updated' => 'Objednávka úspěšně aktualizována',
        'deleted' => 'Objednávka úspěšně smazána',
        'deleting' => 'Mazání objednávky..',
        'delete_confirm' => 'Opravdu chcete smazat tuto objednávku?',
        'update_invoice_number' => 'Nastavit číslo faktury',
        'shipped' => 'Odesláno',
        'shipping_pending' => 'Čeká se na dopravu',
        'not_shipped' => 'Čeká se',
        'data' => 'Data objednávky',
        'total_revenue' => 'Celkové příjmy',
        'download_invoice' => 'Stáhnout fakturu',
        'modal' => [
            'cancel' => 'Zrušit',
            'update' => 'Aktualizovat informace',
        ],
        'payment_states' => [
            'pending_state' => 'Na platbu se čeká',
            'failed_state' => 'Platba neúspěšná',
            'refunded_state' => 'Platba vrácena',
            'paid_state' => 'Zaplaceno',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Zaručený počet dnů na doručení',
        'available_above_total' => 'Použít, pokuje je celková cena rovna nebo vyšší',
        'available_below_total' => 'Použít, pokud je celková cena nižší než',
        'countries' => 'Doprava dostupná do těchto zemí',
        'countries_comment' => 'Pokud není vybraná země, bude tento typ dostupný do všech zemí.',
        'not_required_name' => 'Doprava',
        'not_required_description' => 'Košík nevyžaduje dopravu.',
    ],
    'payment_status' => [
        'paid' => 'Zaplaceno',
        'deferred' => 'Odloženo',
        'paid_deferred' => 'Zaplaceno odloženo',
        'paiddeferred' => 'Zaplaceno odloženo',
        'charged_back' => 'Naúčtováno zpět',
        'refunded' => 'Vráceno',
        'paidout' => 'Vyplaceno',
        'failed' => 'Selhalo',
        'pending' => 'Probíhá',
        'expired' => 'Vypršelo',
        'cancelled' => 'Zrušeno',
        'open' => 'Otevřeno',
    ],
    'permissions' => [
        'manage_products' => 'Správa produktů',
        'manage_categories' => 'Správa kategorií',
        'manage_orders' => 'Správa objednávek',
        'manage_discounts' => 'Správa slev',
        'settings' => [
            'manage_general' => 'Správa konfigurace',
            'manage_payment_gateways' => 'Správa platebních bran',
            'manage_currency' => 'Správa měny',
            'manage_payment_methods' => 'Správa plateb',
        ],
        'manage_properties' => 'Správa vlastností produktu',
        'manage_customer_groups' => 'Správa skupin zákazníků',
        'manage_customer_addresses' => 'Správa adres zákazníků',
        'manage_notifications' => 'Správa oznámení',
        'manage_price_categories' => 'Správa kategorií cen',
        'manage_order_states' => 'Správa stavu objednávek',
        'manage_shipping_methods' => 'Správa dopravy',
        'manage_taxes' => 'Správa DPH',
        'manage_payment_log' => 'Správa záznamů plateb',
        'manage_feeds' => 'Správa kanálů',
        'manage_wishlists' => 'Správa seznamů přání',
        'manage_services' => 'Správa služeb',
        'manage_reviews' => 'Správa recenzí',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produkty',
                'description' => 'Zobrazí seznam produktů',
            ],
            'properties' => [
                'no_category_filter' => 'Nefiltrovat podle kategorie',
                'use_url' => 'Použijte slug kategorie z URL',
                'filter_component' => [
                    'title' => 'Filtrovat alias komponenty',
                    'description' => 'Alias komponenty ProductsFilter, který tuto komponentu filtruje',
                ],
                'filter' => [
                    'title' => 'Řetězec filtru',
                    'description' => 'Vynucený filtr pro tuto komponentu',
                ],
                'include_variants' => [
                    'title' => 'Zobrazit varianty produktu',
                    'description' => 'Nezobrazovat jednotlivé produkty, ale všechny dostupné varianty produktů',
                ],
                'include_children' => [
                    'title' => 'Zahrnout podřazené',
                    'description' => 'Zobrazit také všechny produkty podřazených kategorií',
                ],
                'per_page' => [
                    'title' => 'Na stránce',
                    'description' => 'Kolik produktů se zobrazí na stránce',
                ],
                'paginate' => [
                    'title' => 'Stránkování',
                    'description' => 'Stránkovat výsledky (zobrazit více než jednu stránku)',
                ],
                'sort' => [
                    'title' => 'Seřadit',
                    'description' => 'Toto přepíše preference řazení uživatele',
                ],
                'set_page_title' => [
                    'title' => 'Nastavit název stránky',
                    'description' => 'Jako název stránky použijte název kategorie',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filtr produktů',
                'description' => 'Filtruje produkty z kategorie',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Zobrazit filtr cen',
                ],
                'showBrandFilter' => [
                    'title' => 'Zobrazit filtr značek',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Zobrazit filtr AKCE',
                ],
                'includeChildren' => [
                    'title' => 'Zahrnout podřazené',
                    'description' => 'Zahrnout také vlastnosti a filtry z produktů z podřazených kategorií',
                ],
                'includeVariants' => [
                    'title' => 'Zahrnout varianty',
                    'description' => 'Zobrazit filtry pro vlastnosti variant',
                ],
                'includeSliderAssets' => [
                    'title' => 'Přidat noUI Slider',
                    'description' => 'Přidat všechny pluginy noUI Slider skrz cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Řazení',
                    'description' => 'Výchozí řazení',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Nejčastěji kupovaný',
                'priceLow' => 'Nejnižší cena',
                'priceHigh' => 'Nejvyšší cena',
                'latest' => 'Nejnovější',
                'oldest' => 'Nejstarší',
                'random' => 'Náhodně',
                'manual' => 'Ručně',
                'name' => 'Název',
                'ratings' => 'Hodnocení',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Uživatelský účet',
                'description' => 'Zobrazuje různé formuláře, kde si zákazník může prohlížet a upravovat své údaje',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Aktivní podstránka',
                ],
            ],
            'pages' => [
                'orders' => 'Objednávky',
                'profile' => 'Profil',
                'addresses' => 'Adresy',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Profil zákazníka',
                'description' => 'Zobrazuje formulář profilu zákazníka.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Výběr měny',
                'description' => 'Možnost výběru měny',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Frontendové závislosti',
                'description' => 'Zahrnuje všechny potřebné závislosti frontendu',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Seznam adres',
                'description' => 'Zobrazuje seznam adres všech registrovaných zákazníků',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'Požadovaná adresa nebyla nalezena',
                'cannot_delete_last_address' => 'Nemůžete smazat svou poslední adresu',
            ],
            'messages' => [
                'address_deleted' => 'Adresa smazána',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Seznam objednávek',
                'description' => 'Zobrazuje seznam objednávek všech zákazníků',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Detaily produktu',
                'description' => 'Zobrazuje detaily produktu',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Přesměrování při změně vlastnosti',
                    'description' => 'Přesměruje zákazníka na novou stránku detailu produktu pokud byla změněna vlastnost',
                ],
            ],
            'added_to_cart' => 'Produkt byl úspěšně přidán',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Recenze produktu',
                'description' => 'Zobrazuje všechny recenze produktu',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Počet recenzí na stránce',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Zobrazit pouze hodnocení této varianty',
                    'description' => "Nezobrazovat recenze jiných variant tohoto produktu",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Košík',
                'description' => 'Zobrazuje košík',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Zobrazit aplikátor slev',
                ],
                'showShipping' => [
                    'title' => 'Zobrazit cenu dopravy',
                ],
                'showTaxes' => [
                    'title' => 'Zobrazit DPH',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Zobrazit tlačítko "přejít k pokladně',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Pokladna',
                'description' => 'Stará se o proces platby',
            ],
            'errors' => [
                'missing_settings' => 'Prosím, vyberte způsob platby a dopravy.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Zadání promo kódu',
                'description' => 'Zobrazuje vstupní pole promo kódu',
            ],
            'discount_applied' => 'Sleva byla úspěšně uplatněna!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Výběr způsobu přepravy',
                'description' => 'Zobrazí seznam všech dostupných způsobů dopravy',
            ],
            'errors' => [
                'unavailable' => 'Vybraný způsob dopravy není pro vaši objednávku k dispozici.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Výběr způsobu platby',
                'description' => 'Zobrazí seznam všech dostupných platebních metod
                ',
            ],
            'errors' => [
                'unavailable' => 'Vybraný způsob platby není pro vaši objednávku k dispozici.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Výběr adres',
                'description' => 'Zobrazí seznam všech existujících adres zákazníka',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formulář adresy',
                'description' => 'Zobrazí formulář pro úpravu adresy uživatele',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Adresa',
                ],
                'redirect' => [
                    'title' => 'Přesměrovat (po uložení)',
                ],
                'set' => [
                    'title' => 'Použít tuto adresu jako',
                ],
            ],
            'redirects' => [
                'checkout' => 'Pokladna',
            ],
            'set' => [
                'billing' => 'Fakturační adresa',
                'shipping' => 'Adresa dopravy',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Přihlášení',
                'description' => 'Zobrazí formulář pro registraci a přihlášení',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Přesměrovat po přihlášení',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Snažíte se přihlásit s účtem neregistrovaného zákazníka.',
                'unknown_user' => 'Email nebo heslo je neplatné.',
                'not_activated' => 'Váš účet musí být aktivován před přihlášením.',
                'login' => [
                    'required' => 'Vložte emailovou adresu.',
                    'email' => 'Vložte správnou emailovou adresu.',
                    'between' => 'Vložte správnou emailovou adresu.',
                ],
                'password' => [
                    'required' => 'Vložte své heslo.',
                    'max' => 'Heslo je příliš dlouhé.',
                    'min' => 'Heslo je příliš krátké - musí mít alespoň 8 znaků. ',
                ],
                'password_repeat' => [
                    'required' => 'Zopakujte své heslo.',
                    'same' => 'Hesla se neshodují.',
                ],
                'email' => [
                    'required' => 'Vložte emailovou adresu.',
                    'email' => 'Emailová adresa je neplatná.',
                    'unique' => 'Zákazník s touto emailovou adresou již existuje.',
                    'non_existing_user' => 'Zákazník s touto emailovou adresou již existuje. Použijte funkci "Zapomenuté heslo" .',
                ],
                'firstname' => [
                    'required' => 'Vložte své jméno.',
                ],
                'lastname' => [
                    'required' => 'Vložte své příjmení.',
                ],
                'lines' => [
                    'required' => 'Vložte svou adresu.',
                ],
                'zip' => [
                    'required' => 'Vložte směrovací číslo.',
                ],
                'city' => [
                    'required' => 'Vložte město.',
                ],
                'country_id' => [
                    'required' => 'Vyberte zemi.',
                    'exists' => 'Tato hodnota není platná.',
                ],
                'state_id' => [
                    'required' => 'Vyberte stát',
                    'exists' => 'Vybraná hodnota není platná.',
                ],
                'terms_accepted' => [
                    'required' => 'Přijměte podmínky.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Kategorie',
                'description' => 'Seznam dostupných kategorií',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Začít od kategorie',
                    'description' => 'Zobrazit pouze podřazené kategorie této kategorie',
                ],
                'categorySlug' => [
                    'title' => 'Kategorie slug parametr',
                    'description' => 'Tento parametr použijte k načtení nadřazené kategorie z adresy URL',
                ],
                'categoryPage' => [
                    'title' => 'Stránka kategorie',
                    'description' => 'Odkazy odkazují na tuto stránku. Pokud není zadáno nic, použije se výchozí nastavení z nastavení backendu.',
                ],
            ],
            'no_parent' => 'Zobrazit všechny kategorie',
            'by_slug' => 'Jako nadřazenou použijte kategorii v adrese URL',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Souhrn košíku',
                'description' => 'Zobrazí počet produktů a celkovou cenu košíku',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Zobrazit počet produktů',
                    'description' => 'Zobrazí počet produktů v košíku',
                ],
                'showTotalPrice' => [
                    'title' => 'Zobrazit celkovou cenu',
                    'description' => 'Zobrazí celkovou cenu všech produktů v košíku',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Hlavní panel zákazníka',
                'description' => 'Zobrazí odkaz pro přihlášení a změny nastavení zákazníckého účtu',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Štítek hlavního panelu zákazníka',
                    'description' => 'Text odkazu na stránku zákaznického účtu',
                ],
                'logoutLabel' => [
                    'title' => 'Štítek odhlášení',
                    'description' => 'Text odkazu pro odhlášení',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Rozšířený Ecommerce (UA) komponent',
                'description' => 'Implementuje Google Tag Manager Data Layer',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Tlačítko Seznam přání',
                'description' => 'Zobrazí tlačítko Seznam přání',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produkt',
                    'description' => 'ID produktu',
                ],
                'variant' => [
                    'name' => 'Varianta',
                    'description' => 'ID varianty',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Seznamy přání',
                'description' => 'Zobrazí správce Seznamu přání',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Zobrazit dopravu',
                    'description' => 'Zobrazí cenu dopravy',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'Od (Váha v gramech)',
        'to_weight' => 'Do (Váha v gramech)',
    ],
    'products' => [
        'variants_comment' => 'Vytvořit různé varianty stejného produktu',
    ],
    'order_states' => [
        'name' => 'Název',
        'description' => 'Popis',
        'color' => 'Barva',
        'flag' => 'Zvláštní značka',
        'flags' => [
            'new' => 'Nastavit stav objednávky jako "Nová"',
            'complete' => 'Nastavit stav objednávky jako "Vyřízeno"',
            'cancelled' => 'Nastavit stav objednávky jako "zrušeno"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Tento kód může být použit na identifikaci této skupiny programově',
        'discount_comment' => 'Dejte této skupině zákazníků určitou slevu v % na všechny produkty',
    ],
    'order_status' => [
        'processed' => 'Zpracováno',
        'disputed' => 'Sporné',
        'shipped' => 'Odesláno',
        'delivered' => 'Dodáno',
        'pending' => 'Probíhající',
        'cancelled' => 'Zrušeno',
    ],
    'notifications' => [
        'enabled' => 'Povoleno',
        'enabled_comment' => 'Toto oznámení je povoleno',
        'template' => 'Šablona emailu',
    ],
    'payment_log' => [
        'payment_data' => 'Platební údaje',
        'data_comment' => 'Tato data byla vrácena poskytovatelem plateb',
        'order_data_comment' => 'Toto jsou všechny údaje o objednávce pro tuto platbu',
        'message_comment' => 'Tuto zprávu vrátil poskytovatel plateb',
        'code_comment' => 'Tento kód byl vrácen poskytovatelem plateb',
        'failed_only' => 'Pouze neuspěšné',
    ],
    'services' => [
        'options' => 'Možnosti',
        'option' => 'Možnost',
        'required' => 'Služba je povinná',
        'required_comment' => 'Jedna z možností této služby musí být vybrána, když je produkt přidán do košíku.',
    ],
    'reviews' => [
        'rating' => 'Hodnocení',
        'review' => 'Text recenze',
        'title' => 'Název recenze',
        'pros' => 'Pozitiva',
        'cons' => 'Negativa',
        'anonymous' => 'Anonymní',
        'only_unapproved' => 'Zobrazit pouze neschválené',
        'no_more' => 'Žadné neschválené recenze',
        'approve_next' => 'Schválit a přejít na další',
    ],
];
