# v1.9.0

## Changes

* PHP7.2 is now required to run this plugin
* Property values are now translatable
* Added a new option to group search results by Product
* Wishlists can now have a shipping method attached 
  (opt-in via new [showShipping-Property](../components/wishlists.md#show-shipping-bool))
* You can now set a default tax which is used as long as the shipping destination country is unknown
* Fixed various bugs when using country specific taxes
* E-mail templates now use translatable strings
* Optimized loading of translated attributes
* Various minor bugfixes

## Required actions

### Update RainLab.Translate 

Update `RainLab.Translate` to version `1.6.3` to be compatible
with this release. 

Version `1.6.3` enables eager-loading of translated attributes.
This decreases the overall query count on all pages. 

### Update product component partials

If you override the `properties/color.htm` or `properties/default.htm`
partials of the `Product` component, make sure to use 
new value accessors to properly load translations.

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/commit/4ba95c8808dda658e255d2688efaeae69f5ec8e9)

If you override the `tax-info.htm` partial of the `Product` component,
make sure to uses the new `filteredTaxes` attribute to only display the
correct taxes for the user's current shipping destination country.

See [PR](https://github.com/OFFLINE-GmbH/oc-mall-plugin/pull/416/files#diff-52fecf5054aab175b91d3f4985e037cd)

### Update cart component partials

If you override the `cart/table/entries.htm` or `cart/table/taxes.htm`
partials of the `Cart` component, make sure to select the taxes
directly off the new `totals` variable.

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/commit/cc7fe4e51d6ac2f89122eb9722f3397f6a07eff2)

### Update wishlist component partials

If you override the `wishlists/cart.htm` partial of the `Wishlist` component
make sure to include the new shipping method partial if you plan
on using this feature. If you do not want to display shipping cost
for Wishlists the component will still function without this change.

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/commit/a407e7c40f9efce52eb18c5180f3f59ebdf8c32a)


### Optional: Use included "Proceed to checkout button"

The `Cart` component got a new `showProceedToCheckout` property that includes
a "Proceed to checkout" button with the component if enabled. The button will be
removed correctly if a user removes all products from the cart. Until now
it was not possible to remove the button if it was placed on a theme partial.

This change is opt-in. If you don't explicitly set the new property to true,
the component output will be unchanged.

See [Theme commit](https://github.com/OFFLINE-GmbH/oc-mall-theme/commit/b451cfdc922db907921dfd175f70fcf22c4637f5)

See [Issue](https://github.com/OFFLINE-GmbH/oc-mall-plugin/issues/395)