<?php

namespace OFFLINE\Mall\Classes\Traits;

use Closure;
use OFFLINE\Mall\Models\Currency;
use OFFLINE\Mall\Models\Price;
use OFFLINE\Mall\Models\Variant;

trait NullPrice
{
    protected $defaultCurrency = null;

    protected function nullPrice(
        $currency,
        $related,
        string $relation = 'prices',
        ?Closure $filter = null
    ) {
        $price   = null;
        $default = $this->getDefaultCurrency();

        $model = new Price();

        // Add missing prices only when running the frontend.
        if ($this->shouldInherit()) {
            $base = $related->where('currency_id', $default->id)->first();
            if ($base !== null) {
                $price                = (int)($base->price * $currency->rate);
                $model->autoGenerated = true;
            } elseif ($this instanceof Variant) {
                // Variants can inherit their product's pricing information.
                return $this->product->price($currency, $relation, $filter);
            }
        }

        return $model->setRawAttributes([
            'price'       => $price,
            'currency_id' => optional($currency)->id ?? Currency::activeCurrency()->id,
        ], true);
    }

    protected function getDefaultCurrency()
    {
        if ( ! $this->defaultCurrency) {
            $this->defaultCurrency = Currency::defaultCurrency();
        }

        return $this->defaultCurrency;
    }

    /**
     * Prices should not be inherited when the code in run in the backend.
     * We also don't want to inherit prices when running in the console
     * (for seeding and indexing) except when unit tests are running.
     *
     * @return bool
     */
    protected function shouldInherit()
    {
        if (property_exists($this, 'forcePriceInheritance') && $this->forcePriceInheritance) {
            return true;
        }

        if (app()->runningInBackend()) {
            return false;
        }

        if (app()->runningInConsole() && ! app()->runningUnitTests()) {
            return false;
        }

        return true;
    }
}
