'use strict';var Defaults={defaultAmount:0,defaultCurrency:'USD',defaultPrecision:2},Globals={globalLocale:'en-US',globalFormat:'$0,0.00',globalRoundingMode:'HALF_EVEN',globalFormatRoundingMode:'HALF_AWAY_FROM_ZERO',globalExchangeRatesApi:{endpoint:void 0,headers:void 0,propertyPath:void 0}},Static={normalizePrecision:function(a){var b=a.reduce(function(c,a){return Math.max(c.getPrecision(),a.getPrecision())});return a.map(function(a){return a.getPrecision()===b?a:a.convertPrecision(b)})}},_typeof='function'==typeof Symbol&&'symbol'==typeof Symbol.iterator?function(a){return typeof a}:function(a){return a&&'function'==typeof Symbol&&a.constructor===Symbol&&a!==Symbol.prototype?'symbol':typeof a};function isNumeric(a){return!isNaN(parseInt(a))&&isFinite(a)}function isPercentage(a){return isNumeric(a)&&100>=a&&0<=a}function areValidRatios(a){return 0<a.length&&a.every(function(a){return 0<a})}function isEven(a){return 0==a%2}function isFloat(a){return isNumeric(a)&&!Number.isInteger(a)}function countFractionDigits(){var a=0<arguments.length&&arguments[0]!==void 0?arguments[0]:0,b=a.toString().split('.')[1];return b?b.length:0}function isHalf(a){return .5==Math.abs(a)%1}function getJSON(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{};return new Promise(function(c,d){var e=Object.assign(new XMLHttpRequest,{onreadystatechange:function(){4===e.readyState&&(200<=e.status&&400>e.status?c(JSON.parse(e.responseText)):d(new Error(e.statusText)))},onerror:function(){d(new Error('Network error'))}});e.open('GET',a,!0),setXHRHeaders(e,b.headers),e.send()})}function setXHRHeaders(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:{};for(var c in b)a.setRequestHeader(c,b[c]);return a}function isUndefined(a){return'undefined'==typeof a}function flattenObject(a){var b=1<arguments.length&&void 0!==arguments[1]?arguments[1]:'.',c={};return Object.entries(a).forEach(function(a){if('object'===_typeof(a[1])){var d=flattenObject(a[1]);Object.entries(d).forEach(function(d){c[a[0]+b+d[0]]=d[1]})}else c[a[0]]=a[1]}),c}function Calculator(){var a=Math.sign,b=Math.floor,c=Math.round,d=Math.abs,e=function(d,a){var b=function(a){return Math.pow(10,countFractionDigits(a))},e=Math.max(b(d),b(a));return c(d*e)*c(a*e)/(e*e)},f={HALF_ODD:function(a){var b=c(a);return isHalf(a)?isEven(b)?b-1:b:b},HALF_EVEN:function(a){var b=c(a);return isHalf(a)?isEven(b)?b:b-1:b},HALF_UP:function(a){return c(a)},HALF_DOWN:function(a){return isHalf(a)?b(a):c(a)},HALF_TOWARDS_ZERO:function(e){return isHalf(e)?a(e)*b(d(e)):c(e)},HALF_AWAY_FROM_ZERO:function(b){return isHalf(b)?a(b)*Math.ceil(d(b)):c(b)}};return{add:function(c,a){return c+a},subtract:function(c,a){return c-a},multiply:function(c,a){return isFloat(c)||isFloat(a)?e(c,a):c*a},divide:function(c,a){return c/a},modulo:function(c,a){return c%a},round:function(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:'HALF_EVEN';return f[b](a)}}}var calculator=Calculator();function Format(a){var b=/^(?:(\$|USD)?0(?:(,)0)?(\.)?(0+)?|0(?:(,)0)?(\.)?(0+)?\s?(dollar)?)$/gm.exec(a);return{getMatches:function(){return null===b?[]:b.slice(1).filter(function(a){return!isUndefined(a)})},getMinimumFractionDigits:function(){var a=function(a){return'.'===a};return isUndefined(this.getMatches().find(a))?0:this.getMatches()[calculator.add(this.getMatches().findIndex(a),1)].split('').length},getCurrencyDisplay:function(){return{USD:'code',dollar:'name',$:'symbol'}[this.getMatches().find(function(a){return'USD'===a||'dollar'===a||'$'===a})]},getStyle:function(){return isUndefined(this.getCurrencyDisplay(this.getMatches()))?'decimal':'currency'},getUseGrouping:function(){return!isUndefined(this.getMatches().find(function(a){return','===a}))}}}function CurrencyConverter(a){var b=function(){var a=0<arguments.length&&arguments[0]!==void 0?arguments[0]:'',b=arguments[1];for(var c in b)a=a.replace('{{'+c+'}}',b[c]);return a};return{getExchangeRate:function(c,d){return getJSON(b(a.endpoint,{from:c,to:d}),{headers:a.headers}).then(function(e){return flattenObject(e)[b(a.propertyPath,{from:c,to:d})]})}}}function assert(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:new Error;if(!a)throw b}function assertPercentage(a){assert(isPercentage(a),new RangeError('You must provide a numeric value between 0 and 100.'))}function assertValidRatios(a){assert(areValidRatios(a),new TypeError('You must provide a non-empty array of numeric values greater than 0.'))}function assertInteger(a){assert(Number.isInteger(a),new TypeError('You must provide an integer.'))}var calculator$1=Calculator(),Dinero=function a(b){var c=Math.pow,d=Object.assign({},{amount:a.defaultAmount,currency:a.defaultCurrency,precision:a.defaultPrecision},b),e=d.amount,f=d.currency,g=d.precision;assertInteger(e),assertInteger(g);var h=a.globalLocale,i=a.globalFormat,j=a.globalRoundingMode,k=a.globalFormatRoundingMode,l=Object.assign({},a.globalExchangeRatesApi),m=function(b){var c=Object.assign({},Object.assign({},{amount:e,currency:f,precision:g},b),Object.assign({},{locale:this.locale},b));return Object.assign(a({amount:c.amount,currency:c.currency,precision:c.precision}),{locale:c.locale})},n=function(a){assert(this.hasSameCurrency(a),new TypeError('You must provide a Dinero instance with the same currency.'))};return{getAmount:function(){return e},getCurrency:function(){return f},getLocale:function(){return this.locale||h},setLocale:function(a){return m.call(this,{locale:a})},getPrecision:function(){return g},convertPrecision:function(a){return assertInteger(a),m.call(this,{amount:calculator$1.multiply(this.getAmount(),c(10,calculator$1.subtract(a,this.getPrecision()))),precision:a})},add:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return m.call(this,{amount:calculator$1.add(c[0].getAmount(),c[1].getAmount()),precision:c[0].getPrecision()})},subtract:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return m.call(this,{amount:calculator$1.subtract(c[0].getAmount(),c[1].getAmount()),precision:c[0].getPrecision()})},multiply:function(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:j;return m.call(this,{amount:calculator$1.round(calculator$1.multiply(this.getAmount(),a),b)})},divide:function(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:j;return m.call(this,{amount:calculator$1.round(calculator$1.divide(this.getAmount(),a),b)})},percentage:function(a){return assertPercentage(a),this.multiply(calculator$1.divide(a,100))},allocate:function(a){var b=this;assertValidRatios(a);for(var c=a.reduce(function(c,a){return calculator$1.add(c,a)}),d=this.getAmount(),e=a.map(function(a){var e=Math.floor(calculator$1.divide(calculator$1.multiply(b.getAmount(),a),c));return d=calculator$1.subtract(d,e),m.call(b,{amount:e})}),f=0;0<d;f++)e[f]=e[f].add(m.call(this,{amount:1})),d=calculator$1.subtract(d,1);return e},convert:function(a,b){var c=this;return b=Object.assign({},l,b),CurrencyConverter(b).getExchangeRate(this.getCurrency(),a).then(function(d){return assert(!isUndefined(d),new TypeError('No rate was found for the destination currency "'+a+'".')),m.call(c,{amount:calculator$1.round(calculator$1.multiply(c.getAmount(),parseFloat(d)),b.roundingMode),currency:a})})},equalsTo:function(a){return this.hasSameAmount(a)&&this.hasSameCurrency(a)},lessThan:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return c[0].getAmount()<c[1].getAmount()},lessThanOrEqual:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return c[0].getAmount()<=c[1].getAmount()},greaterThan:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return c[0].getAmount()>c[1].getAmount()},greaterThanOrEqual:function(b){n.call(this,b);var c=a.normalizePrecision([this,b]);return c[0].getAmount()>=c[1].getAmount()},isZero:function(){return 0===this.getAmount()},isPositive:function(){return 0<=this.getAmount()},isNegative:function(){return 0>this.getAmount()},hasSubUnits:function(){return 0!==calculator$1.modulo(this.getAmount(),c(10,g))},hasCents:function(){return 0!==calculator$1.modulo(this.getAmount(),c(10,g))},hasSameCurrency:function(a){return this.getCurrency()===a.getCurrency()},hasSameAmount:function(b){var c=a.normalizePrecision([this,b]);return c[0].getAmount()===c[1].getAmount()},toFormat:function(){var a=0<arguments.length&&arguments[0]!==void 0?arguments[0]:i,b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:k,c=Format(a);return this.toRoundedUnit(c.getMinimumFractionDigits(),b).toLocaleString(this.getLocale(),{currencyDisplay:c.getCurrencyDisplay(),useGrouping:c.getUseGrouping(),minimumFractionDigits:c.getMinimumFractionDigits(),style:c.getStyle(),currency:this.getCurrency()})},toUnit:function(){return calculator$1.divide(this.getAmount(),c(10,g))},toRoundedUnit:function(a){var b=1<arguments.length&&arguments[1]!==void 0?arguments[1]:k,d=c(10,a);return calculator$1.divide(calculator$1.round(calculator$1.multiply(this.toUnit(),d),b),d)},toObject:function(){return{amount:e,currency:f,precision:g}}}},dinero=Object.assign(Dinero,Defaults,Globals,Static);module.exports=dinero;
