<?php
return [
    'plugin' => [
        'name' => 'Image Resizer',
        'description' => 'Добавляет фильтры, позволяющие обрабатывать изображения на лету (изменение размера, обрезка и пр.) с кешированием',
    ],
    'permissions' => [
        'tab' => 'Image Resizer',
        'access_settings' => 'Настройки обработки изображений',
    ],
    'settings' => [
        'tabs' => [
            'main' => 'Основные',
            'filters' => 'Фильтры'
        ],
        'sections' => [
            '_404' => [
                'label' => 'Изображение не найдено',
                'comment' => 'Выберите, как поступить, если изображение не найдено'
            ]
        ],
        'fields' => [
            'driver' => [
                'label' => 'PHP-драйвер для обработки изображений',
                'comment' => 'Выберите драйвер (только поддерживаемые библиотекой intervention\image)',
                'options' => [
                    'gd' => 'Библиотека GD',
                    'imagick' => 'Расширение Imagick'
                ],
            ],
            'mode' => [
                'label' => 'Режим по-умолчанию',
                'comment' => 'Выберите режим, который будет использоваться, если заданы фиксированные значения ширины и высоты (поддерживаются опции CSS "background-size", с дополнительным режимом "stretch")',
                'options' => [
                    'auto' => 'Автоматически',
                    'contain' => 'Вписать (contain)',
                    'cover' => 'Заполнить (cover)',
                    'stretch' => 'Растянуть (stretch)',
                ],
            ],
            'format' => [
                'label' => 'Формат генерируемых изображений',
                'comment' => 'Выберите формат, в котором будут выводиться генерируемые изображения',
                'options' => [
                    'auto' => 'Автоматически (исходный формат)',
                    'jpg' => 'JPG',
                    'png' => 'PNG',
                    'webp' => 'WEBP',
                    'bmp' => 'BMP',
                    'gif' => 'GIF',
                    'ico' => 'ICO',
                ]
            ],
            'quality' => [
                'label' => 'Качество по-умолчанию',
                'comment' => 'Выберите качество генерируемых изображений (1-100)'
            ],
            'image_not_found' => [
                'label' => '404 Изображение не найдено',
                'comment' => 'Выберите изображение, которое будет выводиться, если исходное не найдено',
            ],
            'image_not_found_background' => [
                'label' => 'Цвет фона изображения 404',
                'comment' => 'Выберите цвет фона для изображения, заданного выше',
            ],
            'image_not_found_mode' => [
                'label' => 'Режим по-умолчанию изображения 404',
                'comment' => 'Выберите режим изменения размера для изображения 404',
            ],
            'image_not_found_format' => [
                'label' => 'Формат изображения 404',
                'comment' => 'Выберите формат, в котором будут выводиться изображения 404',
            ],
            'image_not_found_quality' => [
                'label' => 'Качество по-умолчанию изображения 404',
                'comment' => 'Выберите качество генерируемых изображений 404 (1-100)',
            ],
            'background' => [
                'label' => 'Фон по-умолчанию',
                'comment' => 'Выберите цвет, который будет замещать прозрачные участки изображений с прозрачностью (png, webp) при конвертировании в форматы, не поддерживающие прозрачность (jpg, etc)',
            ],
            'filters' => [
                'label' => 'Фильтры',
                'prompt' => 'Добавить фильтр',
                'fields' => [
                    'code' => [
                        'label' => 'Код фильтра',
                        'comment' => 'Используется при ссылке на фильтр',
                    ],
                    'description' => [
                        'label' => 'Описание',
                        'comment' => 'Напишите описание для этого фильтра',
                    ],
                    'rules' => [
                        'label' => 'Правила / Модификации',
                        'prompt' => 'Добавить новое правило',
                        'fields' => [
                            'modifier' => [
                                'label' => 'Свойство',
                                'comment' => 'Выберите свойство',
                                'options' => [
                                    'width' => 'Ширина',
                                    'height' => 'Высота',
                                    'min_width' => 'Минимальная ширина',
                                    'min_height' => 'Минимальная высота',
                                    'max_width' => 'Максимальная ширина',
                                    'max_height' => 'Максимальная высота',
                                    'blur' => 'Размытие',
                                    'sharpen' => 'Резкость',
                                    'brightness' => 'Яркость',
                                    'contrast' => 'Контрастность',
                                    'pixelate' => 'Пикселизация',
                                    'greyscale' => 'Оттенки серого',
                                    'invert' => 'Инвертировать',
                                    'opacity' => 'Прозрачность',
                                    'rotate' => 'Поворот',
                                    'flip' => 'Отражение',
                                    'background' => 'Цвет фона',
                                    'colorize' => 'Изменение оттенка',
                                    'format' => 'Формат',
                                    'quality' => 'Качество',
                                    'mode' => 'Режим',
                                ]
                            ],
                            'value' => [
                                'label' => 'Значение',
                                'comment' => 'Задайте значение для выбранного свойства',
                            ]
                        ]
                    ]
                ]
            ]
        ],
    ],
];
