<div>

    <!-- Search -->
    <form
        role="form"
        id="installPluginsForm"
        data-handler="onInstallPlugin"
        onsubmit="$.wn.installProcess.searchSubmit(this); return false">
        <div class="product-search">
            <input
                name="code"
                id="pluginSearchInput"
                class="product-search-input search-input-lg typeahead"
                placeholder="<?= e(trans('system::lang.plugins.search')) ?>"
                data-search-type="plugins"
                />
            <i class="icon icon-search"></i>
            <i class="icon loading" style="display: none"></i>
        </div>
    </form>

    <div class="row">

        <div class="col-md-7">

            <!-- Installed plugins -->
            <div id="pluginList"
                class="product-list-manager">

                <h4 class="section-header">
                    <a href="<?= Backend::url('system/updates') ?>"><?= e(trans('system::lang.plugins.installed')) ?></a>
                    <small>(<span class="product-counter"><?= count($installedPlugins) ?></span>)</small>
                </h4>

                <?php if (!count($installedPlugins)): ?>
                    <div class="product-list-empty">
                        <p><?= e(trans('system::lang.plugins.no_plugins')) ?></p>
                    </div>
                <?php else: ?>
                    <ul class="product-list plugin-list">
                        <?php foreach ($installedPlugins as $plugin): ?>

                            <li data-code="<?= $plugin['code'] ?>">
                                <div class="image">
                                    <img src="<?= $plugin['image'] ?>" alt="">
                                </div>
                                <div class="details">
                                    <h4><?= $plugin['name'] ?></h4>
                                    <p><?= e(trans('system::lang.plugin.by_author', ['name' => $plugin['author']])) ?></p>
                                </div>
                                <button
                                    type="button"
                                    class="close"
                                    aria-hidden="true"
                                    data-request="onRemovePlugin"
                                    data-request-data="code: '<?= $plugin['code'] ?>'"
                                    data-request-confirm="<?= e(trans('system::lang.plugins.remove_confirm')) ?>"
                                    data-stripe-load-indicator>
                                    &times;
                                </button>
                            </li>

                        <?php endforeach ?>
                    </ul>
                <?php endif ?>

            </div>

        </div>
        <div class="col-md-5">

            <!-- Recommended extras -->
            <div class="suggested-products-container">
                <h4 class="section-header"><?= e(trans('system::lang.plugins.recommended')) ?></h4>
                <div class="scroll-panel">
                    <div
                        id="suggestedPlugins"
                        class="suggested-products suggested-plugins"
                        data-handler="onGetPopularPlugins"
                        data-view="plugin/suggestion"></div>
                </div>
            </div>

        </div>

    </div>

</div>

<script type="text/template" data-partial="plugin/suggestion">
    <div class="product">
        <a
            data-control="popup"
            data-handler="onInstallPlugin"
            data-request-data="code: '{{code}}'"
            href="javascript:;">
            <div class="image"><img src="{{image}}" alt=""></div>
            <div class="details">
                <h5 class="text-overflow">{{code}}</h5>
                <p>{{description}}</p>
            </div>
        </a>
    </div>
</script>
