<div
    data-control="sensitive"
    data-clean="true"
    data-event-handler="<?= $this->getEventHandler('onShowValue') ?>"
    <?php if ($hideOnTabChange): ?>
        data-hide-on-tab-change="true"
    <?php endif ?>
>
    <div class="loading-indicator-container size-form-field">
        <div class="input-group">
            <input
                type="password"
                name="<?= $this->getFieldName() ?>"
                id="<?= $this->getId() ?>"
                value="<?= ($hasValue) ? $hiddenPlaceholder : '' ?>"
                placeholder="<?= e(trans($this->formField->placeholder)) ?>"
                class="form-control"
                <?php if ($this->previewMode): ?>
                    disabled="disabled"
                <?php endif ?>
                autocomplete="off"
                data-input
            />
            <?php if ($allowCopy): ?>
            <a
                href="javascript:;"
                class="input-group-addon btn btn-secondary"
                data-copy
            >
                <i class="icon-copy"></i>
            </a>
            <?php endif ?>
            <a
                href="javascript:;"
                class="input-group-addon btn btn-secondary"
                data-toggle
            >
                <i class="icon-eye" data-icon></i>
            </a>
        </div>
        <div class="loading-indicator hide" data-loader>
            <span class="p-a"></span>
        </div>
    </div>
</div>
