<?php

return [
    'plugin' => [
        'name' => 'Конструктор плагинов',
        'description' => 'Предоставляет визуальные инструменты для создания плагинов Winter CMS.',
        'add' => 'Создать плагин',
        'no_records' => 'Плагины не найдены',
        'no_name' => 'Без имени',
        'search' => 'Поиск...',
        'filter_description' => 'Отображать все плагины или только ваши плагины.',
        'settings' => 'Настройки',
        'entity_name' => 'Плагин',
        'field_name' => 'Имя',
        'field_author' => 'Автор',
        'field_description' => 'Описание',
        'field_icon' => 'Иконка плагина',
        'field_plugin_namespace' => 'Пространство имён плагина',
        'field_author_namespace' => 'Пространство имён автора',
        'field_namespace_description' => 'Пространство имён может содержать только латинские буквы и цифры и должно начинаться с латинской буквы. Пример пространства имён плагина: Blog',
        'field_author_namespace_description' => 'Вы не можете изменить пространства имён с помощью Конструктора после создания плагина. Пример пространства имён автора: JohnSmith',
        'tab_general' => 'Общие параметры',
        'tab_description' => 'Описание',
        'field_homepage' => 'Ссылка на сайт плагина (если есть)',
        'no_description' => 'Описание для этого плагина не предусмотрено',
        'error_settings_not_editable' => 'Настройки этого плагина не могут быть отредактированы с помощью Конструктора.',
        'update_hint' => 'Вы можете редактировать название и описание локализованного плагина на вкладке Локализация.',
        'manage_plugins' => 'Создавайте и редактируйте плагины',
    ],
    'author_name' => [
        'title' => 'Имя автора',
        'description' => 'Имя автора по умолчанию, используемое при создании новых плагинов. Имя автора не является фиксированным — можно изменить его в конфигурации плагинов в любое время.',
    ],
    'author_namespace' => [
        'title' => 'Пространство имён автора',
        'description' => 'Если вы разрабатываете для Marketplace, пространство имён должно соответствовать авторскому коду и не может быть изменено. Подробности см. в документации.',
    ],
    'database' => [
        'menu_label' => 'База данных',
        'no_records' => 'Таблицы не найдены',
        'search' => 'Поиск...',
        'confirmation_delete_multiple' => 'Удалить выбранные таблицы?',
        'field_name' => 'Имя таблицы',
        'tab_columns' => 'Столбцы',
        'column_name_name' => 'Столбец',
        'column_name_required' => 'Пожалуйста, укажите имя столбца',
        'column_name_type' => 'Тип',
        'column_type_required' => 'Пожалуйста, выберите тип столбца',
        'column_name_length' => 'Длина',
        'column_validation_length' => 'Значение длины должно быть целым или дробным (для десятичных столбцов) числом. Пробелы не допускаются.',
        'column_validation_title' => 'В именах столбцов допускаются только цифры, строчные латинские буквы и символы подчеркивания',
        'column_name_unsigned' => 'Unsigned',
        'column_name_nullable' => 'Nullable',
        'column_auto_increment' => 'Столбец с автоприращением',
        'column_default' => 'Значение по умолчанию',
        'column_auto_primary_key' => 'PK',
        'tab_new_table' => 'Новая таблица',
        'btn_add_column' => 'Добавить столбец',
        'btn_delete_column' => 'Удалить столбец',
        'btn_add_id' => 'Добавить ID',
        'btn_add_timestamps' => 'Добавить временные метки',
        'btn_add_soft_deleting' => 'Добавить поддержку мягкого удаления',
        'id_exists' => 'Столбец ID уже существует в таблице.',
        'timestamps_exist' => 'Столбцы created_at и deleted_at уже существуют в таблице.',
        'soft_deleting_exist' => 'Столбец deleted_at уже существует в таблице.',
        'confirm_delete' => 'Удалить таблицу?',
        'error_enum_not_supported' => 'Таблица содержит один или несколько столбцов с типом "enum", который на данный момент не поддерживается Конструктором.',
        'error_table_name_invalid_prefix' => "Имя таблицы должно начинаться с префикса плагина: ':prefix'.",
        'error_table_name_invalid_characters' => 'Недопустимое имя таблицы. Имена таблиц должны содержать только латинские буквы, цифры и знаки подчеркивания. Имена должны начинаться с латинской буквы и не должны содержать пробелов.',
        'error_table_duplicate_column' => "Дублирование имени столбца: ':column'.",
        'error_table_auto_increment_in_compound_pk' => 'Автоинкрементный столбец не может быть частью составного первичного ключа.',
        'error_table_mutliple_auto_increment' => 'Таблица не может содержать несколько автоинкрементных столбцов.',
        'error_table_auto_increment_non_integer' => 'Автоинкрементные столбцы должны иметь целочисленный тип.',
        'error_table_decimal_length' => "Параметр длины для типа :type должен быть в формате '10,2', без пробелов.",
        'error_table_length' => 'Параметр длины для типа :type должен быть задан в виде целого числа.',
        'error_unsigned_type_not_int' => "Ошибка в столбце ':column'. Флаг Unsigned может быть применен только к столбцам целочисленного типа.",
        'error_integer_default_value' => "Недопустимое значение по умолчанию для целочисленного столбца ':column'. Допустимыми значениями являются '10', '-10'.",
        'error_decimal_default_value' => "Недопустимое значение по умолчанию для decimal или double столбца ':column'. Допустимыми значениями являются '1.00', '-1.00'.",
        'error_boolean_default_value' => "Недопустимое значение по умолчанию для boolean столбца ':column'. Допустимыми значениями являются '0' и '1', или 'true' и 'false'.",
        'error_unsigned_negative_value' => "Значение по умолчанию для unsigned столбца ':column' не может быть отрицательным.",
        'error_table_already_exists' => "Таблица ':name' уже существует в базе данных.",
        'error_table_name_too_long' => "Имя таблицы не должно быть длиннее 64 символов.",
        'error_column_name_too_long' => "Имя столбца ':column' слишком длинное. Имена столбцов не должны быть длиннее 64 символов."
    ],
    'model' => [
        'menu_label' => 'Модели',
        'entity_name' => 'Модель',
        'no_records' => 'Модели не найдены',
        'search' => 'Поиск...',
        'add' => 'Добавить...',
        'forms' => 'Формы',
        'lists' => 'Списки',
        'field_class_name' => 'Имя класса',
        'field_database_table' => 'Таблица в базе данных',
        'field_add_timestamps' => 'Добавить поддержку временных меток',
        'field_add_timestamps_description' => 'Таблица базы данных должна иметь столбцы created_at и updated_at.',
        'field_add_soft_deleting' => 'Добавить поддержку мягкого удаления',
        'field_add_soft_deleting_description' => 'Таблица базы данных должна иметь столбец deleted_at.',
        'error_class_name_exists' => 'Для указанного имени класса уже существует файл модели: :path',
        'error_timestamp_columns_must_exist' => 'Таблица базы данных должна иметь столбцы created_at и updated_at.',
        'error_deleted_at_column_must_exist' => 'Таблица базы данных должна иметь столбец deleted_at.',
        'add_form' => 'Добавить форму',
        'add_list' => 'Добавить список',
    ],
    'form' => [
        'saved' => 'Форма сохранена',
        'confirm_delete' => 'Удалить форму?',
        'tab_new_form' => 'Новая форма',
        'property_label_title' => 'Метка',
        'property_label_required' => 'Пожалуйста, укажите контрольную метку.',
        'property_span_title' => 'Размещение',
        'property_comment_title' => 'Комментарий',
        'property_comment_above_title' => 'Комментарий выше',
        'property_default_title' => 'По умолчанию',
        'property_checked_default_title' => 'Отмечено по умолчанию',
        'property_css_class_title' => 'Класс CSS',
        'property_css_class_description' => 'Необязательный CSS-класс для присвоения контейнеру поля.',
        'property_disabled_title' => 'Отключен',
        'property_read_only_title' => 'Только для чтения',
        'property_hidden_title' => 'Скрытое поле',
        'property_required_title' => 'Обязательно для заполнения',
        'property_field_name_title' => 'Имя поля',
        'property_placeholder_title' => 'Заполнитель',
        'property_default_from_title' => 'По умолчанию из',
        'property_stretch_title' => 'Растягивать',
        'property_stretch_description' => 'Указывает, растягивается ли это поле, чтобы соответствовать высоте родительского поля.',
        'property_context_title' => 'Контекст',
        'property_context_description' => 'Указывает, какой контекст формы должен использоваться при отображении поля.',
        'property_context_create' => 'Создать',
        'property_context_update' => 'Обновить',
        'property_context_preview' => 'Превью',
        'property_dependson_title' => 'Зависит от',
        'property_trigger_action' => 'Действие',
        'property_trigger_show' => 'Показать',
        'property_trigger_hide' => 'Скрыть',
        'property_trigger_enable' => 'Включить',
        'property_trigger_disable' => 'Отключить',
        'property_trigger_empty' => 'Пустое',
        'property_trigger_field' => 'Поле',
        'property_trigger_field_description' => 'Определяет имя другого поля, которое будет вызывать действие.',
        'property_trigger_condition' => 'Условие',
        'property_trigger_condition_description' => 'Определяет условие, которому должно удовлетворять указанное поле, чтобы условие считалось "истинным". Поддерживаемые значения: checked, unchecked, value[somevalue].',
        'property_trigger_condition_checked' => 'Отмечено',
        'property_trigger_condition_unchecked' => 'Не отмечено',
        'property_trigger_condition_somevalue' => 'value[укажите-здесь-значение]',
        'property_preset_title' => 'Пресет',
        'property_preset_description' => 'Позволяет первоначально установить значение поля значением другого поля, преобразованным с помощью входного предустановленного конвертера.',
        'property_preset_field' => 'Поле',
        'property_preset_field_description' => 'Определяет имя другого поля, из которого будет взято значение.',
        'property_preset_type' => 'Тип',
        'property_preset_type_description' => 'Указывает тип преобразования',
        'property_attributes_title' => 'Атрибуты',
        'property_attributes_description' => 'Пользовательские атрибуты HTML для добавления к элементу поля формы.',
        'property_container_attributes_title' => 'Атрибуты контейнера',
        'property_container_attributes_description' => 'Пользовательские атрибуты HTML для добавления в элемент контейнера поля формы.',
        'property_group_advanced' => 'Дополнительно',
        'property_dependson_description' => 'Список имён других полей, от которых зависит данное поле; при изменении других полей данное поле будет обновлено. Одно поле на строку.',
        'property_trigger_title' => 'Триггер',
        'property_trigger_description' => 'Позволяет изменять атрибуты элементов, такие как видимость или значение, основываясь на состоянии другого элемента.',
        'property_default_from_description' => 'Берет значение по умолчанию из значения другого поля.',
        'property_field_name_required' => 'Имя поля является обязательным',
        'property_field_name_regex' => 'Имя поля может содержать только латинские буквы, цифры, знаки подчеркивания, тире и квадратные скобки.',
        'property_attributes_size' => 'Размер',
        'property_attributes_size_tiny' => 'Крошечный',
        'property_attributes_size_small' => 'Небольшой',
        'property_attributes_size_large' => 'Большой',
        'property_attributes_size_huge' => 'Огромный',
        'property_attributes_size_giant' => 'Гигантский',
        'property_comment_position' => 'Расположение комментария',
        'property_comment_position_above' => 'Выше',
        'property_comment_position_below' => 'Ниже',
        'property_hint_path' => 'Путь к файлу фрагмента с подсказкой',
        'property_hint_path_description' => 'Путь к файлу фрагмента, содержащему текст подсказки. Используйте символ $ для ссылки на корневой каталог плагинов, например: $/acme/blog/partials/_hint.htm',
        'property_hint_path_required' => 'Пожалуйста, укажите путь к файлу фрагмента с текстом подсказки',
        'property_partial_path' => 'Путь к файлу фрагмента',
        'property_partial_path_description' => 'Путь к файлу фрагмента. Используйте символ $ для ссылки на корневой каталог плагинов, например: $/acme/blog/partials/_partial.htm',
        'property_partial_path_required' => 'Пожалуйста, укажите путь к файлу фрагмента',
        'property_code_language' => 'Язык',
        'property_code_theme' => 'Тема',
        'property_theme_use_default' => 'Использовать тему по умолчанию',
        'property_group_code_editor' => 'Редактор кода',
        'property_gutter' => 'Gutter',
        'property_gutter_show' => 'Видим',
        'property_gutter_hide' => 'Скрыт',
        'property_wordwrap' => 'Перенос слов',
        'property_wordwrap_wrap' => 'Переносить',
        'property_wordwrap_nowrap' => 'Не переносить',
        'property_fontsize' => 'Размер шрифта',
        'property_codefolding' => 'Сворачивание кода',
        'property_codefolding_manual' => 'Вручную',
        'property_codefolding_markbegin' => 'Отмечать начало',
        'property_codefolding_markbeginend' => 'Отмечать начало и конец',
        'property_autoclosing' => 'Автоматическое закрытие',
        'property_enabled' => 'Включено',
        'property_disabled' => 'Выключено',
        'property_soft_tabs' => 'Табуляция по умолчанию',
        'property_tab_size' => 'Размер табуляции',
        'property_readonly' => 'Только для чтения',
        'property_use_default' => 'Использовать настройки по умолчанию',
        'property_options' => 'Параметры',
        'property_prompt' => 'Prompt',
        'property_prompt_description' => 'Текст, отображаемый для кнопки создания.',
        'property_prompt_default' => 'Добавить новый пункт',
        'property_available_colors' => 'Доступные цвета',
        'property_available_colors_description' => 'Список доступных цветов в шестнадцатеричном формате (#FF0000). Оставьте пустым для набора цветов по умолчанию. Введите одно значение на строку.',
        'property_datepicker_mode' => 'Режим',
        'property_datepicker_mode_date' => 'Дата',
        'property_datepicker_mode_datetime' => 'Дата и время',
        'property_datepicker_mode_time' => 'Время',
        'property_datepicker_min_date' => 'Минимальная дата',
        'property_datepicker_min_date_description' => 'Минимальная/самая ранняя дата, которую можно выбрать. Это может быть любая строка, принимаемая Carbon. Оставьте пустым для отключения минимальной даты.',
        'property_datepicker_max_date' => 'Максимальная дата',
        'property_datepicker_max_date_description' => 'Максимальная/самая поздняя дата, которую можно выбрать. Это может быть любая строка, принимаемая Carbon. Оставьте пустым для отключения максимальной даты.',
        'property_datepicker_year_range' => 'Годовой диапазон',
        'property_datepicker_year_range_description' => 'Количество лет по обе стороны (например, 10) или массив верхнего/нижнего диапазона (например, [1900,2015]). Оставьте пустым для значения по умолчанию (10).',
        'property_datepicker_year_range_invalid_format' => 'Неверный формат диапазона. Используйте число (например, "10") или массив верхнего/нижнего диапазона (например, "[1900,2015]")',
        'property_datepicker_format' => 'Формат',
        'property_datepicker_year_format_description' => 'Определите пользовательский формат даты. По умолчанию используется формат "Y-m-d"',
        'property_markdown_mode' => 'Режим',
        'property_markdown_mode_split' => 'Split',
        'property_markdown_mode_tab' => 'Tab',
        'property_fileupload_mode' => 'Режим',
        'property_fileupload_mode_file' => 'Файл',
        'property_fileupload_mode_image' => 'Изображение',
        'property_group_fileupload' => 'Загрузка файлов',
        'property_fileupload_prompt' => 'Prompt',
        'property_fileupload_prompt_description' => 'Текст, отображаемый для кнопки загрузки, применяется только для режима "Файл", необязательный.',
        'property_fileupload_image_width' => 'Ширина изображения',
        'property_fileupload_image_width_description' => 'Необязательный параметр - размер изображений будет изменен до этой ширины. Применяется только для режима "Изображение".',
        'property_fileupload_invalid_dimension' => 'Неверное значение размера - пожалуйста, введите число.',
        'property_fileupload_image_height' => 'Высота изображения',
        'property_fileupload_image_height_description' => 'Необязательный параметр - размер изображений будет изменен до этой высоты. Применяется только для режима "Изображение".',
        'property_fileupload_file_types' => 'Типы файлов',
        'property_fileupload_file_types_description' => 'Необязательный список расширений файлов, которые принимаются загрузчиком. Например: zip,txt',
        'property_fileupload_mime_types' => 'MIME-типы',
        'property_fileupload_mime_types_description' => 'Необязательный список типов MIME, которые принимаются загрузчиком, либо в виде расширений файлов, либо в виде полностью определенных имен. Например: bin,txt',
        'property_fileupload_use_caption' => 'Использовать заголовок',
        'property_fileupload_use_caption_description' => 'Позволяет задать название и описание для файла.',
        'property_fileupload_thumb_options' => 'Параметры миниатюр',
        'property_fileupload_thumb_options_description' => 'Управление параметрами автоматически создаваемых миниатюр. Применяется только для режима "Изображение".',
        'property_fileupload_thumb_mode' => 'Режим',
        'property_fileupload_thumb_auto' => 'Авто',
        'property_fileupload_thumb_exact' => 'Копия',
        'property_fileupload_thumb_portrait' => 'Портрет',
        'property_fileupload_thumb_landscape' => 'Ландшафт',
        'property_fileupload_thumb_crop' => 'Обрезка',
        'property_fileupload_thumb_extension' => 'Расширение файла',
        'property_name_from' => 'Имя столбца',
        'property_name_from_description' => 'Имя столбца отношения, используемое для отображения имени.',
        'property_relation_select' => 'Выбрать',
        'property_relation_select_description' => 'CONCAT нескольких столбцов вместе для отображения имени',
        'property_relation_scope' => 'Scope',
        'property_relation_scope_description' => 'Указывает метод области действия запроса, определенный в модели связанной формы, чтобы всегда применяться к запросу списка.',
        'property_description_from' => 'Столбец описания',
        'property_description_from_description' => 'Имя столбца отношения, используемое для отображения описания.',
        'property_recordfinder_prompt' => 'Prompt',
        'property_recordfinder_prompt_description' => 'Текст, отображаемый при отсутствии выбранной записи. Символ %s представляет собой значок поиска. Оставьте пустым для подсказки по умолчанию.',
        'property_recordfinder_list' => 'Конфигурация списка',
        'property_recordfinder_list_description' => 'Ссылка на файл определения колонки списка. Используйте символ $ для ссылки на корневой каталог плагинов, например: $/acme/blog/lists/_list.yaml',
        'property_recordfinder_list_required' => 'Пожалуйста, укажите путь к YAML-файлу списка',
        'property_group_recordfinder' => 'Поиск записей',
        'property_mediafinder_mode' => 'Режим',
        'property_mediafinder_mode_file' => 'Файл',
        'property_mediafinder_mode_image' => 'Изображение',
        'property_mediafinder_prompt' => 'Prompt',
        'property_mediafinder_prompt_description' => 'Текст, отображаемый при отсутствии выбранного элемента. Символ %s представляет собой значок медиаменеджера. Оставьте пустым для подсказки по умолчанию.',
        'property_mediafinder_image_width_description' => 'Если используется тип изображения, изображение предварительного просмотра будет отображаться с этой шириной, необязательно.',
        'property_mediafinder_image_height_description' => 'Если используется тип изображения, изображение предварительного просмотра будет отображаться с этой высотой, необязательно.',
        'property_group_taglist' => 'Список тегов',
        'property_taglist_mode' => 'Режим',
        'property_taglist_mode_description' => 'Определяет формат, в котором возвращается значение этого поля',
        'property_taglist_mode_string' => 'Строка',
        'property_taglist_mode_array' => 'Массив',
        'property_taglist_mode_relation' => 'Связь',
        'property_taglist_separator' => 'Разделитель',
        'property_taglist_separator_comma' => 'Запятые',
        'property_taglist_separator_space' => 'Пробелы',
        'property_taglist_options' => 'Предопределенные теги',
        'property_taglist_custom_tags' => 'Пользовательские теги',
        'property_taglist_custom_tags_description' => 'Разрешить пользователю вводить пользовательские теги вручную.',
        'property_taglist_name_from' => 'Имя из',
        'property_taglist_name_from_description' => 'Определяет атрибут модели отношения, отображаемый в теге. Используется только в режиме "Связь".',
        'property_taglist_use_key' => 'Использовать ключ',
        'property_taglist_use_key_description' => 'Если флажок установлен, список тегов будет использовать ключ вместо значения для сохранения и чтения данных. Используется только в режиме "Связь".',
        'property_group_relation' => 'Связь',
        'property_relation_prompt' => 'Prompt',
        'property_relation_prompt_description' => 'Текст для отображения при отсутствии доступных вариантов выбора.',
        'property_empty_option' => 'Пустая опция',
        'property_empty_option_description' => 'Пустой вариант соответствует пустому выделению, но в отличие от заполнителя он может быть выбран повторно.',
        'property_show_search' => 'Отображать поиск',
        'property_show_search_description' => 'Включает функцию поиска для этого выпадающего списка.',
        'property_title_from' => 'Заголовок из',
        'property_title_from_description' => 'Укажите имя дочернего поля, чтобы использовать значение этого поля в качестве заголовка для каждого элемента повторителя.',
        'property_min_items' => 'Минимум элементов',
        'property_min_items_description' => 'Минимальное количество элементов, разрешенных в повторителе.',
        'property_min_items_integer' => 'Минимальное количество элементов должно быть целым положительным числом.',
        'property_max_items' => 'Максимум элементов',
        'property_max_items_description' => 'Максимальное количество элементов, разрешенных в повторителе.',
        'property_max_items_integer' => 'Максимальное количество элементов должно быть целым положительным числом.',
        'property_style' => 'Стиль',
        'property_style_description' => 'Определяет поведение, применяемое к этому повторителю.',
        'control_group_standard' => 'Стандарт',
        'control_group_widgets' => 'Виджеты',
        'click_to_add_control' => 'Добавить элемент',
        'loading' => 'Загрузка...',
        'control_text' => 'Текст',
        'control_text_description' => 'Однострочное текстовое поле',
        'control_password' => 'Пароль',
        'control_password_description' => 'Однострочное текстовое поле для ввода пароля',
        'control_checkbox' => 'Флажок',
        'control_checkbox_description' => 'Отдельный флажок',
        'control_switch' => 'Переключатель',
        'control_switch_description' => 'Одиночный переключатель, альтернатива флажку',
        'control_textarea' => 'Текстовая область',
        'control_textarea_description' => 'Многострочное текстовое поле с регулируемой высотой',
        'control_dropdown' => 'Раскрывающийся список',
        'control_dropdown_description' => 'Выпадающий список со статическими или динамическими опциями',
        'control_balloon-selector' => 'Balloon-список',
        'control_balloon-selector_description' => 'Список, в котором одновременно может быть выбран только один элемент, со статическими или динамическими опциями',
        'control_unknown' => 'Неизвестный тип управления: :type',
        'control_repeater' => 'Повторитель',
        'control_repeater_description' => 'Выводит повторяющийся набор элементов управления формы',
        'control_number' => 'Число',
        'control_number_description' => 'Однострочное текстовое поле, которое принимает только числа',
        'control_hint' => 'Подсказка',
        'control_hint_description' => 'Выводит содержимое подсказки в поле, которое может быть скрыто пользователем',
        'control_partial' => 'Фрагмент',
        'control_partial_description' => 'Выводит содержимое файла фрагмента',
        'control_section' => 'Секция',
        'control_section_description' => 'Отображает секцию формы с заголовком и подзаголовком',
        'control_radio' => 'Переключатели',
        'control_radio_description' => 'Список переключателей, в котором одновременно может быть выбран только один элемент',
        'control_radio_option_1' => 'Вариант 1',
        'control_radio_option_2' => 'Вариант 2',
        'control_checkboxlist' => 'Список флажков',
        'control_checkboxlist_description' => 'Список флажков, в котором можно выбрать несколько элементов',
        'control_codeeditor' => 'Редактор кода',
        'control_codeeditor_description' => 'Редактор обычного текста для форматированного кода или разметки',
        'control_colorpicker' => 'Выбор цвета',
        'control_colorpicker_description' => 'Поле для выбора шестнадцатеричного значения цвета',
        'control_datepicker' => 'Выбор даты',
        'control_datepicker_description' => 'Текстовое поле, используемое для выбора даты и времени',
        'control_richeditor' => 'Расширенный редактор',
        'control_richeditor_description' => 'Визуальный редактор для форматированного текста, также известный как WYSIWYG-редактор',
        'control_markdown' => 'Редактор Markdown',
        'control_markdown_description' => 'Базовый редактор для текста в формате Markdown',
        'control_taglist' => 'Список тегов',
        'control_taglist_description' => 'Поле для ввода списка тегов',
        'control_fileupload' => 'Загрузка файлов',
        'control_fileupload_description' => 'Загрузчик файлов для изображений или обычных файлов',
        'control_recordfinder' => 'Поиск записей',
        'control_recordfinder_description' => 'Поле с информацией о связанной записи с функцией поиска',
        'control_mediafinder' => 'Поиск медиа',
        'control_mediafinder_description' => 'Поле для выбора элемента из библиотеки Media Manager',
        'control_relation' => 'Связь',
        'control_relation_description' => 'Отображает выпадающий список или список с флажками для выбора связанной записи',
        'error_file_name_required' => 'Пожалуйста, введите имя файла формы.',
        'error_file_name_invalid' => 'Имя файла может содержать только латинские буквы, цифры, знаки подчеркивания, точки и хэши.',
        'span_left' => 'Слева',
        'span_right' => 'Справа',
        'span_full' => 'На всю ширину',
        'span_auto' => 'Авто',
        'style_default' => 'По умолчанию',
        'style_collapsed' => 'Свёрнутый',
        'style_accordion' => 'Аккордеон',
        'empty_tab' => 'Пустая вкладка',
        'confirm_close_tab' => 'Вкладка содержит элементы управления, которые будут удалены. Продолжить?',
        'tab' => 'Вкладка формы',
        'tab_title' => 'Заголовок',
        'controls' => 'Элементы управления',
        'property_tab_title_required' => 'Заголовок вкладки является обязательным.',
        'tabs_primary' => 'Основные вкладки',
        'tabs_secondary' => 'Дополнительные вкладки',
        'tab_stretch' => 'Stretch',
        'tab_stretch_description' => 'Определяет, растягивается ли этот контейнер вкладок, чтобы соответствовать высоте родительского контейнера.',
        'tab_css_class' => 'Класс CSS',
        'tab_css_class_description' => 'Присваивает класс CSS контейнеру вкладок.',
        'tab_name_template' => 'Вкладка %s',
        'tab_already_exists' => 'Вкладка с указанным названием уже существует.',
    ],
    'list' => [
        'tab_new_list' => 'Новый список',
        'saved' => 'Список сохранён',
        'confirm_delete' => 'Удалить список?',
        'tab_columns' => 'Столбцы',
        'btn_add_column' => 'Добавить столбец',
        'btn_delete_column' => 'Удалить столбец',
        'column_dbfield_label' => 'Поле',
        'column_dbfield_required' => 'Пожалуйста, введите поле модели',
        'column_name_label' => 'Метка',
        'column_label_required' => 'Пожалуйста, укажите метку столбца',
        'column_type_label' => 'Тип',
        'column_type_required' => 'Пожалуйста, укажите тип столбца',
        'column_type_text' => 'Текст',
        'column_type_number' => 'Число',
        'column_type_switch' => 'Переключатель',
        'column_type_datetime' => 'Дата и время',
        'column_type_date' => 'Дата',
        'column_type_time' => 'Время',
        'column_type_timesince' => 'Время с',
        'column_type_timetense' => 'Время до',
        'column_type_select' => 'Выбрать',
        'column_type_partial' => 'Фрагмент',
        'column_label_default' => 'По умолчанию',
        'column_label_searchable' => 'Поиск',
        'column_label_sortable' => 'Сортируемый',
        'column_label_invisible' => 'Невидимый',
        'column_label_select' => 'Выбрать',
        'column_label_relation' => 'Связь',
        'column_label_css_class' => 'Класс CSS',
        'column_label_width' => 'Ширина',
        'column_label_path' => 'Путь',
        'column_label_format' => 'Формат',
        'column_label_value_from' => 'Значение из',
        'error_duplicate_column' => "Дублирование имени поля столбца: ':column'.",
        'btn_add_database_columns' => 'Добавьте столбцы базы данных',
        'all_database_columns_exist' => 'Все столбцы базы данных уже определены в списке'
    ],
    'controller' => [
        'menu_label' => 'Контроллеры',
        'no_records' => 'Контроллеры плагина не найдены',
        'controller' => 'Контроллер',
        'behaviors' => 'Поведение',
        'new_controller' => 'Новый контроллер',
        'error_controller_has_no_behaviors' => 'Контроллер не имеет настраиваемого поведения.',
        'error_invalid_yaml_configuration' => 'Ошибка загрузки файла конфигурации поведения: :file',
        'behavior_form_controller' => 'Поведение контроллера формы',
        'behavior_form_controller_description' => 'Добавляет функциональность формы на внутреннюю страницу. Поведение предоставляет три страницы под названием "Создание", "Обновление" и "Предварительный просмотр".',
        'property_behavior_form_placeholder' => '--выбрать форму--',
        'property_behavior_form_name' => 'Имя',
        'property_behavior_form_name_description' => 'Имя объекта, которым управляет данная форма',
        'property_behavior_form_name_required' => 'Пожалуйста, введите название формы',
        'property_behavior_form_file' => 'Конфигурация формы',
        'property_behavior_form_file_description' => 'Ссылка на файл определения поля формы',
        'property_behavior_form_file_required' => 'Пожалуйста, введите путь к файлу конфигурации формы',
        'property_behavior_form_model_class' => 'Класс модели',
        'property_behavior_form_model_class_description' => 'Имя класса модели, данные формы загружаются и сохраняются по этой модели.',
        'property_behavior_form_model_class_required' => 'Пожалуйста, выберите класс модели',
        'property_behavior_form_default_redirect' => 'Перенаправление по умолчанию',
        'property_behavior_form_default_redirect_description' => 'Страница для перенаправления по умолчанию при сохранении или отмене формы.',
        'property_behavior_form_create' => 'Создать страницу записи',
        'property_behavior_form_redirect' => 'Перенаправление',
        'property_behavior_form_redirect_description' => 'Страница для перенаправления при создании записи.',
        'property_behavior_form_redirect_close' => 'Закрыть перенаправление',
        'property_behavior_form_redirect_close_description' => 'Страница для перенаправления, когда запись создана и вместе с запросом отправлена переменная close post.',
        'property_behavior_form_flash_save' => 'Сохранить флэш-сообщение',
        'property_behavior_form_flash_save_description' => 'Флэш-сообщение для отображения при сохранении записи.',
        'property_behavior_form_page_title' => 'Заголовок страницы',
        'property_behavior_form_update' => 'Страница обновления записи',
        'property_behavior_form_update_redirect' => 'Перенаправление',
        'property_behavior_form_create_redirect_description' => 'Страница для перенаправления при сохранении записи.',
        'property_behavior_form_flash_delete' => 'Удалить флэш-сообщение',
        'property_behavior_form_flash_delete_description' => 'Флэш-сообщение для отображения при удалении записи.',
        'property_behavior_form_preview' => 'Страница предварительного просмотра записи',
        'behavior_list_controller' => 'Поведение контроллера списка',
        'behavior_list_controller_description' => 'Предоставляет список с возможностью сортировки и поиска с дополнительными ссылками на его записи. Поведение автоматически создает действие контроллера "index".',
        'property_behavior_list_title' => 'Заголовок списка',
        'property_behavior_list_title_required' => 'Пожалуйста, введите название списка',
        'property_behavior_list_placeholder' => '--выбрать список--',
        'property_behavior_list_model_class' => 'Класс модели',
        'property_behavior_list_model_class_description' => 'Имя класса модели, данные списка загружаются из этой модели.',
        'property_behavior_form_model_class_placeholder' => '--выбрать модель--',
        'property_behavior_list_model_class_required' => 'Пожалуйста, выберите класс модели',
        'property_behavior_list_model_placeholder' => '--выбрать модель--',
        'property_behavior_list_file' => 'Файл конфигурации списка',
        'property_behavior_list_file_description' => 'Ссылка на файл определения списка',
        'property_behavior_list_file_required' => 'Пожалуйста, введите путь к файлу конфигурации списка',
        'property_behavior_list_record_url' => 'URL записи',
        'property_behavior_list_record_url_description' => 'Свяжите каждую запись списка с другой страницей. Например: users/update:id. Часть :id заменяется идентификатором записи.',
        'property_behavior_list_no_records_message' => 'Сообщение об отсутствии записей',
        'property_behavior_list_no_records_message_description' => 'Сообщение для отображения, когда записи не найдены',
        'property_behavior_list_recs_per_page' => 'Записей на странице',
        'property_behavior_list_recs_per_page_description' => 'Количество записей для отображения на одной странице, используйте 0 для отключения. По умолчанию: 0',
        'property_behavior_list_recs_per_page_regex' => 'Количество записей должно быть целочисленным значением',
        'property_behavior_list_show_setup' => 'Отображать кнопку настройки',
        'property_behavior_list_show_sorting' => 'Отображать сортировку',
        'property_behavior_list_default_sort' => 'Сортировка по умолчанию',
        'property_behavior_form_ds_column' => 'Столбец',
        'property_behavior_form_ds_direction' => 'Направление',
        'property_behavior_form_ds_asc' => 'По возрастанию',
        'property_behavior_form_ds_desc' => 'По убыванию',
        'property_behavior_list_show_checkboxes' => 'Отображать флажки',
        'property_behavior_list_onclick' => 'Обработчик нажатия кнопки мыши',
        'property_behavior_list_onclick_description' => 'Пользовательский код JavaScript для выполнения при нажатии на запись.',
        'property_behavior_list_show_tree' => 'Отображать дерево',
        'property_behavior_list_show_tree_description' => 'Отображает древовидную иерархию для родительских/дочерних записей.',
        'property_behavior_list_tree_expanded' => 'Дерево развёрнуто',
        'property_behavior_list_tree_expanded_description' => 'Определяет, должны ли узлы дерева быть развернуты по умолчанию.',
        'property_behavior_list_toolbar' => 'Панель инструментов',
        'property_behavior_list_toolbar_buttons' => 'Фрагмент с кнопками',
        'property_behavior_list_toolbar_buttons_description' => 'Ссылка на файл фрагмента контроллера с кнопками панели инструментов. Например: list_toolbar',
        'property_behavior_list_search' => 'Поиск',
        'property_behavior_list_search_prompt' => 'Поисковая подсказка',
        'property_behavior_list_filter' => 'Настройка фильтра',
        'behavior_reorder_controller' => 'Изменить поведение контроллера',
        'behavior_reorder_controller_description' => 'Предоставляет возможности для сортировки и переупорядочивания записей. Поведение автоматически создает действие контроллера "reorder".',
        'property_behavior_reorder_title' => 'Изменить название',
        'property_behavior_reorder_title_required' => 'Пожалуйста, введите новое название',
        'property_behavior_reorder_name_from' => 'Имя атрибута',
        'property_behavior_reorder_name_from_description' => 'Атрибут модели, который должен использоваться в качестве метки для каждой записи.',
        'property_behavior_reorder_name_from_required' => 'Пожалуйста, введите имя атрибута',
        'property_behavior_reorder_model_class' => 'Класс модели',
        'property_behavior_reorder_model_class_description' => 'Имя класса модели, данные для переупорядочивания загружаются из этой модели.',
        'property_behavior_reorder_model_class_placeholder' => '--выбрать модель--',
        'property_behavior_reorder_model_class_required' => 'Пожалуйста, выберите класс модели',
        'property_behavior_reorder_model_placeholder' => '--выбрать модель--',
        'property_behavior_reorder_toolbar' => 'Панель инструментов',
        'property_behavior_reorder_toolbar_buttons' => 'Фрагмент с кнопками',
        'property_behavior_reorder_toolbar_buttons_description' => 'Ссылка на файл фрагмента контроллера с кнопками панели инструментов. Например: reorder_toolbar',
        'error_controller_not_found' => 'Оригинальный файл контроллера не найден.',
        'error_invalid_config_file_name' => 'Имя файла конфигурации поведения :class (:file) содержит недопустимые символы и не может быть загружено.',
        'error_file_not_yaml' => 'Файл конфигурации поведения :class (:file) не является файлом YAML. Поддерживаются только файлы конфигурации YAML.',
        'saved' => 'Контроллер сохранён',
        'controller_name' => 'Имя контроллера',
        'controller_name_description' => 'Имя контроллера определяет имя класса и URL внутренних страниц контроллера\. Применяются стандартные соглашения об именовании переменных PHP. Первым символом должна быть заглавная латинская буква. Примеры: Categories, Posts, Products.',
        'base_model_class' => 'Базовый класс модели',
        'base_model_class_description' => 'Выберите класс модели для использования в качестве базовой модели в поведении, которое требует или поддерживает модели. Вы можете настроить поведение позже.',
        'base_model_class_placeholder' => '--выбрать модель--',
        'controller_behaviors' => 'Поведение',
        'controller_behaviors_description' => 'Выберите поведение, которое должен реализовать контроллер. Конструктор автоматически создаст файлы представления, необходимые для поведения.',
        'controller_permissions' => 'Разрешения',
        'controller_permissions_description' => 'Выберите разрешения пользователей, которые могут получить доступ к представлениям контроллера. Разрешения могут быть определены на вкладке "Разрешения" в Конструкторе. Вы можете изменить этот параметр в PHP-скрипте контроллера позже.',
        'controller_permissions_no_permissions' => 'Плагин не определяет никаких разрешений.',
        'menu_item' => 'Активный пункт меню',
        'menu_item_description' => 'Выберите пункт меню, чтобы сделать его активным для страниц контроллера. Вы можете изменить этот параметр в PHP-скрипте контроллера позже.',
        'menu_item_placeholder' => '--выбрать пункт меню--',
        'error_unknown_behavior' => 'Класс поведения :class не зарегистрирован в библиотеке поведения.',
        'error_behavior_view_conflict' => 'Выбранные модели поведения предоставляют конфликтующие представления (:view) и не могут быть использованы вместе в контроллере.',
        'error_behavior_config_conflict' => 'Выбранные модели поведения предоставляют конфликтующие файлы конфигурации (:file) и не могут быть использованы вместе в контроллере.',
        'error_behavior_view_file_not_found' => 'Шаблон вида :view поведения :class не может быть найден.',
        'error_behavior_config_file_not_found' => 'Шаблон конфигурации :file поведения :class не найден.',
        'error_controller_exists' => 'Файл контроллера уже существует: :file.',
        'error_controller_name_invalid' => 'Неверный формат имени контроллера. Имя может содержать только цифры и латинские буквы. Первым символом должна быть заглавная латинская буква.',
        'error_behavior_view_file_exists' => 'Файл представления контроллера уже существует: :view.',
        'error_behavior_config_file_exists' => 'Файл конфигурации поведения уже существует: :file.',
        'error_save_file' => 'Ошибка сохранения файла контроллера: :file',
        'error_behavior_requires_base_model' => 'Поведение :behavior требует выбора базового класса модели.',
        'error_model_doesnt_have_lists' => 'Выбранная модель не имеет списков. Пожалуйста, сначала создайте список.',
        'error_model_doesnt_have_forms' => 'Выбранная модель не имеет форм. Пожалуйста, сначала создайте форму.',
    ],
    'version' => [
        'menu_label' => 'Версии',
        'no_records' => 'Версии плагина не найдены',
        'search' => 'Поиск...',
        'tab' => 'Версии',
        'saved' => 'Версия сохранена',
        'confirm_delete' => 'Удалить версию?',
        'tab_new_version' => 'Новая версия',
        'migration' => 'Миграция',
        'seeder' => 'Сидер',
        'custom' => 'Увеличить номер версии',
        'apply_version' => 'Применить версию',
        'applying' => 'Применение...',
        'rollback_version' => 'Откатить версию',
        'rolling_back' => 'Откат назад...',
        'applied' => 'Версия применена',
        'rolled_back' => 'Версия изменена',
        'hint_save_unapplied' => 'Вы сохранили неприменённую версию. Неприменённые версии могут быть автоматически применены, когда вы или другой пользователь входит в админку или когда таблица базы данных сохраняется в разделе "База данных" Конструктора.',
        'hint_rollback' => 'Откат версии также приведет к откату всех версий, более новых, чем эта версия. Обратите внимание, что неприменённые версии могут быть автоматически применены системой, когда вы или другой пользователь входит в админку или когда таблица базы данных сохраняется в разделе "База данных" Конструктора.',
        'hint_apply' => 'При применении версии также будут применены все старые неприменённые версии плагина.',
        'dont_show_again' => 'Не показывать снова',
        'save_unapplied_version' => 'Сохранить неприменённую версию',
        'sort_ascending' => 'Сортировать по возрастанию',
        'sort_descending' => 'Сортировать по убыванию',
    ],
    'menu' => [
        'menu_label' => 'Внутреннее меню',
        'tab' => 'Меню',
        'items' => 'Пункты меню',
        'saved' => 'Меню сохранены',
        'add_main_menu_item' => 'Добавить пункт главного меню',
        'new_menu_item' => 'Пункт меню',
        'add_side_menu_item' => 'Добавить подпункт',
        'side_menu_item' => 'Пункт бокового меню',
        'property_label' => 'Метка',
        'property_label_required' => 'Пожалуйста, введите метки пунктов меню.',
        'property_url_required' => 'Пожалуйста, введите URL-адрес пункта меню',
        'property_url' => 'URL',
        'property_icon' => 'Иконка',
        'property_icon_required' => 'Пожалуйста, выберите иконку',
        'property_permissions' => 'Разрешения',
        'property_order' => 'Порядок',
        'property_order_invalid' => 'Пожалуйста, введите порядок пунктов меню в виде целочисленного значения.',
        'property_order_description' => 'Порядок пункта меню управляет его положением в меню. Если порядок не предоставлен, пункт будет помещен в конец меню. Значения пукнта по умолчанию имеют приращение 100.',
        'property_attributes' => 'Атрибуты HTML',
        'property_code' => 'Код',
        'property_code_invalid' => 'Код должен содержать только латинскую букву и цифры',
        'property_code_required' => 'Пожалуйста, введите код пункта меню.',
        'error_duplicate_main_menu_code' => "Дублирование кода пункта главного меню: ':code'.",
        'error_duplicate_side_menu_code' => "Дублирование кода пункта бокового меню: ':code'.",
    ],
    'localization' => [
        'menu_label' => 'Локализация',
        'language' => 'Язык',
        'strings' => 'Строки',
        'confirm_delete' => 'Удалить язык?',
        'tab_new_language' => 'Новый язык',
        'no_records' => 'Языки не найдены',
        'saved' => 'Языковой файл сохранён',
        'error_cant_load_file' => 'Невозможно загрузить запрошенный языковой файл - файл не найден.',
        'error_bad_localization_file_contents' => 'Невозможно загрузить запрошенный языковой файл. Языковые файлы могут содержать только определения массивов и строки.',
        'error_file_not_array' => 'Невозможно загрузить запрошенный языковой файл. Языковые файлы должны возвращать массив.',
        'save_error' => "Ошибка сохранения файла ':name'. Пожалуйста, проверьте права на запись.",
        'error_delete_file' => 'Ошибка удаления файла локализации.',
        'add_missing_strings' => 'Добавить отсутствующие строки',
        'copy' => 'Копировать',
        'add_missing_strings_label' => 'Выберите язык для копирования отсутствующих строк',
        'no_languages_to_copy_from' => 'Не существует других языков, из которых можно скопировать строки.',
        'new_string_warning' => 'Новая строка или секция',
        'structure_mismatch' => 'Структура файла исходного языка не соответствует структуре редактируемого файла. Некоторые отдельные строки в редактируемом файле соответствуют секциям в исходном файле (или наоборот) и не могут быть объединены автоматически.',
        'create_string' => 'Создать новую строку',
        'string_key_label' => 'Ключ',
        'string_key_comment' => 'Введите строковый ключ, используя точку в качестве разделителя секций. Например: plugin.search. Строка будет создана в файле исходного языка плагина.',
        'string_value' => 'Ззначение',
        'string_key_is_empty' => 'Строковый ключ не должен быть пустым',
        'string_key_is_a_string' => ':key является строкой и не может содержать другие строки.',
        'string_value_is_empty' => 'Строковое значение не должно быть пустым',
        'string_key_exists' => 'Строковый ключ уже существует',
    ],
    'permission' => [
        'menu_label' => 'Разрешения',
        'tab' => 'Разрешения',
        'form_tab_permissions' => 'Разрешения',
        'btn_add_permission' => 'Добавить разрешение',
        'btn_delete_permission' => 'Удалить разрешение',
        'column_permission_label' => 'Код разрешения',
        'column_permission_required' => 'Пожалуйста, введите код разрешения',
        'column_tab_label' => 'Заголовок вкладки',
        'column_tab_required' => 'Пожалуйста, введите заголовок вкладки разрешения',
        'column_label_label' => 'Метка',
        'column_label_required' => 'Пожалуйста, введите метку разрешения',
        'saved' => 'Разрешения сохранены',
        'error_duplicate_code' => "Дублирование кода разрешения: ':code'.",
    ],
    'yaml' => [
        'save_error' => "Ошибка сохранения файла ':name'. Пожалуйста, проверьте права на запись.",
    ],
    'common' => [
        'error_file_exists' => "Файл уже существует: ':path'.",
        'field_icon_description' => 'Winter CMS использует иконки Font Autumn: https://wintercms.com/docs/ui/icon',
        'destination_dir_not_exists' => "Директория назначения не существует: ':path'.",
        'error_make_dir' => "Ошибка создания директории: ':name'.",
        'error_dir_exists' => "Директория уже существует: ':path'.",
        'template_not_found' => "Файл шаблона не найден: ':name'.",
        'error_generating_file' => "Ошибка генерации файла: ':path'.",
        'error_loading_template' => "Ошибка загрузки файла шаблона: ':name'.",
        'select_plugin_first' => 'Пожалуйста, сначала выберите плагин. Для просмотра списка плагинов нажмите на значок > на левой боковой панели.',
        'plugin_not_selected' => 'Плагин не выбран',
        'add' => 'Добавить',
    ],
    'migration' => [
        'entity_name' => 'Миграция',
        'error_version_invalid' => 'Версия должна быть указана в формате 1.0.1',
        'field_version' => 'Версия',
        'field_description' => 'Описание',
        'field_code' => 'Код',
        'save_and_apply' => 'Сохранить и применить',
        'error_version_exists' => 'Версия миграции уже существует.',
        'error_script_filename_invalid' => 'Имя файла скрипта миграции может содержать только латинские буквы, цифры и знаки подчеркивания. Имя должно начинаться с латинской буквы и не должно содержать пробелов.',
        'error_cannot_change_version_number' => 'Невозможно изменить номер версии для примененной версии.',
        'error_file_must_define_class' => 'Код миграции должен определять класс миграции или сидера. Оставьте поле кода пустым, если вы хотите обновить только номер версии.',
        'error_file_must_define_namespace' => 'Код миграции должен определять пространство имён. Оставьте поле кода пустым, если вы хотите обновить только номер версии.',
        'no_changes_to_save' => 'Нет изменений для сохранения.',
        'error_namespace_mismatch' => "Код миграции должен использовать пространство имён плагина: :namespace",
        'error_migration_file_exists' => "Файл миграции :file уже существует. Пожалуйста, используйте другое название класса.",
        'error_cant_delete_applied' => 'Эта версия уже была применена и не может быть удалена. Пожалуйста, сначала откатите версию.',
    ],
    'components' => [
        'list_title' => 'Список записей',
        'list_description' => 'Отображает список записей для выбранной модели',
        'list_page_number' => 'Номер страницы',
        'list_page_number_description' => 'Это значение используется для определения того, на какой странице находится пользователь.',
        'list_records_per_page' => 'Записей на странице',
        'list_records_per_page_description' => 'Количество записей для отображения на одной странице. Оставьте пустым, чтобы отключить пагинацию.',
        'list_records_per_page_validation' => 'Неверный формат значения. Значение должно быть числом.',
        'list_no_records' => 'Сообщение об отсутствии записей',
        'list_no_records_description' => 'Сообщение для отображения в списке в случае отсутствия записей. Используется во фрагменте компонента по умолчанию.',
        'list_no_records_default' => 'Записи не найдены',
        'list_sort_column' => 'Сортировать по столбцу',
        'list_sort_column_description' => 'Столбец модели, по которому должны быть упорядочены записи',
        'list_sort_direction' => 'Направление',
        'list_display_column' => 'Столбец для отображения',
        'list_display_column_description' => 'Столбец для отображения в списке. Используется во фрагменте компонента по умолчанию.',
        'list_display_column_required' => 'Пожалуйста, выберите столбец для отображения.',
        'list_details_page' => 'Страница с подробной информацией',
        'list_details_page_description' => 'Страница для отображения сведений о записи.',
        'list_details_page_no' => '--без страницы с подробностями--',
        'list_sorting' => 'Сортировка',
        'list_pagination' => 'Пагинация',
        'list_order_direction_asc' => 'По возрастанию',
        'list_order_direction_desc' => 'По убыванию',
        'list_model' => 'Класс модели',
        'list_scope' => 'Область видимости',
        'list_scope_description' => 'Необязательная область видимости модели для получения записей',
        'list_scope_default' => '--выбрать область видимости, необязательно--',
        'list_scope_value' => 'Значение области видимости',
        'list_scope_value_description' => 'Необязательное значение для передачи в область видимости модели',
        'list_details_page_link' => 'Ссылка на страницу с подробной информацией',
        'list_details_key_column' => 'Ключевой столбец страницы деталей',
        'list_details_key_column_description' => 'Столбец модели для использования в качестве идентификатора записи в ссылках на странице подробностей.',
        'list_details_url_parameter' => 'Имя параметра URL',
        'list_details_url_parameter_description' => 'Имя параметра URL страницы подробностей, который принимает идентификатор записи.',
        'details_title' => 'Детали записи',
        'details_description' => 'Отображение сведений о записи для выбранной модели',
        'details_model' => 'Класс модели',
        'details_identifier_value' => 'Значение идентификатора',
        'details_identifier_value_description' => 'Значение идентификатора для загрузки записи из базы данных. Укажите фиксированное значение или имя параметра URL.',
        'details_identifier_value_required' => 'Значение идентификатора является обязательным',
        'details_key_column' => 'Ключевой столбец',
        'details_key_column_description' => 'Столбец модели для использования в качестве идентификатора записи при извлечении записи из базы данных.',
        'details_key_column_required' => 'Имя ключевого столбца обязательно',
        'details_display_column' => 'Отображать столбец',
        'details_display_column_description' => 'Столбец модели для отображения на странице подробностей. Используется в файле фрагмента по умолчанию.',
        'details_display_column_required' => 'Пожалуйста, выберите столбец для отображения.',
        'details_not_found_message' => 'Сообщение об отсутствующей записи',
        'details_not_found_message_description' => 'Сообщение для отображения, если запись не найдена. Используется в файле фрагмента по умолчанию.',
        'details_not_found_message_default' => 'Запись не найдена',
    ],
    'validation' => [
        'reserved' => ':attribute не может быть зарезервированным ключевым словом PHP'
    ]
];
