<?php

use Cms\Classes\Controller;
use OFFLINE\Mall\Classes\Feeds\GoogleMerchantFeed;
use OFFLINE\Mall\Models\FeedSettings;

// Send virtual product files to the user's browser.
Route::get('/mall/download/{key}', '\OFFLINE\Mall\Classes\Downloads\VirtualProductFileDownload@handle')
     ->middleware('web');

// Handles Responses generated by a PaymentProvider. It just renders the contents of
// the mall.checkout.response session key. This way a PaymentProvider may render a HTML
// form to execute custom POST requests to a PaymentGateway.
//
// @see \OFFLINE\Mall\Classes\Payments\PaymentRedirector::handlePaymentResult
Route::get('/mall/checkout/response', function () {
    $data = session()->pull('mall.checkout.response');
    if ( ! $data) {
        return response('Missing data.', 404);
    }

    return response($data, 200);
})->middleware('web');

// Renders the Google Merchant integration feed. It outputs all
// of the store's products as an XML document, which is indexed
// by Google on a regular basis.
Route::get('/feeds/google-merchant/{key}', function ($key) {
    $useFeed = FeedSettings::get('google_merchant_enabled');
    if ( ! $useFeed) {
        return (new Controller())->run('404');
    }

    $settingsKey = FeedSettings::get('google_merchant_key');
    if ($key !== $settingsKey) {
        return response('Auth failed', 401);
    }

    $feed = new GoogleMerchantFeed(
        request()->get('locale')
    );

    return response($feed->build(), 200, ['Content-Type' => 'application/xml']);
});