<?php return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'E-commerce solution pour October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Créer produit',
            'update' => 'Modifier produit',
            'preview' => 'Aperçu produit',
        ],
        'categories' => [
            'create' => 'Créer catégorie',
            'update' => 'Modifier catégorie',
            'preview' => 'Aperçu catégorie',
        ],
        'orders' => [
            'show' => 'Détails commande',
            'export' => 'Exporter commandes',
        ],
        'discounts' => [
            'create' => 'Créer une réduction',
            'update' => 'Modifier la réduction',
            'preview' => 'Aperçu de la réduction',
        ],
        'services' => [
            'create' => 'Créer un service',
            'update' => 'Modifier un service',
        ],
        'shipping_methods' => [
            'create' => 'Créer un mode d\'expédition',
            'update' => 'Modifier le mode d\'expédition',
            'preview' => 'Prévisualiser la méthode d\'expédition',
        ],
        'payment_methods' => [
            'create' => 'Créer un mode de paiement',
            'edit' => 'Modifier le mode de paiement',
            'reorder' => 'Réorganiser',
        ],
        'custom_field_options' => [
            'edit' => 'Modifier les options de champ',
        ],
        'properties' => [
            'create' => 'Créer des propriétés',
            'edit' => 'Editer les propriétés',
        ],
        'order_states' => [
            'create' => 'Créer statut',
            'edit' => 'Modifier statut',
            'reorder' => 'Reorder status',
        ],
        'brands' => [
            'create' => 'Créer marque',
            'edit' => 'Modifier marque',
        ],
        'property_groups' => [
            'create' => 'Créer groupe',
            'edit' => 'Modifier groupe',
        ],
        'customer_groups' => [
            'create' => 'Créer groupe',
            'update' => 'Modifier groupe',
        ],
        'notifications' => [
            'update' => 'Notification de mise à jour',
        ],
        'taxes' => [
            'create' => 'Créer taxe',
            'update' => 'Modifier taxe',
        ],
        'reviews' => [
            'create' => 'Créer une critique',
            'update' => 'Modifier la critique',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Toutes les catégories',
        'single_category' => 'Catégorie',
        'all_products' => 'Tous les produits',
        'all_variants' => 'Toutes les variantes',
    ],
    'currency_settings' => [
        'label' => 'Monnaies',
        'description' => 'Configurez vos devises',
        'currencies' => 'Entrez uniquement les codes de devise officiels à 3 caractères.',
        'currency_code' => 'Code de devise',
        'currency_decimals' => 'Num. décimales',
        'currency_rounding' => 'Arrondir le total',
        'currency_rounding_comment' => 'Le total, taxes comprises, est arrondi à cette valeur si cette monnaie est active.',
        'currency_format' => 'Format',
        'currency_symbol' => 'Symbole',
        'currency_rate' => 'Taux',
        'is_default' => 'Par défaut',
        'unknown' => 'Devise inconnue',
    ],
    'payment_gateway_settings' => [
        'label' => 'Moyens de paiement',
        'description' => 'Configurez vos moyens de paiement',
        'stripe' => [
            'api_key' => 'Stripe API Key',
            'api_key_comment' => 'Vous pouvez trouver cette clé dans votre tableau de bord Stripe',
            'publishable_key' => 'Stripe Publishable Key',
            'publishable_key_comment' => 'Vous pouvez trouver cette clé dans votre tableau de bord Stripe',
        ],
        'paypal' => [
            'client_id' => 'PayPal Client ID',
            'secret' => 'PayPal Secret',
            'test_mode' => 'Test mode',
            'test_mode_comment' => 'Exécutez tous les paiements dans le bac à sable PayPal.',
        ],
        'postfinance' => [
            'test_mode' => 'Mode test',
            'test_mode_comment' => 'Exécution de tous les paiements dans l\'environnement de test',
            'pspid' => 'PSPID (Identifiant)',
            'hashing_method' => 'Algorithme de hachage',
            'hashing_method_comment' => 'Configuration -> Informations techniques -> Paramètres de sécurité',
            'sha_in' => 'Signature SHA-IN',
            'sha_in_comment' => 'Configuration -> Informations techniques -> Vérification des données et origine',
            'sha_out' => 'Signature SHA-OUT',
            'sha_out_comment' => 'Configuration -> Informations techniques -> Retour d\'information sur la transaction',
        ],
    ],
    'notification_settings' => [
        'label' => 'Notifications',
        'description' => 'Configurer les notifications de la boutique',
    ],
    'price_category_settings' => [
        'label' => 'Catégories de prix',
        'description' => 'Configurer des catégories de prix supplémentaires',
    ],
    'order_state_settings' => [
        'description' => 'Configurer les états de commande',
    ],
    'payment_method_settings' => [
        'description' => 'Gérer les moyens de paiement',
    ],
    'shipping_method_settings' => [
        'description' => 'Gérer les méthodes d\'expédition',
    ],
    'tax_settings' => [
        'description' => 'Gérer les taxes',
    ],
    'general_settings' => [
        'category' => 'Mall: Générale',
        'category_payments' => 'Mall: Paiements',
        'category_orders' => 'Mall: Commandes',
        'label' => 'Configuration',
        'description' => 'Réglages généraux',
        'product_page' => 'Fiche produit',
        'product_page_comment' => 'C\'est ici que les détails du produit sont affichés',
        'address_page' => 'Page adresse',
        'address_page_comment' => 'Le composant de formulaire d\'adresse doit être présent sur cette page',
        'checkout_page' => 'Page de commande',
        'checkout_page_comment' => 'Le composant de commande doit être présent sur cette page',
        'account_page' => 'Page de compte',
        'account_page_comment' => 'Le composant myAccount doit être présent sur cette page',
        'cart_page' => 'Page panier',
        'cart_page_comment' => 'Le composant cart doit être présent sur cette page',
        'category_page' => 'Page de catégorie pour la liste des produits',
        'redirect_to_cart' => 'Rediriger vers le panier',
        'redirect_to_cart_comment' => 'Rediriger vers le panier après que l\'utilisateur a ajouté un produit',
        'use_state' => 'Utilisez les champs État/Province/Région ',
        'use_state_comment' => 'Les clients doivent sélectionner un État/Province/Région lors de l\'inscription',
        'group_search_results_by_product' => 'Regrouper les résultats de la recherche par produit',
        'shipping_selection_before_payment' => 'Sélectionnez le mode d\'expédition avant le paiement lors du passage en caisse.',
        'shipping_selection_before_payment_comment' => 'Par défaut, lors du passage à la caisse, l\'utilisateur doit d\'abord choisir un mode de paiement avant de sélectionner un mode d\'expédition ; utilisez cette option pour inverser cette logique.',
        'admin_email' => 'Email de l\'administrateur',
        'admin_email_comment' => 'Les notifications de l\'administrateur seront envoyées à cette adresse',
        'base' => 'Paramètres de base',
        'links' => 'Pages CMS',
        'links_comment' => 'Choisissez les pages utilisées pour afficher vos produits',
        'customizations' => 'Personnalisations',
        'customizations_comment' => 'Personnaliser les fonctionnalités de votre boutique',
        'category_page_comment' => 'Ajouter le composant "produits" à cette page.',
        'order_number_start' => 'Numéro de première commande',
        'order_number_start_comment' => 'Identifiant initial de la première commande',
        'index_driver' => 'Index driver',
        'index_driver_comment' => 'Si votre base de données prend en charge JSON, utilisez le pilote de base de données.',
        'index_driver_filesystem' => 'Filesystem',
        'index_driver_database' => 'Database (seulement pour MySQL 5.7+ or MariaDB 10.2+)',
        'index_driver_hint' => 'Si vous changez cette option, assurez-vous de lancer "php artisan mall: reindex" sur la ligne de commande pour réindexer vos produits.!',
    ],
    'feed_settings' => [
        'description' => 'Configurer les flux de du plugin mall',
        'google_merchant_enabled' => 'Activer le flux Google Merchant Center',
        'google_merchant_enabled_comment' => 'Un flux de produits sera généré',
        'google_merchant_url' => 'Votre URL de flux marchand Google',
        'google_merchant_url_locale' => 'Ajouter ?locale=xy pour obtenir un flux localisé.',
    ],
    'review_settings' => [
        'description' => 'Configurer les avis',
        'enabled' => 'Avis activés',
        'enabled_comment' => 'Les clients peuvent créer des avis',
        'moderated' => 'Examen des avis',
        'moderated_comment' => 'Les nouveaux avis doivent être publiés manuellement par l\'administrateur du site',
        'allow_anonymous' => 'Autoriser les avis anonymes',
        'allow_anonymous_comment' => 'Les utilisateurs non enregistrés peuvent créer des avis',
    ],
    'common' => [
        'shop' => 'Boutique',
        'products' => 'Produits',
        'product' => 'Produit',
        'orders' => 'Commandes',
        'cart' => 'Panier',
        'shipping' => 'Livraison',
        'taxes' => 'Taxes',
        'rates' => 'Taux',
        'inventory' => 'Inventaire',
        'accessories' => 'Accessoires',
        'shipping_methods' => 'Méthodes de livraison',
        'accessory' => 'Champs personnalisés',
        'custom_fields' => 'Champs personnalisés',
        'variants' => 'Variantes',
        'variant' => 'Variante',
        'discounts' => 'Remises',
        'discount' => 'Remise',
        'discount_percentage' => 'Remise (%)',
        'select_placeholder' => '-- Choisissez s\'il vous plaît',
        'main_image' => 'Image principale',
        'images' => 'Images',
        'image_set' => 'Image set',
        'attachments' => 'Images/Téléchargements',
        'downloads' => 'Téléchargements',
        'select_image' => 'Choisir image',
        'select_file' => 'Choisir Fichier',
        'allowed' => 'Permis',
        'not_allowed' => 'Interdit',
        'yes' => 'Oui',
        'no' => 'Non',
        'seo' => 'SEO',
        'properties_links' => 'Propriétés/Liens',
        'categories' => 'Catégories',
        'category' => 'Catégorie',
        'meta_title' => 'Meta title',
        'meta_description' => 'Meta description',
        'meta_keywords' => 'Meta keywords',
        'reorder' => 'Réorganiser les entrées',
        'id' => 'ID',
        'created_at' => 'Créé le',
        'updated_at' => 'Mis à jour le',
        'approved_at' => 'Approuvé le',
        'hide_published' => 'Cache publié',
        'slug' => 'URL',
        'name' => 'Nom',
        'display_name' => 'Nom affiché',
        'group_name' => 'Nom de groupe',
        'add_value' => 'Ajouter valeur',
        'export_orders' => 'Export commandes',
        'use_backend_defaults' => 'Utiliser les valeurs par défaut configurées dans les paramètres du backend',
        'api_error' => 'Impossible d\'enregistrer la réduction. Erreur lors de l\'envoi des modifications à l\'API MALL.',
        'includes_tax' => 'Taxes incluses',
        'conditions' => 'Conditions',
        'general' => 'Generale',
        'logo' => 'Logo',
        'payment_gateway' => 'Passerelle de paiement',
        'payment_provider' => 'Fournisseur de paiement',
        'payment_methods' => 'Méthodes de payement',
        'payment' => 'Paiement',
        'payments' => 'Paiements',
        'image' => 'Image',
        'color' => 'Couleur',
        'unit' => 'Unité',
        'dont_group' => '-- Do not group',
        'properties' => 'Propriétés',
        'old_price' => 'Ancien prix',
        'property' => 'Propriété',
        'property_groups' => 'Propriété groupes',
        'property_group' => 'Propriété groupe',
        'options' => 'Options',
        'option' => 'Option',
        'catalogue' => 'Catalogue',
        'out_of_stock' => 'Ce produit est en rupture de stock.',
        'out_of_stock_short' => 'Rupture de stock',
        'stock_limit_reached' => 'Vous ne pouvez plus ajouter d\'articles de ce produit à votre panier puisque la limite de stock est atteinte.',
        'deleted_at' => 'Supprimé le',
        'sort_order' => 'Ordre de tri',
        'order_states' => 'Etat de commande',
        'website' => 'Website',
        'brands' => 'Marques',
        'brand' => 'Marque',
        'sorting_updated' => 'L\'ordre de tri a été mis à jour',
        'not_in_use' => 'Option non utilisée',
        'saved_changes' => 'Changements sauvegardés avec succès',
        'none' => '-- Aucun',
        'customers' => 'Clients',
        'customer_groups' => 'Groupes client',
        'customer_group' => 'Groupe client',
        'product_or_variant' => 'Produit/Variante',
        'code' => 'Code',
        'code_comment' => 'Ce code peut être utilisé pour identifier cet enregistrement par programme',
        'checked' => 'Coché',
        'unchecked' => 'Décoché',
        'notifications' => 'Notifications',
        'notification' => 'Notification',
        'price_missing' => 'Entrez au moins un prix pour la devise par défaut',
        'slug_unique' => 'L\'URL doit être unique',
        'fees' => 'Frais',
        'value' => 'Valeur',
        'action_required' => 'Action Requise!',
        'invalid_quantity' => 'La quantité spécifiée n\'est pas valide',
        'addresses' => 'Adresses',
        'address' => 'Adresse',
        'reference' => 'Référence',
        'session_id' => 'Session ID',
        'message' => 'Message',
        'payment_method' => 'Mode de paiement',
        'data' => 'Data',
        'successful' => 'Réussi',
        'failed' => 'Échoué',
        'caution' => 'Mise en garde',
        'since_begin' => 'Depuis début',
        'weekly' => 'Hebdomadaire',
        'feeds' => 'Feeds',
        'services' => 'Services',
        'service' => 'Service',
        'review' => 'Avis',
        'reviews' => 'Avis',
        'review_categories' => 'Catégories des avis',
        'review_category' => 'Catégorie de l\'avis',
        'title' => 'Titre',
        'version' => 'Version',
    ],
    'variant' => [
        'method' => [
            'single' => 'Article',
            'variant' => 'Article variantes',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Utiliser pour variantes',
        'use_for_variants_comment' => 'Cette propriété est différente pour différentes variantes de ce produit',
        'filter_type' => 'Type de filtre',
        'filter_types' => [
            'none' => 'Sans filtre',
            'set' => 'Ensemble',
            'range' => 'Intervalle',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Champ de texte',
        'integer' => 'Entier',
        'float' => 'Décimal',
        'textarea' => 'Champ de texte à plusieurs lignes',
        'richeditor' => 'Éditeur enrichi',
        'dropdown' => 'Liste déroulante',
        'checkbox' => 'Case à cocher',
        'color' => 'Couleur',
        'image' => 'Image',
        'switch' => 'Commutateur',
        'add' => 'Ajouter option',
        'name' => 'Nom',
        'price' => 'Prix',
        'attributes' => 'Attributs',
        'option' => 'Option',
    ],
    'product' => [
        'user_defined_id' => 'ID produit',
        'name' => 'Nom produit',
        'published' => 'Publié',
        'published_short' => 'Publ.',
        'is_virtual' => 'Est virtuel',
        'is_virtual_comment' => 'Ce produit est virtuel (un fichier, pas de livraison)',
        'product_file' => 'Fichier du produit',
        'product_files' => 'Fiches du produit',
        'product_files_section_comment' => 'Il s\'agit d\'un produit virtuel. Vous pouvez transférer de nouvelles versions de fichiers ci-dessous. La dernière version sera téléchargeable par les clients.',
        'product_file_version' => 'version du fichier',
        'not_published' => 'Non publié',
        'published_comment' => 'Ce produit est visible sur le site',
        'stock' => 'Stock',
        'price' => 'Prix',
        'description_short' => 'Courte description',
        'description' => 'Description',
        'weight' => 'Poids (g)',
        'length' => 'Longueur (mm)',
        'height' => 'Hauteur (mm)',
        'width' => 'Largeur (mm)',
        'quantity_default' => 'Defaut quantité',
        'quantity_min' => 'Minimum quantité',
        'quantity_max' => 'Maximum quantité',
        'inventory_management_method' => 'Méthode de gestion des stocks',
        'allow_out_of_stock_purchases' => 'Autoriser les achats en rupture de stock',
        'allow_out_of_stock_purchases_comment' => 'Ce produit peut être commandé même s\'il est en rupture de stock',
        'stackable' => 'Empiler dans le panier',
        'stackable_comment' => 'Si ce produit est ajouté au panier plusieurs fois, n\'afficher qu\'une entrée (augmenter la quantité)',
        'shippable' => 'Livrable',
        'shippable_comment' => 'Ce produit peut être expédié',
        'taxable' => 'Taxable',
        'taxable_comment' => 'Calculer les taxes sur ce produit',
        'add_currency' => 'Ajouter devise',
        'is_taxable' => 'Utiliser les taxes',
        'is_not_taxable' => 'Ne pas utiliser de taxe',
        'currency' => 'Devise',
        'general' => 'Général',
        'duplicate_currency' => 'Vous avez entré plusieurs prix pour la même devise',
        'property_title' => 'Titre',
        'property_value' => 'Valeur',
        'link_title' => 'Titre',
        'link_target' => 'Cible URL',
        'embed_title' => 'Titre',
        'embed_code' => 'Code intégré',
        'properties' => 'Propriétés',
        'links' => 'Liens',
        'embeds' => 'Pièces jointes',
        'details' => 'Détails',
        'price_includes_tax' => 'Le prix inclu les taxes',
        'price_includes_tax_comment' => 'Le prix défini comprend toutes les taxes',
        'group_by_property' => 'Attribut pour groupement de variantes',
        'additional_descriptions' => 'Descriptions supplémentaires',
        'additional_properties' => 'Propriétés supplémentaires',
        'gtin' => 'Code article international (GTIN)',
        'mpn' => 'Référence fabricant (MPN)',
        'price_table_modal' => [
            'trigger' => 'Modifier les valeurs de stock et de prix',
            'label' => 'Prix et stock',
            'title' => 'Aperçu des prix et des stocks',
            'currency_dropdown' => 'Devise: ',
        ],
        'missing_category' => 'Le produit n\'a pas de catégorie associée. Veuillez sélectionner une catégorie ci-dessous pour modifier ce produit..',
        'variant_support_header' => 'Variantes non prises en charge',
        'variant_support_text' => 'La catégorie sélectionnée n\'a pas de propriétés de variante définies. Veuillez basculer la méthode de gestion des stocks sur "Article" ou sélectionner une autre catégorie..',
        'filter_virtual' => 'Afficher uniquement les produits virtuels',
    ],
    'product_file' => [
        'display_name_comment' => 'Ce nom sera visible pour le client.',
        'version_comment' => 'Une version unique aide le client à reconnaître les fichiers mis à jour.',
        'expires_after_days' => 'Téléchargement valable durant (jours)',
        'expires_after_days_comment' => 'Le fichier ne peut être téléchargé que pendant ce nombre de jours après l\'achat. Laissez vide pour aucune limite.',
        'max_download_count' => 'Nombre maximum de téléchargements',
        'max_download_count_comment' => 'Le fichier ne peut être téléchargé qu\'autant de fois. Laissez vide pour aucune limite.',
        'session_required' => 'Identification requise',
        'session_required_comment' => 'Le fichier ne peut être téléchargé que lorsque le client est connecté (le lien de téléchargement n\'est pas partageable).',
        'file' => 'Fichier',
        'download_count' => 'Nombre de téléchargements',
        'errors' => [
            'invalid' => 'Lien de téléchargement non valide',
            'expired' => 'Le lien de téléchargement a expiré',
            'too_many_attempts' => 'Trop de tentatives de téléchargement',
            'not_found' => 'Si vous ne trouvez pas le fichier demandé, veuillez nous contacter pour obtenir de l\'aide.',
        ],
        'hint' => [
            'intro' => 'Ce produit n\'a pas de fichier joint. Veuillez vous assurer d\'en ajouter un ou de le générer par programmation lors de la commande.',
            'info_text' => 'Vous pouvez trouver des informations sur la manière de procéder',
            'info_link' => 'dans la documentation',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Est le principal',
        'is_main_set_comment' => 'Est principal',
        'create_new' => 'Créer un nouvel ensemble',
    ],
    'category' => [
        'name' => 'Nom',
        'code' => 'Code',
        'code_comment' => 'Ce code peut être utilisé pour identifier cette catégorie dans vos partials frontend.',
        'parent' => 'Parent',
        'no_parent' => 'Aucun parent',
        'inherit_property_groups' => 'Hériter des propriétés de la catégorie parente',
        'inherit_property_groups_comment' => 'Utiliser les groupes de propriétés de la catégorie parente de cette catégorie',
        'inherit_review_categories' => 'Héritage des catégories d\'avis de la catégorie parente',
        'inherit_review_categories_comment' => 'Utilisez les catégories d\'avis de la catégorie mère de cette catégorie',
    ],
    'custom_fields' => [
        'name' => 'Nom du champ',
        'type' => 'Type du champ',
        'options' => 'Options',
        'required' => 'Requis',
        'required_comment' => 'Ce champ est obligatoire pour passer une commande',
        'is_required' => 'Est requis',
        'is_not_required' => 'N\'est pas requis',
    ],
    'tax' => [
        'percentage' => 'Pourcentage',
        'countries' => 'Appliquer la taxe uniquement lors de l\'expédition dans ces pays',
        'countries_comment' => 'Si aucun pays n\'est sélectionné, la taxe est appliquée dans le monde entier.',
        'is_default' => 'Par défaut',
        'is_default_comment' => 'Cette taxe est utilisée si le pays de destination de l\'expédition n\'est pas encore connu',
    ],
    'discounts' => [
        'name' => 'Nom',
        'code' => 'Code de réduction',
        'code_comment' => 'Laissez vide pour générer un code aléatoire',
        'total_to_reach' => 'Total de commande minimal pour que la remise soit valide',
        'type' => 'Type de remise',
        'trigger' => 'Valide si',
        'rate' => 'Taux (%)',
        'amount' => 'Montant fixé',
        'max_number_of_usages' => 'Nombre maximum d\'utilisations',
        'valid_from' => 'Valable à partir de',
        'expires' => 'Expire',
        'number_of_usages' => 'Nombre d\'utilisations',
        'shipping_description' => 'Nom du mode de livraison alternatif',
        'shipping_price' => 'Prix du mode de livraison alternatif',
        'shipping_guaranteed_days_to_delivery' => 'Jours garantis de livraison',
        'section_type' => 'Que fait cette réduction ?',
        'section_trigger' => 'Quand cette réduction est-elle applicable ?',
        'types' => [
            'fixed_amount' => 'Montant fixé',
            'rate' => 'Taux',
            'shipping' => 'Envoi alternatif',
        ],
        'triggers' => [
            'total' => 'Le total de la commande est atteint',
            'code' => 'Le code de réduction est entré',
            'product' => 'Un produit spécifique est présent dans le panier',
            'shipping_method' => 'La méthode d’expédition est l’une des suivantes',
            'customer_group' => 'L’utilisateur appartient à un groupe de clients spécifique',
            'payment_method' => 'En fonction du mode de paiement',
        ],
        'validation' => [
            'empty' => 'Entrez un code promo.',
            'shipping' => 'Vous ne pouvez appliquer qu\'un seul code promotionnel qui réduit vos frais d\'expédition.',
            'duplicate' => 'Vous ne pouvez utiliser le même code promotionnel qu\'une seule fois.',
            'expired' => 'Ce code promo a expiré.',
            'not_found' => 'Ce code promo n\'est pas valide.',
            'usage_limit_reached' => 'Ce code promotionnel a été appliqué plusieurs fois et n’est donc plus valide.',
        ],
    ],
    'payment_method' => [
        'price' => 'Frais fixes',
        'price_comment' => 'Le montant à ajouter au total de la commande',
        'fee_percentage' => 'Frais de pourcentage',
        'fee_percentage_comment' => 'Le pourcentage du total à ajouter au total de la commande',
        'fee_label' => 'Étiquette des frais',
        'fee_label_comment' => 'Ce texte sera affiché au client lors de la commande.',
        'instructions' => 'Instructions de paiement',
        'instructions_comment' => 'La syntaxe Twig est prise en charge. Utilisez {{order}} pour accéder aux informations de commande correspondantes, le cas échéant.',
        'pdf_partial' => 'Partiel de la pièce jointe en PDF',
        'pdf_partial_comment' => 'Pour toutes les commandes avec ce mode de paiement, un PDF rendu à partir du partiel sélectionné sera joint au courrier de notification',
        'pdf_partial_none' => 'Pas de pièce jointe en PDF',
    ],
    'order' => [
        'order_number' => '# Commande',
        'invoice_number' => '# Facture',
        'payment_hash' => 'Paiement hash',
        'customer' => 'Client',
        'creation_date' => 'Créé le',
        'modification_date' => 'Modifié le',
        'completion_date' => 'Completé le',
        'credit_card' => 'Carte de crédit',
        'payment_status' => 'Status du paiement',
        'grand_total' => 'TOTAL',
        'billing_address' => 'Adresse de facturation',
        'shipping_address' => 'Adresse de livraison',
        'currency' => 'Devise',
        'status' => 'Statut',
        'email' => 'Email',
        'will_be_paid_later' => 'Sera payé plus tard',
        'shipping_address_same_as_billing' => 'Adresse de livraison identique à celle de facturation',
        'credit_card_last4_digits' => '4 derniers chiffres',
        'tracking_number' => 'Numéro de suivi',
        'tracking_url' => 'URL de suivi',
        'tracking_shipped' => 'Marquer la commande comme expédiée',
        'tracking_shipped_comment' => 'La commande sera marquée comme expédiée',
        'tracking_completed' => 'Marquer la commande comme terminée',
        'tracking_completed_comment' => 'La commande sera marquée comme complète',
        'tracking_notification' => 'Envoyer une notification',
        'tracking_notification_comment' => 'Une notification contenant les informations de suivi sera envoyée au client.',
        'shipping_fees' => 'Frais de port',
        'shipping_provider' => 'Fournisseur d\'expédition',
        'shipping_method' => 'Méthode d\'envoi',
        'card_holder_name' => 'Titulaire de la carte',
        'card_type' => 'Type de Panier',
        'payment_method' => 'Mode de paiement',
        'payment_gateway_used' => 'Mode de paiement',
        'tax_provider' => 'Taxe Fournisseur',
        'lang' => 'Language',
        'refunds_amount' => 'Montant des remboursements',
        'adjusted_amount' => 'Montant ajusté',
        'rebate_amount' => 'Montant du rabais',
        'total' => 'Total',
        'taxes_total' => 'Taxes total',
        'items_total' => 'Total des articles',
        'subtotal' => 'Sous total',
        'taxable_total' => 'Total taxable',
        'total_weight' => 'Poids total',
        'total_rebate_rate' => 'Remise totale',
        'notes' => 'Notes',
        'custom_fields' => 'Champs personnalisés',
        'shipping_enabled' => 'Expédition activée',
        'payment_transaction_id' => 'ID de la transaction de paiement',
        'change_order_status' => 'Changer le statut de la commande',
        'change_payment_status' => 'Changer le statut de paiement',
        'items' => 'Articles',
        'quantity' => 'Quantité',
        'shipping_address_is_same_as_billing' => 'L\'adresse de livraison est la même que l\'adresse de facturation',
        'update_shipping_state' => 'Mettre à jour l\'état d\'expédition',
        'invalid_status' => 'Le statut sélectionné n\'existe pas.',
        'updated' => 'Mise à jour de la commande réussie',
        'deleted' => 'Commande supprimée avec succès',
        'deleting' => 'Supprimer une commande...',
        'delete_confirm' => 'Voulez-vous vraiment supprimer cette commande?',
        'update_invoice_number' => 'Définir le numéro de facture',
        'shipped' => 'Expédié',
        'shipping_pending' => 'En attente de livraison',
        'not_shipped' => 'En cours',
        'data' => 'Données de commande',
        'total_revenue' => 'Revenu total',
        'download_invoice' => 'Télécharger la facture',
        'order_file_name' => 'commande-:order',
        'modal' => [
            'cancel' => 'Annuler',
            'update' => 'Mettre à jour information',
        ],
        'payment_states' => [
            'pending_state' => 'Paiement en attente',
            'failed_state' => 'Paiement échoué',
            'refunded_state' => 'Paiement remboursé',
            'paid_state' => 'Payé',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Livraison garantie en jours',
        'available_above_total' => 'Disponible si le total est supérieur ou égal à',
        'available_below_total' => 'Disponible si le total est inférieur à',
        'countries' => 'Disponible pour l\'expédition dans ces pays',
        'countries_comment' => 'Si aucun pays n\'est sélectionné, cette méthode est disponible dans le monde entier.',
        'not_required_name' => 'Pas d\'expédition requise',
        'not_required_description' => 'Le panier actuel ne nécessite aucune livraison.',
    ],
    'payment_status' => [
        'paid' => 'Payé',
        'deferred' => 'Différé',
        'paid_deferred' => 'Payé différé',
        'paiddeferred' => 'Payé différé',
        'charged_back' => 'Rechargé',
        'refunded' => 'Remboursé',
        'paidout' => 'Payé',
        'failed' => 'Échoué',
        'pending' => 'en attendant',
        'expired' => 'Expiré',
        'cancelled' => 'Annulé',
        'open' => 'En cours',
    ],
    'permissions' => [
        'manage_products' => 'Peut gérer des produits',
        'manage_categories' => 'Peut gérer des categories',
        'manage_orders' => 'Peut gérer des orders',
        'manage_discounts' => 'Peut gérer des discounts',
        'settings' => [
            'manage_general' => 'Peut modifier les paramètres généraux de la boutique',
            'manage_payment_gateways' => 'Peut modifier les paramètres de la passerelle de paiement',
            'manage_currency' => 'Possibilité de modifier les paramètres des devises de la boutique',
            'manage_payment_methods' => 'Peut changer de mode de paiement',
        ],
        'manage_properties' => 'Possibilité de modifier les propriétés des produits.',
        'manage_customer_groups' => 'Peut gérer des customer groups',
        'manage_customer_addresses' => 'Peut gérer des customer addresses',
        'manage_notifications' => 'Peut gérer des notifications',
        'manage_price_categories' => 'Peut gérer des price categories',
        'manage_order_states' => 'Peut gérer des order states',
        'manage_shipping_methods' => 'Peut gérer des shipping methods',
        'manage_taxes' => 'Peut gérer des taxes',
        'manage_payment_log' => 'Peut gérer des payment log',
        'manage_feeds' => 'Peut gérer les flux RSS',
        'manage_wishlists' => 'Peut gérer les listes de souhaits',
        'manage_services' => 'Peut gérer les services',
        'manage_reviews' => 'Peut gérer les avis',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Produits',
                'description' => 'Affiche une liste de produits',
            ],
            'properties' => [
                'no_category_filter' => 'Ne pas filtrer par catégorie',
                'use_url' => 'Utiliser le slug de catégorie depuis l\'URL',
                'filter_component' => [
                    'title' => 'Filtre alias de composant',
                    'description' => 'Alias du composant ProductsFilter qui filtre ce composant Products',
                ],
                'filter' => [
                    'title' => 'Filtrer la chaîne (string)',
                    'description' => 'Filtre forcé pour ce composant',
                ],
                'include_variants' => [
                    'title' => 'Afficher les variantes d\'article',
                    'description' => 'Ne pas montrer les produits simples mais toutes les variantes de produits disponibles',
                ],
                'include_children' => [
                    'title' => 'Inclure les enfants',
                    'description' => 'Afficher tous les produits des catégories enfants également',
                ],
                'per_page' => [
                    'title' => 'Par page',
                    'description' => 'Combien de produits à afficher par page',
                ],
                'paginate' => [
                    'title' => 'Pagination',
                    'description' => 'Paginer le résultat (afficher plus d\'une page)',
                ],
                'sort' => [
                    'title' => 'Trier',
                    'description' => 'Ceci remplace la préférence de tri de l\'utilisateur',
                ],
                'set_page_title' => [
                    'title' => 'Définir le titre de la page',
                    'description' => 'Utiliser le nom de la catégorie comme titre de la page',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filtre de produits',
                'description' => 'Filtre les produits d\'une catégorie',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Afficher le filtre de prix',
                ],
                'showBrandFilter' => [
                    'title' => 'Afficher le filtre de la marque',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Afficher le filtre en vente',
                ],
                'includeChildren' => [
                    'title' => 'Inclure les enfants',
                    'description' => 'Inclure également les propriétés et les filtres des produits dans les catégories enfants',
                ],
                'includeVariants' => [
                    'title' => 'Inclure les variantes',
                    'description' => 'Afficher les filtres pour les propriétés de variantes',
                ],
                'includeSliderAssets' => [
                    'title' => 'Inclure noUI Slider',
                    'description' => 'Inclure toutes les dépendances de noUI Slider via cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Ordre de tri',
                    'description' => 'Ordre de tri initial',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Best-seller',
                'priceLow' => 'Prix le plus bas',
                'priceHigh' => 'Prix le plus élevé',
                'latest' => 'Le plus récent',
                'oldest' => 'Le plus ancien',
                'random' => 'Au hasard',
                'manual' => 'Manuel',
                'name' => 'Nom',
                'ratings' => 'Notes',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Compte utilisateur',
                'description' => 'Affiche différents formulaires où un utilisateur peut voir et éditer son profil',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Sous-page active',
                ],
            ],
            'pages' => [
                'orders' => 'Ordres',
                'profile' => 'Profil',
                'addresses' => 'Adresses',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Profil client',
                'description' => 'Affiche un formulaire de modification de profil client.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Sélecteur de devise',
                'description' => 'Affiche un sélecteur pour sélectionner la devise de la boutique actuellement active',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Dépendances Frontend',
                'description' => 'Inclut toutes les dépendances nécessaires',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Liste d\'adresses',
                'description' => 'Affiche une liste de toutes les adresses d\'utilisateurs enregistrés',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'L\'adresse demandée est introuvable',
                'cannot_delete_last_address' => 'Vous ne pouvez pas supprimer votre dernière adresse',
            ],
            'messages' => [
                'address_deleted' => 'Adresse supprimée',
                'default_billing_address_changed' => 'L\'adresse de facturation par défaut a été modifiée',
                'default_shipping_address_changed' => 'L\'adresse de livraison par défaut a été modifiée',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Liste des commandes',
                'description' => 'Affiche une liste de toutes les commandes client',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Détails du produit',
                'description' => 'Affiche les détails d\'un produit',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Redirection sur le changement de propriété',
                    'description' => 'Rediriger l\'utilisateur vers la nouvelle page de détail si une propriété a été modifiée',
                ],
            ],
            'added_to_cart' => 'Produit ajouté avec succès',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Avis sur les produits',
                'description' => 'Affiche toutes les avis sur un produit',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Nombre d\'avis par page',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Afficher uniquement les évaluations de cette variante',
                    'description' => "Ne pas montrer les avis des autres variantes de ce produit",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Panier',
                'description' => 'Affiche le panier',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Afficher l\'applicateur de remise',
                ],
                'showShipping' => [
                    'title' => 'Afficher les frais de port',
                ],
                'showTaxes' => [
                    'title' => 'Voir taxes',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Afficher le bouton "Passer commande"',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Paiement',
                'description' => 'Gère le processus de paiement',
            ],
            'errors' => [
                'missing_settings' => 'Veuillez sélectionner un mode de paiement et d\'expédition.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Saisie du code promo',
                'description' => 'Affiche un champ de saisie du code promo',
            ],
            'discount_applied' => 'Remise appliquée avec succès!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Sélecteur d\'expédition',
                'description' => 'Affiche une liste de toutes les méthodes d\'expédition disponibles',
            ],
            'errors' => [
                'unavailable' => 'La méthode d\'expédition sélectionnée n\'est pas disponible pour votre commande.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Sélecteur de méthode de paiement',
                'description' => 'Affiche une liste de tous les modes de paiement disponibles',
            ],
            'errors' => [
                'unavailable' => 'Le mode de paiement sélectionné n\'est pas disponible pour votre commande.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Sélecteur d\'adresse',
                'description' => 'Affiche une liste de toutes les adresses d\'utilisateurs existantes',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formulaire d\'adresse',
                'description' => 'Affiche un formulaire pour modifier l\'adresse d\'un utilisateur',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Adresse',
                ],
                'redirect' => [
                    'title' => 'Redirection (après sauvegarde)',
                ],
                'set' => [
                    'title' => 'Utilisez cette adresse comme',
                ],
            ],
            'redirects' => [
                'checkout' => 'Page de paiement',
            ],
            'set' => [
                'billing' => 'Adresse de facturation',
                'shipping' => 'Adresse de livraison',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'S\'inscrire',
                'description' => 'Affiche un formulaire d\'inscription et de connexion',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Rediriger après la connexion',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Vous essayez de vous connecter avec un compte invité.',
                'unknown_user' => 'Les informations d\'identification que vous avez entrées ne sont pas valides.',
                'not_activated' => 'Votre compte doit être activé avant de pouvoir vous connecter.',
                'login' => [
                    'required' => 'Veuillez entrer une adresse courriel.',
                    'email' => 'S\'il vous plaît, mettez une adresse email valide.',
                    'between' => 'S\'il vous plaît, mettez une adresse email valide.',
                ],
                'password' => [
                    'required' => 'S\'il vous plait entrez votre mot de passe.',
                    'max' => 'Le mot de passe fourni est trop long.',
                    'min' => 'Le mot de passe fourni est trop court. Veuillez entrer au moins 8 caractères.',
                ],
                'password_repeat' => [
                    'required' => 'Veuillez répéter votre mot de passe.',
                    'same' => 'Votre confirmation de mot de passe ne correspond pas à votre mot de passe entré.',
                ],
                'email' => [
                    'required' => 'Veuillez entrer une adresse courriel.',
                    'email' => 'Cette adresse email est invalide.',
                    'unique' => 'Un utilisateur avec cette adresse email est déjà enregistré.',
                    'non_existing_user' => 'Un utilisateur avec cette adresse e-mail est déjà enregistré. Utiliser la fonction de réinitialisation du mot de passe.',
                ],
                'firstname' => [
                    'required' => 'Veuillez entrer votre nom de famille.',
                ],
                'lastname' => [
                    'required' => 'Veuillez entrez votre prénom s\'il vous plait.',
                ],
                'lines' => [
                    'required' => 'Veuillez entrez votre adresse.',
                ],
                'zip' => [
                    'required' => 'Veuillez entrez votre code postal.',
                ],
                'city' => [
                    'required' => 'Veuillez entrez votre a ville.',
                ],
                'country_id' => [
                    'required' => 'Choisissez un pays.',
                    'exists' => 'Le pays fourni n\'est pas valide.',
                ],
                'state_id' => [
                    'required' => 'Choisissez un état',
                    'exists' => 'La valeur sélectionnée n\'est pas valide.',
                ],
                'terms_accepted' => [
                    'required' => 'Veuillez accepter nos conditions générales de vente. .',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Catégories',
                'description' => 'Liste des catégories disponibles',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Catégorie de départ',
                    'description' => 'Afficher uniquement les catégories enfants de cette catégorie',
                ],
                'categorySlug' => [
                    'title' => 'Paramètre de slug de catégorie',
                    'description' => 'Utilisez ce paramètre pour charger la catégorie parente à partir de l\'URL',
                ],
                'categoryPage' => [
                    'title' => 'Page de catégorie',
                    'description' => 'Des liens indiqueront cette page. Si rien n\'est entré, les paramètres par défaut des paramètres du backend seront utilisés.',
                ],
            ],
            'no_parent' => 'Afficher toutes les catégories',
            'by_slug' => 'Utilisez la catégorie dans l\'URL en tant que parent',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Résumé du panier',
                'description' => 'Affiche le nombre de produits dans et la valeur totale du panier',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Afficher le nombre de produits',
                    'description' => 'Affiche le nombre d\'articles dans le panier',
                ],
                'showTotalPrice' => [
                    'title' => 'Afficher la valeur totale',
                    'description' => 'Affiche la valeur totale de tous les articles du panier.',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Tableau de bord client',
                'description' => 'Affiche un lien permettant au client de se connecter et de modifier les paramètres de son compte',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Etiquette du tableau de bord client',
                    'description' => 'Texte du lien pour la page du compte client',
                ],
                'logoutLabel' => [
                    'title' => 'Étiquette de déconnexion',
                    'description' => 'Texte du lien pour le lien de déconnexion',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Amélioration de la composante commerce électronique (UA)',
                'description' => 'Mise en place d\'une couche de données Google Tag Manager',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Bouton de la liste de souhaits',
                'description' => 'Affiche un bouton de liste de souhaits',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Produit',
                    'description' => 'ID du produit',
                ],
                'variant' => [
                    'name' => 'Variante',
                    'description' => 'ID de la variante',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Listes de souhaits',
                'description' => 'Affiche le gestionnaire de liste de souhaits',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Afficher l\'expédition',
                    'description' => 'Afficher les frais d\'expédition et le sélecteur',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'À partir de (poids en grammes)',
        'to_weight' => 'Jusqu\'À (Poids en grammes)',
    ],
    'products' => [
        'variants_comment' => 'Créer différentes variantes du même produit',
    ],
    'order_states' => [
        'name' => 'Nom',
        'description' => 'Description',
        'color' => 'Couleur',
        'flag' => 'Drapeau spécial',
        'flags' => [
            'new' => 'Définir l\'état de la commande comme "nouveau"',
            'complete' => 'Définir l\'état de la commande comme "terminé"',
            'cancelled' => 'Définir l\'état de la commande comme "annulé"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Ce code peut être utilisé pour identifier ce groupe par programmation',
        'discount_comment' => 'Donnez à ce groupe de clients une remise spécifique en% sur tout votre catalogue',
    ],
    'order_status' => [
        'processed' => 'Traité',
        'disputed' => 'Contesté',
        'shipped' => 'Expédié',
        'delivered' => 'Livré',
        'pending' => 'En attendant',
        'cancelled' => 'Annulé',
    ],
    'notifications' => [
        'enabled' => 'Activée',
        'enabled_comment' => 'Cette notification est activée',
        'template' => 'Template mail',
    ],
    'payment_log' => [
        'payment_data' => 'Données de paiement',
        'data_comment' => 'Ces données ont été renvoyées par le fournisseur de paiement',
        'order_data_comment' => 'Toutes les données de commande pour ce paiement',
        'message_comment' => 'Ce message a été renvoyé par le fournisseur de paiement',
        'code_comment' => 'Ce code a été renvoyé par le fournisseur de paiement',
        'failed_only' => 'Échoué Seulement',
    ],
    'services' => [
        'options' => 'Options',
        'option' => 'Option',
        'required' => 'Le service est requis',
        'required_comment' => 'Une option de ce service doit être sélectionnée lorsqu\'un produit est ajouté au panier.',
    ],
    'reviews' => [
        'rating' => 'Avis',
        'review' => 'Détails de l\'avis',
        'title' => 'Titre de votre évaluation',
        'pros' => 'Aspects positifs',
        'cons' => 'Aspects négatifs',
        'anonymous' => 'Anonyme',
        'only_unapproved' => 'Afficher seulement ceux qui ne sont pas approuvés',
        'no_more' => 'Plus aucun avis non approuvé',
        'approved' => 'Avis approuvé',
        'approve' => 'Approuver l\'avis',
        'approve_next' => 'Approuver et passer au suivant',
    ],
];
