<?php return [
    'plugin' => [
        'name' => 'Mall',
        'description' => 'Solución de E-commerce para October CMS',
    ],
    'titles' => [
        'products' => [
            'create' => 'Crear producto',
            'update' => 'Editar producto',
            'preview' => 'Previsualizar producto',
        ],
        'categories' => [
            'create' => 'Crear categoría',
            'update' => 'Editar categoría',
            'preview' => 'Previsualizar Categoría',
        ],
        'orders' => [
            'show' => 'Detalles de Orden',
            'export' => 'Exportar pedidos',
        ],
        'discounts' => [
            'create' => 'Crear descuento',
            'update' => 'Editar descuento',
            'preview' => 'Previsualizar descuento',
        ],
        'services' => [
            'create' => 'Crear servicio',
            'update' => 'Editar servicio',
        ],
        'shipping_methods' => [
            'create' => 'Crear método de despacho',
            'update' => 'Editar método de despacho',
            'preview' => 'Previsualizar método de despacho',
        ],
        'payment_methods' => [
            'create' => 'Crear medio de pago',
            'edit' => 'Editar medio de pago',
            'reorder' => 'Reordenar',
        ],
        'custom_field_options' => [
            'edit' => 'Configurar opciones de campo',
        ],
        'properties' => [
            'create' => 'Crear propiedades',
            'edit' => 'Editar propiedades',
        ],
        'order_states' => [
            'create' => 'Crear estado',
            'edit' => 'Editar estado',
            'reorder' => 'Reordenar estados',
        ],
        'brands' => [
            'create' => 'Crear marca',
            'edit' => 'Editar marca',
        ],
        'property_groups' => [
            'create' => 'Crear grupo',
            'edit' => 'Editar grupo',
        ],
        'customer_groups' => [
            'create' => 'Crear grupo',
            'update' => 'Editar grupo',
        ],
        'notifications' => [
            'update' => 'Actualizar notificación',
        ],
        'taxes' => [
            'create' => 'Crear impuesto',
            'update' => 'Editar impuesto',
        ],
        'reviews' => [
            'create' => 'Crear reseña',
            'update' => 'Editar reseña',
        ],
    ],
    'menu_items' => [
        'all_categories' => 'Todas las categorías de la tienda',
        'single_category' => 'Sólo una categoría de la tienda',
        'all_products' => 'Todos los productos de la tienda',
        'all_variants' => 'Todas las variantes de la tienda',
    ],
    'currency_settings' => [
        'label' => 'Divisas',
        'description' => 'Configurar tus divisas',
        'currencies' => 'Ingresa sólo códigos oficiales de 3 caracteres.',
        'currency_code' => 'Código de divisa',
        'currency_decimals' => 'Posiciones decimales',
        'currency_rounding' => 'Redondear el total',
        'currency_rounding_comment' => 'El total, con impuestos, se redondeará a este valor si la divisa está activa.',
        'currency_format' => 'Formato',
        'currency_symbol' => 'Símbolo',
        'currency_rate' => 'Tasa de cambio',
        'is_default' => 'Por omisión',
        'unknown' => 'Divisa Desconocida',
    ],
    'payment_gateway_settings' => [
        'label' => 'Portales de pago',
        'description' => 'Configura tus portales de pago',
        'stripe' => [
            'api_key' => 'API Key de Stripe',
            'api_key_comment' => 'Puedes encontrarla en el Dashboard de Stripe',
            'publishable_key' => 'Publishable Key de Stripe',
            'publishable_key_comment' => 'Puedes encontrarla en el Dashboard de Stripe',
        ],
        'paypal' => [
            'client_id' => 'ID de cliente PayPal',
            'secret' => 'Clave secreta de PayPal',
            'test_mode' => 'Modo de prueba',
            'test_mode_comment' => 'Ejecutar todos los pagos en el sandbox de PayPal.',
        ],
        'postfinance' => [
            'test_mode' => 'Modo de prueba',
            'test_mode_comment' => 'Realizar pagos contra el ambiente de pruebas',
            'pspid' => 'PSPID (Nombre de usuario)',
            'hashing_method' => 'Hash algorithm',
            'hashing_method_comment' => 'Configuración -> Información Técnica -> Parámetros globales de Seguridad',
            'sha_in' => 'Firma SHA-IN',
            'sha_in_comment' => 'Configuración -> Información Técnica -> Datos y verificación de origen',
            'sha_out' => 'Firma SHA-OUT',
            'sha_out_comment' => 'Configuración -> Información Técnica -> Feedback de Transacción',
        ],
    ],
    'notification_settings' => [
        'label' => 'Notificaciones',
        'description' => 'Configura las notificaciones de la tienda',
    ],
    'price_category_settings' => [
        'label' => 'Categorías de Precio',
        'description' => 'Configura categorías de precio adicionales',
    ],
    'order_state_settings' => [
        'description' => 'Configurar estados de pedidos',
    ],
    'payment_method_settings' => [
        'description' => 'Gestionar medios de pago',
    ],
    'shipping_method_settings' => [
        'description' => 'Gestionar métodos de despacho',
    ],
    'tax_settings' => [
        'description' => 'Gestionar impuestos',
    ],
    'general_settings' => [
        'category' => 'Mall: General',
        'category_payments' => 'Mall: Pagos',
        'category_orders' => 'Mall: Pedidos',
        'label' => 'Configuración',
        'description' => 'Ajustes Generales',
        'product_page' => 'Página de detalle de productos',
        'product_page_comment' => 'En esta página se mostrarán los detalles de tus productos',
        'address_page' => 'Página de dirección',
        'address_page_comment' => 'La página seleccionada debe contar con el componente addressForm',
        'checkout_page' => 'Página de Checkout',
        'checkout_page_comment' => 'El componente checkout debe estar presente en esta página',
        'account_page' => 'Página de perfil',
        'account_page_comment' => 'El componente myAccount debe estar presente en esta página',
        'cart_page' => 'Página de carro',
        'cart_page_comment' => 'El componente cart debe estar presente en esta página',
        'category_page' => 'Página de categoría para listado de productos',
        'redirect_to_cart' => 'Redireccionar al carro',
        'redirect_to_cart_comment' => 'Redireccionar al carro después de que el usuario agrega un producto',
        'use_state' => 'Usar el campo de Estado/País/Provincia',
        'use_state_comment' => 'Los clientes deben seleccionar un Estado/País/Provincia durante el registro',
        'group_search_results_by_product' => 'Agrupar resultados por producto',
        'group_search_results_by_product_comment' => 'Mostrar un Producto sólo una vez en resultados de búsqueda, no incluir las Variantes',
        'shipping_selection_before_payment' => 'Select shipping method BEFORE payment during checkout',
        'shipping_selection_before_payment_comment' => 'By default, during checkout, the user is first asked to select a payment method before selecting a shipping method; use this option to reverse this logic',
        'admin_email' => 'Email del administrador',
        'admin_email_comment' => 'Las notificaciones de administración serán enviadas a esta dirección',
        'base' => 'Ajustes de Base',
        'links' => 'Páginas del CMS',
        'links_comment' => 'Elegir las páginas en las que se mostrarán tus productos',
        'customizations' => 'Personalizaciones',
        'customizations_comment' => 'Personalizar las características de tu tienda',
        'category_page_comment' => 'Agregar el componente "products" a esta página.',
        'order_number_start' => 'Número del primer pedido',
        'order_number_start_comment' => 'ID inicial del primer pedido',
        'index_driver' => 'Controlador del índice',
        'index_driver_comment' => 'Si tu base de datos soporta JSON utiliza el controlador de base de datos.',
        'index_driver_filesystem' => 'Sistema de archivos',
        'index_driver_database' => 'Base de Datos (sólo para MySQL 5.7+ o MariaDB 10.2+)',
        'index_driver_hint' => 'Si cambias esta opción asegúrate de correr "php artisan mall:reindex"en la línea de comandos para reindexar tus productos!',
    ],
    'feed_settings' => [
        'description' => 'Configurar feeds para Mall',
        'google_merchant_enabled' => 'Activar feed de Google Merchant Center',
        'google_merchant_enabled_comment' => 'Se generará un feed de productos',
        'google_merchant_url' => 'URL del feed en Google Merchant',
        'google_merchant_url_locale' => 'Agregar ?locale=xy para obtener un listado localizado.',
    ],
    'review_settings' => [
        'description' => 'Configurar reseñas',
        'enabled' => 'Reseñas habilitadas',
        'enabled_comment' => 'Los clientes pueden dejar reseñas',
        'moderated' => 'Moderar reseñas',
        'moderated_comment' => 'Reseñas nuevas deben ser publicadas manualmente por el administrador del sitio',
        'allow_anonymous' => 'Permitir reseñas anónimas',
        'allow_anonymous_comment' => 'Usuarios no registrados pueden dejar reseñas',
    ],
    'common' => [
        'shop' => 'Tienda',
        'products' => 'Productos',
        'product' => 'Producto',
        'orders' => 'Pedidos',
        'cart' => 'Carro',
        'shipping' => 'Despacho',
        'taxes' => 'Impuestos',
        'rates' => 'Tarifas',
        'inventory' => 'Inventario',
        'accessories' => 'Accesorios',
        'shipping_methods' => 'Métodos de despacho',
        'accessory' => 'Accesorio',
        'custom_fields' => 'Campos personalizados',
        'variants' => 'Variantes',
        'variant' => 'Variante',
        'discounts' => 'Descuentos',
        'discount' => 'Descuento',
        'discount_percentage' => 'Descuento (%)',
        'select_placeholder' => '-- Selecciona',
        'main_image' => 'Imagen Principal',
        'images' => 'Imágenes',
        'image_set' => 'Conjunto de Imágenes',
        'attachments' => 'Imágenes/Descargas/Embeds',
        'downloads' => 'Descargas',
        'select_image' => 'Elegir imagen',
        'select_file' => 'Seleccionar archivo',
        'allowed' => 'Permitido',
        'not_allowed' => 'No permitido',
        'yes' => 'Sí',
        'no' => 'No',
        'seo' => 'SEO',
        'properties_links' => 'Propiedades/Enlaces',
        'categories' => 'Categorías',
        'category' => 'Categoría',
        'meta_title' => 'Meta: Título',
        'meta_description' => 'Meta: Descripción',
        'meta_keywords' => 'Meta: Palabras clave',
        'reorder' => 'Reordenar entradas',
        'id' => 'ID',
        'created_at' => 'Creado',
        'updated_at' => 'Actualizado',
        'approved_at' => 'Aprobado',
        'hide_published' => 'Ocultar publicados',
        'slug' => 'URL',
        'name' => 'Nombre',
        'display_name' => 'Nombre de pantalla',
        'group_name' => 'Nombre del grupo',
        'add_value' => 'Agregar valor',
        'export_orders' => 'Exportar pedidos',
        'use_backend_defaults' => 'Utilizar los valores por omisión configurados en los ajustes de backend',
        'api_error' => 'No se pudo guardar el descuento. Se produjo un error al enviar los cambios a la API de Mall.',
        'includes_tax' => 'Con impuestos',
        'conditions' => 'Condiciones',
        'general' => 'General',
        'logo' => 'Logo',
        'payment_gateway' => 'Portal de pagos',
        'payment_provider' => 'Proveedor de pagos',
        'payment_methods' => 'Medios de pago',
        'payment' => 'Pago',
        'payments' => 'Pagos',
        'image' => 'Imagen',
        'color' => 'Color',
        'unit' => 'Unidad',
        'dont_group' => '-- No agrupar',
        'properties' => 'Propiedades',
        'old_price' => 'Precio anterior',
        'property' => 'Propiedad',
        'property_groups' => 'Grupos de propiedades',
        'property_group' => 'Grupo de propiedades',
        'options' => 'Opciones',
        'option' => 'Opción',
        'catalogue' => 'Catálogo',
        'out_of_stock' => 'Este producto se encuentra agotado.',
        'out_of_stock_short' => 'Agotado',
        'stock_limit_reached' => 'No puedes agregar más unidades de este producto al carro debido a que se ha alcanzado el límite disponible.',
        'deleted_at' => 'Eliminado',
        'sort_order' => 'Ordenar por',
        'order_states' => 'Ordenar Estados',
        'website' => 'Sitio web',
        'brands' => 'Marcas',
        'brand' => 'Marca',
        'sorting_updated' => 'Se ha actualizado el orden',
        'not_in_use' => 'La opción no está en uso',
        'saved_changes' => 'Cambios guardados exitosamente',
        'none' => '-- Ninguno',
        'customers' => 'Clientes',
        'customer_groups' => 'Grupos de clientes',
        'customer_group' => 'Grupo de clientes',
        'product_or_variant' => 'Producto/Variante',
        'code' => 'Código',
        'code_comment' => 'Este código puede ser utilizado para identificar este registro programáticamente',
        'checked' => 'Seleccionado',
        'unchecked' => 'Deseleccionado',
        'notifications' => 'Notificaciones',
        'notification' => 'Notificación',
        'price_missing' => 'Ingresa al menos el precio para la divisa por omisión',
        'slug_unique' => 'La URL debe ser única',
        'fees' => 'Cargos',
        'value' => 'Valor',
        'action_required' => 'Se requiere acción!',
        'invalid_quantity' => 'La cantidad especificada no es válida',
        'addresses' => 'Direcciones',
        'address' => 'Dirección',
        'reference' => 'Referencia',
        'session_id' => 'ID de sesión',
        'message' => 'Mensaje',
        'payment_method' => 'Medio de pago',
        'data' => 'Datos',
        'successful' => 'Exitoso',
        'failed' => 'Fallido',
        'caution' => 'Precaución',
        'since_begin' => 'Desde el principio',
        'weekly' => 'Semanalmente',
        'feeds' => 'Feeds',
        'services' => 'Servicios',
        'service' => 'Servicio',
        'review' => 'Reseña',
        'reviews' => 'Reseñas',
        'review_categories' => 'Categorías de reseñas',
        'review_category' => 'Categoría de reseñas',
        'title' => 'Título',
        'version' => 'Versión',
    ],
    'variant' => [
        'method' => [
            'single' => 'Artículo',
            'variant' => 'Variantes de artículo',
        ],
    ],
    'properties' => [
        'use_for_variants' => 'Usar para variantes',
        'use_for_variants_comment' => 'Esta propiedad es diferente para distintas variantes de este producto',
        'filter_type' => 'Tipo de filtro',
        'filter_types' => [
            'none' => 'Sin filtro',
            'set' => 'Conjunto',
            'range' => 'Rango',
        ],
    ],
    'custom_field_options' => [
        'text' => 'Campo de texto',
        'integer' => 'Número entero',
        'float' => 'Número decimal',
        'textarea' => 'Campo de texto en múltiples líneas',
        'richeditor' => 'Texto enriquecido',
        'dropdown' => 'Menú de selección',
        'checkbox' => 'Recuadro',
        'color' => 'Color',
        'image' => 'Imagen',
        'add' => 'Agregar opción',
        'name' => 'Nombre',
        'price' => 'Precio',
        'attributes' => 'Atributo',
        'option' => 'Opción',
    ],
    'product' => [
        'user_defined_id' => 'ID del Producto',
        'name' => 'Nombre de Producto',
        'published' => 'Publicado',
        'published_short' => 'Publ.',
        'is_virtual' => 'Es Virtual',
        'is_virtual_comment' => 'Este producto es virtual (un archivo, sin despacho)',
        'product_file' => 'Archivo',
        'product_files' => 'Archivos',
        'product_files_section_comment' => 'Este es un producto virtual. Puedes subir nuevas versiones del archivo a continuación. La última versión será descargable por los clientes.',
        'product_file_version' => 'Versión de archivo',
        'not_published' => 'No publicado',
        'published_comment' => 'Este producto se encontrará visible en el sitio web',
        'stock' => 'Existencias',
        'price' => 'Precio',
        'description_short' => 'Descripción corta',
        'description' => 'Descripción',
        'weight' => 'Peso (g)',
        'length' => 'Largo (mm)',
        'height' => 'Alto (mm)',
        'width' => 'Ancho (mm)',
        'quantity_default' => 'Cantidad por omisión',
        'quantity_min' => 'Cantidad mínima',
        'quantity_max' => 'Cantidad máxima',
        'inventory_management_method' => 'Método de gestión de inventario',
        'allow_out_of_stock_purchases' => 'Permitir compras sin existencias',
        'allow_out_of_stock_purchases_comment' => 'Este producto puede sear solicitado aunque no quede inventario disponible',
        'stackable' => 'Apilar en el carro',
        'stackable_comment' => 'Si el producto es agregado al carro en múltiples oportunidades, sólo mostrar una entrada (incrementar cantidad)',
        'shippable' => 'Despachable',
        'shippable_comment' => 'Este producto es despachable',
        'taxable' => 'Gravable',
        'taxable_comment' => 'Calcular impuestos en este producto',
        'add_currency' => 'Agregar divisa',
        'is_taxable' => 'Usar impuesto',
        'is_not_taxable' => 'No usar impuestos',
        'currency' => 'Divisa',
        'general' => 'General',
        'duplicate_currency' => 'Has ingresado múltiples precios para la misma divisa',
        'property_title' => 'Título',
        'property_value' => 'Valor',
        'link_title' => 'Título',
        'link_target' => 'URL de destino',
        'embed_title' => 'Título',
        'embed_code' => 'Código para embeber',
        'properties' => 'Propiedades',
        'links' => 'Enlaces',
        'embeds' => 'Embeds',
        'details' => 'Detalles',
        'price_includes_tax' => 'Precio incluye impuestos',
        'price_includes_tax_comment' => 'El precio definido incluye todos los impuestos',
        'group_by_property' => 'Atributo para agrupar variantes',
        'additional_descriptions' => 'Descripciones adicionales',
        'additional_properties' => 'Propiedades adicionales',
        'gtin' => 'Número Global de Artículo Comercial (GTIN)',
        'mpn' => 'Número de Pieza del Fabricante (MPN)',
        'price_table_modal' => [
            'trigger' => 'Editar existencias y precios',
            'label' => 'Precio y existencias',
            'title' => 'Vista rápida de precios y existencias',
            'currency_dropdown' => 'Divisa: ',
        ],
        'missing_category' => 'El producto no está asociado a alguna categoría. Por favor selecciona una categoría para editar el producto.',
        'variant_support_header' => 'No se permiten variantes',
        'variant_support_text' => 'La categoría seleccionada no cuenta con propiedades de variantes. Por favor cambien el método de gestión de inventario a "Artículo" o seleccione otra categoría',
        'filter_virtual' => 'Mostrar sólo productos virtuales',
    ],
    'product_file' => [
        'display_name_comment' => 'Este nombre será visible al cliente.',
        'version_comment' => 'Un identificador único de versión ayuda al cliente a reconocer actualizaciones de archivos.',
        'expires_after_days' => 'Días de validez de la descarga',
        'expires_after_days_comment' => 'El archivo sólo puede ser descargado por esta cantidad de días después de la compra. Dejar en blanco para no establecer un límite.',
        'max_download_count' => 'Cantidad máxima de descargas',
        'max_download_count_comment' => 'El archivo sólo puede ser descargado esta cantidad de veces. Dejar en blanco para no establecer un límite.',
        'session_required' => 'Requiere inicio de sesión',
        'session_required_comment' => 'El archivo sólo puede ser descargado por un cliente autentificado (no permite compartir el enlace de descarga).',
        'file' => 'Archivo',
        'download_count' => 'Descargas ejecutadas',
        'errors' => [
            'invalid' => 'Enlace de descarga inválido',
            'expired' => 'Enlace de descarga expirado',
            'too_many_attempts' => 'Demasiados intentos de descarga',
            'not_found' => 'No se encuentra el archivo solicitado. Por favor, contáctenos para recibir soporte técnico.',
        ],
        'hint' => [
            'intro' => 'Este producto no tiene un archivo adjunto. Por favor asegúrese de agregar uno o de generarlo programáticamente durente el proceso de checkout.',
            'info_text' => 'Puedes encontrar información de cómo hacer esto',
            'info_link' => 'en la documentación',
        ],
    ],
    'image_sets' => [
        'is_main_set' => 'Es el conjunto principal',
        'is_main_set_comment' => 'Usar este conjunto de imágenes para este producto',
        'create_new' => 'Crear nuevo conjunto',
    ],
    'category' => [
        'name' => 'Nombre',
        'code' => 'Código',
        'code_comment' => 'Este código puede ser usado para identificar esta categoría en los parciales de frontend.',
        'parent' => 'Categoría padre',
        'no_parent' => 'Sin padre',
        'inherit_property_groups' => 'Heredar grupos de propiedades de la categoría padre',
        'inherit_property_groups_comment' => 'Usar los grupos de propiedades de la categoría padre seleccionada',
        'inherit_review_categories' => 'Heredar categorías de reseñas de la categoría padre',
        'inherit_review_categories_comment' => 'Usar las categorías de reseña de la categoría padre seleccionada',
    ],
    'custom_fields' => [
        'name' => 'Nombre del campo',
        'type' => 'Tipo de campo',
        'options' => 'Opciones',
        'required' => 'Requerido',
        'required_comment' => 'Este campo es requerido para poder realizar un pedido',
        'is_required' => 'Requerido',
        'is_not_required' => 'No requerido',
    ],
    'tax' => [
        'percentage' => 'Porcentaje',
        'countries' => 'Sólo aplicar impuestos al despachar a estos países',
        'countries_comment' => 'Si no se seleccionan países el impuesto se aplica a nivel mundial.',
        'is_default' => 'Por omisión',
        'is_default_comment' => 'Este impuesto es usado si aún se desconoce el país de despacho',
    ],
    'discounts' => [
        'name' => 'Nombre',
        'code' => 'Código de descuento',
        'code_comment' => 'Dejar vacío para generar un código aleatorio',
        'total_to_reach' => 'Cantidad mínima en el pedido para que el descuento sea válido',
        'type' => 'Tipo de descuento',
        'trigger' => 'Válido si',
        'rate' => 'Tasa (%)',
        'amount' => 'Cantidad fija',
        'max_number_of_usages' => 'Cantidad máxima de usos',
        'valid_from' => 'Válido desde',
        'expires' => 'Expira',
        'number_of_usages' => 'Cantidad de usos',
        'shipping_description' => 'Nombre del medio alternativo de despacho',
        'shipping_price' => 'Precio del medio alternativo de despacho',
        'shipping_guaranteed_days_to_delivery' => 'Cantidad de días garantizados para recepción del producto',
        'section_type' => '¿Qué hace este descuento?',
        'section_trigger' => '¿Cuándo puede utilizarse este descuento?',
        'types' => [
            'fixed_amount' => 'Cantidad fija',
            'rate' => 'Porcentaje',
            'shipping' => 'Despacho alternativo',
        ],
        'triggers' => [
            'total' => 'Se llega al total del pedido',
            'code' => 'Se ingresa el código de descuento',
            'product' => 'Un producto específico se encuentra en el carro',
            'shipping_method' => 'El método de envío es uno de los siguientes',
            'customer_group' => 'El usuario pertenece a un grupo de clientes específico',
            'payment_method' => 'Según la forma de pago',
        ],
        'validation' => [
            'empty' => 'Ingresa un código de promoción.',
            'shipping' => 'Sólo puedes usar un código de promoción para reducir tu tarifa de despacho.',
            'duplicate' => 'Puedes usar el código de promoción sólo una vez.',
            'expired' => 'El código de promoción ha expirado.',
            'not_found' => 'El código ingresado no es válido.',
            'usage_limit_reached' => 'Este código de promoción ha excedido la cantidad disponible y por lo tanto ya no es válido.',
        ],
    ],
    'payment_method' => [
        'price' => 'Tarifa plana',
        'price_comment' => 'Cantidad a agregar al total del pedido',
        'fee_percentage' => 'Tarifa porcentual',
        'fee_percentage_comment' => 'El porcentaje del pedido a agregar al total',
        'fee_label' => 'Nombre de la tarifa',
        'fee_label_comment' => 'Este texto se mostrará a los clientes en el proceso de checkout.',
        'instructions' => 'Instrucciones de pago',
        'instructions_comment' => 'Puedes utilizar sintaxis de Twig. Usa {{ order }} o {{ cart }} para acceder a la información correspondiente si es que se encuentra disponible',
        'pdf_partial' => 'Parcial para el PDF adjunto',
        'pdf_partial_comment' => 'Para todas los pedidos con este medio de pago, se adjuntará un archivo PDF al correo electrónico generado a partir del parcial seleccionado.',
        'pdf_partial_none' => 'Sin PDF adjunto',
    ],
    'order' => [
        'order_number' => '# Pedido',
        'invoice_number' => '# Factura',
        'payment_hash' => 'Hash de pago',
        'customer' => 'Cliente',
        'creation_date' => 'Creado',
        'modification_date' => 'Modificado',
        'completion_date' => 'Completado',
        'credit_card' => 'Tarjeta de crédito',
        'payment_status' => 'Estado del pago',
        'grand_total' => 'Total',
        'billing_address' => 'Dirección de facturación',
        'shipping_address' => 'Dirección de despacho',
        'currency' => 'Divisa',
        'status' => 'Estado',
        'email' => 'Email',
        'will_be_paid_later' => 'Se pagará más adelante',
        'shipping_address_same_as_billing' => 'La dirección de despacho es la misma que la de facturación',
        'credit_card_last4_digits' => 'Últimos 4 dígitos',
        'tracking_number' => 'Número de tracking',
        'tracking_url' => 'URL de tracking',
        'tracking_shipped' => 'Marcar pedido como despachado',
        'tracking_shipped_comment' => 'El pedido se marcará como despachado',
        'tracking_completed' => 'Marcar pedido como completado',
        'tracking_completed_comment' => 'El pedido se marcará como completado',
        'tracking_notification' => 'Enviar notificación',
        'tracking_notification_comment' => 'Una notificación con la información de tracking será enviada al cliente',
        'shipping_fees' => 'Cargos de despacho',
        'shipping_provider' => 'Proveedor logístico',
        'shipping_method' => 'Medio de despacho',
        'card_holder_name' => 'Nombre en la tarjeta',
        'card_type' => 'Tipo de tarjeta',
        'payment_method' => 'Medio de pago',
        'payment_gateway_used' => 'Portal de pagos',
        'tax_provider' => 'Proveedor de impuestos',
        'lang' => 'Idioma',
        'refunds_amount' => 'Monto del reembolso',
        'adjusted_amount' => 'Monto ajustado',
        'rebate_amount' => 'Monto de rebaja',
        'total' => 'Total',
        'taxes_total' => 'Impuestos totales',
        'items_total' => 'Total productos',
        'subtotal' => 'Subtotal',
        'taxable_total' => 'Total imponible',
        'total_weight' => 'Peso total',
        'total_rebate_rate' => 'Total descuento',
        'notes' => 'Notas',
        'custom_fields' => 'Campos personalizados',
        'shipping_enabled' => 'Despacho habilitado',
        'payment_transaction_id' => 'ID de transacción de pago',
        'change_order_status' => 'Cambiar estado del pedido',
        'change_payment_status' => 'Cambiar estado del pago',
        'items' => 'Ítemes',
        'quantity' => 'Cantidad',
        'shipping_address_is_same_as_billing' => 'La dirección de despacho es la misma que la dirección de facturación',
        'update_shipping_state' => 'Actualizar estado de despacho',
        'invalid_status' => 'El estado de despacho seleccionado no existe.',
        'updated' => 'El pedido se ha actualizado exitosamente',
        'deleted' => 'El pedido se ha eliminado exitosamente',
        'deleting' => 'Eliminando pedido...',
        'delete_confirm' => '¿Realmente quieres eliminar este pedido?',
        'update_invoice_number' => 'Fijar número de factura',
        'shipped' => 'Enviado',
        'shipping_pending' => 'Medio de despacho',
        'not_shipped' => 'Pendiente',
        'data' => 'Datos del pedido',
        'total_revenue' => 'Utilidad total',
        'download_invoice' => 'Descargar factura',
        'order_file_name' => 'pedido-:order',
        'modal' => [
            'cancel' => 'Cancelar',
            'update' => 'Actualizar información',
        ],
        'payment_states' => [
            'pending_state' => 'Pago pendiente',
            'failed_state' => 'Pago falló',
            'refunded_state' => 'Pago reembolsado',
            'paid_state' => 'Pagado',
        ],
    ],
    'shipping_method' => [
        'guaranteed_delivery_days' => 'Despacho garantizado en días',
        'available_above_total' => 'Disponible si el total es mayor o igual a',
        'available_below_total' => 'Disponible si el total es menor que',
        'countries' => 'Disponible para despacho a estos países',
        'countries_comment' => 'Si no se selecciona país, este medio estará disponible a nivel mundial.',
        'not_required_name' => 'No se necesita despacho',
        'not_required_description' => 'El carro no requiere despacho.',
    ],
    'payment_status' => [
        'paid' => 'Pagado',
        'deferred' => 'Diferido',
        'paid_deferred' => 'Pago diferido',
        'paiddeferred' => 'Pago diferido',
        'charged_back' => 'Charged back',
        'refunded' => 'Reembolsado',
        'paidout' => 'Pagado a proveedor',
        'failed' => 'Fallado',
        'pending' => 'Pendiente',
        'expired' => 'Expirado',
        'cancelled' => 'Cancelado',
        'open' => 'Abierto',
    ],
    'permissions' => [
        'manage_products' => 'Puede gestionar productos',
        'manage_categories' => 'Puede gestionar categorías',
        'manage_orders' => 'Puede gestionar pedidos',
        'manage_discounts' => 'Puede gestionar descuentos',
        'settings' => [
            'manage_general' => 'Puede gestionar ajustes generales de la tienda',
            'manage_payment_gateways' => 'Puede gestionar ajustes de portales de pagos',
            'manage_currency' => 'Puede gestionar ajustes de divisas',
            'manage_payment_methods' => 'Puede gestionar métodos de pago',
        ],
        'manage_properties' => 'Puede editar propiedades de productos',
        'manage_customer_groups' => 'Puede gestionar grupos de clientes',
        'manage_customer_addresses' => 'Puede gestionar direcciones de clientes',
        'manage_notifications' => 'Puede gestionar notificaciones',
        'manage_price_categories' => 'Puede gestionar categorías de precios',
        'manage_order_states' => 'Puede gestionar estados de pedidos',
        'manage_shipping_methods' => 'puede gestionar medios de despacho',
        'manage_taxes' => 'Puede gestionar impuestos',
        'manage_payment_log' => 'Puede gestionar el registro de pagos',
        'manage_feeds' => 'Puede gestionar feeds',
        'manage_wishlists' => 'Puede gestionar listas de deseos',
        'manage_services' => 'Puede gestionar servicios',
        'manage_reviews' => 'Puede gestionar reseñas',
    ],
    'components' => [
        'products' => [
            'details' => [
                'name' => 'Productos',
                'description' => 'Muestra una lista de productos',
            ],
            'properties' => [
                'no_category_filter' => 'No filtrar por categoría',
                'use_url' => 'Usar el slug de categoría desde la URL',
                'filter_component' => [
                    'title' => 'Alias del componente de filtro',
                    'description' => 'Alias del componente ProductsFilter que filtra este componente de Productos',
                ],
                'filter' => [
                    'title' => 'Filtrar por',
                    'description' => 'Forzar el filtro para este componente',
                ],
                'include_variants' => [
                    'title' => 'Mostrar variantes de artículos',
                    'description' => 'No mostrar productos únicos sino todas sus variantes disponibles',
                ],
                'include_children' => [
                    'title' => 'Incluir hijos',
                    'description' => 'También mostrar todos los productos de categorías anidadas',
                ],
                'per_page' => [
                    'title' => 'Por página',
                    'description' => 'Cantidad de productos a mostrar por página',
                ],
                'paginate' => [
                    'title' => 'Paginar',
                    'description' => 'Paginar el resultado (mostrar más de una página)',
                ],
                'sort' => [
                    'title' => 'Orden',
                    'description' => 'Esto sobreescribe la preferencia de pedido establecida por el cliente',
                ],
                'set_page_title' => [
                    'title' => 'Fijar título de página',
                    'description' => 'Usar el nombre de la categoría como título de página',
                ],
            ],
        ],
        'productsFilter' => [
            'details' => [
                'name' => 'Filtro de productos',
                'description' => 'Filtra el listado de productos por categoría',
            ],
            'properties' => [
                'showPriceFilter' => [
                    'title' => 'Mostrar filtro de precio',
                ],
                'showBrandFilter' => [
                    'title' => 'Mostrar filtro de marca',
                ],
                'showOnSaleFilter' => [
                    'title' => 'Mostrar filtro de artículos en oferta',
                ],
                'includeChildren' => [
                    'title' => 'Incluir hijos',
                    'description' => 'Adicionalmente incluye propiedades y filtros de categorías anidadas',
                ],
                'includeVariants' => [
                    'title' => 'Incluir variantes',
                    'description' => 'Mostrar filtros para propiedades de variantes',
                ],
                'includeSliderAssets' => [
                    'title' => 'Incluir noUI Slider',
                    'description' => 'Incluir todas las dependencias de noUI Slider a través de cdnjs',
                ],
                'sortOrder' => [
                    'title' => 'Orden Predeterminado',
                    'description' => 'Parámetro de pedido inicial',
                ],
            ],
            'sortOrder' => [
                'bestseller' => 'Más vendidos',
                'priceLow' => 'Menor precio',
                'priceHigh' => 'Mayor precio',
                'latest' => 'Últimos',
                'oldest' => 'Más antiguos',
                'random' => 'Aleatorio',
                'manual' => 'Manual',
                'name' => 'Nombre',
                'ratings' => 'Evaluaciones',
            ],
        ],
        'myAccount' => [
            'details' => [
                'name' => 'Cuenta de usuario',
                'description' => 'Muestra diversos formularios donde un usuario puede ver y editar su perfil',
            ],
            'properties' => [
                'page' => [
                    'title' => 'Subpágina activa',
                ],
            ],
            'pages' => [
                'orders' => 'Pedidos',
                'profile' => 'Perfil',
                'addresses' => 'Direcciones',
            ],
        ],
        'customerProfile' => [
            'details' => [
                'name' => 'Perfil de Cliente',
                'description' => 'Muestra un formulario de edición de perfil de cliente.',
            ],
            'properties' => [
            ],
        ],
        'currencyPicker' => [
            'details' => [
                'name' => 'Selector de divisas',
                'description' => 'Muestra un campo donde el usuario selecciona la divisa a utilizar en la tienda',
            ],
            'properties' => [
            ],
        ],
        'dependencies' => [
            'details' => [
                'name' => 'Dependencias de Frontend',
                'description' => 'Incluye todas las dependencias necesarias del frontend',
            ],
            'properties' => [
            ],
        ],
        'addressList' => [
            'details' => [
                'name' => 'Lista de direcciones',
                'description' => 'Muestra una lista con todas las direcciones registradas por el usuario',
            ],
            'properties' => [
            ],
            'errors' => [
                'address_not_found' => 'La dirección solicitada no se encuentra',
                'cannot_delete_last_address' => 'No puedes editar la última dirección registrada',
            ],
            'messages' => [
                'address_deleted' => 'Dirección eliminada',
                'default_billing_address_changed' => 'Se ha cambiado la dirección de facturación predeterminada',
                'default_shipping_address_changed' => 'Se ha cambiado la dirección de despacho predeterminada',
            ],
        ],
        'ordersList' => [
            'details' => [
                'name' => 'Lista de pedidos',
                'description' => 'Muestra una lista con todos los pedidos del cliente',
            ],
            'properties' => [
            ],
        ],
        'product' => [
            'details' => [
                'name' => 'Detalles de producto',
                'description' => 'Muestra los detalles de un producto',
            ],
            'properties' => [
                'redirectOnPropertyChange' => [
                    'title' => 'Redirigir al cambiar propiedades',
                    'description' => 'Redirigir al usuario a la nueva página de detalle si alguna propiedad de producto fue cambiada',
                ],
            ],
            'added_to_cart' => 'Producto agregado exitosamente',
        ],
        'productReviews' => [
            'details' => [
                'name' => 'Reseñas de producto',
                'description' => 'Muestra todas las reseñas de productos',
            ],
            'properties' => [
                'perPage' => [
                    'title' => 'Cantidad de reseñas por página',
                ],
                'currentVariantReviewsOnly' => [
                    'title' => 'Mostrar sólo las reseñas de esta variante',
                    'description' => "No mostrar las reseñas de otras variantes de este producto.",
                ],
            ],
        ],
        'cart' => [
            'details' => [
                'name' => 'Carro',
                'description' => 'Muestra el carro de compras',
            ],
            'properties' => [
                'showDiscountApplier' => [
                    'title' => 'Mostrar aplicador de descuento',
                ],
                'showShipping' => [
                    'title' => 'Mostrar costo de despacho',
                ],
                'showTaxes' => [
                    'title' => 'Mostrar impuestos',
                ],
                'showProceedToCheckoutButton' => [
                    'title' => 'Mostrar botón para proceder al checkout',
                ],
            ],
        ],
        'checkout' => [
            'details' => [
                'name' => 'Checkout',
                'description' => 'Gestiona el proceso de finalización compra',
            ],
            'errors' => [
                'missing_settings' => 'Por favor seleccione un medio de pago y despacho.',
            ],
        ],
        'discountApplier' => [
            'details' => [
                'name' => 'Campo de descuento',
                'description' => 'Muestra un campo de texto para el ingreso de un código de descuento',
            ],
            'discount_applied' => 'Descuento realizado exitosamente!',
        ],
        'shippingMethodSelector' => [
            'details' => [
                'name' => 'Selector de despacho',
                'description' => 'Muestra una lista de medios de despacho disponibles',
            ],
            'errors' => [
                'unavailable' => 'El medio de despacho seleccionado no se encuentra disponible para su pedido.',
            ],
        ],
        'paymentMethodSelector' => [
            'details' => [
                'name' => 'Selector de medio de despacho',
                'description' => 'Muestra una lista con todos los medios de despacho disponibles',
            ],
            'errors' => [
                'unavailable' => 'El método de despacho seleccionado no se encuentra disponible para su pedido.',
            ],
        ],
        'addressSelector' => [
            'details' => [
                'name' => 'Selector de Dirección',
                'description' => 'Muestra una lista de direcciones disponibles para el usuario',
            ],
            'errors' => [
            ],
        ],
        'addressForm' => [
            'details' => [
                'name' => 'Formulario de Dirección',
                'description' => 'Muestra un formulario para que el usuario ingrese direcciones',
            ],
            'properties' => [
                'address' => [
                    'title' => 'Dirección',
                ],
                'redirect' => [
                    'title' => 'Redirigir (después de guardar)',
                ],
                'set' => [
                    'title' => 'Usar esta dirección como',
                ],
            ],
            'redirects' => [
                'checkout' => 'Página de Checkout',
            ],
            'set' => [
                'billing' => 'Dirección de facturación',
                'shipping' => 'Dirección de despacho',
            ],
        ],
        'signup' => [
            'details' => [
                'name' => 'Registro',
                'description' => 'Muestra formularios de registro e inicio de sesión',
            ],
            'properties' => [
                'redirect' => [
                    'name' => 'Redirigir después del inicio de sesión',
                ],
            ],
            'errors' => [
                'user_is_guest' => 'Estás tratando de iniciar sesión con una cuenta de invitado.',
                'unknown_user' => 'Las credenciales ingresadas no son válidas.',
                'not_activated' => 'Tu cuenta debe ser activada antes de poder iniciar sesión.',
                'login' => [
                    'required' => 'Por favor ingresa tu correo electrónico.',
                    'email' => 'Por favor ingresa un email válido.',
                    'between' => 'Por favor ingresa un email válido.',
                ],
                'password' => [
                    'required' => 'Por favor ingresa tu contraseña.',
                    'max' => 'La contraseña ingresada es demasiado larga.',
                    'min' => 'La contraseña ingresada es demasiado corta. Por favor utiliza al menos 8 caracteres.',
                ],
                'password_repeat' => [
                    'required' => 'Por favor confirma tu contraseña.',
                    'same' => 'La confirmación de contraseña no coincide con la contraseña ingresada.',
                ],
                'email' => [
                    'required' => 'Por favor ingresa tu correo electrónico.',
                    'email' => 'Esta cuenta de correo electrónico no es válida.',
                    'unique' => 'Un usuario con esta cuenta de correo electrónico ya existe.',
                    'non_existing_user' => 'Un usuario ya se ha registrado con este email. Por favor, intenta con reestablecer tu contraseña.',
                ],
                'firstname' => [
                    'required' => 'Por favor ingresa tu nombre.',
                ],
                'lastname' => [
                    'required' => 'Por favor ingresa tu apellido.',
                ],
                'lines' => [
                    'required' => 'Por favor ingresa tu dirección.',
                ],
                'zip' => [
                    'required' => 'Por favor ingresa tu código postal.',
                ],
                'city' => [
                    'required' => 'Por favor ingresa tu ciudad.',
                ],
                'country_id' => [
                    'required' => 'Selecciona un país.',
                    'exists' => 'El país seleccionado no es válido.',
                ],
                'state_id' => [
                    'required' => 'Selecciona un estado o provincia',
                    'exists' => 'El estado o provincia seleccionado(a) no es válido(a).',
                ],
                'terms_accepted' => [
                    'required' => 'Debes aceptar los términos y condiciones para proceder.',
                ],
            ],
        ],
        'categories' => [
            'details' => [
                'name' => 'Cat3egorías',
                'description' => 'Lista las categorías disponibles',
            ],
            'properties' => [
                'parent' => [
                    'title' => 'Empezar desde la categoría',
                    'description' => 'Sólo mostrar categorías hijas de esta categoría',
                ],
                'categorySlug' => [
                    'title' => 'Parámetro de slug de categoría',
                    'description' => 'Usa este parámetro para cargar la categoría padre desde la URL',
                ],
                'categoryPage' => [
                    'title' => 'Página de categoría',
                    'description' => 'Los enlaces generados apuntarán a esta página. Si se deja en blanco se utilizará la configuración predeterminada.',
                ],
            ],
            'no_parent' => 'Mostrar todas las categorías',
            'by_slug' => 'Utilizar la categoría definida en el slug como padre',
        ],
        'cartSummary' => [
            'details' => [
                'name' => 'Resumen del carro',
                'description' => 'Muestra la cantidad de productos y valor total del carro',
            ],
            'properties' => [
                'showItemCount' => [
                    'title' => 'Mostrar cantidad total de productos',
                    'description' => 'Muestra la cantidad total de productos agregados al carro',
                ],
                'showTotalPrice' => [
                    'title' => 'Mostrar valor total',
                    'description' => 'Muestra la suma total de todos los productos en el carro',
                ],
            ],
        ],
        'customerDashboard' => [
            'details' => [
                'name' => 'Escritorio del Cliente',
                'description' => 'Muestra un enlace para que el cliente inicie sesión y cambie los ajustes de su cuenta',
            ],
            'properties' => [
                'customerDashboardLabel' => [
                    'title' => 'Etiqueta del escritorio del cliente',
                    'description' => 'Texto a agregar en el link a la página de perfil del cliente',
                ],
                'logoutLabel' => [
                    'title' => 'Etiqueta de cierre de sesión',
                    'description' => 'Texto a utilizar para el enlace de cierre de sesión',
                ],
            ],
        ],
        'enhancedEcommerceAnalytics' => [
            'details' => [
                'name' => 'Component de Ecommerce Mejorado (UA)',
                'description' => 'Implementa una capa de datos de Google Tag Manager',
            ],
        ],
        'wishlistButton' => [
            'details' => [
                'name' => 'Botón de Lista de Deseos',
                'description' => 'Muestra un botón para agregar a lista de deseos',
            ],
            'properties' => [
                'product' => [
                    'name' => 'Producto',
                    'description' => 'ID del producto',
                ],
                'variant' => [
                    'name' => 'Variante',
                    'description' => 'ID de la variante',
                ],
            ],
        ],
        'wishlists' => [
            'details' => [
                'name' => 'Listas de deseos',
                'description' => 'Muestra el gestionador de listas de deseos',
            ],
            'properties' => [
                'showShipping' => [
                    'name' => 'Mostrar despacho',
                    'description' => 'Mostrar selector y calculadora de costos de envío',
                ],
            ],
        ],
    ],
    'shipping_method_rates' => [
        'from_weight' => 'Desde (Peso en gramos)',
        'to_weight' => 'Hasta (Peso en gramos)',
    ],
    'products' => [
        'variants_comment' => 'Crear diferentes variantes del mismo producto',
    ],
    'order_states' => [
        'name' => 'Nombre',
        'description' => 'Descripción',
        'color' => 'Color',
        'flag' => 'Etiquetas especiales',
        'flags' => [
            'new' => 'Fijar el estado del pedido como "nuevo"',
            'complete' => 'Fijar el estado del pedido como "terminado"',
            'cancelled' => 'Fijar el estado del pedido como "cancelado"',
        ],
    ],
    'customer_group' => [
        'code_comment' => 'Este código puede ser utilizado para identificar este grupo programáticamente',
        'discount_comment' => 'Dar un descuento porcentual específico a este grupo de clientes en todo el catálogo',
    ],
    'order_status' => [
        'processed' => 'Procesado',
        'disputed' => 'Cuestionado',
        'shipped' => 'Despachado',
        'delivered' => 'Entregado',
        'pending' => 'Pendiente',
        'cancelled' => 'Cancelado',
    ],
    'notifications' => [
        'enabled' => 'Habilitado',
        'enabled_comment' => 'Esta notificación está habilitada',
        'template' => 'Plantilla de correo electrónico',
    ],
    'payment_log' => [
        'payment_data' => 'Información del pago',
        'data_comment' => 'Estos son los datos informados por el portal de pagos',
        'order_data_comment' => 'esta es toda la información de pedido para este pago',
        'message_comment' => 'Respuesta del proveedor de pagos',
        'code_comment' => 'Código devuelto por el proveedor de pagos',
        'failed_only' => 'Sólo fallos',
    ],
    'services' => [
        'options' => 'Opciones',
        'option' => 'Opción',
        'required' => 'Debes seleccionar un searvicio',
        'required_comment' => 'Una opción de servicio debe ser seleccionada cuando el producto es añadido al carro.',
    ],
    'reviews' => [
        'rating' => 'Evaluación',
        'review' => 'Detalles de la reseña',
        'title' => 'Título de la reseña',
        'pros' => 'Aspectos positivos',
        'cons' => 'Aspectos negativos',
        'anonymous' => 'Anónimo',
        'only_unapproved' => 'Mostrar sólo no aprobadas',
        'no_more' => 'No se encontraron reseñas no aprobadas',
        'approved' => 'Reseña aprobada',
        'approve' => 'Aprobar reseña',
        'approve_next' => 'Aprobar y revisar siguiente',
    ],
];
