# v1.5.0

## Changes

* [Services](../digging-deeper/services.md) can now be managed in the backend and can be added to products
* The `mallDependencies` component now injects a global `.mall-modal` element
into the DOM

## Required actions

### `mallDependencies`

Make sure the `mallDependencies` component is added to your layout's
`<head>` tag, and is not just included in the code section.

```twig{6}
[mallDependencies]
==
<!DOCTYPE html>
<html>
<head>
    {% component 'mallDependencies' %}
</head>
```

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-theme/commit/334e9a0abd89c701473a528ff1b9b43f332bce03)

### `.mall-modal` styles

If you make use of the new `Services` feature, make sure to style the
`.mall-modal` element. 

For styling inspiration take a look at [the commit to the demo theme](https://github.com/OFFLINE-GmbH/oc-mall-theme/commit/6660c9572f268164e031b9496366d0d82bd65003).


### `mall.cart.productAdded` event

If you did override the `components/product/default.htm` partial, make sure
to only fire the `mall.cart.productAdded` event if the `data` object
has a `added` key with the value of `true`.

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/commit/771e3d94685d1636b27c78ef66736a241dd6e36e)

### Service options in cart overview

If you did override the `components/cart/table/entry.htm` partial, make sure
to add the new service option information.

For styling inspiration take a look at [the commit to the demo theme](https://github.com/OFFLINE-GmbH/oc-mall-theme/commit/e02cb36d764395a212372abd83ea1a053560c0ed).

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/compare/60c8f017ce0c85928ee0c6be3ef72034e1c7f0e5..3af55dc05f903dbe2a91da1d11d9cd76a3eaa67b#diff-97d9934bc5c6ea57aae23f2b172615f1)

### Service options in confirmation mail

Make sure to add the new service options output to the `mall.order.table` mail
 partial if you plan to use the services feature.
 
Keep in mind that you will have to purge the partial from the database if
you modify it on the filesystem.

See [Commit](https://github.com/OFFLINE-GmbH/oc-mall-plugin/compare/60c8f017ce0c85928ee0c6be3ef72034e1c7f0e5..3af55dc05f903dbe2a91da1d11d9cd76a3eaa67b#diff-c756239ec92b708c1325201d3c196ac0) 